<?php
class ControllerSyncCustomer extends Controller {
	public function index() {
		$this->load->language('api/customer');

		// Delete past customer in case there is an error
		unset($this->session->data['customer']);

		$json = array();

		if (!isset($this->session->data['api_id'])) {
			$json['error']['warning'] = $this->language->get('error_permission');
		} else {
			// Add keys for missing post vars
			$keys = array(
				'customer_id',
				'customer_group_id',
				'firstname',
				'lastname',
				'email',
				'telephone',
				'fax'
			);

			foreach ($keys as $key) {
				if (!isset($this->request->get[$key])) {
					$this->request->get[$key] = '';
				}
			}
		
	
		if ( !isset($this->request->post['customer_id']) ) {
			if ( !isset($this->request->post['search']) ) {
				// All customers
				$this->load->model('account/customer');
				$json = $this->model_account_customer->getCustomers();
			} else {
				$this->load->model('sync/customer');
				$json = $this->model_sync_customer->searchCustomers($this->request->post['search']);
			}
		} else {
 
			// Customer
			$this->load->model('account/customer');
			$customer_info = $this->model_account_customer->getCustomer($this->request->post['customer_id']);
			if (!$customer_info || !$this->customer->login($customer_info['email'], '', true)) {
				$json['error']['warning'] = $this->language->get('error_customer');
			} else {
				$json[$this->request->post['customer_id']] = $customer_info;
			}
		}
	}
		// Add addresses
		if ( !isset($json['error'])) {
			foreach ($json as $k => $customer) {
				$this->load->model('sync/customer');
				$addresses = $this->model_sync_customer->getAddresses($customer['customer_id']);
				$customer_json[$k] = $customer;
				$customer_json[$k]['addresses'] = $addresses;
			}
			$json = $customer_json;
		}
		$this->response->addHeader('Content-Type: application/json');
		$this->response->setOutput(json_encode($json));
	}	

	public function search( ) {


	}

}
