<?php
class ControllerSyncProduct extends Controller {
	public function index() {
		$this->load->language('api/customer');

		// Delete past customer in case there is an error
		unset($this->session->data['customer']);

		$json = array();

		if (!isset($this->session->data['api_id'])) {
			$json['error']['warning'] = $this->language->get('error_permission');
		} else {
			// Add keys for missing post vars
			$keys = array(
				'customer_id',
				'customer_group_id',
				'firstname',
				'lastname',
				'email',
				'telephone',
				'fax'
			);

			foreach ($keys as $key) {
				if (!isset($this->request->get[$key])) {
					$this->request->get[$key] = '';
				}
			}

	
		if ( !isset($this->request->post['product_id']) ) {
			if ( !isset($this->request->post['search']) ) {
				// All customers
				$this->load->model('catalog/product');
				$json = $this->model_catalog_product->getProducts();
			} else {
				$this->load->model('sync/customer');
				$json = $this->model_sync_customer->searchCustomers($this->request->post['search']);
			}
		} else {
 
			// Customer
			$this->load->model('catalog/product');
			$product_info = $this->model_catalog_product->getProduct($this->request->post['product_id']);
			if (!$product_info ) {
				$json['error']['warning'] = $this->language->get('error_customer');
			} else {
				$json = $product_info;
				
			}
		}
	}
		$this->response->addHeader('Content-Type: application/json');
		$this->response->setOutput(json_encode($json));
	}	

	public function search( ) {


	}

}
