<?php
/*
  --------------------------------------------------------------------------
  GAzie - Gestione Azienda
  Copyright (C) 2004-2021 - Antonio De Vincentiis Montesilvano (PE)
  (http://www.devincentiis.it)
  <http://gazie.sourceforge.net>
  --------------------------------------------------------------------------
  Questo programma e` free software;   e` lecito redistribuirlo  e/o
  modificarlo secondo i  termini della Licenza Pubblica Generica GNU
  come e` pubblicata dalla Free Software Foundation; o la versione 2
  della licenza o (a propria scelta) una versione successiva.

  Questo programma  e` distribuito nella speranza  che sia utile, ma
  SENZA   ALCUNA GARANZIA; senza  neppure  la  garanzia implicita di
  NEGOZIABILITA` o di  APPLICABILITA` PER UN  PARTICOLARE SCOPO.  Si
  veda la Licenza Pubblica Generica GNU per avere maggiori dettagli.

  Ognuno dovrebbe avere   ricevuto una copia  della Licenza Pubblica
  Generica GNU insieme a   questo programma; in caso  contrario,  si
  scriva   alla   Free  Software Foundation, 51 Franklin Street,
  Fifth Floor Boston, MA 02110-1335 USA Stati Uniti.
  --------------------------------------------------------------------------
 */
require("../../library/include/datlib.inc.php");
$admin_aziend = checkAdmin();
$msg = '';
if (isset($_POST['Insert']) || isset($_POST['Update'])) {   //se non e' il primo accesso
    $form = array_merge(gaz_dbi_parse_post('clfoco'), gaz_dbi_parse_post('anagra'));
    $form['ritorno'] = $_POST['ritorno'];
    $form['hidden_req'] = $_POST['hidden_req'];
    $form['pec_email'] = trim($form['pec_email']);
    $form['e_mail'] = trim($form['e_mail']);
    $form['datnas_Y'] = intval($_POST['datnas_Y']);
    $form['datnas_M'] = intval($_POST['datnas_M']);
    $form['datnas_D'] = intval($_POST['datnas_D']);
    foreach ($_POST['search'] as $k => $v) {
        $form['search'][$k] = $v;
    }

    $toDo = 'update';
    if (isset($_POST['Insert'])) {
        $toDo = 'insert';
    }

    if ($form['hidden_req'] == 'toggle') { // e' stato accettato il link ad una anagrafica esistente
        $rs_a = gaz_dbi_get_row($gTables['anagra'], 'id', $form['id_anagra']);
        $form = array_merge($form, $rs_a);
    }

    if (isset($_POST['Submit'])) { // conferma tutto
        // inizio controllo campi
        $real_code = $admin_aziend['masfor'] * 1000000 + $form['codice'];
        require("../../library/include/check.inc.php");
        $rs_same_code = gaz_dbi_dyn_query('*', $gTables['clfoco'], " codice = " . $real_code, "codice", 0, 1);
        $same_code = gaz_dbi_fetch_array($rs_same_code);
        if ($same_code && ($toDo == 'insert')) { // c'� gi� uno stesso codice
            $form['codice'] ++; // lo aumento di 1
            $msg .= "18+";
        }
        if (strlen($form["ragso1"]) < 3) {
            if (!empty($form["legrap_pf_nome"]) && !empty($form["legrap_pf_cognome"]) && $form["sexper"] != 'G') {// setto la ragione sociale con l'eventuale legale rappresentante
                $form["ragso1"] = strtoupper($form["legrap_pf_cognome"] . ' ' . $form["legrap_pf_nome"]);
            } else { // altrimenti do errore                
                $msg .= '0+';
            }
        }
        if (empty($form["indspe"])) {
            $msg .= '1+';
        }
        // faccio i controlli sul codice postale 
        $rs_pc = gaz_dbi_get_row($gTables['country'], 'iso', $form["country"]);
        if ( gaz_dbi_get_row($gTables['company_config'], 'var', 'check_cust_address')['val']==1 ) {
          $cap = new postal_code;
          if ($cap->check_postal_code($form["capspe"], $form["country"], $rs_pc['postal_code_length']) && $rs_pc['postal_code_length']>0) {
              $msg .= '2+';
          }
          if (empty($form["citspe"])) {
              $msg .= '3+';
          }
          if (empty($form["prospe"])) {
              $msg .= '4+';
          }
        }
        if (empty($form["sexper"])) {
            $msg .= '5+';
        }
        $iban = new IBAN;
        if (!empty($form['iban']) && !$iban->checkIBAN($form['iban'])) {
            $msg .= '6+';
        }
        if (!empty($form['iban']) && (substr($form['iban'], 0, 2) <> $form['country'])) {
            $msg .= '7+';
        }
        $cf_pi = new check_VATno_TAXcode();
        $r_pi = $cf_pi->check_VAT_reg_no($form['pariva'], $form['country']);

        // danielemz - temporaneo per imposta 2017- bolle doganali
        if (isset($form['pariva']) && trim($form['pariva']) == '99999999999') {
            $r_pi = "";
        }
        if (strlen(trim($form['codfis'])) == 11) {
            $r_cf = $cf_pi->check_VAT_reg_no($form['codfis'], $form['country']);
            if ($form['sexper'] != 'G') {
                $r_cf = 'Codice fiscale sbagliato per una persona fisica';
                $msg .= '8+';
            }
        } else {
            $r_cf = $cf_pi->check_TAXcode($form['codfis'], $form['country']);
        }
        if (!empty($r_pi)) {
            $msg .= "9+";
        }
        if ($form['codpag'] < 1) {
            $msg .= "17+";
        }
        $anagrafica = new Anagrafica();
        if (!($form['pariva'] == "") && !($form['pariva'] == "00000000000")) {
            $partner_with_same_pi = $anagrafica->queryPartners('*', "codice <> " . $real_code . " AND codice BETWEEN " . $admin_aziend['masfor'] . "000000 AND " . $admin_aziend['masfor'] . "999999 AND pariva = '" . $form['pariva'] . "'", "pariva DESC", 0, 1);
            if ($partner_with_same_pi) { // c'� gi� un fornitore sul piano dei conti
                $msg .= "10+";
            } elseif ($form['id_anagra'] == 0) { // � un nuovo fornitore senza anagrafica
                $rs_anagra_with_same_pi = gaz_dbi_query_anagra(array("*"), $gTables['anagra'], array("pariva" => "='" . $form['pariva'] . "'"), array("pariva" => "DESC"), 0, 1);
                $anagra_with_same_pi = gaz_dbi_fetch_array($rs_anagra_with_same_pi);
                if ($anagra_with_same_pi) { // c'� gi� un'anagrafica con la stessa PI non serve reinserirlo ma avverto
                    // devo attivare tutte le interfacce per la scelta!
                    $anagra = $anagra_with_same_pi;
                    $msg .= '15+';
                }
            }
        }
        if (!empty($r_cf)) {
            $msg .= "11+";
        }
        if (!($form['codfis'] == "") && !($form['codfis'] == "00000000000")) {
            $partner_with_same_cf = $anagrafica->queryPartners('*', "codice <> " . $real_code . " AND codice BETWEEN " . $admin_aziend['masfor'] . "000000 AND " . $admin_aziend['masfor'] . "999999 AND codfis = '" . $form['codfis'] . "'", "codfis DESC", 0, 1);
            if ($partner_with_same_cf) { // c'� gi� un fornitore sul piano dei conti
                $msg .= "12+";
            } elseif ($form['id_anagra'] == 0) { // � un nuovo fornitore senza anagrafica
                $rs_anagra_with_same_cf = gaz_dbi_query_anagra(array("*"), $gTables['anagra'], array("codfis" => "='" . $form['codfis'] . "'"), array("codfis" => "DESC"), 0, 1);
                $anagra_with_same_cf = gaz_dbi_fetch_array($rs_anagra_with_same_cf);
                if ($anagra_with_same_cf) { // c'� gi� un'anagrafica con lo stesso CF non serve reinserirlo ma avverto
                    // devo attivare tutte le interfacce per la scelta!
                    $anagra = $anagra_with_same_cf;
                    $msg .= '16+';
                }
            }
        }
        if (empty($form['codfis'])) {
            if ($form['sexper'] == 'G') {
                $msg .= "13+";
                $form['codfis'] = $form['pariva'];
            } else {
                $msg .= "14+";
            }
        }
        if (empty(trim($form['external_service_descri'])) && $form['external_resp'] > 0) {
            $msg .= "21+";
        }
        $uts_datnas = mktime(0, 0, 0, $form['datnas_M'], $form['datnas_D'], $form['datnas_Y']);
        if (!checkdate($form['datnas_M'], $form['datnas_D'], $form['datnas_Y']) && ($admin_aziend['country'] != $form['country'] )) {
            $msg .= "19+";
        }
        if (!filter_var($form['pec_email'], FILTER_VALIDATE_EMAIL) && !empty($form['pec_email'])) {
            $msg .= "20+";
        }
        if (!filter_var($form['e_mail'], FILTER_VALIDATE_EMAIL) && !empty($form['e_mail'])) {
            $msg .= "20+";
        }
        if (!filter_var($form['e_mail'], FILTER_VALIDATE_EMAIL) && !empty($form['e_mail'])) {
            $msg .= "20+";
        }
		// il codice SIAN deve essere univoco nell'ambito clienti e fornitori
		if (intval($form['id_SIAN'])>0){
			$rs_same_code = gaz_dbi_dyn_query('*', $gTables['anagra'], " id_SIAN = " . $form['id_SIAN']);
			$rows=gaz_dbi_num_rows($rs_same_code);
			if ($rows>0 && ($toDo == 'insert')) { // c'� gi� uno stesso codice
				$form['id_SIAN'] ++; // lo aumento di 1
				$msg .= "22+";
			} 
			if ($toDo == 'update') {		 
				foreach ($rs_same_code as $row){
					if ($row['ragso1']!==$form['ragso1'] AND $row['id_SIAN']==$form['id_SIAN']){
						$form['id_SIAN'] ++; // c'� gi� uno stesso codice lo aumento di 1
						$msg .= "22+";
					}
				}
			}
		}

        if (empty($msg)) { // nessun errore
            $form['codice'] = $real_code;
            $form['datnas'] = date("Ymd", $uts_datnas);
            if ($toDo == 'insert') {
                if ($form['id_anagra'] > 0) {
                    gaz_dbi_table_insert('clfoco', $form);
                } else {
                    $anagrafica->insertPartner($form);
                }
            } elseif ($toDo == 'update') {
                $anagrafica->updatePartners($form['codice'], $form);
            }
            header('Location: report_fornit.php');
            exit;
        }
    } elseif (isset($_POST['Return'])) { // torno indietro
        header("Location: " . $form['ritorno']);
        exit;
    }
} elseif (!isset($_POST['Update']) && isset($_GET['Update'])) { //se e' il primo accesso per UPDATE
    $anagrafica = new Anagrafica();
    $form = $anagrafica->getPartner(intval($admin_aziend['masfor'] * 1000000 + $_GET['codice']));
    $form['codice'] = intval(substr($form['codice'], 3));
    $toDo = 'update';
    $form['search']['id_des'] = '';
    $form['search']['fiscal_rapresentative_id'] = '';
    $form['ritorno'] = $_SERVER['HTTP_REFERER'];
    $form['hidden_req'] = '';
    $form['datnas_Y'] = substr($form['datnas'], 0, 4);
    $form['datnas_M'] = substr($form['datnas'], 5, 2);
    $form['datnas_D'] = substr($form['datnas'], 8, 2);
	$form['external_resp']=$form['external_resp'];
} elseif (!isset($_POST['Insert'])) { //se e' il primo accesso per INSERT
    $anagrafica = new Anagrafica();
    $last = $anagrafica->queryPartners('*', "codice BETWEEN " . $admin_aziend['masfor'] . "000000 AND " . $admin_aziend['masfor'] . "999999", "codice DESC", 0, 1);
    $form = array_merge(gaz_dbi_fields('clfoco'), gaz_dbi_fields('anagra'));
    $form['codice'] = substr($last[0]['codice'], 3) + 1;
    $toDo = 'insert';
    $form['search']['id_des'] = '';
    $form['search']['fiscal_rapresentative_id'] = '';
    $form['country'] = $admin_aziend['country'];
    $form['id_language'] = $admin_aziend['id_language'];
    $form['id_currency'] = $admin_aziend['id_currency'];
    $form['datnas_Y'] = 1900;
    $form['datnas_M'] = 1;
    $form['datnas_D'] = 1;
    $form['counas'] = $admin_aziend['country'];
    $form['spefat'] = 'N';
    $form['stapre'] = 'N';
    $form['allegato'] = 1;
    $form['ritorno'] = $_SERVER['HTTP_REFERER'];
    $form['hidden_req'] = '';
	$form['external_resp']="";
	$form["external_service_descri"]="";
	$form['id_SIAN']="";
}

require("../../library/include/header.php");
$script_transl = HeadMain(0, array('custom/autocomplete',
    'calendarpopup/CalendarPopup',
        /** ENRICO FEDELE */
        /* 'jquery/jquery-1.7.1.min',
          'jquery/ui/jquery.ui.core',
          'jquery/ui/jquery.ui.widget',
          'jquery/ui/jquery.ui.position',
          'jquery/ui/jquery.ui.autocomplete', */
        /** ENRICO FEDELE */        ));
?>
<script>
<?php
echo "function toggleContent(currentContent) {
        var thisContent = document.getElementById(currentContent);
        if ( thisContent.style.display == 'none') {
           thisContent.style.display = '';
           return;
        }
        thisContent.style.display = 'none';
      }
      function selectValue(currentValue) {
         document.form.id_anagra.value=currentValue;
         document.form.hidden_req.value='toggle';
         document.form.submit();
      }\n
var cal = new CalendarPopup();
var calName = '';
function setMultipleValues(y,m,d) {
     document.getElementById(calName+'_Y').value=y;
     document.getElementById(calName+'_M').selectedIndex=m*1-1;
     document.getElementById(calName+'_D').selectedIndex=d*1-1;
}
function setDate(name) {
  calName = name.toString();
  var year = document.getElementById(calName+'_Y').value.toString();
  var month = document.getElementById(calName+'_M').value.toString();
  var day = document.getElementById(calName+'_D').value.toString();
  var mdy = month+'/'+day+'/'+year;
  cal.setReturnFunction('setMultipleValues');
  cal.showCalendar('anchor', mdy);
}
";
?>
$(function() {
    $('#iban,#codfis').keyup(function(){
        this.value = this.value.toUpperCase();
    });
    
});    
</script>
<?php
echo "<form method=\"POST\" name=\"form\">\n";
echo "<input type=\"hidden\" name=\"ritorno\" value=\"" . $form['ritorno'] . "\">\n";
echo "<input type=\"hidden\" value=\"" . $form['hidden_req'] . "\" name=\"hidden_req\" />\n";
echo "<input type=\"hidden\" value=\"" . $form['id_anagra'] . "\" name=\"id_anagra\" />\n";
echo "<input type=\"hidden\" name=\"" . ucfirst($toDo) . "\" value=\"\">";
$gForm = new gazieForm();
if ($toDo == 'insert') {
    echo "<div align=\"center\" class=\"FacetFormHeaderFont\">" . $script_transl['ins_this'] . "</div>\n";
} else {
    echo "<div align=\"center\" class=\"FacetFormHeaderFont\">" . $script_transl['upd_this'] . " '" . $form['codice'] . "'</div>\n";
    echo "<input type=\"hidden\" value=\"" . $form['codice'] . "\" name=\"codice\" />\n";
}
echo "<div align=\"center\">\n";
echo '<table class="table-striped table-bordered table-condensed">';
if (!empty($msg)) {
    echo '<tr><td colspan="3" class="FacetDataTDred">' . $gForm->outputErrors($msg, $script_transl['errors']) . "</td></tr>\n";
    if (isset($anagra)) {
        echo "<tr>\n";
        echo "\t <td>\n";
        echo "\t </td>\n";
        echo "<td colspan=\"2\"><div onmousedown=\"toggleContent('id_anagra')\" class=\"FacetDataTDred\" style=\"cursor:pointer;\">";
        echo ' &dArr; ' . $script_transl['link_anagra'] . " &dArr;</div>\n";
        echo "<div style=\"display: ;\" class=\"selectContainer\" id=\"id_anagra\" onclick=\"selectValue('" . $anagra['id'] . "');\" >\n";
        echo "<div class=\"selectHeader\"> ID = " . $anagra['id'] . "</div>\n";
        echo '<table cellspacing="0" cellpadding="0" width="100%" class="selectTable">';
        echo "\n<tr class=\"odd\"><td>" . $script_transl['ragso1'] . " </td><td> " . $anagra['ragso1'] . "</td></tr>\n";
        echo "<tr class=\"even\"><td>" . $script_transl['ragso2'] . " </td><td> " . $anagra['ragso2'] . "</td></tr>\n";
        echo "<tr class=\"odd\"><td>" . $script_transl['sexper'] . " </td><td> " . $anagra['sexper'] . "</td></tr>\n";
        echo "<tr class=\"even\"><td>" . $script_transl['indspe'] . " </td><td> " . $anagra['indspe'] . "</td></tr>\n";
        echo "<tr class=\"odd\"><td>" . $script_transl['capspe'] . " </td><td> " . $anagra['capspe'] . "</td></tr>\n";
        echo "<tr class=\"even\"><td>" . $script_transl['citspe'] . " </td><td> " . $anagra['citspe'] . " (" . $anagra['prospe'] . ")</td></tr>\n";
        echo "<tr class=\"odd\"><td>" . $script_transl['telefo'] . " </td><td> " . $anagra['telefo'] . "</td></tr>\n";
        echo "<tr class=\"even\"><td>" . $script_transl['cell'] . " </td><td> " . $anagra['cell'] . "</td></tr>\n";
        echo "<tr class=\"odd\"><td>" . $script_transl['fax'] . " </td><td> " . $anagra['fax'] . "</td></tr>\n";
        echo "</div></table></div>\n";
        echo "\t </td>\n";
        echo "</tr>\n";
    }
}
if ($toDo == 'insert') {
    echo "<tr>\n";
    echo "\t<td>" . $script_transl['codice'] . "* </td>\n";
    echo "\t<td colspan=\"2\"><input type=\"text\" name=\"codice\" value=\"" . $form['codice'] . "\" align=\"right\" maxlength=\"6\" /></td>\n";
    echo "</tr>\n";
}
echo "<tr>\n";
echo "\t<td>" . $script_transl['ragso1'] . "* </td>\n";
echo "\t<td colspan=\"2\">
      <input type=\"text\" name=\"ragso1\" placeholder=\"" . $script_transl['ragso1_placeholder'] . "\" value=\"" . $form['ragso1'] . "\" align=\"right\" maxlength=\"50\" /></td>\n";
echo "</tr>\n";
echo "<tr>\n";
echo "\t<td>" . $script_transl['ragso2'] . " </td>\n";
echo "\t<td colspan=\"2\">
      <input type=\"text\" name=\"ragso2\" value=\"" . $form['ragso2'] . "\" align=\"right\" maxlength=\"50\" /></td>\n";
echo "</tr>\n";
echo "<tr>\n";
echo "\t<td>" . $script_transl['legrap_pf_nome'] . " </td>\n";
echo "\t<td>
      <input type=\"text\" name=\"legrap_pf_nome\" title=\"" . $script_transl['legrap_pf_title'] . "\"  value=\"" . $form['legrap_pf_nome'] . "\" align=\"right\" maxlength=\"60\" /></td>\n";
echo "\t<td>
      <input type=\"text\" name=\"legrap_pf_cognome\" title=\"" . $script_transl['legrap_pf_title'] . "\"  value=\"" . $form['legrap_pf_cognome'] . "\" align=\"right\" maxlength=\"60\" /></td>\n";
echo "</tr>\n";
echo "<tr>\n";
echo "<td>" . $script_transl['sexper'] . "*</td><td colspan=\"2\">\n";
$gForm->variousSelect('sexper', $script_transl['sexper_value'], $form['sexper']);
echo "\t </td>\n";
echo "</tr>\n";
echo "<tr>\n";
echo "<td>" . $script_transl['external_resp'] . "</td><td colspan=\"2\">\n";
$gForm->variousSelect('external_resp', $script_transl['external_resp_value'], $form['external_resp'], 'FacetSelect', false);
echo "\t </td>\n";
echo "</tr>\n";
echo "<tr>\n";
echo "\t<td>" . $script_transl['external_service_descri'] . " </td>\n";
echo "\t<td colspan=\"2\">
      <textarea name=\"external_service_descri\" rows=\"2\" cols=\"50\" class=\"FacetInput\">" . $form["external_service_descri"] . "</textarea></td>\n";
echo "</tr>\n";

/** ENRICO FEDELE */
/* Cambiato l'ordine dei campi per renderlo pi� coerente con l'autocompletamento (prima il campo comune che ha la funzione attiva) */
echo "<tr>\n";
echo "\t<td>" . $script_transl['citspe'] . " *  </td>\n";
echo "\t<td>
      <input type=\"text\" name=\"citspe\" id=\"search_location\" value=\"" . $form['citspe'] . "\" align=\"right\" maxlength=\"60\" /></td>\n";
echo "\t<td>
      <input type=\"text\" name=\"prospe\" id=\"search_location-prospe\" value=\"" . $form['prospe'] . "\" align=\"right\" maxlength=\"2\" /></td>\n";
echo "</tr>\n";
echo "<tr>\n";
echo "\t<td>" . $script_transl['indspe'] . " * </td>\n";
echo "\t<td colspan=\"2\">
      <input type=\"text\" name=\"indspe\" value=\"" . $form['indspe'] . "\" align=\"right\" maxlength=\"60\" /></td>\n";
echo "</tr>\n";
echo "<tr>\n";
echo "\t<td>" . $script_transl['capspe'] . " * </td>\n";
echo "\t<td colspan=\"2\">
      <input type=\"text\" name=\"capspe\" id=\"search_location-capspe\" value=\"" . $form['capspe'] . "\" align=\"right\" maxlength=\"10\" /></td>\n";
echo "</tr>\n";
echo "<tr>\n";
echo "<td>" . $script_transl['country'] . "</td><td colspan=\"2\">\n";
$gForm->selectFromDB('country', 'country', 'iso', $form['country'], 'iso', 0, ' - ', 'name');
echo "</td>\n";
echo "</tr>\n";
/** ENRICO FEDELE */
echo "<tr>\n";
echo "<td>" . $script_transl['id_language'] . "</td><td colspan=\"2\">\n";
$gForm->selectFromDB('languages', 'id_language', 'lang_id', $form['id_language'], 'lang_id', 1, ' - ', 'title_native');
echo "</td>\n";
echo "</tr>\n";
echo "<tr>\n";
echo "<td>" . $script_transl['id_currency'] . "</td><td colspan=\"2\">\n";
$gForm->selectFromDB('currencies', 'id_currency', 'id', $form['id_currency'], 'id', 1, ' - ', 'curr_name');
echo "</td>\n";
echo "</tr>\n";
echo "<tr>\n";
echo "\t<td>" . $script_transl['fiscal_rapresentative_id'] . " </td><td colspan=\"2\">\n";
$select_fiscal_rapresentative_id = new selectPartner("fiscal_rapresentative_id");
$select_fiscal_rapresentative_id->selectAnagra('fiscal_rapresentative_id', $form['fiscal_rapresentative_id'], $form['search']['fiscal_rapresentative_id'], 'fiscal_rapresentative_id', $script_transl['mesg']);
echo "</td>\n";
echo "</tr>\n";
echo "<tr>\n";
echo "\t<td>" . $script_transl['sedleg'] . " </td>\n";
echo "\t<td colspan=\"2\">
      <textarea name=\"sedleg\" rows=\"2\" cols=\"30\" maxlength=\"100\" >" . $form['sedleg'] . "</textarea></td>\n";
echo "</tr>\n";
echo "<tr>\n";
echo "<td>" . $script_transl['datnas'] . "</td><td colspan=\"2\">\n";
$gForm->CalendarPopup('datnas', $form['datnas_D'], $form['datnas_M'], $form['datnas_Y']);
echo "\t</td>\n";
echo "</tr>\n";
echo "<tr>\n";
/** ENRICO FEDELE */
/* Aggiunto id per autocompletamento */
echo "\t<td>" . $script_transl['luonas'] . " </td>\n";
echo "\t<td colspan=\"2\">
      <input type=\"text\" id=\"search_luonas\" name=\"luonas\" value=\"" . $form['luonas'] . "\" align=\"right\" maxlength=\"50\" /></td>\n";
echo "</tr>\n";
echo "<tr>\n";
echo "\t<td>" . $script_transl['pronas'] . " </td>\n";
echo "\t<td colspan=\"2\">
      <input type=\"text\" id=\"search_pronas\" name=\"pronas\" value=\"" . $form['pronas'] . "\" align=\"right\" maxlength=\"2\" /></td>\n";
echo "</tr>\n";
echo "<tr>\n";
echo "<td>" . $script_transl['counas'] . "</td><td colspan=\"2\">\n";
$gForm->selectFromDB('country', 'counas', 'iso', $form['counas'], 'iso', 1, ' - ', 'name');
echo "</td>\n";
echo "</tr>\n";
echo "<tr>\n";
echo "\t<td>" . $script_transl['telefo'] . " </td>\n";
echo "\t<td colspan=\"2\">
      <input type=\"text\" name=\"telefo\" value=\"" . $form['telefo'] . "\" align=\"right\" maxlength=\"50\" /></td>\n";
echo "</tr>\n";
echo "<tr>\n";
echo "\t<td>" . $script_transl['fax'] . " </td>\n";
echo "\t<td colspan=\"2\">
      <input type=\"text\" name=\"fax\" value=\"" . $form['fax'] . "\" align=\"right\" maxlength=\"50\" /></td>\n";
echo "</tr>\n";
echo "<tr>\n";
echo "\t<td>" . $script_transl['cell'] . " </td>\n";
echo "\t<td colspan=\"2\">
      <input type=\"text\" name=\"cell\" value=\"" . $form['cell'] . "\" align=\"right\" maxlength=\"50\" /></td>\n";
echo "</tr>\n";
echo "<tr>\n";
echo "\t<td><a href=\"https://telematici.agenziaentrate.gov.it/VerificaCF/Scegli.do?parameter=verificaCf\" target=\"blank\">" . $script_transl['codfis'] . "</a> *</td>\n";
echo "\t<td colspan=\"2\">
      <input type=\"text\" name=\"codfis\" id=\"codfis\" value=\"" . $form['codfis'] . "\" align=\"right\" maxlength=\"16\" /></td>\n";
echo "</tr>\n";
echo "<tr>\n";
echo "\t<td><a href=\"https://telematici.agenziaentrate.gov.it/VerificaPIVA/Scegli.do?parameter=verificaPiva\" target=\"blank\">" . $script_transl['pariva'] . "</a> </td>\n";
echo "\t<td colspan=\"2\">
      <input type=\"text\" name=\"pariva\" value=\"" . $form['pariva'] . "\" align=\"right\" maxlength=\"11\"  title=\"11 volte 9 per bolletta doganale\" /></td>\n";
echo "</tr>\n";
echo "<tr>\n";
echo "\t<td><a href=\"https://www.inipec.gov.it/cerca-pec\" target=\"blank\">" . $script_transl['pec_email'] . "</a></td>\n";
echo "\t<td colspan=\"2\">
      <input type=\"text\" name=\"pec_email\" value=\"" . $form['pec_email'] . "\" align=\"right\" maxlength=\"60\" /></td>\n";
echo "</tr>\n";
echo "<tr>\n";
echo "\t<td>" . $script_transl['e_mail'] . "</td>\n";
echo "\t<td colspan=\"2\">
      <input type=\"text\" name=\"e_mail\" value=\"" . $form['e_mail'] . "\" align=\"right\" maxlength=\"60\" /></td>\n";
echo "</tr>\n";
echo "<tr>\n";
echo "<td>" . $script_transl['codpag'] . "</td><td colspan=\"2\">\n";
$gForm->selectFromDB('pagame', 'codpag', 'codice', $form['codpag'],  'tippag`, `giodec`, `numrat', 1, ' ', 'descri');
echo "</td>\n";
echo "</tr>\n";
echo "<tr>\n";
echo "\t<td>" . $script_transl['sconto'] . "</td>\n";
echo "\t<td colspan=\"2\">
      <input type=\"text\" name=\"sconto\" value=\"" . $form['sconto'] . "\" align=\"right\" maxlength=\"5\" /></td>\n";
echo "</tr>\n";
echo "<tr>\n";
echo "<td>" . $script_transl['banapp'] . "</td><td colspan=\"2\">\n";
$select_banapp = new selectbanapp("banapp");
$select_banapp->addSelected($form["banapp"]);
$select_banapp->output();
echo "</td>\n";
echo "</tr>\n";
echo "<tr>\n";
echo "<td>" . $script_transl['portos'] . "</td><td colspan=\"2\">\n";
$gForm->selectFromDB('portos', 'portos', 'codice', $form['portos'], 'codice', 1, ' ', 'descri');
echo "</td>\n";
echo "</tr>\n";
echo "<tr>\n";
echo "<td>" . $script_transl['spediz'] . "</td><td colspan=\"2\">\n";
$gForm->selectFromDB('spediz', 'spediz', 'codice', $form['spediz'], 'codice', 1, ' ', 'descri');
echo "</td>\n";
echo "</tr>\n";
echo "<tr>\n";
echo "<td>" . $script_transl['imball'] . "</td><td colspan=\"2\">\n";
$gForm->selectFromDB('imball', 'imball', 'codice', $form['imball'], 'codice', 1, ' ', 'descri');
echo "</td>\n";
echo "</tr>\n";
echo "<tr>\n";
echo "<td>" . $script_transl['listin'] . "</td><td colspan=\"2\">\n";
$gForm->selectNumber('listin', $form['listin'], 0, 1, 3);
echo "</td>\n";
echo "</tr>\n";
echo "<tr>\n";
echo "<td>" . $script_transl['cosric'] . "</td><td colspan=\"2\">\n";
$gForm->selectAccount('cosric', $form['cosric'], 3);
echo "</td>\n";
echo "</tr>\n";

echo "<tr>\n";
echo "<td>" . $script_transl['id_agente'] . "</td><td colspan=\"2\">\n";
$select_agente = new selectAgente("id_agente", "F");
$select_agente->addSelected($form["id_agente"]);
$select_agente->output();
echo "</td>\n";
echo "</tr>\n";
echo "<tr>\n";
echo "\t<td>" . $script_transl['destin'] . " </td>\n";
echo "\t<td colspan=\"2\">
      <textarea name=\"destin\" rows=\"2\" cols=\"50\" class=\"FacetInput\">" . $form["destin"] . "</TEXTAREA></td>\n";
echo "</tr>\n";
echo "<tr>\n";
echo "\t<td>" . $script_transl['id_des'] . " </td><td colspan=\"2\">\n";
$select_id_des = new selectPartner("id_des");
$select_id_des->selectAnagra('id_des', $form['id_des'], $form['search']['id_des'], 'id_des', $script_transl['mesg']);
echo "</td>\n";
echo "</tr>\n";
echo "<tr>\n";
echo "\t<td>" . $script_transl['iban'] . " </td>\n";
echo "\t<td colspan=\"2\">
      <input type=\"text\" name=\"iban\" id=\"iban\" value=\"" . $form['iban'] . "\" align=\"right\" maxlength=\"27\" /></td>\n";
echo "</tr>\n";
echo "<tr>\n";
echo "\t<td>" . $script_transl['maxrat'] . "</td>\n";
echo "\t<td colspan=\"2\">
      <input type=\"text\" name=\"maxrat\" value=\"" . $form['maxrat'] . "\" align=\"right\" maxlength=\"16\" /></td>\n";
echo "</tr>\n";
echo "<tr>\n";
echo "<td>" . $script_transl['ragdoc'] . "</td><td colspan=\"2\">\n";
$gForm->variousSelect('ragdoc', $script_transl['yn_value'], $form['ragdoc']);
echo "\t </td>\n";
echo "</tr>\n";
echo "<tr>\n";
echo "<td>" . $script_transl['speban'] . "</td><td colspan=\"2\">\n";
$gForm->variousSelect('speban', $script_transl['yn_value'], $form['speban']);
echo "\t </td>\n";
echo "</tr>\n";
echo "<tr>\n";
echo "<td>" . $script_transl['addbol'] . "</td><td colspan=\"2\">\n";
$gForm->variousSelect('addbol', $script_transl['yn_value'], $form['addbol']);
echo "\t </td>\n";
echo "</tr>\n";
echo "<tr>\n";
echo "<td>" . $script_transl['spefat'] . "</td><td colspan=\"2\">\n";
$gForm->variousSelect('spefat', $script_transl['yn_value'], $form['spefat']);
echo "\t </td>\n";
echo "</tr>\n";
echo "<tr>\n";
echo "<td>" . $script_transl['stapre'] . "</td><td colspan=\"2\">\n";
$gForm->variousSelect('stapre', $script_transl['yn_value'], $form['stapre']);
echo "\t </td>\n";
echo "</tr>\n";
echo "<tr>\n";
echo "<td>" . $script_transl['aliiva'] . "</td><td colspan=\"2\">\n";
$gForm->selectFromDB('aliiva', 'aliiva', 'codice', $form['aliiva'], 'codice', 1, ' - ', 'descri');
echo "</td>\n";
echo "</tr>\n";
echo "<tr>\n";
echo "\t<td>" . $script_transl['ritenuta'] . "</td>\n";
echo "\t<td colspan=\"2\">
      <input type=\"text\" name=\"ritenuta\" value=\"" . $form['ritenuta'] . "\" align=\"right\" maxlength=\"4\" /></td>\n";
echo "</tr>\n";
echo "<tr>\n";
echo "\t<td>" . $script_transl['operation_type'] . "</td>\n";
echo "\t<td colspan=\"2\">";
$gForm->selectFromXML('../../library/include/operation_type.xml', 'operation_type', 'operation_type', $form['operation_type'], true, '', 'col-sm-6');
echo "</td></tr>\n";
echo "<tr>\n";
echo "<td>" . $script_transl['allegato'] . "</td><td colspan=\"2\">\n";
$gForm->variousSelect('allegato', $script_transl['allegato_value'], $form['allegato'], 'FacetSelect', false);
echo "\t </td>\n";
echo "</tr>\n";
echo "<tr>\n";
echo "<td>" . $script_transl['status'] . "</td><td colspan=\"2\">\n";
$gForm->variousSelect('status', $script_transl['status_value'], $form['status'], 'FacetSelect', false);
echo "\t </td>\n";
echo "</tr>\n";
echo "<tr>\n";
echo "\t<td>" . $script_transl['annota'] . "</td>\n";
//echo "\t<td colspan=\"2\">
//      <input type=\"text\" name=\"annota\" value=\"".$form['annota']."\" align=\"right\" maxlength=\"100\" /></td>\n";
echo "\t<td colspan=\"2\">
      <textarea name=\"annota\" rows=\"2\" cols=\"50\" class=\"FacetInput\">" . $form["annota"] . "</TEXTAREA></td>\n";
echo "</tr>\n";
echo "<tr>\n";
echo "\t<td> Codice identificativo SIAN </td>\n";
echo "\t<td colspan=\"2\">
      <input type=\"text\" onkeyup=\"this.value=this.value.replace(/[^\d]/,'')\" name=\"id_SIAN\" value=\"" . $form['id_SIAN'] . "\" align=\"right\" maxlength=\"10\" /></td>\n";
echo "</tr>\n";
echo "<tr>\n";
echo "\t<td>" . $script_transl['sqn'] . "</td>";
echo "\t </td>\n";
echo "\t<td >\n";
echo '<input name="Return" type="submit" value="' . $script_transl['return'] . '">';
echo "\t </td>\n";
echo "\t<td  align=\"right\">\n";
echo '<input name="Submit" type="submit" value="' . ucfirst($script_transl[$toDo]) . '">';
echo "\t </td>\n";
echo "</tr>\n";
?>
</table></div>
</form>
<?php
require("../../library/include/footer.php");
?>