CREATE DATABASE IF NOT EXISTS gazie;
USE gazie;
SET NAMES utf8;

SET SQL_MODE = "NO_AUTO_VALUE_ON_ZERO";
SET AUTOCOMMIT = 0;
START TRANSACTION;
SET time_zone = "+00:00";


/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8mb4 */;

--
-- Database: `gazie`
--

-- --------------------------------------------------------

--
-- Struttura della tabella `gaz_001agenti`
--

DROP TABLE IF EXISTS `gaz_001agenti`;
CREATE TABLE IF NOT EXISTS `gaz_001agenti` (
  `id_agente` int(9) NOT NULL,
  `id_fornitore` int(9) NOT NULL,
  `base_percent` decimal(4,2) NOT NULL,
  `tipo_contratto` tinyint(1) NOT NULL,
  `adminid` varchar(20) NOT NULL,
  `last_modified` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id_agente`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Dump dei dati per la tabella `gaz_001agenti`
--

INSERT INTO `gaz_001agenti` (`id_agente`, `id_fornitore`, `base_percent`, `tipo_contratto`, `adminid`, `last_modified`) VALUES
(1, 212000007, '3.00', 0, 'amministratore', '2008-10-04 06:48:11');

-- --------------------------------------------------------

--
-- Struttura della tabella `gaz_001agenti_forn`
--

DROP TABLE IF EXISTS `gaz_001agenti_forn`;
CREATE TABLE IF NOT EXISTS `gaz_001agenti_forn` (
  `id_agente` int(9) NOT NULL,
  `id_fornitore` int(9) NOT NULL,
  `base_percent` decimal(4,2) NOT NULL,
  `tipo_contratto` tinyint(1) NOT NULL,
  `adminid` varchar(20) NOT NULL,
  `last_modified` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  KEY `idx_id_agente` (`id_agente`) USING BTREE,
  KEY `idx_id_fornitore` (`id_fornitore`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Struttura della tabella `gaz_001aliiva`
--

DROP TABLE IF EXISTS `gaz_001aliiva`;
CREATE TABLE IF NOT EXISTS `gaz_001aliiva` (
  `codice` int(3) NOT NULL DEFAULT '0',
  `tipiva` char(1) NOT NULL DEFAULT '',
  `operation_type` char(15) NOT NULL DEFAULT '',
  `aliquo` decimal(3,1) DEFAULT '0.0',
  `taxstamp` int(1) NOT NULL,
  `fae_natura` varchar(4) NOT NULL,
  `descri` varchar(50) NOT NULL DEFAULT '',
  `status` varchar(10) DEFAULT NULL,
  `annota` varchar(255) DEFAULT NULL COMMENT 'Descrizione estesa e/o annotazioni',
  `adminid` varchar(20) NOT NULL DEFAULT '',
  `last_modified` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`codice`),
  KEY `tipiva` (`tipiva`),
  KEY `aliquo` (`aliquo`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Dump dei dati per la tabella `gaz_001aliiva`
--

INSERT INTO `gaz_001aliiva` (`codice`, `tipiva`, `operation_type`, `aliquo`, `taxstamp`, `fae_natura`, `descri`, `status`, `annota`, `adminid`, `last_modified`) VALUES
(1, 'I', '', '22.0', 0, '', 'IVA al 22%', '0', '', 'amministratore', '2008-10-08 09:50:08'),
(2, 'I', '', '10.0', 0, '', 'IVA al 10%', '0', '', 'amministratore', '2008-10-08 09:50:00'),
(3, 'I', '', '5.0', 0, '', 'IVA al 5%', '0', '', 'amministratore', '2021-01-24 12:48:35'),
(4, 'I', '', '4.0', 0, '', 'IVA al 4%', '0', '', 'amministratore', '2021-01-24 12:48:26'),
(5, 'D', '', '22.0', 0, '', 'IVA al 22% INDETRAIBILE', '', '', 'amministratore', '2021-01-24 12:49:36'),
(6, 'D', '', '10.0', 0, '', 'IVA al 10% INDETRAIBILE', '', '', 'amministratore', '2021-01-24 12:49:38'),
(7, 'D', '', '4.0', 0, '', 'IVA al 4% INDETRAIBILE', '', '', 'amministratore', '2021-01-24 12:49:41'),
(8, 'T', '', '22.0', 0, '', 'IVA 22% SPLIT PAYMENT', '', '', '', '2021-01-24 12:50:10'),
(9, 'T', '', '10.0', 0, '', 'IVA 10% SPLIT PAYMENT', '', '', '', '2021-01-24 12:50:33'),
(10, 'T', '', '4.0', 0, '', 'IVA 4% SPLIT PAYMENT', '', '', '', '2021-01-24 12:50:36'),
(11, 'C', '', '0.0', 1, 'N1', 'Esclusa art. 15', '0', '', 'amministratore', '2021-01-24 12:54:12'),
(12, 'S', '', '0.0', 1, 'N2.2', 'Fuori campo Iva art. 2 DPR 633/72', NULL, NULL, '', '2021-01-24 12:04:11'),
(13, 'S', '', '0.0', 1, 'N2.2', 'Fuori campo Iva art. 3 DPR 633/72', NULL, NULL, '', '2021-01-24 12:04:11'),
(14, 'S', '', '0.0', 1, 'N2.2', 'Fuori campo Iva art. 4 DPR 633/72', NULL, NULL, '', '2021-01-24 12:04:11'),
(15, 'S', '', '0.0', 1, 'N2.2', 'Fuori campo Iva art. 5 DPR 633/72', NULL, NULL, '', '2021-01-24 12:04:11'),
(16, 'S', '', '0.0', 1, 'N2.1', 'Art.7 bis DPR 633/72 (cessione di beni extra-UE)', NULL, NULL, '', '2021-01-24 12:04:11'),
(17, 'S', '', '0.0', 1, 'N2.1', 'Art.7 ter  DPR 633/72 prest.serv.UE (vendite)', NULL, NULL, '', '2021-01-24 12:04:11'),
(18, 'S', '', '0.0', 1, 'N2.1', 'Art.7 ter  DPR 633/72 prest.serv.extra-UE', NULL, NULL, '', '2021-01-24 12:04:11'),
(19, 'S', '', '0.0', 1, 'N2.1', 'Art.7 quater DPR 633/72 prest.serv. UE (vendite)', NULL, NULL, '', '2021-01-24 12:04:11'),
(20, 'S', '', '0.0', 1, 'N2.1', 'Art.7 quater DPR 633/72 prest.serv. extra-UE', NULL, NULL, '', '2021-01-24 12:04:11'),
(21, 'S', '', '0.0', 1, 'N2.1', 'Art.7 quinquies DPR 633/72 (prest.serv.)', NULL, NULL, '', '2021-01-24 12:04:11'),
(22, 'S', '', '0.0', 1, 'N2.1', 'Art.7 sexies, septies DPR 633/72 (prest.serv.)', NULL, NULL, '', '2021-01-24 12:04:11'),
(23, 'S', '', '0.0', 1, 'N2.2', 'Art. 38 c.5 DL  331/1993', NULL, NULL, '', '2021-01-24 12:04:11'),
(24, 'S', '', '0.0', 1, 'N2.2', 'Art.17 c.3 DPR 633/72', NULL, NULL, '', '2021-01-24 12:04:11'),
(25, 'S', '', '0.0', 1, 'N2.2', 'Art.19 c.3 lett. b DPR 633/72', NULL, NULL, '', '2021-01-24 12:04:11'),
(26, 'S', '', '0.0', 1, 'N2.2', 'Art.50 bis c.4 DL 331/1993', NULL, NULL, '', '2021-01-24 12:04:11'),
(27, 'S', '', '0.0', 1, 'N2.2', 'Art.74 cc.1e2 DPR 633/72', NULL, NULL, '', '2021-01-24 12:04:11'),
(28, 'S', '', '0.0', 1, 'N2.2', 'Art.19 c.3 lett.e DPR 633/72', NULL, NULL, '', '2021-01-24 12:04:11'),
(29, 'S', '', '0.0', 1, 'N2.2', 'Art.13 DPR 633/72', NULL, NULL, '', '2021-01-24 12:04:11'),
(30, 'S', '', '0.0', 1, 'N2.2', 'Art.27 c.1e2 DL 98/2011(contr.min.)', NULL, NULL, '', '2021-01-24 12:04:11'),
(31, 'S', '', '0.0', 1, 'N2.2', 'Art.1 c.54-89 L. 190/2014 succ.mod.(forf.)', NULL, NULL, '', '2021-01-24 12:04:11'),
(32, 'S', '', '0.0', 1, 'N2.2', 'Art.26 c.3 DPR 633/72', NULL, NULL, '', '2021-01-24 12:04:11'),
(33, 'S', '', '0.0', 1, 'N2.2', 'DM 9/4/1993', NULL, NULL, '', '2021-01-24 12:04:11'),
(34, 'S', '', '0.0', 1, 'N2.2', 'Art.26 bis L.196/1997', NULL, NULL, '', '2021-01-24 12:04:11'),
(35, 'S', '', '0.0', 1, 'N2.2', 'Art.8 c.35 L. 67/1988', NULL, NULL, '', '2021-01-24 12:04:11'),
(36, 'N', '', '0.0', 1, 'N3.1', 'Art.8 c.1 lett.a DPR 633/72', NULL, NULL, '', '2021-01-24 12:04:11'),
(37, 'N', '', '0.0', 1, 'N3.1', 'Art.8 c.1 lett.b DPR 633/72', NULL, NULL, '', '2021-01-24 12:04:11'),
(38, 'N', '', '0.0', 1, 'N3.6', 'Art.2 c.2, n.4 DPR 633/72', NULL, NULL, '', '2021-01-24 12:04:11'),
(39, 'N', '', '0.0', 1, 'N3.4', 'Art.8 bis DPR 633/72', NULL, NULL, '', '2021-01-24 12:04:11'),
(40, 'N', '', '0.0', 1, 'N3.6', 'Art.9 c.1 DPR 633/72', NULL, NULL, '', '2021-01-24 12:04:11'),
(41, 'N', '', '0.0', 1, 'N3.6', 'Non imp. art.72 DPR 633/72', NULL, NULL, '', '2021-01-24 12:04:11'),
(42, 'N', '', '0.0', 1, 'N3.6', 'Art. 71 DPR 633/72', NULL, NULL, '', '2021-01-24 12:04:11'),
(43, 'N', '', '0.0', 1, 'N3.1', 'Non imp. art.8 c.1 lett. b-bis  DPR 633/72', NULL, NULL, '', '2021-01-24 12:04:11'),
(44, 'N', '', '0.0', 1, 'N3.5', 'Non imp. art.8 c.1 lett. c DPR 633/72', NULL, NULL, '', '2021-01-24 12:04:11'),
(45, 'N', '', '0.0', 1, 'N3.4', 'Non imp. art.8 bis c.2 DPR 633/72', NULL, NULL, '', '2021-01-24 12:04:11'),
(46, 'N', '', '0.0', 1, 'N3.1', 'Non imp. art.9 c.2 DPR 633/72', NULL, NULL, '', '2021-01-24 12:04:11'),
(47, 'N', '', '0.0', 1, 'N3.1', 'Non imp.art.72 c.1 DPR 633/72', NULL, NULL, '', '2021-01-24 12:04:11'),
(48, 'N', '', '0.0', 1, 'N3.1', 'Non imp. art.50 bis c.4 lett.g DL 331/93', NULL, NULL, '', '2021-01-24 12:04:11'),
(49, 'N', '', '0.0', 1, 'N3.2', 'Non imp. art.50 bis c.4 lett.f DL 331/93', NULL, NULL, '', '2021-01-24 12:04:11'),
(50, 'N', '', '0.0', 1, 'N3.2', 'Non imp. art.41 DL 331/93', NULL, NULL, '', '2021-01-24 12:04:11'),
(51, 'N', '', '0.0', 1, 'N3.2', 'Non imp. art.58 c.1 DL 331/93', NULL, NULL, '', '2021-01-24 12:04:11'),
(52, 'N', '', '0.0', 1, 'N3.6', 'Non imp. art.38 quater c.1 DPR 633/72', NULL, NULL, '', '2021-01-24 12:04:11'),
(53, 'N', '', '0.0', 1, 'N3.1', 'Non imp. art.14 legge n. 49/1987', NULL, NULL, '', '2021-01-24 12:04:11'),
(54, 'E', '', '0.0', 1, 'N4', 'Esente art.10 DPR 633/72', NULL, NULL, '', '2021-01-24 12:04:11'),
(55, 'E', '', '0.0', 1, 'N4', 'Esente a.19 c.3 lett.a bis DPR 633/72', NULL, NULL, '', '2021-01-24 12:04:11'),
(56, 'E', '', '0.0', 1, 'N4', 'Esente art.10 n.27 quinquies DPR 633/72', NULL, NULL, '', '2021-01-24 12:04:11'),
(57, 'E', '', '0.0', 1, 'N4', 'Esente art.10 n.18 DPR 633/72', NULL, NULL, '', '2021-01-24 12:04:11'),
(58, 'E', '', '0.0', 1, 'N4', 'Esente art.10 n.19 DPR 633/72', NULL, NULL, '', '2021-01-24 12:04:11'),
(59, 'M', '', '0.0', 1, 'N5', 'Art.36 DL n.41/1995', NULL, NULL, '', '2021-01-24 12:04:11'),
(60, 'M', '', '0.0', 1, 'N5', 'Art.36 c.1 DL 41/1995', NULL, NULL, '', '2021-01-24 12:04:11'),
(61, 'M', '', '0.0', 1, 'N5', 'Art.36 c.5 DL 41/1995', NULL, NULL, '', '2021-01-24 12:04:11'),
(62, 'M', '', '0.0', 1, 'N5', 'Art.36 c.6 DL 41/1995', NULL, NULL, '', '2021-01-24 12:04:11'),
(63, 'M', '', '0.0', 1, 'N5', 'Art.74 ter DPR 633/72 (Reg.spec, ag.viaggio)', NULL, NULL, '', '2021-01-24 12:04:11'),
(64, 'R', '', '22.0', 0, 'N6.2', 'Acquisti art.17 c.5', NULL, NULL, '', '2021-01-24 12:04:11'),
(65, 'R', '', '0.0', 0, 'N6.2', 'Vendite art.17 c.5', NULL, NULL, '', '2021-01-24 12:04:11'),
(66, 'R', '', '22.0', 0, 'N6.4', 'Acquisti art.17 c.6 l.a bis', NULL, NULL, '', '2021-01-24 12:04:11'),
(67, 'R', '', '0.0', 0, 'N6.4', 'Vendite art.17 c.6 l.a bis', NULL, NULL, '', '2021-01-24 12:04:11'),
(68, 'R', '', '22.0', 0, 'N6.1', 'Acquisti art.74 c. 7 e 8', NULL, NULL, '', '2021-01-24 12:04:11'),
(69, 'R', '', '0.0', 0, 'N6.1', 'Vendite art.74 c. 7 e 8', NULL, NULL, '', '2021-01-24 12:04:11'),
(70, 'R', '', '22.0', 0, 'N6.3', 'Acquisti art.17 c.6 l. a', NULL, NULL, '', '2021-01-24 12:04:11'),
(71, 'R', '', '0.0', 0, 'N6.3', 'Vendite art.17 c.6 l. a', NULL, NULL, '', '2021-01-24 12:04:11'),
(72, 'R', '', '22.0', 0, 'N6.5', 'Acquisti art.17 c.6 l. b', NULL, NULL, '', '2021-01-24 12:04:11'),
(73, 'R', '', '0.0', 0, 'N6.5', 'Vendite Art.17 c.6 l. b', NULL, NULL, '', '2021-01-24 12:04:11'),
(74, 'R', '', '22.0', 0, 'N6.6', 'Acquisti art.17 c.6 l. c', NULL, NULL, '', '2021-01-24 12:04:11'),
(75, 'R', '', '0.0', 0, 'N6.6', 'Vendite Art.17 c.6 l. c', NULL, NULL, '', '2021-01-24 12:04:11'),
(76, 'R', '', '22.0', 0, 'N6.7', 'Acquisti art.17 c.6 l. a ter', NULL, NULL, '', '2021-01-24 12:04:11'),
(77, 'R', '', '0.0', 0, 'N6.7', 'Vendite Art.17 c.6 l. a ter', NULL, NULL, '', '2021-01-24 12:04:11'),
(78, 'R', '', '22.0', 0, 'N6.8', 'Acquisti art.17 c.6 l. d bis,d ter,d quater', NULL, NULL, '', '2021-01-24 12:04:11'),
(79, 'R', '', '0.0', 0, 'N6.8', 'Vendite Art.17 c.6 l. d bis,d ter,d quater', NULL, NULL, '', '2021-01-24 12:04:11'),
(80, 'R', '', '0.0', 0, 'N6.9', 'Cessioni beni UE art.7 bis', NULL, NULL, '', '2021-01-24 12:04:11'),
(81, 'R', 'SERVIZ', '22.0', 0, 'N6.9', 'Acquisti art.7 quater prest.serv. (TD17)', NULL, NULL, '', '2021-01-24 12:04:11'),
(82, 'R', 'SERVIZ', '22.0', 0, 'N6.9', 'Acquisti art.7 quinquies prest.serv (TD17)', NULL, NULL, '', '2021-01-24 12:04:11'),
(83, 'R', '', '22.0', 0, 'N6.9', 'Acquisti art.17 c.2 (beni extra UE TD19) ', NULL, NULL, '', '2021-01-24 12:04:11'),
(84, 'R', '', '22.0', 0, 'N6.9', 'Acquisti art.46 (beni intra UE TD18) ', NULL, NULL, '', '2021-01-24 12:04:11'),
(85, 'S', '', '0.0', 1, 'N7', 'Art.40 c. 3 e 4 e art.41 DL 331/93', NULL, NULL, '', '2021-01-24 12:04:11');

-- --------------------------------------------------------

--
-- Struttura della tabella `gaz_001artico`
--

DROP TABLE IF EXISTS `gaz_001artico`;
CREATE TABLE IF NOT EXISTS `gaz_001artico` (
  `codice` varchar(32) NOT NULL DEFAULT '',
  `descri` varchar(255) DEFAULT NULL,
  `id_artico_group` int(9) NOT NULL DEFAULT '0' COMMENT 'Se valorizzato punta all''id di gaz_NNNartico_group e serve per indicare ad un ecommerce sincronizzato che questa è una variante del prodotto genericamente indicato nella tabella citata',
  `codice_fornitore` varchar(50) NOT NULL COMMENT 'Da intendersi come "codice produttore" ovvero univoco per il medesimo prodotto, indipendentemente dal canale/fornitore utilizzato per l''approvigionamento. I codici utilizzati dai singoli fornitori vanno eventualmente indicati su rigdoc-rigbro',
  `id_assets` int(9) NOT NULL DEFAULT '0' COMMENT 'Riferimento al bene strumentale ( id di gaz_NNNassets), quando maggiore di 0 è un bene strumentale e come tale in genere non in vendita ',
  `ref_ecommerce_id_product` varchar(50) DEFAULT '' COMMENT 'Riferimento all''articolo in eventuale ecommerce sincronizzato',
  `custom_field` text COMMENT 'Riferimenti generici utilizzabili sui moduli. Normalmente in formato json: {"nome_modulo":{"nome_variabile":{"valore_variabile": {}}}}',
  `ecomm_option_attribute` varchar(255) NOT NULL DEFAULT '' COMMENT 'Riferimenti  agli attributi, opzioni, varianti utilizzati dall''ecommerce sincronizzato. Normalmente un array json',
  `quality` varchar(50) NOT NULL COMMENT 'per indicare la qualità del materiale , normativa, ecc',
  `ordinabile` varchar(1) NOT NULL,
  `movimentabile` varchar(1) NOT NULL,
  `good_or_service` int(1) NOT NULL,
  `lot_or_serial` int(1) NOT NULL,
  `image` blob,
  `barcode` varchar(64) NOT NULL DEFAULT '',
  `unimis` char(3) DEFAULT NULL,
  `larghezza` decimal(10,3) DEFAULT NULL,
  `lunghezza` decimal(10,3) DEFAULT NULL,
  `spessore` decimal(10,3) DEFAULT NULL,
  `bending_moment` decimal(8,2) DEFAULT NULL COMMENT 'Resistenza es.momento flettente (Wx cm³), utilizzabile per calcoli di svariata natura comunque legati alla resistenza meccanica del materiale',
  `catmer` int(3) NOT NULL DEFAULT '0',
  `ragstat` char(15) NOT NULL,
  `preacq` decimal(14,5) DEFAULT '0.00000' COMMENT 'Colonna utilizzata dal modulo ProduzionI (orderman) per indicare il costo di produzione in mancanza di movimenti di magazzino per acquisti. Sul modulo Acquisti (acquis) indica il prezzo di acquisto di un bene strumentale o servizio, e comunque di qualsiasi merce/servizio/strumento che non è presente in contabilità di magazzino (gaz_NNNmovmag).',
  `preve1` decimal(14,5) DEFAULT '0.00000',
  `preve2` decimal(14,5) DEFAULT '0.00000',
  `preve3` decimal(14,5) DEFAULT '0.00000',
  `preve4` decimal(14,5) DEFAULT '0.00000',
  `sconto` decimal(6,3) DEFAULT '0.000',
  `web_mu` varchar(15) NOT NULL,
  `web_price` decimal(14,5) NOT NULL,
  `web_multiplier` decimal(6,3) NOT NULL,
  `web_public` tinyint(1) NOT NULL,
  `depli_public` tinyint(1) DEFAULT '0',
  `web_url` varchar(255) NOT NULL,
  `aliiva` int(2) DEFAULT NULL,
  `retention_tax` tinyint(4) NOT NULL DEFAULT '0',
  `last_cost` decimal(14,5) DEFAULT '0.00000',
  `payroll_tax` tinyint(4) NOT NULL DEFAULT '0',
  `scorta` decimal(12,3) DEFAULT '0.000',
  `riordino` decimal(12,3) DEFAULT '0.000',
  `uniacq` char(3) NOT NULL DEFAULT '',
  `classif_amb` tinyint(1) NOT NULL DEFAULT '0' COMMENT 'Classificazione ambientale come da art.16  comma 2 del D.Lgs 150/2012 (Utilizzato in quaderno di campagna)',
  `maintenance_period` int(3) NOT NULL DEFAULT '0' COMMENT 'Periodicità in giorni della eventuale manutenzione del bene/servizio',
  `durability` int(4) NOT NULL DEFAULT '0' COMMENT 'Durabilità anche se solo presunta espressa in unità di misura specificata nel campo successivo',
  `durability_mu` varchar(1) DEFAULT NULL COMMENT 'Unità di misura della durabilità di cui al campo precedente (H=ore,D=giorni,M=mesi) nel caso di durabilità alimenti (<=minore di,>=maggiore di)',
  `warranty_days` int(4) NOT NULL DEFAULT '0' COMMENT 'Durata della garanzia in giorni',
  `mostra_qdc` tinyint(1) NOT NULL DEFAULT '0' COMMENT 'Mostra nei movimenti del quaderno di campagna: 1=si , 0=no',
  `peso_specifico` decimal(12,3) DEFAULT '0.000',
  `volume_specifico` decimal(12,3) NOT NULL,
  `dose_massima` decimal(8,3) NOT NULL DEFAULT '0.000' COMMENT 'Utilizzato in quaderno di campagna',
  `rame_metallico` decimal(8,3) NOT NULL DEFAULT '0.000' COMMENT 'Utilizzato in quaderno di campagna',
  `perc_N` decimal(3,1) DEFAULT NULL COMMENT 'Se un concime dev''essere valorizzato con la percentuale di azoto (N)',
  `perc_P` decimal(3,1) DEFAULT NULL COMMENT 'Se un concime dev''essere valorizzato con la percentuale di fosforo (P)',
  `perc_K` decimal(3,1) DEFAULT NULL COMMENT 'Se un concime dev''essere valorizzato con la percentuale di potassio (K)',
  `tempo_sospensione` int(2) NOT NULL DEFAULT '0' COMMENT 'Utilizzato in quaderno di campagna',
  `SIAN` int(1) NOT NULL DEFAULT '0' COMMENT '0 non movimenta, 1 movimenta il SIAN come olio, 2 movimenta il SIAN come olive',
  `id_reg` int(6) NOT NULL COMMENT 'Riferimento al numero registrazione della tabella camp_fitofarmaci',
  `pack_units` tinyint(6) NOT NULL,
  `codcon` int(9) NOT NULL DEFAULT '0',
  `id_cost` int(9) NOT NULL,
  `annota` varchar(50) DEFAULT NULL,
  `adminid` varchar(20) NOT NULL DEFAULT '',
  `last_modified` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `clfoco` char(15) DEFAULT NULL,
  `last_used` date DEFAULT NULL,
  PRIMARY KEY (`codice`),
  KEY `ragstat` (`ragstat`),
  KEY `clfoco` (`clfoco`),
  KEY `ref_ecommerce_id_product` (`ref_ecommerce_id_product`),
  KEY `catmer` (`catmer`),
  KEY `id_assets` (`id_assets`),
  KEY `id_reg` (`id_reg`),
  KEY `id_artico_group` (`id_artico_group`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Dump dei dati per la tabella `gaz_001artico`
--

INSERT INTO `gaz_001artico` (`codice`, `descri`, `id_artico_group`, `codice_fornitore`, `id_assets`, `ref_ecommerce_id_product`, `custom_field`, `ecomm_option_attribute`, `quality`, `ordinabile`, `movimentabile`, `good_or_service`, `lot_or_serial`, `image`, `barcode`, `unimis`, `larghezza`, `lunghezza`, `spessore`, `bending_moment`, `catmer`, `ragstat`, `preacq`, `preve1`, `preve2`, `preve3`, `preve4`, `sconto`, `web_mu`, `web_price`, `web_multiplier`, `web_public`, `depli_public`, `web_url`, `aliiva`, `retention_tax`, `last_cost`, `payroll_tax`, `scorta`, `riordino`, `uniacq`, `classif_amb`, `maintenance_period`, `durability`, `durability_mu`, `warranty_days`, `mostra_qdc`, `peso_specifico`, `volume_specifico`, `dose_massima`, `rame_metallico`, `perc_N`, `perc_P`, `perc_K`, `tempo_sospensione`, `SIAN`, `id_reg`, `pack_units`, `codcon`, `id_cost`, `annota`, `adminid`, `last_modified`, `clfoco`, `last_used`) VALUES
('PENGUIN', 'Plastic penguin', 0, '', 0, '3', NULL, '', '', '', '', 0, 0, 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, '8004551806212', 'pz', NULL, NULL, NULL, NULL, 1, '', '10.55000', '15.88000', '16.90000', '19.21000', '0.00000', '0.000', 'pz', '15.88000', '1.000', 1, 1, '', 1, 0, '0.00000', 0, '0.000', '0.000', 'pz', 0, 0, 0, NULL, 0, 0, '0.200', '0.810', '0.000', '0.000', NULL, NULL, NULL, 0, 0, 0, 3, 0, 0, 'PET 100 gr', 'amministratore', '2020-03-10 10:48:56', '', NULL),
('USBLIGHT', 'Luce per notebook USB', 0, '', 0, '4', NULL, '', '', '', '', 0, 0, 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, '1000000000047', 'pz', NULL, NULL, NULL, NULL, 1, '', '0.00000', '10.00000', '12.00000', '14.00000', '0.00000', '0.000', 'pz', '10.00000', '1.000', 1, 1, '', 1, 0, '0.00000', 0, '0.000', '0.000', 'pz', 0, 0, 0, NULL, 0, 0, '0.000', '0.000', '0.000', '0.000', NULL, NULL, NULL, 0, 0, 0, 1, 420000006, 330000004, '', 'amministratore', '2020-03-10 10:48:56', '', NULL),
('H1000', 'Miele mille fiori 1 kg', 0, '', 0, '1', NULL, '', '', '', '', 0, 0, 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, '1000000000092', 'pz', NULL, NULL, NULL, NULL, 1, '', '0.00000', '5.00000', '7.00000', '9.00000', '0.00000', '0.000', 'pz', '5.00000', '1.000', 1, 1, '', 2, 0, '0.00000', 0, '0.000', '0.000', 'pz', 0, 0, 0, NULL, 0, 0, '0.000', '0.000', '0.000', '0.000', NULL, NULL, NULL, 0, 0, 0, 1, 420000006, 330000004, '', 'amministratore', '2020-03-10 10:48:56', '', NULL);
INSERT INTO `gaz_001artico` (`codice`, `descri`, `id_artico_group`, `codice_fornitore`, `id_assets`, `ref_ecommerce_id_product`, `custom_field`, `ecomm_option_attribute`, `quality`, `ordinabile`, `movimentabile`, `good_or_service`, `lot_or_serial`, `image`, `barcode`, `unimis`, `larghezza`, `lunghezza`, `spessore`, `bending_moment`, `catmer`, `ragstat`, `preacq`, `preve1`, `preve2`, `preve3`, `preve4`, `sconto`, `web_mu`, `web_price`, `web_multiplier`, `web_public`, `depli_public`, `web_url`, `aliiva`, `retention_tax`, `last_cost`, `payroll_tax`, `scorta`, `riordino`, `uniacq`, `classif_amb`, `maintenance_period`, `durability`, `durability_mu`, `warranty_days`, `mostra_qdc`, `peso_specifico`, `volume_specifico`, `dose_massima`, `rame_metallico`, `perc_N`, `perc_P`, `perc_K`, `tempo_sospensione`, `SIAN`, `id_reg`, `pack_units`, `codcon`, `id_cost`, `annota`, `adminid`, `last_modified`, `clfoco`, `last_used`) VALUES
('INSTGAZIE', 'Installazione e avviamento gestionale GAzie', 0, '', 0, '2', NULL, '', '', '', '', 1, 0, 0x474946383961c7009a00f70000000000ed790cca140ac7889f5f3817f8bcc5c65d65f2a5c4322021ef9cbcf09ba6210c12c66917ee8ba561685fffcccc009933227352ee7c945f4f5203843a28634a037633c3301c304c3fcda0a72c4e3e9e4f0414693a96878cf7b6c5f7dddec17e92cbaac059484af1acbd303f38f6bfd4c5474789585d3f674ca06979dd1b11c3818bf8e5e492210be3859de57617cebfc4f09cb5cc6600f6b5ce333333544d4ef6bdcef7acc5999999966c73c07383256e3ea95b19272a2e494042f8cede1c7d48c6221cd97e9576555cf2f4f331613ef08dac472d174b534d934b06de8fa5dd241df1a4b5dbd1d3e49cb4159648f7c5d6af6271147341f0a5bdd771177a7172f6c5cebf6778f8b5be7f4f3ed093a6db768cddb5c4c43d3a6c411dd88b94f8d7deef9cadb1798ca05460158944486e5bf8adcc53614bb42821180f0fb2717d231919423a3bad9fa7655c5b009440217a54cc3333df95afef839cf9dfe8f7a5c4f8c4ddcca9b3e39da7c75456352929347d4e394c3864484bf47d17ee94a5d78d9def95b4d6150af1acb6238044ce7582205f3acb6e7a3c31327d7b79774317f7ced6e8c1d0f59dad147639cb2119e3e3e3e5939e785e64e7a7c06d494bde21188e7579e5a8b7d7763f326c42008b39883e1dce8c95c54d196a716cb561170e120d298248e67c95514446a48991bf6417ffffff523117f7a4befbbcda196c42019c42f8aebc89626de7b6ca47734e236c4cae4a4dc97141cc6666f093ad9966666c5358f7d5d8f69dbede7417ffd5e4e87917dd261effcedf965219d7a0a9d692a6f69bb44b4e3e1e92494a694b3b7450cd7a8bfe8aa6dda7b5181a15228e4ace8b9ce06f86aeacab7f8a85ef8a9e577761e694b23a3939864a179e757cb37a83dc667a087d3ab585921a734ddcbdc7e793a6e7758c902924385e3e33281a291017261f1ccd1a10d08495f98317f8bcdce1a9bf294735f7abb5ef7c1834322ad31d1ed61a0f68432c3d3a31f0a3ad666666fedfe8ce6a184b825673706ef9b6d3fec5d8df8e9b927d84058e3f493a3db94413c52822295b44ffc5dd33333321f904051400ff002c00000000c7009a000008ff00ff091c48b0a0c18308132a5cc8b0a1401a341c4a9c48b1a2c58b18336a5cd8c34ba9533d368a1c49b2a4c993058fe422f7625a48943063ca9c39b2c7273f2f5e90fb74e425cd9f4083feec31cdcfaea3bbfce452e453a8d3a7502d9eca8914a91f1eea9a46ddca956b8f5238ab222597cb8bd6ae68d3caece18b9cd8b757f544544bb72e49026ff3ee2247c5acddbf8029ea6110566fd574e97cc90dccb87141b62c0de725c780c059c798d3d2f0920e2915c4bb728a1e2dda8f1fc59953abd5230fa72f023c3ec9cb25b92a65cbaa7343edc1c32d8f643c769d5244a01403062fd2bd30fce9934bddd07f6e36ba4bd1113f54be4d2be5650d0f1ea59427ff7f7bead4ce9ed1d32f94e66394883ef0fb8818e5431a42449f5fe4e2718a8aaf64609552ca0bbe7c43c52ecde5825867b95071204ecfa927a10fb6b4a2c60ae3dc13c936db84e1611878e001c80ad5b462cb2811f1e6d67e5e7ca7080fca9926cf34c9cce6852fdf95f2207547f9f109229749c8181bb6e4b042247f28f00e3aac6051c093055821a5944f6231c83b224aa2087533aea1c84d7ec8f389178af872c4750de6521928be7ce28b3c9d59b5549042d2258d2dd5dc93e43b833839e59f80066a852b5928f802153c1070c437c91c51ca276b7c135b38d39025e6116ccac3032845199a13623c2c56a75da3e4f0c59e833cf9a70dacb6eaeaabac5affc18517016047c5349f50c1000fdf1cf14932bedc9a0c036af2b0c61a70ba994caeb7b609a74e7dd139aa5313541389020a0ce2c194b076eb2dabf6b4d18e0ce9e4f249700cf475c40b3cbc48c01ac74d03ca117b31508a22df3cfacd29f2c8e39172882936d7b450559b64b6514ad92a944f7efb6d2fae48924400e99ccbc334a7307094ae0c904900288a90c3d2270c1c91b122c0b6591e4b3991230f6e040b254235db603b42c20cab6ac5228b7cf081150e776b4f2fa478218352fd2655552eb968da66736532b0c6340cec9b0e03ce4d235e4ea6a116334dd2e450b302375309e5ceb7f8ccc2dab704ed702f5cd89284693cea254f29be9c9228283c54ff4d004be990a3dc5b9481f4754cb670826daa6647d9f3da90b30086150dbbedad3d3f7460b45bb56dbcab22d3c8a3c81abb2cb85c5e4645783849d250b327ce4f2e0206e43ed7be48e596bf1d02251b98767a6da61d474579fd7e92dc82849782deea1b89308ecd8df75cfbf492535e40ee96db638f258a501159e71b53c1ee343c78af297888fd9ed40b5e30af9124d7be93b3f4d34f7ffbf5d863dfcb1d7df41e1a6900240dddfc300d3df4e08004688dfa764100f76124078b639815ea4741ebe5ef82daab8222725118f0f5882905d1c367ac02420752840dd5c096076c00a55bac8d82b5b382077246c31a5e9055bd10d72738e7c17494e2329ce9d127ffa465c283f840714c90e0075800c3dad5f08939bb61abecc108494ca3560bd4cb69c4d00a83a8034ee9c8ce3f10a10f114cc016689cc0281051c4821c1161505ac40b9bf80128daf18917cce1b8782899d364001562d0074110c1800050210bad18003218c1089e3992115cc8002924318a22fae00bd962e1935c48479fddf1935092a20d2026312cf671031de8052a94e0867fe8a31ba7f8c42c7e61075dc4e39674c8a52e6f79cb5b30220339a8e440a441cc51bd71049a2cc0123bf9b319823294a27c1829f6d8b976304217aeb84237d0d082135cc296f16066fd74f18302606308d500841294008871ac20059210c1c054f3462cb0ea49e26ce633a118ffcd57c14d6e14cbe251c8510a5b18230e713040378ce18f5b82e1a1f9f4d9431f5a004000221818cd6818b6c1891c884035d2509c3d6db02d71b2e016cedc270dfb092bed694e067cac8a3c3a210e01b440126370412fe830518846b47669bb0530be108c0f1975a32b984066527833284554a5cf64290e77d73b9c24474dfb78c43ad6210f06b44008fee8694f7f5abb89b2b3a847fdd01f72e01808b2a24acacce722520a553c4a155cf6c047f7c2d8890b6c751d9da0823c0460807a3cf407884dec0fc85abf5e5814ad69f510351823893fa40a4ab3cb675def78d71978760625d04508dab10fbf6ef502f2a0c205c4b10f398455b1b065ecf4ac308e6dff4036b26cfd8b0822810e8671529c73f58070874bdce182b2b8c875db673fab3d5700c200fc58c7122a5189c07642ab9d98851960cb5d30c8d6673f188131621083c87e68087609a9fcaa24c7a722f7bdcf7caf702db75ced31e217b3888338d8b18425a8000dc132ed6c00910a307037b6df456c242e7adba3de830d75a14623886b05269a14a5f22dee27333c5f1b2cf7c39eb5813dec70df4374e11182a8447f55f008638460138fa8042f5a238f68d8e1c0dcfdee076e378e6890d7bc6198ac5a6cf1072739f5a732e4b092973c5c2e70c1c31f2e81f6ece10a609818c52ae8ef740561026468210ed46dc106c811005924000a38ceb16c6fb1083c8c03ffa340dec647d112d2de56e9b7f964b29e396c8f15aca0047608b41d4ae00a6400e21079e087380491652dfbb7c521c883002a21882edca1949838331436bd69477ada91dfe5b112e06cde6a04451a6eb084256c519014acb70058a870445910dc3ddb7ab8acd26f170cc0eb3c98200e4110873854a062476fd9047730063ff85b6957f8c31f45db800b4ac0e96a5bbbda3ff0ee4fd98c076c00c3b6e6dd863067e2065250c312a440c6007c2090dd1a199f642dc0ade7ed017f184310fe6587bed9a102621bdbd12c1e07174c90625e70d915f6f0ac3fccd10a1da0020aadbab6c427be88b4c17011580046139031eaa3624b01b99589242cc16e81d4c01c5aff88c80aec0c6b3c3393d6f4be75ae1bfdef9a1fbbd0fc50012f0c9e871294e0c3fef8c5163c500257517be248e734fd6c67857b688308da504223227b0ffbc444129230083ccc61460560e1ebb1b67044637e6b7b1402df36afb920f8618c1f1863d83b1744cf7f0ee2190042142b7cd5d193cee940b91072b7b0c23b32704b4648dda81f472f4cdc907583b861043343077133eb5eb2efd91571a079da572c0e03b8e207062838cfed508fba7f761978c735abf69e74414969b6155d44e18131f5a39a1a25a3b084417c2009750f210c600f7b3e99286fcbebd9ec68dfbc7f0560825f60b30bc95781097c6efae52e4308c58d38a77dcefdee731f56b36381ff9422c1857880211e86affd871e8c126acc992035a006293af0852681fda7b5363e9331aff99aaba0d2e35002bd700939b773bca002fc600ea9507dcb5502b1600d23405c11e77d14e873dee24252f20e5aa04b7460781ff2714a651213800d09410ac0e07560276b74c43636f075fac764c8c70b69f77f71600cae3068fc2783fd250ecb60070cb85ce56002029007d1405c9e558145973b3cd38280207bbce48161f071214712d8308504d10a93c009e8107c9dc4448bd08258f0827a8679c5666c94260e5d60833e380376107a06687006b0863fe8596dd86f5d20046620817755004e677e0f857e80d0081fb70226210dbfd04506310137f00b91107c2affa8362f147862587667676cfd260efc9007c050020b4887cb200e8e560909587a73488787c00e071804063005d597844153430af00b7ef887da700f82a800555712a370094246106cf00b33c009efc0859173525f3889f4660e682008c2266c41b06be3600ed4b75cfce76882500872588a76f0763b57096808080df87daff8444ca00562757ee6608b0a1009ef2712bb8807e3f60fd23000f5800cf597824c1478493602230076c8b867936051e3600ce3000cc8e00a9b56776d28083ae85f71e00aa4588a33900ae3008a5aa602aa180312f95976c40a80704d62150f8c2888ac46123490011ef00bb6404c1330006660065ad088605725fcd88fc11786ffffb86715587da9000ce250864b708dd9588a3df908662800d82007374077d5a767f7507eb33851bf90248d471292108153f00bbf300937700393300ec378936239966499934c667a5da079a2680e11299125800c4100944b200ebfc0085ae004f5d0961fa66791d00c4da00d3fa00b620508207712967009c53505ad300e5b48968e5996666984a5580e79c09000d7731bb95ce6c00f72290e9c100fb77007c070007a3903b61609da600a440003d79458bac0088090022831824e509b62300aa360598fb99b371999c3558af55002a1f76fe2600c9d9899334086c626082b100f3f807e19200766b05c4c167ce8400d890003a6d004ad8958f1e00a2710136cff300a10f60fad8082bcc99bbe295ca5e80fae407035c70fc8509a126902fd270887e09c81a90b5ca00509f059f2f598270000a0300144d00450404e88a50b6d00142bd008e919a1bd398973980a14b96c0d7991d3879c9f5502f6696cec600074a058ba700bc8000cac986164c90a29000a6b0000350075bd005ba440136c700f6129a1128a8c3f58028060023f99a15a768dc7899ce56000a87899230a5baff90b4a699ac57593353902aca0062efaa2cd00098cc05d352a1322b00d39aaa3ea49a10c080c5d306c9b170478c9a19e550eb390a417d90569f603fda9945d7903539aa73569a5c702008920a35c2a724a22a68e19992ff992f2e50405388326ffc0a69f950a8500a7fd550971c008339a6675da957a9aa7e8c0a72fea0ca6a00d970a5b7750033001414c40a8639a9377daaa37900ac8b0a86a7708a9f0921279a82f499116e968fce00a0a3aa7fd89072380a7533a08c66aacb5e0a26990064d0075bf0a5b8c800fe559122994aaaa5aa866e9aa3780aba9200741a07335f70872500f875a7db8fa92775a0f80b0ab5af608e6a00b8e9466f0da9f5ac004acc00ac77aace8400900d0af38600a90e00aa37a60da400a55e006f421124874adc197addaaaaddcbaae3266895de059e77ab166f0b05d3903726094c64697f0fa698b9066777007bf00a6e890b2291b0908900c35a09da600036836a73fb07daeffc00577d006a4800f075b033e30adeb8149614aa891a9b1108babe5509172899fe580b1876ab4adaaa89d0908212bb256cb33cdaa0da2190948f20c19d00490600a621bb0bdc07766bb69370b025599103e702de8a9aa9710b7721b81fa07b5778ab1e550898e1604f3e9b4467b00800bb85e0966cb690cbaa07457fb698cd00463db04307007304004623bb65ce00f67bb7d48c87d4650920a310a63b3a936499627ba0c9cc0095f70baa8bb0cc080984b66b71aebb487eaa6d19707e5300317fbb0819bbbb9db054b7b08878b748e646dae10b9935bbc62db045c1068669bb916e82a4a400f0c310a6e3b089b3a965e66ba1aa2242aabb2b8380ecbc0ba19ffe6ba470bbb2f299c0cc90be2300eb58aabaeaabb803b05f01bbf5370031fea68210a06976b6d25c00530000944f0bf4400098e7b837690741468392e000f0cb15b8ba3a762f90ba5ebb69237259f4639e810095fa0051128be1cecba9e457094ea0ab68baeadeabef27bc2f39b07fda7027980bff95b6df660034e36c35c8070f68074de973f1e600c408b100cac004c00bafd8807a6fb077f308cae272817cc0988d9c14eecaab8fa9e82300b4d9bb1259cbb289cc53780a419aa025db0082f2c71822668382c8edf225fe2d5c30721bdd8f20ed53b08cb80494a92307fe248b770c722eb010ac0094e60c54fecc4b85a0f93d0054a500fda8ac5599cc566ff700592da5f950a057f12c667db7ddea267537005f384109efb710e4cc46e1b6b14ac6d90588c4c34258df0054ee0017ffcc4813c095c69b7898cc2375008ecda5fbdba088122c965dcbcaf626b4ca0060dd1b61f47bd35997172fc0e362025b2137ee2a48f5272caa9bcca1c4cbe6670004e2007c090cdc02007721003a8f0cd274c5ee28c0a6ff76f41600ef6c0bceacc7ad766c65006a52a2a966110050d210d5ff021415c9380608b963525b215288dc0c4d23cd037e004cb300e19720f2112228050ba80100df02bce12edcd5fe0b18ef608bfd00bebbcd1ace7ceadf25ee91906b5e0100fdac6fa1c098df0072320257f4756b80c2805f0079c30ac04ffedc47260babc9530155c0097000ce3000861800a134d5e4ac0991f0b081acdd14acdcbd4f95e423ca57f30060e510d46c58f8080d22a2d25944756ae870591a005aa5cd3766b069310c70ac00a49accc3c6305c8b00ccb1006a4e6217260d48e569cbdb07a4badceadd2d4c8f5d4f93a08cf109e0d01411fc70ac0c0cf83a0d5628764498c0e5f7009626db7c0c0097f800e3b93d680d20b8b70099c00d44745b8d67808779d3f4a0da07d0dba7f9daf73a0780c610b1fd708ec24884cc0d28b1d515f98c431bd0c916db45a700f5e07283c73c77484cb3c830cb5d508c8ed046909a2b3f003774581a64d5c9bfad74c50ddd65ddd1240090e21ccd8320eb7ffc82aedc5586de33056e0d84eb0dbdaba0c284dc7cb1c391404392f6d0577bd0c2e400bb49000f57b9179007177b5d7d13d5cc45a93c77add045edd61c00d7d20118aa300b5852da0ac63b9f307baadbb91adde8d903016c7d875fc0b42400b319007fc0570d32745ccfbdfc2a5a7055eddefb0e22cfe07dc700556d71029d008189cd2b36d052e1751406339e8300ee79dbb62adde0ae038b215df7f32806fc6c5c6d6058c903b1bcdd7c215e03559e02c5ee5ef3007cc30066aac10ae3d0e07b32d13d444a40c78d8234391000c37e0be82cbca873de4385edbcd9cc47003086ffa6fbdea2a1bb993508ee2d75de547e5e287a0dd14210d082ddb9413de30ffc466157c4361b00c6abee61d6c06728049b196e3f984d95416058dbc047ccb941cda7d2076a779dae72c8edca6de08cf90e55bde10f023882395e88d833fd1840adf9be66aeec45908c46f5ee4dfc27dbd00977289d19e8e9c79599aa23ea5a4fe0edb80d0cc8ed08720d51821091fa72ab56d41fddd82f7a0948feec4cbf007176ee9cdec30dda70b9c50cb9e99708e6a7ac73ee5d6fd0e46c521dbc0b55c7b0f257711d520dbe04d3bd67eed24b50d5a60eb8feebe0feb0498b4d210deebde077a96b983c6600fec99ee9fd5aac8dee788f7711ff70c1200e31761cf82884c36f05027954cfcde2a8d0ef0010fe4e97dc405b0d5486639dc474574bd04ecff700850f0f0103f0312cf8f041e5946fc0773c00dcc600d067002314e119eeb2146b644f7b352d71e038e7ef2502fe9058fe83f853dddd70be3907cec300b355f5c8eeaaaf17bdde565543dfff3d630069480221931011f275c1596647937f2adc204cb30bf507feb5dd9edf2c3f2c0154d5090963bc7c225205f1cdaaa616fdde6f50cdc600d27b0ea15e1da0a10066e2f434c3ff2b46ef777afe609a03889dd446c26282cd50be51ef82640525e5ff8772abf889f567f2001675fef2221edd8024a965ff7269ff9806b066d8e0554bf63c9044d52e573a0dd05227cfac869f8873ff66aa5f85720e82521fb0a605c34f45edff283af72f9b8afe67a1f57b6fff34952f503b3c090943a09f04cf80c78fb0930d17f2e01cc40f428610b1f22fd39f35e9f85e7c8890b4f9ffdba8b4461ee33946f43006143e04082050d1ab4f7ebd19225fc90cdf01031e20d8a14cd5cc498d1cc0c1b50167dfc68c54ac411614c8679c6ed8a887f2d5dbe84195326cc092725dec42971c64e9e3d7dfefc1963d901a2458d1e45eae48b82418b58b0b85540ea54aa530f5ec53ad0559c4a951efd2a5051ac588d19177d789a562dd49261fecc617682c64cba75658eda6632e75ea07dfdfa8cb6ec0652c248cdc8f9d268d02d168b2256856cf5eadf9f76f2a858f208d08cb19d3d9740cbe2c3e8d16917b545292a8a0fbbad5d4b03d4a8d1ff88bd377beaa44c5909b0c1857d1f38bc14cb8791b53d40be493077e54382788933566f8467ea36188b269d96f88d183168351075a58f6bf2ad41c81e51c078c4e5ed3903725267ca94df8581dd5380a5b871e4b8ddfbf4671c717861e710e93a3bca0c1b1601632ded16b1618aeebe73418df1cac390ae1c4c6242bdf5d8fbcf2f5496996fbefa08bbaf112c3e5c2fc49fec016621760cb0613ab138b2e2a3d01c04030c2866382081040209a401635a1925432567b2c5261641741130de4a3c112939ee51d1c327718ab2a7549091310f208ff240208f4002a98412381b0c175c02d906841c26986b493b61f221af30b6ecd22733e0938fca2a8b426cb62dff6beb73862f83a8440513381b942837dd4c20b0142461ed4e4d61a281936082a1edc944774a6019544a3431d2039ce044b143f9ea73d125d8117384118e4225575d85ac548e01a869c5964c37251626353e0d15d6517b52428e1b50a54fd5043851808957118d3295182b1147881b84ecaebb68a29143890140a02607496c19459a62df9d49120eb15d96a7520f80365a5597f9e39d6be9fdcf8e420408c20039c641378556d615611436dc853762bb4488a63b16eb05345f55894a31d97fa10c311535c6d0019021244679493694e8ee069c3acba84b3980a903178d55c5259a5607f1000b9f573c34d103b4c0251823584a39e9f24040f62698cb827aa3beff4acd355f7d074d009765b679e767af81fe30d1490031c2081786553a6d0dbb9bc203eaa286bb2c209749e054aba515528e9dbff6f9daf6c472c285b28da9536dc363b285c804de8e3b23ea285ac609bbad46f5445e1318876baf0f1dab71333a03c685061a50e370d3611aa5e2181eef5ca3b190ba01103902a5bcf2fa2ed759b1beb76cddf3a30011bd81564e27fe1f1a96f99475b22eaac8a87c6f504209da6b17d4b7cb85040410503dcee9f1c6c582769c39c63fb9f8d3ab615b79cff0ad7d1b53a9bfd97a5ec3cd9c899fd5ef1d6af0517542fc39444992f94c2789f4e18f22ec8356b8bc330ef8dded37970b172dc6110626d8ca5606f48c46105822ff266c4308e3db021b0468ba09a80e83095420fd6230b906ce67522f7ce1f58804a70956f08218641daa1408880fce41072334ddca5aa63ca2a0b03b2709863140108dbab1b0852e84212e643843252ca31153b8210e11a443058e43145f8c02104d0702211de07145e1620c4e72122108c105c630c632e4d0c427421186109c21915c308e600cc28f83d0a2583618ae9318e38ba23881180f9783329eb1284c48212d2429c9368eae0173d8c2168c310e25546c52d7135214ef78b9194ed205dac3a2056f053b471205921194a4312420016e504291861b427770d11b331ed0289194e41f84f9c6d18dcf98b48c820824418d01cc3194a214e5140331495a08ff417b16fccd194ba4c049464296b40ce02d95963a21f19230dc9ca430fff00c6314d39887dc02dad8300149a4400c5a9003132f878b3af4d39f52bc5c30a859cd6bdaaa4a82244a02d039cc6f324384e254daf1a4f81b74d2e20f963492e8de79486e5c6826346083086c21895650430cd818c00080210796b6347a8058060864aa0685d902103130e8c688b2d03f1841085b98e51520aa36314cb4300a9d5030316a0c8d1e7396dc289f9d68200d3654d5aa0f2bdc4b46a1049b5d6d50aff48e242d690ca04a208c43555a2b7845187085f53b967c461b8d50cc438a821b63309f08e4d055afd60796161deb17b99148b4266d028a430a52dd8ad163b0d305ff6d74c131e6304bb3a24c1a88684d09f9da57b6c2f2a2a37341219eead1c24a8c0dce4c6c52df6a491d8860086ad0810ea270822b1ca310577828bc10118e3560d62e4308c4666ff7578c867696cc086769250602a316a5ad621ddd3184d08764b402ba7328843e108108b4bd0b117a08876f7f1b0de1ca6f48d01d5d5c452b8142404cb9124bc15a9dabdae81a0311a0a8052ee67ac9f1490011c9706fc4a85a1e4904025ad6a36f039eb160b206f5bd29036e2012e05c854e73b52ef8af3e8cb6dffe4aa0166bc82a105b115c37c92fa9963466210e598b07a38c9c134ee8902c1cdd21842319d5d8f082fb1bc6ed4234073128f1512b3c4d148f4fc55f24ff6c8be14503609431c644baf07ff5f0a9b23dc39857709734f431d4f826a07a149ee17ee95a88c97654c9122b2a288954b6061c43076b008508b6e182e0b5790b5baecb54052886cb1d8557505eedf844610c1076f7cc9b522b3f6bf6a619b7f904a000852d70306952a4601c6aa0130d340d1369d00011faf0817673db92efea03d4fa18c528f4800877f9401d885047805d220d1f8c22d4e275099fbd9c2f2101bac89904a1ac0fad291f54811a285542d9945db6158c220d6970c3a49bd18c443883029ac8070528708d6b38c2db8440441af8b0034314c11d6b608306ce410212e801ab3420810ff490060460561f0858436f61c286edfaf6bbab860919ff79154319a3777c84966ce986fdae1ac0c313f44844223ad0016c60c3184228842d44f0ec094c1c076d08013434f1069297dce4454004194a9e8905a8e309f9c8472888916d6d2b23dc0820842354c10114f0960f8638c73934c007042080dd24988b34c2110e5933378abd6eb43175a08656f4810d215ef89268500337c003e2cee8c0a4db80037a38c010c258431a46810f7c90a20d6d2044c95731f7b99bfc09260f053810300c920f83ef245f051fd2008e50aca2e4ca40c0023261f8373c411d8a9f3bccf3f104c1bb03083adfb921065087ac7db2e0819e430e9080041f3c2ceb9b62830f26d075884b3ceccd68c31e20400870a4411d7b28063412e1ff094d3c611eaf284226849f896214c3e42b5fc0de8fff8655b07c0145603cc9110f79e61761016b38c32b88b17d62bc4218e040c4df4b4e069aa9b9d1fc6d053cdc50831ab0c110ef5777d031c06e3d9f3e26f0d6c00e3860086f20a1eb55c087b01b3b95733c7a530608d08404ecbb61e00370704077d8036590bb2720847920863550bee30b050410b7bb33b9e95bbcc6738734d08350208413444114cc87e52304e99922f4baa42aa8027a70830918050e303cc9933c298005611b361238074390826b803993d3040af0b6dcf3047c10b9ea5b8005f086e8b33b7518bcc233bc5508053ed0873338c1a52384043c420a20837973b9e50341c32b403df0c0ffe52bb930d4364d088568e0bc3fb3304992ac28a88244808733280255a080e5a30029888008f0c1f7c23f55708422644336d404222cb9024400095cbec04b8370088537d0b62270c01d4840c40b07096c440b2083118c442994bec40b414894c44504c3912bb93d088439e415a311023538011140043e00826b5bc46b808541ac803303422174c44534466324040e2481357cc411048722b0000b0082798bc2535c834b4cc055f086050087c56bc52204c19213bc6e3442303c4608280612c385385117377083d173180b304592a30055880038c0c7602c2d4d0b420eb806053cc680344665708705708727a8bb04b4bede32bec6d303ea7b0396bbc6950307ff28cc8768b4000ac8875780b964ec460a88c64ca83d97c3c88cbc363220036d5349958cc657580631b004198cb844a007f5ab8151e00336f4c57bc4c708c000e52a0358c886a1cc0655304aa39482a454caa5e4b6a65cc96b6b45bbcb047560834c20841d280261d0031208852758434d44801db806422086c72b82270885500807dbbb86681cb92718ba04dc8135783e300cbc27e48394d4368ce4c2a7dc366e4b400ef084699bb40e88387aa0c109f0816b30427bc4c77c2481f78286c7a4ccca1cc4cbc4cccb8485cde44c58384aa45c4a2028020c183d24f0861dd0cbbd8cc622e00361380362f0363ed003612006ad7407687885dcd43e1f00076f2083ff3d70070754875020836874043ea04b75c8040ee0006f3b833d98c7e3d38432a802d82b4c7ca8020740013f34b96b70ccc7ec07ac1baa32e0c9ca34cff3444ff4cc4ca264cf6ce84cce9482a1dc39e6e4c1f733841dc0cf22d0cf22c0cf1d7004424081fd6ccd57c8489223043e50073d70076160d0b813c8375006c39c36c32c062070c536e441caf4492523cff4f4d00f05d1100dd1f624d1cf34d1a34ccafec4cfa6e4b6956cc55674061c28837920034d80801bedceef84cc3323cf4114d11f05d22015d2f3c4ccf67ccff73cd1a3a4cfa54cca6bc850ca0ccf43c38029c5000de8872bad802ccdd2f7cccc2e1dd22f05d33055cf2ee5ccf284830db53f84bae8344d9386a363372aa5d22b95532dddd232edd2cc14d33cd553f3ac80c84c53b5595378735338d5804295d37ea0d30ae8cc3bf5d23dcd530df8d3619b2a4d73d3379dd242b5d2394dd4cd64d4460d5358f0d34815d5f298aa35ad5412a0524c3d5444a5d34565d47e28c45195d59461d336e5034f70002498524f808632f006510d08003b, '', 'n', NULL, NULL, NULL, NULL, 1, '', '0.00000', '500.00000', '0.00000', '0.00000', '0.00000', '0.000', '', '0.00000', '0.000', 1, 1, '', 1, 1, '0.00000', 1, '0.000', '0.000', '', 0, 0, 0, NULL, 0, 0, '0.000', '0.000', '0.000', '0.000', NULL, NULL, NULL, 0, 0, 0, 0, 420000007, 315000099, '', 'amministratore', '2020-03-10 10:48:56', '', NULL);

-- --------------------------------------------------------

--
-- Struttura della tabella `gaz_001artico_group`
--

DROP TABLE IF EXISTS `gaz_001artico_group`;
CREATE TABLE IF NOT EXISTS `gaz_001artico_group` (
  `id_artico_group` int(9) NOT NULL AUTO_INCREMENT,
  `descri` varchar(50) NOT NULL DEFAULT '',
  `large_descri` text NOT NULL,
  `image` blob,
  `web_url` varchar(255) NOT NULL,
  `ref_ecommerce_id_main_product` varchar(50) DEFAULT '' COMMENT 'Riferimento all''articolo principale (padre) in eventuale ecommerce sincronizzato, così ogni rigo di gaz_NNNartico sarà equiparabile alle singole varianti, opzioni, attributi, ecc a secondo del diagramma ER utilizzato',
  `web_public` tinyint(1) NOT NULL DEFAULT '1',
  `depli_public` tinyint(1) NOT NULL DEFAULT '1',
  `adminid` varchar(20) NOT NULL DEFAULT '',
  `last_modified` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id_artico_group`),
  KEY `ref_ecommerce_id_main_product` (`ref_ecommerce_id_main_product`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Struttura della tabella `gaz_001artico_position`
--

DROP TABLE IF EXISTS `gaz_001artico_position`;
CREATE TABLE IF NOT EXISTS `gaz_001artico_position` (
  `id_position` int(3) NOT NULL AUTO_INCREMENT,
  `id_warehouse` int(3) NOT NULL,
  `id_shelf` int(3) NOT NULL,
  `codart` varchar(32) NOT NULL,
  `position` varchar(50) NOT NULL DEFAULT '',
  `image` blob,
  `custom_field` text COMMENT 'Riferimenti generici utilizzabili sui moduli. Normalmente in formato json: {"nome_modulo":{"nome_variabile":{"valore_variabile": {}}}}',
  `adminid` varchar(20) NOT NULL DEFAULT '',
  `last_modified` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id_position`),
  UNIQUE KEY `id_warehouse_id_shelf_codart` (`id_warehouse`,`id_shelf`,`codart`),
  KEY `id_warehouse` (`id_warehouse`),
  KEY `id_shelf` (`id_shelf`),
  KEY `codart` (`codart`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

-- --------------------------------------------------------

--
-- Struttura della tabella `gaz_001assets`
--

DROP TABLE IF EXISTS `gaz_001assets`;
CREATE TABLE IF NOT EXISTS `gaz_001assets` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `id_movcon` int(9) NOT NULL DEFAULT '0' COMMENT 'può essere riferito a gaz_001tesmov in caso di acquisto bene o a gaz_001rigmoc in altri casi, ad esempio negli ammortamenti di fine anno',
  `type_mov` int(2) NOT NULL DEFAULT '0' COMMENT 'tipologia di movimento sul libro cespiti es.1=acquisto, 10 rivalutazione, 50 ammortamento, 90 alienazione',
  `descri` varchar(100) NOT NULL,
  `codice_artico` varchar(32) NOT NULL COMMENT 'verrà valorizzato con un codice articolo se si vorranno gestire i beni strumentali, e sarà lo stesso valore codice in gaz_NNNartico',
  `install_date` date DEFAULT NULL COMMENT 'Data di installazione del bene ammortizzabile',
  `codice_campi` int(3) NOT NULL DEFAULT '0' COMMENT 'Riferimento alla tabella gaz_NNNcampi (luogo di produzione), ovvero il luogo ove è installata la macchina',
  `hostpath` varchar(200) NOT NULL COMMENT 'Percorso di rete della macchina (IoT e/o Industry 4.0)',
  `username` varchar(50) NOT NULL COMMENT 'Nome utente per accesso a dispositivo (IoT e/o Industry 4.0)',
  `password` varchar(50) NOT NULL COMMENT 'Password per accesso a dispositivo (IoT e/o Industry 4.0)',
  `linkmode` varchar(15) NOT NULL COMMENT 'Modalità-protocollo di comunicazione (IoT e/o Industry 4.0)',
  `unimis` varchar(3) NOT NULL,
  `quantity` decimal(12,3) NOT NULL,
  `a_value` decimal(12,2) NOT NULL,
  `pagame` int(2) NOT NULL DEFAULT '0',
  `ss_amm_min` int(2) NOT NULL DEFAULT '0',
  `valamm` decimal(5,2) NOT NULL DEFAULT '0.00',
  `acc_fixed_assets` int(9) NOT NULL DEFAULT '0',
  `acc_found_assets` int(9) NOT NULL DEFAULT '0',
  `acc_cost_assets` int(9) NOT NULL DEFAULT '0',
  `id_no_deduct_vat` int(2) NOT NULL DEFAULT '0',
  `no_deduct_vat_rate` decimal(5,2) NOT NULL DEFAULT '0.00',
  `acc_no_deduct_cost` int(11) NOT NULL DEFAULT '0',
  `no_deduct_cost_rate` decimal(5,2) NOT NULL DEFAULT '0.00',
  `lost_cost_value` decimal(12,2) NOT NULL DEFAULT '0.00',
  `super_ammort` decimal(12,2) NOT NULL DEFAULT '0.00',
  PRIMARY KEY (`id`),
  KEY `codice_artico` (`codice_artico`),
  KEY `descri` (`descri`),
  KEY `acc_fixed_assets` (`acc_fixed_assets`),
  KEY `id_movcon` (`id_movcon`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Struttura della tabella `gaz_001assist`
--

DROP TABLE IF EXISTS `gaz_001assist`;
CREATE TABLE IF NOT EXISTS `gaz_001assist` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `idinstallazione` int(11) NOT NULL,
  `tipo` varchar(3) DEFAULT NULL,
  `codice` int(10) NOT NULL,
  `utente` varchar(50) NOT NULL,
  `data` date NOT NULL,
  `tecnico` varchar(50) NOT NULL,
  `oggetto` varchar(80) NOT NULL,
  `descrizione` text NOT NULL,
  `soluzione` text,
  `ora_inizio` varchar(5) DEFAULT NULL,
  `ora_fine` varchar(5) DEFAULT NULL,
  `info_agg` varchar(80) DEFAULT NULL,
  `clfoco` int(9) NOT NULL,
  `ore` decimal(6,2) NOT NULL,
  `codart` varchar(32) NOT NULL,
  `prezzo` varchar(10) DEFAULT NULL,
  `codeart` varchar(10) DEFAULT NULL,
  `ripetizione` int(11) DEFAULT '1',
  `ogni` varchar(10) DEFAULT 'Anni',
  `stato` varchar(20) NOT NULL,
  `note` text,
  PRIMARY KEY (`id`),
  KEY `idinstallazione` (`idinstallazione`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Struttura della tabella `gaz_001banapp`
--

DROP TABLE IF EXISTS `gaz_001banapp`;
CREATE TABLE IF NOT EXISTS `gaz_001banapp` (
  `codice` int(3) NOT NULL DEFAULT '0',
  `id_bank` int(6) NOT NULL DEFAULT '0',
  `descri` varchar(50) NOT NULL DEFAULT '',
  `codabi` int(5) NOT NULL DEFAULT '0',
  `codcab` int(5) NOT NULL DEFAULT '0',
  `locali` varchar(50) NOT NULL DEFAULT '',
  `codpro` char(2) NOT NULL DEFAULT '',
  `annota` varchar(50) DEFAULT NULL,
  `adminid` varchar(20) NOT NULL DEFAULT '',
  `last_modified` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`codice`),
  KEY `id_bank` (`id_bank`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Dump dei dati per la tabella `gaz_001banapp`
--

INSERT INTO `gaz_001banapp` (`codice`, `id_bank`, `descri`, `codabi`, `codcab`, `locali`, `codpro`, `annota`, `adminid`, `last_modified`) VALUES
(1, 0, 'BANCA DEL LAGO', 1111, 11111, 'TREVISO', 'TV', '', 'amministratore', '2008-09-27 07:42:34');

-- --------------------------------------------------------

--
-- Struttura della tabella `gaz_001body_text`
--

DROP TABLE IF EXISTS `gaz_001body_text`;
CREATE TABLE IF NOT EXISTS `gaz_001body_text` (
  `id_body` int(9) UNSIGNED NOT NULL AUTO_INCREMENT,
  `table_name_ref` varchar(50) NOT NULL DEFAULT '',
  `id_ref` int(9) NOT NULL DEFAULT '0',
  `body_text` mediumtext NOT NULL,
  `lang_id` int(3) NOT NULL,
  PRIMARY KEY (`id_body`),
  KEY `table_name_ref` (`table_name_ref`),
  KEY `id_ref` (`id_ref`)
) ENGINE=MyISAM AUTO_INCREMENT=4 DEFAULT CHARSET=utf8;

--
-- Dump dei dati per la tabella `gaz_001body_text`
--

INSERT INTO `gaz_001body_text` (`id_body`, `table_name_ref`, `id_ref`, `body_text`, `lang_id`) VALUES
(2, 'artico_INSTGAZIE', 0, '<p>Pacchetto installazione software libero GAzie su server web raggiungibile da tutte le macchine della vostra LAN aziendale. Il servizio comprende 4 ore di avviamento all\'utilizzo del programma e la configurazione di base dei dati aziendali.</p>', 1),
(3, 'privacy_regol', 0, '&#60;h1 style=&#34;text-align: center;&#34;&#62;SOMMARIO&#60;/h1&#62;&#13;&#10;&#60;table style=&#34;height: 900px; width: 579px; margin-left: auto; margin-right: auto;&#34;&#62;&#13;&#10;&#60;tbody&#62;&#13;&#10;&#60;tr&#62;&#13;&#10;&#60;td style=&#34;height: 14px; width: 77px; text-align: center;&#34;&#62;&#13;&#10;&#60;h3 style=&#34;text-align: left;&#34;&#62;Art. 1&#60;/h3&#62;&#13;&#10;&#60;/td&#62;&#13;&#10;&#60;td style=&#34;height: 14px; width: 382.767px; text-align: center;&#34;&#62;&#13;&#10;&#60;h3 style=&#34;text-align: left;&#34;&#62;Premessa&#60;/h3&#62;&#13;&#10;&#60;/td&#62;&#13;&#10;&#60;td style=&#34;height: 14px; width: 119.233px; text-align: center;&#34;&#62;&#13;&#10;&#60;h3 style=&#34;text-align: left;&#34;&#62;pag.1&#60;/h3&#62;&#13;&#10;&#60;/td&#62;&#13;&#10;&#60;/tr&#62;&#13;&#10;&#60;tr&#62;&#13;&#10;&#60;td style=&#34;height: 14px; width: 77px;&#34;&#62;&#13;&#10;&#60;h3 style=&#34;text-align: left;&#34;&#62;Art. 2&#60;/h3&#62;&#13;&#10;&#60;/td&#62;&#13;&#10;&#60;td style=&#34;height: 14px; width: 382.767px;&#34;&#62;&#13;&#10;&#60;h3 style=&#34;text-align: left;&#34;&#62;Finalit&#38;agrave;&#60;/h3&#62;&#13;&#10;&#60;/td&#62;&#13;&#10;&#60;td style=&#34;height: 14px; width: 119.233px;&#34;&#62;&#13;&#10;&#60;h3 style=&#34;text-align: left;&#34;&#62;pag.2&#60;/h3&#62;&#13;&#10;&#60;/td&#62;&#13;&#10;&#60;/tr&#62;&#13;&#10;&#60;tr&#62;&#13;&#10;&#60;td style=&#34;height: 14px; width: 77px;&#34;&#62;&#13;&#10;&#60;h3 style=&#34;text-align: left;&#34;&#62;Art. 3&#60;/h3&#62;&#13;&#10;&#60;/td&#62;&#13;&#10;&#60;td style=&#34;height: 14px; width: 382.767px;&#34;&#62;&#13;&#10;&#60;h3 style=&#34;text-align: left;&#34;&#62;Ambito di applicazione&#60;/h3&#62;&#13;&#10;&#60;/td&#62;&#13;&#10;&#60;td style=&#34;height: 14px; width: 119.233px;&#34;&#62;&#13;&#10;&#60;h3 style=&#34;text-align: left;&#34;&#62;pag.2&#60;/h3&#62;&#13;&#10;&#60;/td&#62;&#13;&#10;&#60;/tr&#62;&#13;&#10;&#60;tr&#62;&#13;&#10;&#60;td style=&#34;height: 14px; width: 77px;&#34;&#62;&#13;&#10;&#60;h3 style=&#34;text-align: left;&#34;&#62;Art. 4&#60;/h3&#62;&#13;&#10;&#60;/td&#62;&#13;&#10;&#60;td style=&#34;height: 14px; width: 382.767px;&#34;&#62;&#13;&#10;&#60;h3 style=&#34;text-align: left;&#34;&#62;Principi generali&#60;/h3&#62;&#13;&#10;&#60;/td&#62;&#13;&#10;&#60;td style=&#34;height: 14px; width: 119.233px;&#34;&#62;&#13;&#10;&#60;h3 style=&#34;text-align: left;&#34;&#62;pag.2&#60;/h3&#62;&#13;&#10;&#60;/td&#62;&#13;&#10;&#60;/tr&#62;&#13;&#10;&#60;tr&#62;&#13;&#10;&#60;td style=&#34;height: 14px; width: 77px;&#34;&#62;&#13;&#10;&#60;h3 style=&#34;text-align: left;&#34;&#62;Art. 5&#60;/h3&#62;&#13;&#10;&#60;/td&#62;&#13;&#10;&#60;td style=&#34;height: 14px; width: 382.767px;&#34;&#62;&#13;&#10;&#60;h3 style=&#34;text-align: left;&#34;&#62;Utilizzo del personal computer&#60;/h3&#62;&#13;&#10;&#60;/td&#62;&#13;&#10;&#60;td style=&#34;height: 14px; width: 119.233px;&#34;&#62;&#13;&#10;&#60;h3 style=&#34;text-align: left;&#34;&#62;pag.3&#60;/h3&#62;&#13;&#10;&#60;/td&#62;&#13;&#10;&#60;/tr&#62;&#13;&#10;&#60;tr&#62;&#13;&#10;&#60;td style=&#34;height: 14px; width: 77px;&#34;&#62;&#13;&#10;&#60;h3 style=&#34;text-align: left;&#34;&#62;Art. 6&#60;/h3&#62;&#13;&#10;&#60;/td&#62;&#13;&#10;&#60;td style=&#34;height: 14px; width: 382.767px;&#34;&#62;&#13;&#10;&#60;h3 style=&#34;text-align: left;&#34;&#62;Gestione utenti&#60;/h3&#62;&#13;&#10;&#60;/td&#62;&#13;&#10;&#60;td style=&#34;height: 14px; width: 119.233px;&#34;&#62;&#13;&#10;&#60;h3 style=&#34;text-align: left;&#34;&#62;pag.4&#60;/h3&#62;&#13;&#10;&#60;/td&#62;&#13;&#10;&#60;/tr&#62;&#13;&#10;&#60;tr&#62;&#13;&#10;&#60;td style=&#34;height: 14px; width: 77px;&#34;&#62;&#13;&#10;&#60;h3 style=&#34;text-align: left;&#34;&#62;Art. 7&#60;/h3&#62;&#13;&#10;&#60;/td&#62;&#13;&#10;&#60;td style=&#34;height: 14px; width: 382.767px;&#34;&#62;&#13;&#10;&#60;h3 style=&#34;text-align: left;&#34;&#62;Gestione degli account e delle password&#60;/h3&#62;&#13;&#10;&#60;/td&#62;&#13;&#10;&#60;td style=&#34;height: 14px; width: 119.233px;&#34;&#62;&#13;&#10;&#60;h3 style=&#34;text-align: left;&#34;&#62;pag.4&#60;/h3&#62;&#13;&#10;&#60;/td&#62;&#13;&#10;&#60;/tr&#62;&#13;&#10;&#60;tr&#62;&#13;&#10;&#60;td style=&#34;height: 14px; width: 77px;&#34;&#62;&#13;&#10;&#60;h3 style=&#34;text-align: left;&#34;&#62;Art. 8&#60;/h3&#62;&#13;&#10;&#60;/td&#62;&#13;&#10;&#60;td style=&#34;height: 14px; width: 382.767px;&#34;&#62;&#13;&#10;&#60;h3 style=&#34;text-align: left;&#34;&#62;Utilizzo delle cartelle di rete&#60;/h3&#62;&#13;&#10;&#60;/td&#62;&#13;&#10;&#60;td style=&#34;height: 14px; width: 119.233px;&#34;&#62;&#13;&#10;&#60;h3 style=&#34;text-align: left;&#34;&#62;pag.5&#60;/h3&#62;&#13;&#10;&#60;/td&#62;&#13;&#10;&#60;/tr&#62;&#13;&#10;&#60;tr&#62;&#13;&#10;&#60;td style=&#34;height: 14px; width: 77px;&#34;&#62;&#13;&#10;&#60;h3 style=&#34;text-align: left;&#34;&#62;Art. 9&#60;/h3&#62;&#13;&#10;&#60;/td&#62;&#13;&#10;&#60;td style=&#34;height: 14px; width: 382.767px;&#34;&#62;&#13;&#10;&#60;h3 style=&#34;text-align: left;&#34;&#62;Utilizzo delle stampanti e dei materiali di consumo&#60;/h3&#62;&#13;&#10;&#60;/td&#62;&#13;&#10;&#60;td style=&#34;height: 14px; width: 119.233px;&#34;&#62;&#13;&#10;&#60;h3 style=&#34;text-align: left;&#34;&#62;pag.5&#60;/h3&#62;&#13;&#10;&#60;/td&#62;&#13;&#10;&#60;/tr&#62;&#13;&#10;&#60;tr&#62;&#13;&#10;&#60;td style=&#34;height: 14px; width: 77px;&#34;&#62;&#13;&#10;&#60;h3 style=&#34;text-align: left;&#34;&#62;Art. 10&#60;/h3&#62;&#13;&#10;&#60;/td&#62;&#13;&#10;&#60;td style=&#34;height: 14px; width: 382.767px;&#34;&#62;&#13;&#10;&#60;h3 style=&#34;text-align: left;&#34;&#62;Utilizzo di Internet&#60;/h3&#62;&#13;&#10;&#60;/td&#62;&#13;&#10;&#60;td style=&#34;height: 14px; width: 119.233px;&#34;&#62;&#13;&#10;&#60;h3 style=&#34;text-align: left;&#34;&#62;pag.6&#60;/h3&#62;&#13;&#10;&#60;/td&#62;&#13;&#10;&#60;/tr&#62;&#13;&#10;&#60;tr&#62;&#13;&#10;&#60;td style=&#34;height: 14px; width: 77px;&#34;&#62;&#13;&#10;&#60;h3 style=&#34;text-align: left;&#34;&#62;Art. 11&#60;/h3&#62;&#13;&#10;&#60;/td&#62;&#13;&#10;&#60;td style=&#34;height: 14px; width: 382.767px;&#34;&#62;&#13;&#10;&#60;h3 style=&#34;text-align: left;&#34;&#62;Gestione e utilizzo della posta elettronica&#60;/h3&#62;&#13;&#10;&#60;/td&#62;&#13;&#10;&#60;td style=&#34;height: 14px; width: 119.233px;&#34;&#62;&#13;&#10;&#60;h3 style=&#34;text-align: left;&#34;&#62;pag.6&#60;/h3&#62;&#13;&#10;&#60;/td&#62;&#13;&#10;&#60;/tr&#62;&#13;&#10;&#60;tr&#62;&#13;&#10;&#60;td style=&#34;height: 14px; width: 77px;&#34;&#62;&#13;&#10;&#60;h3 style=&#34;text-align: left;&#34;&#62;Art. 12&#60;/h3&#62;&#13;&#10;&#60;/td&#62;&#13;&#10;&#60;td style=&#34;height: 14px; width: 382.767px;&#34;&#62;&#13;&#10;&#60;h3 style=&#34;text-align: left;&#34;&#62;Responsabile del trattamento dei dati personali&#60;/h3&#62;&#13;&#10;&#60;/td&#62;&#13;&#10;&#60;td style=&#34;height: 14px; width: 119.233px;&#34;&#62;&#13;&#10;&#60;h3 style=&#34;text-align: left;&#34;&#62;pag.7&#60;/h3&#62;&#13;&#10;&#60;/td&#62;&#13;&#10;&#60;/tr&#62;&#13;&#10;&#60;tr&#62;&#13;&#10;&#60;td style=&#34;height: 14px; width: 77px;&#34;&#62;&#13;&#10;&#60;h3 style=&#34;text-align: left;&#34;&#62;Art. 13&#60;/h3&#62;&#13;&#10;&#60;/td&#62;&#13;&#10;&#60;td style=&#34;height: 14px; width: 382.767px;&#34;&#62;&#13;&#10;&#60;h3 style=&#34;text-align: left;&#34;&#62;Controlli e responsabilit&#38;agrave;&#60;/h3&#62;&#13;&#10;&#60;/td&#62;&#13;&#10;&#60;td style=&#34;height: 14px; width: 119.233px;&#34;&#62;&#13;&#10;&#60;h3 style=&#34;text-align: left;&#34;&#62;pag.7&#60;/h3&#62;&#13;&#10;&#60;/td&#62;&#13;&#10;&#60;/tr&#62;&#13;&#10;&#60;tr&#62;&#13;&#10;&#60;td style=&#34;height: 14px; width: 77px;&#34;&#62;&#13;&#10;&#60;h3 style=&#34;text-align: left;&#34;&#62;Art. 14&#60;/h3&#62;&#13;&#10;&#60;/td&#62;&#13;&#10;&#60;td style=&#34;height: 14px; width: 382.767px;&#34;&#62;&#13;&#10;&#60;h3 style=&#34;text-align: left;&#34;&#62;Norma di rinvio&#60;/h3&#62;&#13;&#10;&#60;/td&#62;&#13;&#10;&#60;td style=&#34;height: 14px; width: 119.233px;&#34;&#62;&#13;&#10;&#60;h3 style=&#34;text-align: left;&#34;&#62;pag.8&#60;/h3&#62;&#13;&#10;&#60;/td&#62;&#13;&#10;&#60;/tr&#62;&#13;&#10;&#60;/tbody&#62;&#13;&#10;&#60;/table&#62;&#13;&#10;&#60;h3 style=&#34;text-align: left;&#34;&#62;&#38;nbsp;&#60;/h3&#62;&#13;&#10;&#60;p&#62;&#38;nbsp;&#60;/p&#62;&#13;&#10;&#60;h1&#62;Art. 1 &#38;ndash; Premessa&#60;/h1&#62;&#13;&#10;&#60;p&#62;&#38;nbsp;&#60;/p&#62;&#13;&#10;&#60;ol&#62;&#13;&#10;&#60;li&#62;Il Sistema Informativo Automatizzato, detto anche Sistema Informatico Aziendale (S.I.A.) &#38;egrave; costituito dall&#39;insieme del patrimonio informativo digitale e delle risorse tecnologiche ed organizzative che acquisiscono, elaborano, rendono disponibile ed utilizzano tale patrimonio informativo.&#60;/li&#62;&#13;&#10;&#60;li&#62;Le risorse tecnologiche sono l&#39;insieme degli strumenti hardware e software che permettono di accedere al patrimonio informativo digitale dell&#39;Azienda, nonch&#38;eacute; alle risorse informative esterne collegate alla rete dell&#39;Azienda tramite reti pubbliche o private.&#60;/li&#62;&#13;&#10;&#60;li&#62;Per Amministratore di Sistema&#60;sup&#62;(1)&#60;/sup&#62; si fa riferimento al Responsabile del S.I.A. e, pi&#38;ugrave; in generale, di tutti i Servizi Informatici e Telematici dell&#39;Azienda, o suo delegato.&#60;/li&#62;&#13;&#10;&#60;/ol&#62;&#13;&#10;&#60;hr /&#62;&#13;&#10;&#60;p&#62;&#60;sup&#62;(1)&#60;/sup&#62;Con la definizione di &#60;em&#62;&#34;amministratore di sistema&#34;&#60;/em&#62; si individuano generalmente, in ambito informatico, figure professionali finalizzate alla gestione e alla manutenzione di un impianto di elaborazione o di sue componenti. Ai fini del presente provvedimento vengono per&#38;ograve; considerate tali anche altre figure equiparabili dal punto di vista dei rischi relativi alla protezione dei dati, quali gli amministratori di basi di dati, gli amministratori di reti e di apparati di sicurezza e gli amministratori di sistemi &#60;em&#62;software&#60;/em&#62; complessi (art. 1 provvedimento del Garante per la protezione dei dati personali del 27 novembre 2008, e successive modificazioni ed integrazioni).&#60;/p&#62;&#13;&#10;&#60;h1&#62;&#38;nbsp;&#60;/h1&#62;&#13;&#10;&#60;h1&#62;Art. 2 &#38;ndash; Finalit&#38;agrave;&#60;/h1&#62;&#13;&#10;&#60;ol&#62;&#13;&#10;&#60;li&#62;Il presente regolamento disciplina:&#13;&#10;&#60;ol type=&#34;a&#34;&#62;&#13;&#10;&#60;li&#62;le modalit&#38;agrave; di accesso ed utilizzo degli strumenti informatici, della rete informatica e dei servizi che tramite la stessa rete &#38;egrave; possibile ricevere ed offrire all&#39;interno e all&#39;esterno dell&#39;Amministrazione, nell&#39;ambito dello svolgimento delle proprie mansioni ed attivit&#38;agrave; di ufficio da parte degli amministratori, dipendenti e collaboratori dell&#39;Azienda;&#60;/li&#62;&#13;&#10;&#60;li&#62;l&#39;individuazione del complesso delle misure tecniche, informatiche, organizzative, logistiche e procedurali di sicurezza che configurano il livello adeguato di protezione per il trattamento dei dati personali, al fine di garantire l&#39;aderenza e la rispondenza alle vigenti normative in materia, nonch&#38;eacute; adeguati livelli di sicurezza ed integrit&#38;agrave; del patrimonio informativo dell&#39;Amministrazione Aziendale.&#60;/li&#62;&#13;&#10;&#60;/ol&#62;&#13;&#10;&#60;/li&#62;&#13;&#10;&#60;/ol&#62;&#13;&#10;&#60;h1&#62;Art. 3 &#38;ndash; Ambito di applicazione&#60;/h1&#62;&#13;&#10;&#60;ol&#62;&#13;&#10;&#60;li&#62;Il presente regolamento si applica a tutti gli utenti interni che sono autorizzati ad accedere alle risorse tecnologiche del sistema informatico dell&#39;Azienda.&#60;/li&#62;&#13;&#10;&#60;li&#62;Per utenti interni (d&#38;rsquo;ora innanzi &#38;ldquo;utenti&#38;rdquo; o &#38;ldquo;operatori&#38;rdquo;) si intendono gli amministratori, i responsabili dei servizi, i dipendenti a tempo indeterminato e determinato, il personale con altre forme di rapporto contrattuale ed i collaboratori esterni impegnati in attivit&#38;agrave; istituzionali, limitatamente al periodo di collaborazione.&#60;/li&#62;&#13;&#10;&#60;li&#62;Il presente regolamento &#38;egrave; richiamato quale parte integrante nel contratto individuale di lavoro per i dipendenti o nell&#39;atto di instaurazione della collaborazione a vario titolo con l&#39;Azienda, ed &#38;egrave; consegnato all&#39;interessato, alla sottoscrizione del contratto stesso. Per gli utenti gi&#38;agrave; in servizio al momento dell&#38;rsquo;entrata in vigore del presente Regolamento, copia del Regolamento sar&#38;agrave; opportunamente notificato agli stessi.&#60;/li&#62;&#13;&#10;&#60;/ol&#62;&#13;&#10;&#60;h1&#62;Art. 4 &#38;ndash; Principi generali&#60;/h1&#62;&#13;&#10;&#60;ol&#62;&#13;&#10;&#60;li&#62;L&#39;Azienda promuove l&#39;utilizzo della Rete Informatica e Telematica, di Internet e della Posta Elettronica quali strumenti utili a perseguire con efficacia ed efficienza le proprie finalit&#38;agrave; commerciali e/o industriali e/o professionali, in accordo con le linee guida e i principi delineati dalla normativa vigente.&#60;/li&#62;&#13;&#10;&#60;li&#62;I dati e le informazioni gestite ed archiviate in modalit&#38;agrave; informatica costituiscono patrimonio dell&#39;Azienda finalizzato al raggiungimente dello scopo sociale. Di conseguenza, per consentire la piena disponibilit&#38;agrave; di tale patrimonio, la gestione informatizzata dei dati, deve privilegiare l&#39;utilizzo di sistemi gestionali accentrati, indipendenti dalla singola postazione di lavoro, governati da livelli di autorizzazione predeterminati (user-id/password, ruolo/profilo). Pertanto, la gestione con memorizzazione delle informazioni in locale, sul proprio personal computer, deve essere ridotta al minimo e limitata ai soli casi di estrema necessit&#38;agrave;. In quest&#39;ultima ipotesi, qualora il dipendente debba assentarsi per un periodo prolungato e programmato, deve concordare con il proprio Responsabile, le modalit&#38;agrave; per mettere a disposizione le informazioni d&#39;ufficio memorizzate all&#39;interno del proprio personal computer.&#60;/li&#62;&#13;&#10;&#60;li&#62;L&#39;Azienda promuove, anche tramite supporti documentali pubblicati nella intranet aziendale, l&#39;aggiornamento e la formazione dei propri dipendenti in merito al corretto utilizzo delle strumentazioni informatiche e telematiche.&#60;/li&#62;&#13;&#10;&#60;li&#62;Ogni utente &#38;egrave; responsabile, civilmente e penalmente, del corretto uso delle risorse informatiche, dei servizi e dei programmi a cui ha accesso, nonch&#38;eacute; dei dati trattati a fini commerciali.&#60;/li&#62;&#13;&#10;&#60;li&#62;Ogni utente &#38;egrave; altres&#38;igrave; responsabile del contenuto delle icazioni effettuate e ricevute a fini commerciali, anche per quanto attiene la riservatezza dei dati ivi contenuti, la cui diffusione impropria potrebbe configurare violazione dei segreti commerciali e/o industriali e/o professionali o della normativa per la tutela dei dati personali (privacy).&#60;/li&#62;&#13;&#10;&#60;li&#62;Sono vietati comportamenti che possono creare un danno, anche di immagine, all&#39;Azienda.&#60;/li&#62;&#13;&#10;&#60;/ol&#62;&#13;&#10;&#60;h1&#62;Art. 5 &#38;ndash; Utilizzo del personal computer&#60;/h1&#62;&#13;&#10;&#60;ol&#62;&#13;&#10;&#60;li&#62;Il personal computer &#38;egrave; uno strumento di lavoro e il suo utilizzo deve essere finalizzato esclusivamente allo svolgimento delle attivit&#38;agrave; dell&#39;Azienda. Il personal computer viene assegnato all&#39;utente in relazione alle funzioni svolte, previa autorizzazione del Responsabile e/o del Titolare.&#60;/li&#62;&#13;&#10;&#60;li&#62;Ciascuno &#38;egrave; responsabile dell&#39;utilizzo delle dotazioni informatiche ricevute in assegnazione.&#60;/li&#62;&#13;&#10;&#60;li&#62;Ogni utilizzo non inerente all&#39;attivit&#38;agrave; lavorativa pu&#38;ograve; contribuire ad innescare disservizi, costi di manutenzione e, soprattutto, minacce alla sicurezza e, quindi, deve ritenersi vietato.&#60;/li&#62;&#13;&#10;&#60;li&#62;Il personal computer assegnato come postazione di lavoro &#38;egrave; configurato con un profilo utente per l&#39;installazione autonoma di nuovi programmi deve essere fatta esplicita richiesta all&#38;rsquo;Amministratore di Sistema.&#60;/li&#62;&#13;&#10;&#60;li&#62;Ogni utente deve tenere comportamenti corretti, tali da preservare il buon funzionamento degli strumenti e tali da ridurre i rischi per la sicurezza del sistema informatico. E&#39; vietato l&#39;utilizzo di supporti per la memorizzazione dei dati (CD, DVD, memorie USB, etc.) non sicuri e/o provenienti dall&#39;esterno, al fine di non diffondere eventuali virus.&#60;/li&#62;&#13;&#10;&#60;li&#62;E&#39; necessario spegnere il personal computer al termine dell&#39;attivit&#38;agrave; lavorativa o in caso di assenza prolungata dal proprio ufficio, al fine di evitare l&#39;accesso, anche fortuito, ai dati ivi contenuti, nonch&#38;eacute; al fine di prevenire utilizzi indebiti da parte di terzi che possono essere fonte di responsabilit&#38;agrave;. In presenza di dati personali e/o sensibili, il PC dovr&#38;agrave; essere bloccato ogniqualvolta rimanga incustodito.&#60;/li&#62;&#13;&#10;&#60;li&#62;Non &#38;egrave; consentita l&#39;attivazione della password d&#39;accensione (bios), senza preventiva autorizzazione da parte dell&#38;rsquo;Amministratore di Sistema, o suo incaricato, e, in tal caso, la suddetta password dovr&#38;agrave; essere depositata in busta chiusa presso l&#38;rsquo;uffici dell&#38;rsquo; Amministratore di Sistema o altro locale da questi indicato.&#60;/li&#62;&#13;&#10;&#60;li&#62;I dati archiviati informaticamente devono essere esclusivamente quelli attinenti alle proprie attivit&#38;agrave; lavorative.&#60;/li&#62;&#13;&#10;&#60;li&#62;Costituisce buona regola la pulizia periodica (almeno ogni sei mesi) degli archivi, con cancellazione dei file obsoleti o inutili. Particolare attenzione deve essere prestata alla duplicazione dei dati: &#38;egrave;, infatti, assolutamente da evitare un&#39;archiviazione ridondante.&#60;/li&#62;&#13;&#10;&#60;li&#62;Ogni utente deve periodicamente verificare che il programma di antivirus sia attivo e funzionante, nonch&#38;eacute; avviare un controllo antivirus per la verifica sui dischi locali del personal computer.&#60;/li&#62;&#13;&#10;&#60;li&#62;E&#39; assolutamente vietata l&#39;archiviazione &#34;sistematica&#34; di dati ed in particolare dei dati personali dei partner commerciali dell&#39;Azienda. La tutela dei dati archiviati su personal computer che gestiscono localmente documenti e/o dati non vietati &#38;egrave; demandata all&#39;utente, il quale dovr&#38;agrave; effettuare, con frequenza opportuna, i salvataggi su supporti dedicati ed idonei, nonch&#38;eacute; la conservazione degli stessi in luoghi adatti indicati dall&#39;Amministratore di sistema.&#60;/li&#62;&#13;&#10;&#60;li&#62;Non &#38;egrave; possibile modificare le configurazioni hardware e software predefinite dall&#38;rsquo;Amministratore di Sistema ed installare autonomamente programmi o applicativi senza preventiva autorizzazione dello stesso.&#60;/li&#62;&#13;&#10;&#60;li&#62;E&#39; vietata l&#39;installazione non autorizzata di sistemi che sfruttino il sistema telefonico o reti wireless per l&#39;accesso ad internet o ad altre reti esterne.&#60;/li&#62;&#13;&#10;&#60;li&#62;I sistemisti e i tecnici (personale interno e/o di ditte affidatarie del servizio) che hanno in gestione le componenti del sistema informatico aziendale, possono, previo accordo con l&#39;utente, procedere alla rimozione di ogni file o applicazione che riterranno essere pericolosi per la sicurezza, sia sui singoli personal computer sia sulle cartelle di rete.&#60;/li&#62;&#13;&#10;&#60;li&#62;I sistemisti e i tecnici (personale interno e/o di ditte affidatarie del servizio) incaricati della gestione e della manutenzione del sistema informatico possono, in qualsiasi momento, accedere al personal computer per attivit&#38;agrave; di manutenzione preventiva e correttiva, previo accordo con l&#39;utente. In caso di intervento manutentivo da remoto (anche con strumenti di supporto, assistenza e diagnostica remota), per il quale verr&#38;agrave; richiesta preventivamente all&#39;utente l&#39;abilitazione telematica, l&#39;utente potr&#38;agrave; verificare le operazioni eseguite che vengono tutte visualizzate sul monitor durante la connessione.&#60;/li&#62;&#13;&#10;&#60;li&#62;E&#39; fatto &#60;strong&#62;divieto assoluto riprodurre&#60;/strong&#62; su supporti esterni e/o l&#39;invio telematico di eventuali &#60;strong&#62;dati sensibili&#60;/strong&#62; per evitare che il loro contenuto possa essere recuperato da terzi. Altrettanta cautela deve essere riposta in fase di stampa dei documenti contenenti dati sensibili: la stampa va effettuata su stampanti presidiate dall&#39;addetto e, ove le attrezzature (stampanti di rete, fotocopiatrici con funzione di stampa, etc.) lo consentano, avviare la fase di stampa solo dopo aver inserito un apposito codice.&#60;/li&#62;&#13;&#10;&#60;li&#62;L&#39;eventuale malfunzionamento o danneggiamento del personal computer deve essere tempestivamente comunicato all&#38;rsquo;Amministratore di Sistema.&#60;/li&#62;&#13;&#10;&#60;li&#62;In caso di furto &#38;egrave; onere dell&#39;utente, o del responsabile del servizio di appartenenza, effettuare denuncia all&#39;autorit&#38;agrave; di polizia e far pervenire all&#38;rsquo;Amministratore di Sistema copia della denuncia.&#60;/li&#62;&#13;&#10;&#60;li&#62;Oltre a quanto sopra detto, particolare diligenza deve essere posta dall&#39;utente di PC portatile utilizzato in ambienti esterni all&#39;Amministrazione, sia sotto il profilo della protezione dell&#39;apparecchiatura, sia sotto il profilo della sicurezza dei dati in essa contenuti.&#60;/li&#62;&#13;&#10;&#60;li&#62;E&#39; responsabilit&#38;agrave; del Responsabile di compartecipare al processo di gestione della sicurezza informatica e collaborare alla verifica del coerente utilizzo delle risorse assegnate e ad evitarne sia l&#39;uso improprio che l&#39;accesso da parte di personale non autorizzato.&#60;/li&#62;&#13;&#10;&#60;/ol&#62;&#13;&#10;&#60;h1&#62;Art. 6 &#38;ndash; Gestione utenti&#60;/h1&#62;&#13;&#10;&#60;ol&#62;&#13;&#10;&#60;li&#62;L&#39;abilitazione all&#39;utilizzo delle risorse informatiche avverr&#38;agrave; automaticamente con l&#39;inserimento dell&#39;anagrafica utente da parte dell&#38;rsquo;Amministratore di Sistema, su indicazione del Settore Risorse Umane (se presente). Analogamente, le variazioni di Settore o Ufficio del personale dipendente saranno automaticamente gestite dal sistema. Per gli stagisti, collaboratori esterni o altre figure simili, sar&#38;agrave; cura di ogni Settore o dell&#38;rsquo;Ufficio Risorse Umane inoltrare richiesta all&#38;rsquo;Amministratore di Sistema, specificando gli estremi della persona interessata, nonch&#38;eacute; le date di inizio e fine dell&#39;account richiesto.&#60;/li&#62;&#13;&#10;&#60;/ol&#62;&#13;&#10;&#60;h1&#62;Art. 7 &#38;ndash; Gestione degli account e delle password&#60;/h1&#62;&#13;&#10;&#60;ol&#62;&#13;&#10;&#60;li&#62;L&#39;account &#38;egrave; costituito da un codice identificativo personale (username o user-id) e da una parola chiave (password).&#60;/li&#62;&#13;&#10;&#60;li&#62;Gli account possono essere diversi, ciascuno con una specifica password, e si distinguono, in particolare:&#60;br /&#62;a) di rete, per l&#39;avvio e l&#39;utilizzo del sistema operativo e di tutte le risorse di rete,&#60;br /&#62;b) gestionali, per l&#39;accesso alle applicazioni gestionali a utenti che, per motivi di servizio, ne devono fare uso.&#60;/li&#62;&#13;&#10;&#60;li&#62;La password che viene associata a ciascun utente &#38;egrave; personale, non cedibile e non divulgabile.&#60;/li&#62;&#13;&#10;&#60;li&#62;Le password dovranno avere le caratteristiche che di volta in volta saranno segnalate dall&#38;rsquo;Amministratore di Sistema.&#60;/li&#62;&#13;&#10;&#60;li&#62;Sebbene la password sia personale e riservata, in caso di prolungata assenza ed impedimento dell&#38;rsquo;utente, che renda indispensabile ed indifferibile intervenire per esclusive necessit&#38;agrave; di operativit&#38;agrave; e sicurezza del sistema, il Responsabile del trattamento dei dati, in qualit&#38;agrave; di fiduciario, potr&#38;agrave; richiedere all&#38;rsquo;Amministratore di Sistema (qualora le due figure professionali non coincidano) che venga effettuato il reset della password dell&#38;rsquo;utente medesimo. Al termine del tempo strettamente necessario al recupero delle informazioni di lavoro protette da password, il suddetto Responsabile dovr&#38;agrave; richiedere all&#38;rsquo;Amministratore di Sistema un nuovo reset della password che, questa volta, sar&#38;agrave; comunicato tempestivamente ed esclusivamente all&#38;rsquo;utente interessato.&#60;/li&#62;&#13;&#10;&#60;/ol&#62;&#13;&#10;&#60;h1&#62;Art. 8 &#38;ndash; Utilizzo delle cartelle di rete&#60;/h1&#62;&#13;&#10;&#60;ol&#62;&#13;&#10;&#60;li&#62;Le cartelle di rete sono aree di disco su server centrali/NAS/SAN a disposizione dei vari Uffici. Ogni Ufficio avr&#38;agrave; uno spazio la cui dimensione &#38;egrave; limitata e determinata dall&#38;rsquo;Amministratore di Sistema, in funzione delle esigenze del settore, della disponibilit&#38;agrave; dell&#39;intero sistema di memorizzazione, del numero di utenti, dei volumi e tipologia di documenti trattati.&#60;/li&#62;&#13;&#10;&#60;li&#62;Le cartelle di rete sono periodicamente salvate dall&#38;rsquo;Amministratore di Sistema con cadenza minima di sette giorni ed i corrispondenti salvataggi sono disponibili per un arco temporale massimo di 6 mesi.&#60;/li&#62;&#13;&#10;&#60;li&#62;Le cartelle di rete sono aree di condivisione di documenti strettamente Aziendali e non possono, in alcun modo, essere utilizzate per scopi diversi. Pertanto, qualunque file che non sia correlato all&#39;attivit&#38;agrave; lavorativa non pu&#38;ograve; essere dislocato, nemmeno per brevi periodi, in queste unit&#38;agrave;.&#60;/li&#62;&#13;&#10;&#60;li&#62;L&#39;organizzazione e la gestione dell&#39;albero delle sottocartelle &#38;egrave; demandata al di cui al successivo art. 12. Questi ha anche il compito di effettuare una pulizia periodica degli archivi, con cancellazione dei file obsoleti, duplicati o inutili.&#60;/li&#62;&#13;&#10;&#60;li&#62;L&#38;rsquo;Amministratore di Sistema, nel caso si prefiguri un uso improprio o che metta a repentaglio la sicurezza del sistema informatico dell&#39;Azienda, ha la facolt&#38;agrave;, previ accordi con il Responsabile del trattamento dei dati personali (se non coincidono), di procedere alla rimozione di ogni file o applicazione, nonch&#38;eacute; inibire temporaneamente l&#39;accesso alle cartelle di rete interessate.&#60;/li&#62;&#13;&#10;&#60;/ol&#62;&#13;&#10;&#60;h1&#62;Art. 9 &#38;ndash; Utilizzo delle stampanti e dei materiali di consumo&#60;/h1&#62;&#13;&#10;&#60;ol&#62;&#13;&#10;&#60;li&#62;L&#39;utilizzo delle stampanti e dei materiali di consumo in genere (carta, inchiostro, toner, supporti magnetici, supporti digitali) &#38;egrave; riservato esclusivamente all&#39;espletamento dei compiti di natura strettamente Aziendale. Devono essere evitati in ogni modo sprechi dei suddetti materiali o utilizzi eccessivi, privilegiando altres&#38;igrave; soluzioni operative che mirino al risparmio, come ad esempio privilegiando la stampa fronte retro, nonch&#38;eacute; soluzioni operative che mirino ad evitare l&#39;utilizzo di carta (memorizzazione di documenti scansionati e comunicazione via e-mail) similmente all&#39;ottica delle direttive inerenti alla digitalizzazione della Pubblica Amministrazione e/o delle grandi aziende.&#60;/li&#62;&#13;&#10;&#60;/ol&#62;&#13;&#10;&#60;h1&#62;Art. 10 &#38;ndash; Utilizzo di Internet&#60;/h1&#62;&#13;&#10;&#60;ol&#62;&#13;&#10;&#60;li&#62;L&#39;utilizzo di Internet deve essere limitato a scopi inerenti l&#39;attivit&#38;agrave; lavorativa.&#60;/li&#62;&#13;&#10;&#60;li&#62;Nell&#38;rsquo;uso dei servizi Internet si devono osservare le seguenti norme comportamentali:&#13;&#10;&#60;ul type=&#34;square&#34;&#62;&#13;&#10;&#60;li&#62;presentarsi sempre con il proprio nome, mai sotto il nome altrui;&#60;/li&#62;&#13;&#10;&#60;li&#62;non registrarsi a siti i cui contenuti non siano legati all&#38;rsquo;attivit&#38;agrave; lavorativa;&#60;/li&#62;&#13;&#10;&#60;li&#62;ricordarsi che quando si scarica del materiale da Internet spesso ne viene coinvolto il diritto di propriet&#38;agrave; intellettuale e, pertanto, &#38;egrave; necessario ottenere esplicita autorizzazione dall&#38;rsquo;Amministratore di Sistema;&#60;/li&#62;&#13;&#10;&#60;li&#62;non trasferire sul proprio computer (download) file da siti sconosciuti e, comunque, solo per ragioni connesse all&#38;rsquo;attivit&#38;agrave; lavorativa;&#60;/li&#62;&#13;&#10;&#60;li&#62;non partecipare, per motivi non professionali, a forum, chat line, ecc.;&#60;/li&#62;&#13;&#10;&#60;li&#62;non scaricare e non usare software gratuito o shareware prelevato da siti Internet, salvo i casi in cui ci&#38;ograve; sia necessario per lo svolgimento delle proprie mansioni e previo nulla osta dall&#38;rsquo;Amministratore di Sistema.&#60;/li&#62;&#13;&#10;&#60;/ul&#62;&#13;&#10;&#60;/li&#62;&#13;&#10;&#60;li&#62;L&#39;Azienda, per il tramite dell&#38;rsquo;Amministratore di Sistema, potrebbe adottare misure di filtraggio, che permettano di inibire o restringere l&#39;accesso a siti i cui contenuti siano classificati pericolosi o non attinenti agli scopi istituzionali, nonch&#38;eacute; a limitare i tempi di collegamento e la banda utilizzata.&#60;/li&#62;&#13;&#10;&#60;li&#62;Sono vietate tutte le azioni atte ad eludere tali misure di filtraggio di cui al precedente comma.&#60;/li&#62;&#13;&#10;&#60;li&#62;L&#38;rsquo; Amministratore di Sistema, nel caso si prefiguri un uso improprio o che metta a repentaglio la sicurezza del sistema informatico dell&#39;Azienda, ha la facolt&#38;agrave; di inibire temporaneamente la navigazione, anche senza preavviso, in internet alle postazioni di lavoro interessate e/o ai singoli operatori.&#60;/li&#62;&#13;&#10;&#60;li&#62;Ai soli fini di gestione e di salvaguardia giuridica degli interessi dell&#39;Azienta e dei propri dipendenti, il sistema di gestione Aziendale provvede alla tracciatura secondo norma vigente, e prevede esclusivamente la registrazione dei login effettuati e le modifiche apportate, limitatamente ai dati immessi dagli utenti del gestionale aziendale (GAzie).&#60;/li&#62;&#13;&#10;&#60;/ol&#62;&#13;&#10;&#60;h1&#62;Art. 11 &#38;ndash; Gestione e utilizzo della posta elettronica&#60;/h1&#62;&#13;&#10;&#60;ol&#62;&#13;&#10;&#60;li&#62;Le caselle di posta elettronica rilasciate sono di due tipi:&#60;br /&#62;a) casella di posta elettronica aziendale ordinaria &#38;ndash; riconducibile ad un&#39;unit&#38;agrave; organizzativa (amministrazione, magazzino,&#38;nbsp; etc.);&#60;br /&#62;b) casella di posta elettronica individuale: casella assegnata al singolo utente.&#60;/li&#62;&#13;&#10;&#60;li&#62;Tutti i documenti e le comunicazioni inerenti i procedimenti Aziendali devono essere veicolati esclusivamente tramite gli indirizzi di posta elettronica aziendale.&#60;/li&#62;&#13;&#10;&#60;li&#62;Le caselle di posta elettronica individuali hanno la funzione di strumenti di messaggistica (news, avvisi, passaggi informali di documenti, etc).&#60;/li&#62;&#13;&#10;&#60;li&#62;Il Responsabile del trattamento dei dati personali stabilisce quali utenti hanno accesso alle caselle di posta elettronica aziendali.&#60;/li&#62;&#13;&#10;&#60;li&#62;La casella di posta elettronica assegnata &#38;egrave; uno strumento di lavoro ed il suo utilizzo &#38;egrave; consentito solo per finalit&#38;agrave; connesse allo svolgimento della propria attivit&#38;agrave; lavorativa. Le persone assegnatarie sono responsabili del corretto utilizzo della stessa.&#60;/li&#62;&#13;&#10;&#60;li&#62;Non &#38;egrave; consentito l&#39;invio o la ricezione di messaggi con allegati di dimensione superiori a 10 Mb e con estensione uguali a .lnk, .bat, .exe, .scr ed in generale file di tipo eseguibile o di applicazione.&#38;nbsp; Eventuali esigenze particolari potranno essere segnalate all&#38;rsquo;Amministratore di Sistema che individuer&#38;agrave; la soluzione tecnica pi&#38;ugrave; appropriata.&#60;/li&#62;&#13;&#10;&#60;li&#62;In caso di cessazione del rapporto di lavoro o collaborazione o di mandato degli amministratori, l&#39;indirizzo di posta elettronica individuale dell&#39;interessato viene immediatamente rimosso, con attivazione di un messaggio automatico di ritorno che avverte che l&#38;rsquo;indirizzo e-mail non &#38;egrave; pi&#38;ugrave; disponibile.&#60;/li&#62;&#13;&#10;&#60;li&#62;La casella di posta deve essere mantenuta in ordine, cancellando documenti inutili e con allegati di grandi dimensioni.&#60;/li&#62;&#13;&#10;&#60;li&#62;E&#39; vietato utilizzare l&#39;indirizzo delle caselle di posta elettronica istituzionale e personale per l&#39;invio o la ricezione di messaggi personali o per la partecipazione a dibattiti, forum o mailing-list, salvo diversa ed esplicita autorizzazione.&#60;/li&#62;&#13;&#10;&#60;li&#62;La conservazione della posta elettronica personale &#38;egrave; demandata ad ogni singolo utente. Nel caso in cui i messaggi o allegati debbano essere conservati, l&#39;utente deve autonomamente provvedere al loro salvataggio su cartelle di rete di cui all&#39;art. 8 &#38;ndash; &#34;Utilizzo delle cartelle di rete&#34; del presente Regolamento.&#60;/li&#62;&#13;&#10;&#60;li&#62;Ai soli fini di gestione e di salvaguardia giuridica degli interessi dell&#39;Azienda e dei propri dipendenti, il sistema di gestione della posta elettronica provvede alla tracciatura della corrispondenza in entrata e in uscita, secondo norma vigente, che prevede esclusivamente la registrazione dell&#39;identificativo della postazione di lavoro, del mittente e del destinatario. Il tempo di mantenimento di tali dati viene stabilito in 12 mesi, in analogia a quanto richiamato nel provvedimento del 24.07.2008 del Garante per la protezione di dati personali e del considerando art. 28 del Regolamento UE 2016/679&#60;strong&#62; (GDPR)&#60;/strong&#62;.&#60;/li&#62;&#13;&#10;&#60;/ol&#62;&#13;&#10;&#60;h1&#62;Art. 12 &#38;ndash; Responsabile del trattamento dei dati personali&#60;/h1&#62;&#13;&#10;&#60;ol&#62;&#13;&#10;&#60;li&#62;Il Responsabile del trattamento dei dati personali&#60;/li&#62;&#13;&#10;&#60;li&#62;Al Responsabile, se non coincidenti con la stessa persona dell&#39;Amministratore di Sistema, sar&#38;agrave; assegnato il compito di:&#60;br /&#62;a) verificare le esigenze e l&#39;adeguatezza della strumentazione informatica e segnalarle all&#38;rsquo;Amministratore di Sistema (se non coincidenti con la stessa persona);&#60;br /&#62;b) collaborazione con l&#38;rsquo;Amministratore di Sistema nella supervisione sul corretto utilizzo delle risorse informatiche;&#60;br /&#62;c) assolvere a quanto previsto nell&#39;art. 8 &#38;ndash; &#60;em&#62;&#38;ldquo;Utilizzo delle cartelle di rete&#34;&#60;/em&#62; del presente Regolamento.&#60;/li&#62;&#13;&#10;&#60;li&#62;Il Responsabile dovr&#38;agrave; avere conoscenze idonee al ruolo.&#60;/li&#62;&#13;&#10;&#60;/ol&#62;&#13;&#10;&#60;h1&#62;Art. 13 &#38;ndash; Controlli e responsabilit&#38;agrave;&#60;/h1&#62;&#13;&#10;&#60;ol&#62;&#13;&#10;&#60;li&#62;L&#39;Azienda si riserva di effettuare controlli sul corretto utilizzo degli strumenti informatici e telematici nel rispetto delle normative vigenti e del presente regolamento, nonch&#38;eacute; nel rispetto dello Statuto dei Lavoratori.&#60;/li&#62;&#13;&#10;&#60;li&#62;Per esigenze organizzative, produttive e di sicurezza, l&#39;Azienda effettuer&#38;agrave; controlli automatizzati generali con l&#39;obiettivo di individuare potenziali rischi per la sicurezza o usi impropri del sistema informatico. L&#38;rsquo;Amministratore di Sistema ha la facolt&#38;agrave;, nell&#39;ambito di quanto previsto dalla normativa vigente, di effettuare eventuali ulteriori approfondimenti con gradualit&#38;agrave;, nel rispetto dei principi di pertinenza e non eccedenza, qualora i controlli automatici riscontrino potenziali rischi o problemi. I suddetti procedimenti di controllo saranno opportunamente documentati (tipo di controlli, nome del sistemista che opera i controlli, log di accesso ai sistemi, riscontri dei controlli).&#60;/li&#62;&#13;&#10;&#60;li&#62;Qualora la tipologia dei controlli automatizzati adottati contempli la possibilit&#38;agrave; di controllo dell&#39;attivit&#38;agrave; dei lavoratori, l&#39;attivazione sar&#38;agrave; preceduta da un accordo con le rappresentanze sindacali aziendali, le quali inoltre saranno informate delle iniziative adottate in sede di prima applicazione del presente Regolamento.&#60;/li&#62;&#13;&#10;&#60;li&#62;Il mancato rispetto o la violazione delle norme contenute nel presente regolamento &#38;egrave; perseguibile con provvedimenti disciplinari, nonch&#38;eacute; con le azioni civili e penali consentite.&#60;/li&#62;&#13;&#10;&#60;/ol&#62;&#13;&#10;&#60;h1&#62;Art. 14 &#38;ndash; Norma di rinvio&#60;/h1&#62;&#13;&#10;&#60;ol&#62;&#13;&#10;&#60;li&#62;Per quanto non espressamente previsto nel presente regolamento, si rinvia alle specifiche diposizioni e direttive in materia ed in particolare:&#60;br /&#62;a) Direttiva n. 2/2009 della Presidenza del Consiglio dei Ministri &#38;ndash; Dipartimento della Funzione Pubblica &#38;ldquo;Utilizzo di internet e della casella di posta elettronica istituzionale sul luogo di lavoro&#38;rdquo;;&#60;br /&#62;b) Delibera n. 13/2007 del Garante per la protezione dei dati personali &#38;ldquo;Lavoro: le linee guida del Garante per la posta elettronica e internet&#38;rdquo;;&#60;br /&#62;c) Per quanto riguarda il Codice di comportamento, ad integrazione di quanto previsto nei CCNL applicati, si fa riferimento alle regole contenute nel Dpr. 16 aprile 2013, n. 62 (&#38;ldquo;&#60;em&#62;Regolamento recante codice di comportamento dei dipendenti pubblici, a norma dell&#38;rsquo;art. 54 del Decreto legislativo 30 marzo 2001, n. 165&#60;/em&#62;&#38;rdquo;).&#60;/li&#62;&#13;&#10;&#60;/ol&#62;&#13;&#10;&#60;h2 style=&#34;text-align: center;&#34;&#62;&#38;nbsp;&#60;/h2&#62;&#13;&#10;&#60;h2 style=&#34;text-align: center;&#34;&#62;****************************************&#60;/h2&#62;', 0);

-- --------------------------------------------------------

--
-- Struttura della tabella `gaz_001campi`
--

DROP TABLE IF EXISTS `gaz_001campi`;
CREATE TABLE IF NOT EXISTS `gaz_001campi` (
  `codice` int(3) NOT NULL AUTO_INCREMENT,
  `descri` varchar(50) NOT NULL DEFAULT '',
  `image` mediumblob,
  `indirizzo` varchar(50) DEFAULT NULL,
  `provincia` varchar(2) DEFAULT NULL,
  `comune` varchar(50) DEFAULT NULL,
  `web_url` varchar(255) NOT NULL,
  `ricarico` decimal(7,3) NOT NULL,
  `giorno_decadimento` timestamp NULL DEFAULT NULL,
  `codice_prodotto_usato` varchar(32) NOT NULL,
  `used_from_modules` varchar(127) DEFAULT NULL COMMENT 'Se FALSE o NULL appare nella select di tutti i moduli altrimenti solo in quello/i del/i modulo/i indicati qui. Usare la virgola per separare i nomi dei moduli quando più di uno.',
  `id_mov` int(9) DEFAULT '0',
  `id_rif` int(10) DEFAULT '0' COMMENT 'Identificativo dello stabilimento/deposito assegnato dal SIAN',
  `id_colture` int(3) DEFAULT '0',
  `zona_vulnerabile` int(1) DEFAULT '0' COMMENT 'Nelle regioni che hanno già individuato le Zone Vulnerabili da Nitrati di origine agricola, chiamate ZVN, quando si concima, non si può superare un certo limite di azoto annuo',
  `limite_azoto_zona_vulnerabile` int(3) NOT NULL DEFAULT '170' COMMENT 'Limite di azoto ad ettaro se ZVN ( valore default = 170)',
  `limite_azoto_zona_non_vulnerabile` int(3) NOT NULL DEFAULT '340' COMMENT 'Limite di azoto ad ettaro se zona NON vulnerabile ( valore default = 340)',
  `annota` varchar(50) DEFAULT NULL,
  `adminid` varchar(20) NOT NULL DEFAULT '',
  `last_modified` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`codice`)
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8 COMMENT='Tabella contenente i campi ovvero i luoghi di produzione.';

--
-- Dump dei dati per la tabella `gaz_001campi`
--

INSERT INTO `gaz_001campi` (`codice`, `descri`, `image`, `indirizzo`, `provincia`, `comune`, `web_url`, `ricarico`, `giorno_decadimento`, `codice_prodotto_usato`, `used_from_modules`, `id_mov`, `id_rif`, `id_colture`, `zona_vulnerabile`, `limite_azoto_zona_vulnerabile`, `limite_azoto_zona_non_vulnerabile`, `annota`, `adminid`, `last_modified`) VALUES
(1, 'Campo sotto casa', 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, NULL, NULL, NULL, '', '0.289', '2018-11-07 18:28:42', '', NULL, 0, 0, 0, 0, 170, 340, 'ceci neri', 'amministratore', '2018-02-05 03:07:49');
INSERT INTO `gaz_001campi` (`codice`, `descri`, `image`, `indirizzo`, `provincia`, `comune`, `web_url`, `ricarico`, `giorno_decadimento`, `codice_prodotto_usato`, `used_from_modules`, `id_mov`, `id_rif`, `id_colture`, `zona_vulnerabile`, `limite_azoto_zona_vulnerabile`, `limite_azoto_zona_non_vulnerabile`, `annota`, `adminid`, `last_modified`) VALUES
(2, 'Serra', 0xffd8ffe000104a46494600010101004800480000ffdb004300140e0f120f0d14121012171514181e32211e1c1c1e3d2c2e243249404c4b47404645505a736250556d5645466488656d777b8182814e608d978c7d96737e817cffdb0043011517171e1a1e3b21213b7c5346537c7c7c7c7c7c7c7c7c7c7c7c7c7c7c7c7c7c7c7c7c7c7c7c7c7c7c7c7c7c7c7c7c7c7c7c7c7c7c7c7c7c7c7c7c7c7c7c7c7cffc200110801ef02a603011100021101031101ffc4001a000101010101010100000000000000000000010203040506ffc40017010101010100000000000000000000000000010203ffda000c03010002100310000001f49d6b71e0a87ba3c8763e757d4371ccee68d804040500148500a0004211041500042800105900009660d014405cc781ae314e27196d62052828369161087d75f7c83e5d64fa31e0af49ef9306569b29836081215600500a50000648820150004000454b0400101c01d8cd79e3b1cd7cd2f9a5e6b1325814eb2ea514c554e3440320fa95f5a327c25dd43d09f5a48735e890c1cd7a1d010100402ac29414000c91040094008125115000018ae12f9a589c65843cc749735410000abd32e864c50dcbcecc20501f48fad1e33cd5b8f357da9282ae4a9cd766c02000802168000282022402a0000212c88a0064a79cf14d79e5cae64cd1045d983453040134ba3519a1a8f42f2b3924544a03debd5392fd493e3afb6cf74530438d753bc9a500400810a080a2804082014202005043999ac20e6738f2af38e22d8089014ab0d148650b41a8521664d054985a6e05547a7729a24b9afbd2026574832a3490a140800000040820a00010000843cebe1394713526a210cdbca94094d455a44caca86a29a325200101645a4a2150a3f4567c45e15ed4fa87792006d4019452055a42000802080105000000080f12fcf39cb941d330231a6a2908125d4a8641a351a412dc90101402149560b49015f6b59f992faaca7d24d4b0a58d2810a44157c679ec80d1b346cd9a29410c983a848735d1b2821cce67cb5f32596992c2cb2e286c10142d48a41a819b32a202800a400a0a48517ee59f28f41f45376002885582d00dcbe14d57600c193260c191593058e250b6326ce8743413c8ab312e112e4873b11ab442142d3648964542882182800a585080b002a1615f5753e5cbf4acf7a5064d9650336581579548cc4375d12a8080a8138af0ac4715c453856532a4ee6a392f2af6d9a30002265725214c821625410584312d4816252c504aa429a283264a17ea5cfcf6beb5ce25ef610735e92d4dd663469382f857d926c19aa995c1cca7a8c8349c2dc9939c729785980507a4e879d7a33d17a56ec148431673ac113474cea59cf50405810e8633af2e758880c9b812a1410a5294101f46b99f5a283160878ad44384723473af51ed8ca64f15b4ea9d0d14d80641095c63a1c23ce9161dcab9381dca60eb67a7539d98ac2688a41495acdd9cec8285371a2c17cb9d7925659a894aa29929900a6880f59debe9a79a5ec7529f2cf099352e5257521eeae8807cd3da7acc0001080899ae71b96d718e1085bcabd879637350c59c759f74be8de78ea65294105008eb9aae5a9a8a58a50b4caf8b37c92d3520ca812858d10d901dc594e51d2bb1e797518ab1056a351debb558853c5a9dcf61a32019214194958265baab4cac21532a895839a765c27a2b1acf3b000225502af6cdcd99b2c0aba0087397c59bc08bb81905a08d8804e975a651ce858d41412b56c65aaf6560d40a78b73bc6ebd860843348a44cd40632dd585bd410005219162a14879f5980a00156371a9aa98b069688a73acd9d25e19be5cd442850444b458499ddca748b24a96ee3506aa4b649a93bd765c5581a3c5b9de21e8af41c8c92a16495921a3314ab94d2f610a10a084a25202d79ee79d5042a4aabd32855de6ac948a539d44a169c71af3e6c89691020a86a259a9168b005372adc524d1ecab1ccd029e3de7acb2a9ed347225409002039c45d0347a00000216c0066ac73b386a0a4214e910156c6e5960a73a1012cd4b65f366f0cd8520255c8692a71d5a6e3ac663a2e0dd73b766a3d4839aea1553c7d275c864e95ee3912a11290190629000d1de5850014542901532ab38599412b458154511a968b39d215021468c4be5c6b9c082b594142a0d46a351ab618d22c4eabea90b84b2ac1e5dcdc43253b4b9ad550405282a002148a2800a80520ab1284cdcea6905000050496d445000400a70cebcb92a0c95db1996aa142d844d5b59346cf4c85c255153c9d233683477b38cba8ccb4802081550d4985dd61211746e22414064185da616d9a8a010a4050504a4080140250c9ce290a23ae64acda05895b86a8843bd77cc1ccb2aaa79773314abb4ef5ce5e912205250400a085335491a2900008086ab318dcd66a28000000a96222c80028804af2ca29606a34425400a2d029dabd3883955816bcbb9acdc1bb07a0c2ea2401410a42805073ad96200000080109b8cdb0000000152c92890005042c95e6896c8d02ac3710cd680066a83aa7b30a72ab02d79771943485f4561770880000140009a2350200002990019dcb9a800000001a93365482000a06753cd0b6468d1ceda58dc66a802b0507a13d72538cb6216bcdbcd882457a2d935a890000148140217491a8004000008531b9acdb020001002d4b266ca44a00200cea709442c755e3a0b225954d1815003bc9e8ccb516c0579ba66664068ef6c9752880a2005228005435000020000063a4d62d81080a016916b36222884042920634e595a46e16f0d4d4b0a66cd2ea3992ba40a6d3d3995735a80ae1b9e889125b4b312ee25410a4050b0042d122ea0000080000c749ac5b032420000aa96928a24b4016462b9573cada3711386956c53266cdac8b42c2bac9eacac634d442d70d4ed9bab2d4335996c084000294914cd51625b029402000025675358a04210801402ea4cd101024ab292ae2b8c2aae921e7d29b97503444d2e4e761767793d1958c69602b959db3441535332d9544a0400a08145291604a1600808504acea6b1408420202805d499a32080005ac19979d85a4ae57297a9d65a724dae4d184a58ed5db2b18d352c2d9c6cef9b480cee665b2aac9a2800108b93654ce9aca8219000040525675358a04210020052ea4cd19040016a473d2e6e28448bcecd1b940d994d995ef1ce42f4b3a49575a63342ce75df21019dc92ea5c96cd45290a406140d2674de400842000004a9a9ac510100a80002c4b05441481519ae6665d183665336d804d1b9625336ee299369d64a4b7b5623272aef952033b9997519a455d252820ac1481659a850020202800c983a8008044040094951929080841669791a2016258089d634450335634693a40c14e95ad4e12f7c1508676c14a52160500c9a58019b2e68100210021085b3a69cb14a80214802d173a332c0029043356c589acd920692ae53505b2516d2d7236965e89d229c8d4aab673aef8a4cd41b9c66a401028081ab24a5a837bcf2c6aa8a8810a16590c8add9d3538f3d52c55004210d0b9d5b9cd81156580599a5ce6b52f5b3253470942068d4928b2ad99976759371a389b96175391db3464c9ae99e19d494506a58085b10582aa6b59e79dea29410042cb3242574b9e9a71e7aa6a0140864a12ea526688ab2c010cd359c54042ad3516250eb0ae648942d6a3b49d234725d441b9ce3ae68c90d74cf0ce92c05968204b649a002b7bc73e7ba5280020866a10deb3d74e3cf54d4a0010c9459ab0b334096512c099d1673b24ab0bb8cd7781821a8564a44aa335e893ae54e6b620dce71d7369932bbe98e19d495154001620b48415d358c636050501290c50c9d379e872c6aad8a40420052eb2964a20aa89610cea5b39590ab4d16ae44c9a5a6884252290ed2748a616c41a983ae68c54975d31c71b4140a405b94d00320e9bc671b000a0a902e2c10def3b318d429a12c0648515ab94b1421642896562cb64a1054886e3485a610b4d9ccb42c7593716b12d894d4cc75cd1cd46ba638e36828a082cb050042274de718dd214140411736086f79d9cf1a1568880800adeb33352a88965804315ad495933260c83d10346ab9c74580c99ad183d599a8959828ba998e99aae6b637d31c31b2a0010d5cc9aa01082ba6b18c6e80a4a0a2b24224ae9ace8e78d16950a819ab0256f58ce75548064b523350d6b3c97294a743a9ca335a307a25e65326d32b829e893710ca8835246f346155d378e18dd9614025944a001056f58c637405a8050433512575d64b8c52d28112a10037ac626a2824256a48b6a26acd1b2917503ca9a34b9b2c62b6bb8e566e22caef99d232655106e48de6ab0a37d33cb9e8a8002cb28004216b5ac631ba0852802a19212cebbca5e79d581484a890141bd6712d814a5068033a9dcc8520d2f964daf3484aa4299350557a733ac64c2a20de64bbcd9585a6f79e38d5585812cd09400212a26f79c637480004a8024335e8d6731ce6900829a28290d6a66540a000681353d04229043c0528306c1410d9dceb9488648a86e2352a39553a6e71c68a00b6662a920254043aeb3cb3a004a2000003d1a988c4b040d1b219294a5d499a000042826a74340c9a21e1416ba4b821a00a7a63dab0e527224458352c6e591cecb5bd3cb9d52006d300a50520074d4e32c2000000029e8d4c463344068e864c14a68ba93340148086922e752ae93616a53e758214417412af48f4afa0d90f349994646a58de68e565ade9e48006c8149634b080853a6a719444290a0080a43d3a9ce332c8034743060a5ad46b5339b4a021442826a74968a141f3ae629068d4b08743b9dced116d7293962d324dcb1d3361cacb5ad3cb000e860aa4b1a581045a9bd3966aa000000007a359e52e65801a8e873ac901d62ea673694255a01928d4e853445823e7d99340d141934753a4764db5a336632c66c33b972e92c39596ae9e7812b5108535156848005dea7294010000000f46b3cb372b014d46cc5985883acad4e714d2ea050532837a6e550a229f36ca6414a64a5347b62a69752d1a9cb17318dcb97497273b354d384406ce3429a8d4688a48525bd2ce52c0122802901487a759e79d4819b22ee3a1cecca906e56a72803455d4941286eba1a2102e93e7c131692a88429d0f546339ebad75969aa89c7179ee6b2d4b94c55aba7080062896068dcb0102ace95ca211480400000f569c728b4b029b304094a4d39c420068d14193ad763402827833116de764b680963797539a5b7dcd5b36b848798d65b97098ab4d38c4367340414ad6e2542c4559d2b94640008000057aebcf1980366a5d8013262b4730014004315e8aeb14d05a54f9f884aaa85226840862b56fb65e94951773ca6f0b1939d6aa69c6294e765901685dc05225b5375cf37344101000003d7a9e6cd8003ac6979d65210a7430141214d5010caf53a1b4dac2c7cf9949a5a83340422e6b514f6aecdaf38a79f73a66eb2c273ad54d38c7439ac2c168259b8a82ac166ab9e52a10020140215eaaf3422029b5b18a89161535542d4a5128d1a054d5b0e31d2843cb983a465159ac14a406cd4bd8ec6a152556eb1964e49ab31abc6346545944a20a9a0400e860c900299290000f557920516c349a0688a2c681b21b0530404ad10c1486cb1e241b21b8cda283044eb04b277b772e4d1dedcd539e5c91673d5e719a800214162800a74ac464801a200b5060dd743260d0372880e85294000860b56496e41a0688500f0331750adc58ef6f7210f32e64d4c92aea15e8b69555a8f3c8b396ae239508002829a880a535598a5045a968080b0b69229b3653408500004210a4ac268aa20054ab0a78667518b4956c697d75b307338c964890d4ba5f7ed98f3c697b6e632e55cab890108505058d94b5b2982990684b0d03468800294b5445005828066503350852842c042c4aa43c99cd212a2d29b97aaee89c33308b326f3aea7b76cc7932d2eacefa723cf5c6344346cd50d94a42011a5005290843401084290101a216b712a8116b110a085150a542e60402a9e299dc4a198d05eb6e84a4e68933501d8f75be7cbca9bcdeba6f4870d4b1d1699325585351a2036014002c84591b150191006485008505290a010a01454282101080f133606946a4ad7aab652188cc70335967d39bab391cab796eb35e95ba73b39cbcf36956228743266a94d1a8e86ea45452316d915428cc0a4a188a5040000400a080d0a0215228c1a07813a4742462b526d7baf7ac160733818489a8f41e74cdb64d2e2bacb5a54210251421d2b510dd4342259a12da0224045a48a415229a32010d1220250005150a0a429829900f1a778ec7031201a6bbd763a1cccc7139a6912530b2c4689563bdd45845d24ad029ba44299345a899945281640b08581a2d99961480a01080029085a916912a1410852029e54e91578a6a4036d7aebb10c0384716729b97290cdb52807b2e81640d501a25660500a4200692d4008a810a291900c9a0428299294c81598d5644689400122543fffc40029100001030304010403010101000000000001000211101231032021301322324142044050142334ffda00080101000105020db7f17487fcfdcdd624686b709ba8d6b1ce3ada9ab2d0c63de9ba3a65a34c0446a8d4f5051fce76f2603f5023a810d6013f54b94a93b2142841492893595a84c30431e256b9366ac81ada834d8d796334b4cbcab79f52bc5498fe5ca9530d0653b1e50c3784fd60d5fe925179277c050b1438dc1c3fce9a9e7fedae5ee0c0b41b7d43c1752d08ca6823f924ad4780bcdc7961a754b9795cbcae8953d528382b939d2802a1111b9dff00a651d5b347f15abf24c264eaab45a040caf9738354a24941bfc93ac0176b12899fd40af08ea14752e576dd628ea5da5a86069b0b74f58dcffc6d3706c3d43d00f56ea26ffd178d970168fe0dc11785e5649d568435da41d74755d25ee34952a765aa236e542851d3ca8d929dea1ed4c3e6d6d5d4e741b27e29f6a168284cfef9308ea22ee5ef9a46c8d90ad50a286b348fd22dff009b9d731b253f4c69e9e937c6c953fc6d57abf7ca07a26b0a07ea17070fc823c9f8a035ba63cba9dbafc93e60afd70bcfa8bfd457fa421f92c5fe8d35e562b9a76dc169bae656f6a0e076ddff004bd6a3a4ca1406972ba91b61428ac567f4c35ae0f6b6ed4e53581a3b7dcea7cab1abc4c5e162ff003b17f982ff0032f0ea2b355aa7551739a07e4380ff00495fe85e60af6157b5791790af2391d57001ee9b5c4f89cbc6558a161143a2693fb2c71974b9fa02c74d5b8e8bc4b9dc501dc11ab8d1c6d4e109af46d461405014056b5aae2ad7b97aae64916ea287ab75146aab5ead2a0a8348083015002e14050d5014355ad56856a23f438a1aeb58ed1645e65e834e991caf521727bdcc171690799e1c60ca94f7f33ea1b2e84750047f21811fc95a7aaf2414e282251a384861e1ec853b6de58d11a9a9258d0d041281db2af571d9328b636456250108e9829c0b774ec9aca9a1aea81a63f15a1ef2133da74da578dabc4d5e36221b37325fac9dac5c03c84ed4255e5698f55e15e5171576a175b72f1008315a8360efc393d9585742bf9d524269b0f9dc86b391d5714cd5508b88571e80e85c3963646cca768ac29a4d236cd66854a7b896fe210117800fe432e3ac2d6b8385e17e4fbe51d81cd0b298db4548ff00a69acf5ba929ed5152ee5dea644a8142b2b4495c3d11151c6f0e45b48dee01c9fa446c9df9daf32390c65d5f29b412892e528e17ca85a639f9a9f784d328f5b698a72a0ab172ad56ab022c0bc61001a80820ca2c8ea0485c144474bb4daf4f61674428daf41c40b8a995cec89a0c6367daa7dff0d30823d5875263a6290a16116cf48ca9513b823494ed1051d3850a146e15c98431b064882b04d34e9f6a9f7d18e4791d2ec5471ddc3939b1bc66b32a360db9474fac6f85215bb0080bed53eea04c7270eac2b94ab9072cf6ca73370cec1c2cd46e94407276991d2022b9410512a210884d307ecee0b734fb54fba54a94d741bba8ed06167b70880e4446c6e774f54a730393985bbe573b818479453a8cf753ed539d84fa46a40f2af32f32f32f2af2af2af205e45e40bc817902bc2bc2bdaaf0af0af0ae0ae0ae0ae0ae0af0ae0ae6abdaae6ab9a11d441cd5e95c2e170b85c2e170b85c2e14ae170b85c2e171b5cc1d72a76fc32bf6a04732a422be06034156355826c0ac0ac0ac0ac0ac0ac0831162f1ab5589cc56f25a83178d58ac562b158ad28b4c415615050122d56ab4ab4ab4ab4ab4ab4a82a1cbd4bd4bd73ea5ea5ea5ea5ea5ea5ea5ea5ea5ea5cf6cd41a30f34fb54e5c161450606e39dd142823d51ca8431fae774f54f395a7334f9a9f71af2bea371cf41fe50dc774d74bdd4f9afd8e51417d47ec9fdf351b637fc697064285f35fb21c541968eef943f8c71b06371dda7eeddf31cd20a1ec1dff23f5254a953be3a0e02280e3a324ec30b4aa3637dd6a85e95e947dadeff00918fdc98572b95ca42e14056d1d808a6d0d06d192854ad2a8d8df7295c156a3ed1dd3fc98a02aed8391114b57cb841e22995a751b1b9d8703642850a1428d90a2802851fc49528a149ab5b2540971e5aee3951c7ca84ddeccec77b4779fe39c229b8a46d0b08a844284e4dc52dd8cdaef68eb3b0ff001ca95f0a3700a2142f871a9cb3140e85c391114d3daec053b2770a4a944a952a54a953bf94572b9dbc2e170bd2a4290a42c2b95ca55c55c55c5495254d0a1418a38734e506f03054af86e28cc6c0e46219b5f814850a15aa29c2e115c296a96a96d2e0ae0ae57abd5eaf57957157157157157140c953d873d4e4d1c1417caf8da38a731f6224ca6d462acdaec49571527b463b5b938ec39ea765a55cd5e850c56b69cc5223672b2256437146e29f0cda7073ddf5ed6e4e3ac64e7a465d9da4a15053904690b85321a6451b8a7c336bb1f3ddf5ed6e4e3ac64e7a465d9da70d08858a9a5b00708f28a6e28dc53eacdae5f3ddf5ed6238eb19ea1939a45018d80294290be242ca8e1beda0c53eaca9a1fd0faf6b11c758cf50cfceec9d80aba9c2120494dc2f818a1f6b36bbf43ebdac4ec758cf50cd254a9d98279309a601335844414dc2f8afd59438a3bf43ebdad4eec1d614d6d418ac156a9524856d01e32e346e11c57eaca1abb3dff5ed6e1dd729aa54a953518a420ad0ad0a028dae8020ae6d5306257105c55d2a653708e054fb598d8ecf79f6f6b30eaca952a54ed6e2142850a370ca85159a02d454a26504549350be451d8a9f6331b0e7bcfb764a953bd9ed7ee851b463a9b9a72a690b0a66854a9a1e1422834bd780ab628ef6d5dec6e361ced14952a54ed3eded6fb5f9ebf8ea6a95358dbc10e6c20be6ba5c2990b28e2aef637151939da7a8e3b5bed76771dbf1d431de384c1c51c13bdb577b1b8a8c9cec6f5bb1dadf6bb3b8edfaf50a428e918a8261869f384fc55ded6e11a0c9da781d4ec768c3b3b050edfaf40a354f470be1b4f850a38fc740c1fb654724455fed6e11a0c9d8324f3d4eee1839dc769f6a9e8298a36c539db349a69441ce4e299468ff006b715193b30deb7770c1cec143b4e2b2a76fc37645251d9f1b216960940a348479a3f0dc234193509db86e7779cee2a1428a3bac21d7148ab4f0534fab615a9818468dc9a8e06e1b8f79cd6774a94eea994dde6b0a374d01e50e5a5654ad5e10c2346e4e28eed3de73b89e761acd24a82ac50d5c53942680ae14a9df28d65058430cf69438529ed938a1a37271de7f5654a952a68e99b5405700a57a941562b42b761141ca22173d32a57084501e1b89d91211a372708f03a654d065dfa90558ad13202e053d4a15a1428db72b972a173b2e2a54ed850ac5e345a45055b8528f29b839f7045353b011ed19767a61452172a045b0ae0ae5ea50ac562b55aa3a78ea8afc55bcd2d25109cda452614d1ade308fa9029c251413b181dcfca8569510b850a28485214ae69ca850ad50a1474c6f851d10881b5a850a2cd92a0956943073729e42736851ce3a6d2ac72f195e356051cd795c956ab55aa142850a147f165028384078572264d6f7431c4b827a77b8157426944276cb495e32bc6ad0ad0bd215c8b8a0657a94150a290a1475f2a6b2572a684a9a4a953fa52a76b015e32bc6bc654734850b4f216a1e2996822d76a71172b50802f0bc8af57290b8fd49db0a2b1fab149df129ad40501a405156911727195f2a7d2108511431bee45d3b67f99c6c8e211e4a6a0692a6853b64f0a39a053cc9a1dd0a106a851d87f76764ed650a6d2549569283054846832a764d3e6d58a428515856ecf9e8e7f8b34ca6c04e76d84d9142a20274234f8df3e939850b2a37cd247ea4d31b8d250dd3ba767fffc4001f1100030002030003010000000000000000000111306041507020408090ffda0008010301013f01f1484269b35284d4213d398fd56e2a5294a529757ba65c774084c9343a5f85fb17ce5eb5348ba04210842108427c210842108427e70a5d5a13f853304d398bb9e7edb1773ce75918bb9e73316462ee79ccc5918bb9e7331647dd73998b23eeb9ccc591e90c5a32ccc5a32ccc5a32d557bfad557bb426a509f9161354a5d69fc2e9335e5ed3ffc40023110002010402020301010000000000000001110010203040506031410212217080ffda0008010201013f01fe28e8fa7bea2fa7b8e38f6dc7cd3eaab94514516daea3fb3f67ef515145151454515545145145145ae396f18945b2e8e38f6de078d4789740701c7e23c4b55f0aaaa7d62c8a78c4a2e80f23e1043ce1f8ee8e654588688e11e578945b23038e3dc71c71c71c71c76b8e38e38e38e3da1ac21d571c7738eae3abd9179ce21ce720e0c5e7388739c83831e6d1a221ce720df50d479b154e710e73b2340f8a9a8d61a0727aca343d54d479aad31a0727add3e2a6a21a3d31cc9a9a887546e1db769a886d1a0330cc728d322a21b4680cc322a18a28a28abf93f35dd1410da3328a08a28a28b2b8e38e38e38e3a1ca355d0da2e78866198ee9b84371b5c71e01e330872087cee9a9a886e39c78cc21c827cbcee9b84371cfeb3087208774dc21b8e7f598439043ba6e10dc73facc21c9f1de37086e39fd6610e4f8ef1a0b04371cfeb308720de341608757d6610e41c00b043c18878c1608754e610f14682c10f0878c16087843c8087aa086c1a2739e34d44360d13ce79a886c1a279d34168d13cc8b04305a344f22f19c0344f3868e86c1a279f168d13cd8c2344f41061a0e9ac404582a3a6fd44fa8b1c78974618558e3e8e49c0287fc75fffc40033100001030204040504010305000000000000011131102102203041123240502251606171038191a1e1134262335270b1d1ffda0008010100063f024fb08d7170aec6146b1f471eec26ff000270a3220ff53ea7db09c6cfee7fb9f73c2ab84b2ba3088c9f92f7ef3eda524e4ff0630fc0fba1f4f0ecc605c4ab30a2b49644b7f71c7f57ec9478525cbdbe6befdb6f56ad909e8f8179915a9f7113cbc8f122dbcc5c6be2f9138b9523debc393c2b7f72fdbe7a1df3a7f930fb216e6615553ee62c32e8861fa690870ed4f61c47de96f44e0c5741bd86e27711389ac360b8e989bec7327e0e6c3f81b893e784e7157171587f3ff2193b24934b25257b03a272ee2e155544c48e822b3614170e05b0d0fbe82f97615ed1c087c40c9270ce3c437695ed16c632240b8964fea2c246b6144563c389c8fd17c287217c2a6e49cc85953322e970fb38a9bf6a5c58b7152e60fa78551d064d67acd3950820dc9398b63fd9cd476e21930b2525492e49cebf9398e6363890e27cb1d95b12a61e14154f125d722752e3a40ae41192e8786c3b8c989ce6545398e6269087221c887fa65f01cbfb37fc9cb8bf2429b92bf8257f04afe0e6fd1cc732129d2a79ec222c0f185464e2e1f62d8dce64fc1b289642eb8594e672f610b68dd5a96c2a78a345d2332a79a0e70e1fc9e6a40d8b4fc5a56b297e8ed75dcbc0d384badcba108729cb848463d8f3189a49c58a9145bb20dc4ff72355d23259047192169b1b1b173c3a76b2e8b29e1fc745c2bb189c93c2e38e496cdcbfb2c83742f57c3192c3f44ca5b47c483a5d3a1b0b5e1a5f22d78bcba6b5613f06c6c41cbfb397f6429b96e2194b69fbe9792f9ebb52751bcbb25b52da56b17d6be8416a3d17b85f4994f0f4ec3517b2dcb74d73cd3a39a3d573c52fdaeda5e45fa65d2924924926bb1b1b1b1b687f27f27f27f3592692b5dcdcdf249249249249249249249249283a74aba2b481746d9e49249249249244d29ac92493d55ed4f6c8ba2be877a2bd57457d12bf155d15f44c6d55d15efd6d35f8aae8afa23716ab9169047a26f45aafce45f423648d15f9f444b0d25fd2de2af916f495e8f4f8245c9ef45eca99249249273411af6c8f58a5f42e3a6b4924924e68208edad924f27d74ac93a8bda62b3a4d0335f593d02c4e67d54f40366761cf65d54f43d8b8999732777db57ff04a7b16cebe865a5cb646c8b917d0b14f61e9148b5528bf1e849c8c5872c94b4173d872e5aabf1dd57a2b9199b6c965aaf755eb3c26c955eeabd2b6f4be55c8bd037a056ae9e8d7c96615e8c587f4548a5f229886ed69da2e2f09f7ad86d15ed69d1b68a8b97de89997d1ce27fc151593f92dff0046f49ea1f6ee73483c89e9a345946ecb192e4d20b614a5fb2b1efd74669372c8493d7c69b8e5a8e9d2ef49427f4429fda7327e0952084427b858ba7470a41b1cd4bb12df086e72964ee0ba0ce4e66585cd1492548213badb34e8ad1b2264dbd16f95a89e8abea4f7b8d29cf62da09df3cab6c8d4bd7cf553bdda9fffc4002a10000202010303040203010101000000000001112131104151206171308191a1b1c1d1f0f140e150ffda0008010100013f21a24b6d30d4a648d61e192a529c3cf9199d8863b84a60149334addc47c829b7bfb12eec6c88925a4be4f04cddb772513b4ee37f93dc2f504c240f797f027cbfe9ff0034ff00c324e924eb82f3accf448310de58cbdcdb18f6ab81281be2dd17b964364f4cb9249cda637b21bcb325c1279156a26893cc6ffa10d3a8421c27663236ec491c89b5cb896c24215a420b7935355ee58a6f73468e09e4434ad4222e699c17e2fd89ce34c04a762ffe5c2246ee46a86c21251c2348d6df0770838b634210896361b9ce91c905895a91c2a48910e1c8f64152306f57a2360a3931ec8b4bee20665a82e4b9135a11e1bf6f63b30ab9b25ba71b66d585265299db5763886f2d532079a11c090a37cadfd79ffaa06972564e47044868cddb335086a50a875a6366c4d17826759d2649274ef442dc732450c5d9de236ff024f49d248c49349a528706da903909263a8c7726bd7309960b237453b5b1e31191a12a358c15c8ca3fd10bb9832a5a140d5658c32f1bff00e114379ed8447fc524ff00c72968c89e16e316d42e06b5b247ab6413a4924924e8d440b1a49225cbd04b643f251e0c84e56aa073a1ad4ae333fb2f597fe9b2a495b70b720621b1604df45448df0ede2d224eff009ffd8ffa9fd88f1d793ec724d9709242a8983429d98b28e6990ad809ff008e49f56e89101aa0ca6981306e1f0775ee5b376523f989e80db2597b9282418911a252a63180b43542d22ef573b223708d22b83d9125b211d5d243e5b11cf09e7b311ba1c703739930ce1937024a118db59a2e53d11032ad6e2248e7676ffe040965286fe865160c8934640f817c32f823b0a42e54244434933dc6f42b428904890c5aa1e93d6b9a214511a9e5fe02d136db0810a5ec2d0894eef9d4937f4a08f42749e9924927ad33595dc4cbc8997636216aca1f451289d5625396448128421b27a1746e3d27a234684cbf624d44921414b0ca6f81cdca0927544924924744a407250950deb3097fa82ff40bf5018ca4f2893ff226ff0030b317b92b95ac898f2493beb2778c33e9f7011b1e4c91ba1d06a254684bf61c0418ac4c1233613b10a1088e353d0dce93e8c115d13a22699578da0515c312345e286d213d1f79211813952b5964924924924a4a47638989ca1a6d1a65db91a4f290dffc23619f87b8d9b87b11f6298fa0d1fc8364cfdc69cbfa47f1a902d24839935e0b643bf1b92d3e45b2abdc52c016d95c4f81c5de09899388bbee24f248fb04037dd33c468272d0a3d1bd27443c209196c92492478eb8f42f545cc3e4ee87e52c655adf914a61e35a2bb74ba6bc10410344249152dc4a10f922d275641d9813c69956c2504a5b371fbfe3c180a9a7c9c3213c0760ec1b50c496573c8d4a890dfbe5b81b5b4f616032222ffdc70b6836e59ec43ffa8fff00099da7d911b3eec7ca0a5c292da3fc0da8687e1fc11ffb4feb47f65fc8ff00aafdea00e04f8643fd3f810953bc48ba96886c92459b2b921411099b29897a48f01fb10ad42bb09136dbb8cf279418ad25ff00038caffae48554799c7f23e1d8e3326176f4417a7912aa3cc4195a53b0fcc6cbc8c4c97126187962f3b6aa98da10a4654793372924fce19d225b0e5dc6381e04c0d2f49147e8b42d3fcc30d88846f43a8a532442fe47dd225493dc6917c9ab03d450fe862bc6ad1658f821bbb1e754a909ee32cad69042e0870885c221708d848dbfd9fe5a1a42c13a449739d536364e892d78d32df0268ce898207794955fec0cb150530379333ca15b581a5381cb696dee3734f1761b560bc50f0b93c16f22df61bd54f635b322949a58cb42db6c60a1e081977c9dd0fb0a76b20549b1ec7c9905baf06d5ae2685249df8b0884a7b114f35e04492c9d5be856ae44e05c7f9b44e59216c48b404a383c94496109bda4ec063282d8844f836be652e1666606ed268fc911d0cc4820d3686ba14b22ad692095c337be61cb4350f43d126124f61d4d8bcc8da5dcae0a782594cee4c9b0a217f1fd87f25bc0d8e046b8367591155b9d849c49ea03e5b9124b233d8cac92d6c7ec696ce853c42dbd99b01bedd1248a53c9875371d0cd9c091408ea9fc34237313dcc4c08dd126ec44773243621bbf62bac8d7bd583b7d52286514cdd19c0a1d484f1277dd1f4ed95a432232489667a2909c237d84e728c21ec4102f714483b1e48f8df44dd7039b04931274670dbee381661369c12fc024b2242366f0f24b5092f9d123f00d102504d649d274636448d51c689c87312c4731f37d212214422117825c7c4871180c260bff5054e322c1bdd0613f23bb1e9309542796833a0ba261977ec0c92ae50f484468c8184237371ab21904d26c2424d21e40e4ee433142e74919256592330650d26297962d92b221207978d567553fb0d28a6b9e89d7e07aa050d4a208e981a1040809f9216b25a69c3ea9e0c776590628d3b442df0eb66c52b02a59777f1b0c78a911a89110884568cc8924eec8d8580c761def658bb9b1cee405ca2b9f6e0d876e0dff4160486f87e447e8d565682c69b5ba13168d93abe8b04e527a37381c671ac74410469063034987919e3cf467b23c698fc8f2f5853e638dab5d190f3acc149026b866fb4f6dc69acaeb54ef493293260a642df48a209124b7be4504e64e776999138c2f04070fce9fab5595d0b43910d7637911d0fa53bad8becc4a408d93095ea342d8773e237b6e473d3bcbe867815d8c88f40821a4f7dcb05e446d44924ad1e48d2828896d19393714592a3c9245e79d18dbdb731f90458da19babfdd7f4eab28681e27891ff4270426248861aba52887c321f05f0cf63d9eb2849125042211089bd84d24ae99d26092749d13785a124acf231a1f4275d32cda226c2f410b2cb946015c8c9bd2e759f0c526421220b67913381a905474e6a04f81d618d7f4fe355946736e3498b3237da671c8f321cfe8f2fc23fa423fb41e5f4792f817f808ff0083fa11fd08fe8478ceca28c1d9fb3b3f6767ec9dff00e9dbd13c23c63b9f677fed1fd0f40dbbbf91312be8158768677fbd0825163cdfc1e6fe0f3fa27fc89ff227fc89ff00227647d88ee9f04ff813a047011c04707c90b8fc95c3e4ae1f256141c19ec76378e34c7531eda1c996a8c781da8821bee39508f7233df5fd3f8d72331492c4e28825df8127667d118435a45843b27674dcfb9e71c4e267413656b710e74c56e4095978ac411e1d8d8bd4131212120e641206976763e51a54c8d9249ecc972770ee1dd3ba8ec8ee9dfd04147fb183611cfec8e5f7a9267b49ec24489e037bd13d85ac69032691948cb3714b23730a06e1514047d1389123a5aff5f6d564cc3244b63d8bc3fc9d8fa6663e9c8252e3aa0a7be8f8ee51be45988e44a3d06a4839e9088e05a68a97a7bfa8dcc7715ea84e98704c49b6b24d7229491138136d158dca75c6bfdbdb5592cc650fe4f7261368e4de4419e9173aac990c0dd25d791bbf3e9cde9cfaeb1e93d2635589a24930ee373679160eda386091f763cff4656bf9b55fa1e5e4cc659c112dff00e02c62dfd1d9e3fe3dfd26782c265b525f3a2d7f01675664c28dce034dfe964bd8ec67e4d57e8dde4ddcfe3527fe01670d30f537d5608208208ebe47e964121aa152429823a1c7818303e53dccac9472c723d564fe8775aacf96abf4352fe46c1a6b82fb154d0b1273a2fd546c30f55e3aa752040a288371aa126c910faf310128cd1ec28db442361378c892e7d89c8cc88962dda146e261232f0d72f2d510b868f643e49f036d94f823c084e3d66fa6c307aaf1ebc89848f021c6ae4dcf21aee6528c8165046ce8a3ad3848f46891771c50bce20973c139577d857097193735cbc9d231813ee4e421b1465df5c924924924fe49249249d1227489249f49ff00c0fae4991e06fad2131bd1ac67630771e4759953dc568f05c2174aa27c8873efb917e0b4b62427edfbd72f27e75e4cfa46983f3980f48440891e890460de08101ab285a91e93ff00a5c129d149d137438e887dd4d8a2929f0506d9e3066a508f71b9c16ce0836786350ca072f1820b3931f7fe755bf97af264e9c1e4c74fe05e83a4216997b0b1eabc7fd38076d35a60906e58a711a12160fec12d0c9adc296fe09a49c3c1694d4a6d32ab4cb2530ac46ab8325cda16924a55ceab7337d383c98e9fc084faf28d38d3f5f59fa10f8ea95cf5476643e087c10c746026c220298316450d50b03d8be093ba1ba28b87943b59a91a882f91b50b5915db65c308f3664aee45a3b03db0df010c9f4e11a8812489e8925124a24ee1bd443f8d3e2789e2781e0492493d8be0be34492b137eedc810f921f3a21702350a791dd7a73610a2ad4911e21cdeb5dc3bc7789f2374421c97268fcc6ed2188c95027c8c4a5c107d84b663b8d2ee594cd1a1c490ddc58c9295dfb14d250645df4dc5a3d7245f0cdf4e1824d10c912264bb1e688ec3c27847b50243b8f5070e5a3b3a48880f03c09f03e0e88bbc7786583c325c92f92f9d208e98167d19e9c0fb1913a30b10747cfb1e4a46684e4476c9fc834dcdc723a5e4f322a83e019957b58d2b62ca74dfa2587a649246ef40d0e8ee1dc12f912f92f921f247720487c7504f58d63a1ebf88cde92d167d298b2b4a2567f5a2590998697b9373f72d296ac86c35dc83d85981b9c646dbf029c2b6e368c4b54cc129f061f2f459461d776bd8dfd482ea59089f45ebf88cda2f4b06a3eb6602e70310b3a31e49354265c91773e448889769c193b87f91a06e55326b251270db5b11a892fc110ffbb68b28c3e3579f476d3e80f2f45f1d5bbd27d198cfe84eb060327a2cc065248e042198ad29ba448eafb727770726457b58e49281f1bed04a0bf8365f21e524884cf80afb9e88c3abc8c74d878d30f01e5e82eb5e9debbbd19f48f2fd17a5944a749092e4e016dee621c92cc065891bb4bdd913b391de63ec69c65a8f040a271f64355052f08e334e78e818f5658e8ccb4fc43cfaebd6eee8974b23a279e95d0cfc4256701bf1ad0dc645ee279085b63f036e226875ee5bafb28deb259426d460272f743f1236cb1b88ebab13605d749b78e9163d392f06efad7af5d7bba05d2fd023a9eb349646a3ed24411088ee298934c840690dae9aec42b4ada50bf27d949465f2869cc6d930991562e2cb4a6d1647db4fc0c58d5861d264bc1bbea6617ae5abd598b30d57a08cfa646c9a275cd9f1f637e4cec277b1ca2269af0399c88db8f60d31111b8e6e212940dbf092d31159e05886d7dc81e54ce3b0d45853025b7b1858ae4f1ab4fb016357918750dfa92963f41fa463d19f98d9e836264e86cf484925a0590c909916f21709c427f0128e48ef053cb624bff4600bca64c9b2290f31c489dd65b8a383dc6fb9c0c428122c23f61c8b1e4a22d3ef0c35cfa8fd118b1eb0ba249d5b3f20f8249ea0493a43e04097279912243823a7f37410c97a524a904172e648e1ab2b5486f9128b1a56ea04b584ca8226c553c776350d4b4f63142c1f4858ea9dbd1b71fa0dc184924927a04924924e980cd74c68420823d10f0275afe726b4f6410ec4a7b91e44e528f9097be7920a85c0b5ee272f891394891ab7f235f61c24931930a9e41604f0619f405d44f1a2ebb0927a4249274c7a4924fa588c1e3a5103a27a17a02d5a2cec64f7264844b647ce9b944f0cfb18a9d43e0649d25129d290f25e59edee4e44f0a856c6a528a7b0fd06278d30198924924b65524d60823a71fad88fc7d285d459fa1bf40909b9265692c97a4e89b4e51933444127b8db6c649112b8128d25e4dccdedf9d1f483c6983c99ba537e0997d4fa300fd08e9c5d5a16a924d85e81e0581988922ca8a6d1a47240c4a479d69c9c0ddda115dc5913407b4e90909a7813b360bc824c55312bdf57af230d3079327d383c8b55d783d6c7d6974d60c27a34703c1efc10ee22288f627df48ec48a8e724285246858415fa2155913284f30c699e6a85952c51da334604406992f24ed706ae1a60378b5591374175e0bd6fa867e95a67d0b06224427a9e4c04d11dcc09adca787f420f91384c50d9b09d761cab1d1230ad9015d331144f6658cd18f9847026bf0090f4c460d1e98ba6f91eb2262ebc17ad83c1934823a19eb02c7469d084eaf036776ad2657043e09ad88c56d443712a441e4ab2a65bdf54a8491655861772eac684a3c0e18dc48f60d75618cc421892d0f2e0823545bab60fd55832124e902d12c913d18460baa492749a63c0c999d7ce8abe489635789215c909e2480e204167b91445072c6b2a8f02c13566ff816543418878d584c1e9b17193d28687d5b47eb64f3aa620ba2469c8d0d9d1041040bc8da4598202b14727b9923b9034e0913a3b882d88f7665e0ac2a428d8b2095592542690f71449930ec25fe4daefa4f5613369182892ea5d7b7c0fd6c9e7a10b4606dc90c8d1ed782b48225bc30f823c9dd4fc128b6207f99132c3d84b75102384791636147221e48d9f929e45da376236383dc7e4b0db4937437a3b8c90d4f3ac78f6dca0e4a5f11275d9e1f4bcfa27297643bbd208f4b6f81fadbf4a7a1d8f23e5a26d122c263f679624653f224214bf624dd3df2c8ecf0473bc995b95e44505831b09a6c85c098c8e9890c8ddc53289b245104d9fc937927827e48e85dc648b11a435763d4763c8f304f2a9e45f4365a72ca17533e8f4924924924e8993a92350c90fa5aa5e3ad6579d24945bc3321cc417b13e1d929e1dd97a9f9125133ec4e26f925b026d8a13bc9fce84086c2d286d494d86db28126130c5f7d2c48cb2dc12dc9375dcc0b038312b52e4f3f1dc4dbb328a049f831c9e45d87c09db717f8d1654c0c97d035e09342197b68ad8f2fa67559e9c060ea6fb6d046b27b86cb30bdc9bfe058b4fe48556d0a64431eeb7b228886f2c56a532ca84de5cf313cde88086748d268b2f0c8a964cb0391ad136791248845358210ceda3616c2758706f0c8649424a3064370bb103cb6f82dadc4a1c41e48b6a12814df92194286caf2b636de96b63df12795f640f9b466fc687d9a6dd6ba553430f726f6f81daf96721f93d859d3bcb25ba4f2ca57f00632dfa381df9629baf604beef61ade5c8d3ee38d90e049c0b551a410410410416c35d8add10b63622c4acb78d1078239179217b9f027d850b783607d90f7109caa2531304d29a39b12e65a26c605c18c09c0ec2c2368499f01b042decc9434b298b6068f0c8926b0c5b988f21a94336e98204bb927f009dff00a1496d08f2f81a154cf76393ee2dcb21c3c37f72b84f72760bd88ccc4cf33f2456df243812f047823c0f9a20ccc8488135925457442e345d103d1ea94f4fbe8c566e4de0f04cf72e3b70366e2892831a84c6e4c54c903c118cafd89641730875a2441810c74dca26362cc91499cdec57c92a122928881ddb684b8b16231db48a2b4f6265fa050dfd840ff5086b098dd83f024cb662673fa1a144cf434489cf6208d6c724b83bc6dc94ee496b73b04a5342e44ce3070e99d46c48d9b13a4c1325e91ab3289ee7b098bc0ccef2373d847b99e206a62322e644f4a4a06292192e090b731944367c31368c0e111e0596ddbc0a829a2cb5425e04b96e47e4d1e27733cc29f7169e45227c92b92166593d4d91621e97a18a56c374387b0a5850508e34ec22190f22c9326c4f450e84cc95aefa782d8c4c1fd58dd8999c891bb4605ed902a18aefe4b824c8d6ee90e26fb6e380d2e4c32419c32b710f83e5123645a91942a98120d0a47ed0ddcede09842440c86b620a2efa0be592c5393f22659139208208d2a527d130368693118427767b0e76138e4ad20cf560987a6c38d1336d577946d564b7c0c84fb96fe4499122c1bd14265792012b10c736d9ef0255bc9074be876cc9b0d2c894424a26589d0d5dd4a19f416bc8d55190c1316437261ac112f461333908e5199096c2573025c8d6c2cd8e5135a4e97c0cf4f303d32889234dc9d208d3df444688cf62d91dc8ab287a2a1cb61caf028999523f226f3b0df1f62b62671a24e1df02514c78986c65260926a1177629cd3c912233b9106ecde2044b964282374af27c0cbc111e491a6c8719d124a5489a52332f05d92484f381a125183ee280c58ac090d77086f47d85249ec5ec342d647a4490d11d854540d1f4264508db48a31ee4104fc10a48a9d849c4e934a5133fee983c23263724dcfb2772e494d8e1e424a09e49937dc43576bd88b6e48b14327c05276c4426c47c108b94266cb92339a36f756334a70223dc5e9bfd9b9b8dfd9867ba6e08b822a36424283ce088625b8a71b0ebc09e86f924705098d4e8e048c0b3ab502ec4924e8d93344e845e6c4d45e9e569b1464658eb6a18d2e2ef07d76213f07ecded910eb47ec6a6d0910c5de8cabec9bb237c8f27ffda000c03010002000300000010f51a9ba5300490482482090400014f120105816bb64afdc121848e0a4804a87f122c59ded00021a24800800904bfa124124dc11b6593ea5a099e26cec810696a8986a7ebfec04125b4412002096f4a0023accc925306b10a7349b63bc547efc15cb6ff00cba5209009bc00490082f424920d7c896c661c530ee56cd0503138d4e063c50da8724120976b64106eff002609a00b4ab78dac9b7d6057da618da1ecfcd5b004bb392d20090000010bf00045b40935e9d8d6329693d220515336348bf1868a7e981260b80248242ff5a00000008901e38aa2f7cb7c5324db29221962da1b6d5978040dc8df2692600064fed008b0b8de537465f384ad73fe95cfc8f3ecc4e29f3eb4041fc1264b6123742c924f1d440d97ff00d02ab00177fe9ad530c6fb69d97a923fa936d4499c0d4d35845af402000cd3526ba7ec63eac52434925f21caa57078b34bc0fef4c9b880a396c48e8103621629036bfb5958adac9a79fefa3a269813ec22ec666794e48410a85282a6e8e67eccbf48316606bfd8ebaed4ff00a9c85677b6c26f0a411c9bd6801d6d7654509d6800980afee58606f250258904fe6e76f25a068a12016c973191621c3a186b7ad2eb68357e1b126629b1a86de36c64bd578d7dfb0cd2893a27ae5b6da6e64dd764b28b83f83faa3fb8c67c8bd51db1fe2978fad0c72d23330443d7936da3bfcba4e763e331ff00dcaa9b8d36f82b65a7fe582fb7fd0f4842048aad91249b7b6ddfe93367e8afbf4e5522dbf4b19b36df1c88dca38df27494d35cdb266d3fe104c651fd368839cc709a56c6fd1fc959721cd18d1e8bed2904804bdbec41966db67db87cefff00bec32401b40353a24299fecbeb180e6880852dbb780e877227e9b6a3bb26d3fbcf8cdbed2a2b6cadf6aab3ff0016bd3e6e7103fbf7df7d9cbb6fb4b3f1b5d24924b4b66490269ddb1c69bb67fe132fcc31684efbfdb6e93b3ffb492ff779a492416964c921113c60149219fda6e45b500fb4afff007b6dfec46fee92d9f4d35b6496d8a99b6d256048cd817d1937743d9c8e91376db2fbfd8cda5b6593f9a4b6496d82d1492648807a11ed9a824fca270fcb25014b6cf7db51f492c92fd1896d92c30660104194efb356863d177e894edae1f3379ec96ffaebff00f6ff006fb313db64b4a801c92149b0ddcc978a0c3874d1635a0a4db6d27b3687fb6fb6d28f6d96db25b6d967534f9bfcb124d67011cd39d1b7e8535bf6b6e83fdbdbefa51ec924b64b5cb2d92c19f903abad61c2915107e68bf0ff00ff00df5931db7fb6dfec3f1bd9bfbe2965b2c11aa6582ca36950f830604d9c8c5f7dfe3663fedbedb6fc6d7690022dd6169b102124d6c4a6c65bb393da84ed77afdbf6d6b7900a6c0009a082059db2c596a6eb8a78e80025791389dd47aba309afff00e8804d9682526ff45089a6d82f35c94b92c8f3d486601ac515c140cd2013600b1e8d2e43ff00eab41457a496f971b78b6229575343f5f68aaa2ab3c12d7ea6acb46bc3e6c845d1aa30cbfb2db385fdbb7d5a5910fa309a289c416a86ceb36e833bbb42e7964bf776e1d5b24b2aa6ca4d98133092162193d84186d764f737a5229f25a74bbe576fad5e196d93cb64b00b693d4900f60268bf4b849368efbe90655007eea13447d52af5e9597fc62023aa174c86e3e4d65804988a46f25d7d0091c90bfdbf6a5deb557dc9b6ff00c1d0a95b60a1febbe7e594017b600fc8da8b659e006f1bef579083c2fc16257b970b4f9ea2bbfeb06ac97db6bc011ffebeb248cdb66e3fda7b25838a390052feb991a1f0959b366d1662bd057cd83c0c8e7fd65b6db07fbfd6402c880b240b495afed9248920d0d364d37e9ab893da42bc8df096c94f5924e4206e4e12ff00390e9364b2c90a43ee2831b29259e620a29d3c221d1eef5aa494b6924d0cdfd2d9b5124925b63fbfff007524050d026c9a0ccacb25ff00fb189a0b6d96db520b7fa5bfca2db2db3c65b09b696b75f043c110cba4dff6c3d6cb21038c00b61053db6b6410d927b6d8ac20065b64c49e014b28158bb6c907acde7309209640012013b41321b6e925b5b681964adb49446a465e2b2753f7dacdb6a400492c9643e481631fd2d0b2c9f3809b00b2ff0072c9ce84b854679f926ef3ee4901924120c565664613affccefd3e9a410e5a56c43998d939ce16ac2bc4b7d194cedfff00ff00e3036c926dc3ff00fc9a59344a10b00bd13919eaa19d0d1f7ec335a36f7dbffb7e83ff00384cddd6da6b7ed7cc973c2026b7c73d917b6a2b2feddecb84e84f7fff00ff003fb7de8df7ec17f2df4a5114f2da5d817db5f6eef0565f9b89f589e4feff0036fb23fdcd1ece9169c964e0c2441311b0dd09324a11fdeabbd2a936d64fef7fbffd76c0369012c30c96404c20491ac2cb3779d9e915fbd249a4bf9fc0bffb6d36eeff00d59312491248710402482cc4f3760919cee02ad297ed4daf7fe97def6925c1fa192d92d96d90a409259006b8f8ff006a6c0bff0036290b86dacba61b695960024360324ad24eca08051245245bd00cc2ad7e2da2f49dfde14b335e4024b6496d926f2d14134db35a4846dd41313fe373bc49c245e77edba032596db6c48c84112cb2ccf25c8d62fe92002468be0d879a321c2818c972dae32420190ceb8e9912506769a69b6fd9e640cd652461463cad5944665366806fedf32922a709293265824a434b7edfdb125206dbe1f9fbe374c20e74ccb7fa66e516cb03b2489026caec9b40d24d4b8d5c26df3ac3e8b7756a01a82c01b286cc4a63b6596cedb46594cb3db7bdf79718dce926baff00ffc4001f1100030002030101010100000000000000000111102030314021504151ffda0008010301013f10fe8f7a5c7f3f1e94a5294a52e934488420b6842109fab4a52f04ccc11f826c8842781fb6725e14841a210985c2994a5c2221adbf9962197db7927010987a4f052977b97b5f252f3421099213d3084213643d20c5ed84da694b9b8bc7399e2613c7427fd1b2f0df72c2d609668f0bcb7743570f8f9cf4b8a52f2ce1a5c41f04d213cf72f6b9a52f8a109bc26b4b85b4f5cc4c3e38427828b5a5294b8a52e14a5294a52978402f950fac367c3e612c3c2c516d084271be06244d69744cb7e0fe175a513104f69bdd90f3f4fb984209621382979e6ed0d0ca5dd4128fe6b0984c42e6f3219782eade8f96e905a2424343c7d0c345cbd7a134fb1ff8c2de97c090dfd2971385fb4a5ca8fe8d7126cec6b850ef784d6f021a1669757f80d71a635c298994bc2f0cbb2789962d5fe0b546b7594cec6b853132e9099792210998265c4c2d5fe1b43d26c9909c2989f0b2668bfa1fc2d5c6f69cd44f9dae3589c344132eb08b5b84862e17ab10c84210842108421084233e9f4fbc53128f8a00841abc400485ac3e893d21084e27c171791d153ef242c2f25f1265e27b31620cfe7858b998bdad108421084d5ecf0b2fc2c5cebf258b562c310c5e062e75e95c1381975659928d89f818bf2d72bcacbc42644bc0ff00266572bcacbc5c4caf73f4ccb13e57b3e85884cae77ccfd88689caf67d0b4985e05cafd2b4bc174a21ecc5b2e762f5ada6ef29ef309e2090f372c5b2fcb45e4622656ebe68f5a316f4be0bcd08421084213068488421098421062c312213086f135a5c3c4cc18bc5098fe9084210842108421062ec48842108421098e9a18b563c21890f3084cdd50f662d58884210842107d0910996172b177c9d0e9c4f5bccf662d58b85fd16ac2e5676171f4e33cddef0bd98b562e062dcb99db93a9d05962d5e2e16971385ecc5abec5c0d897cfc21e9a316af69a2e17b316cbadd8bbfc305d7131134be362cacaeb762d9fb4175ab1658f4be562d50badffbc0bd63b61ea87965d2132bc0c5aa175b31702efd63ef34a5294a5f5b16161e175b3fac4b83b72b3b70294a529fdfc462c210fa10bad58b87b7152946cedcafef8a97c2c5a37f05d8b562cd294a5c76294a5294bbb1727f7d8b818b545294a5c52977eda5297818b93fbf88c587862f021f2b1727f7d0c5c6c587862e762e662e4fefaa713ef562f718bf1aea894e8587deac5c17ce5ef7c0845168be702e15b3f02e45e2b8badc5827842cb427b3170ad98b37f3694be262d1ac4c936621fa5f152703161ada1345994eb562d2608420f6621fa5f04e38326213309898a2e25a5294a52fe04213c973084210987aa2ecb6be39ad2e613dcc5b31930b0a8c43cbf64ca5efa5d16b468653b1332d1f462ca18b9294a5cc26d7f22970b2c7a283eb2bbc313189e66294a5c412213f566d07a5c32898d8ed170a421084d67eab10beeac9835888a5c51f58434412fcc9e084c367f04f7a3c462e879985fb898bfb74eca3ca1ecfe63e974a23fa265fdee8ec7f04216cfa214fa464d7fb8bfb9fffc4002111000300020301010101010100000000000001111031202130404150516171ffda0008010201013f107b1ef1fa2d8c98d1594ebf8f08421084213c694a5c5294a5294a5e4f6216cfd176f0fae13f8b04884f3b0428c5cbcb2f1824328b14fdcacbebf9309e146c4c6fa2b2e2784c421099594b3f84e1af0bfc2bce8c5c4c77e8f30842109c590d8c43e3af9a1084e7395c8cf6c4c4279d28f952947829595e1945d22dfe3de0ca3636378a214a5294a5294b9652f831106b3de21fa6990ff834421392f784e709e2c831e2090c4cab984c329494589e130f92192217b2222223808427c4f0c4326104321048eb14a52f05e74bcda1317084210842109e14a5294a53a3af3b88464641025fa174362263be50ec8cefc697d1e8fd279d2f05cef29c1139cc91fee132447fe0ff00c13fe13887fe8ffd104139bc4c4266726df3421332932de5729eed88a513e3048996a8d6c84ee610842128cb8cd2909eacfc2944cb85e02d2c297109f06c626362144f8a730bd0bb2138dc346265d313be0c61a2097bb12e868842616271b7a12f858b0f3043d1ac511a5909a7962e2d51a7a0af78bfe738313df6cb8627081b2e2e5b2897e94a5133f3d5f8c4411130ed8aa84ef93465613be2c38f2b8a5c5cd261899734db1b83cad8f2bcdfc2a3c98d0bfd1717931a1d45294b86c4f0d0c65854366c4a170f851886c3cad8fd9faae29c13f2691da13be2d2781ff8412c3cb1e188835308a52e6107d75879dbe07e8b9a622f07ae2d0997c20c3ff27fce570cdb0d8f0d89d5c575979db952fac1af75e668d0bf1e2c7438c420c84223a28ca3784f0b5c1e1e761eb14b8627c052a2a2a2a2a2a2a2a2a2a2a2a2a2acd29714b8b8b058ab9814a3139e400b46b0864c762bc213085c18c79db0d1098d8fd294b84213294aca565294a5294947d14a529780a529697252e4a5c28f0cb94c5c9707acbcec32fc8d8dbd97d021e1e29048b3332b83d65e7618f29fc2d8dbd97d021ec43c4210685e2f47621e750c621bc10fdf636f542f569e68fd10f8bc2f066f0499d431a20e84a7c2d8dbd50bd4b5e6b43c1f0a3c2f229b6771b85294b87f05efd7f71b7cefc1e0f1784cb16661e5b70990718a21fc17bf5fdc6de17ddf8310c84e486537c478db3be1442d22c3f80f7eab0f7e8f5e6f4510f8bcde7a676cef83cd684e8f9d2f81efd51f83dfa69e487a20862e172b8f428f43c6d9df07c341fc07ebb63f7d34e5d70439327bf46412cca76676e5d07f6b6c7ef084c421308275c81111614283834219785cd2e10f2c443a32a6363a3c5f0d07c3bc4210842323c89c8111111111111111d1d7e1d94be460a37652e294a52e5ec783e0f0cb94b0cb87ac21ef09f42e46e8e8a8a8a8a88294a52959594a685e14a5294a5e07a194a5294a5294a2d9b97c50f6310f8bc358a2cc1a34c2d8f7e3ad1b14a52f014a5297c4be2d07e7b7948595e30984420d1a0c5b36e1df8ad1b70b8b943f9069e9b79085c1f9ae55b1ef877e2b46de2f92f734f4dcdb821f0421e5e161fa58b63df06fc568dfc10f92f735f4dcdb821f042f8267f0316c7be0df96dcd0fe675f53df8a10fdd67f185b43df0efcb6e687f31af9ac1efc50b85c4e53c7b8f837e5b7d846be958bdf19c570a52e58864f1ee3e0df8b1ef9bf07ea46be948d49d90842725f1bc6c7ef84b787eef5ea8d318421084210995a1f92f39e0c66c7ef06dc16fe1d068842108421084208d3d4b5e6b9cf88d4db82d8c799984210842130f58842792d7aff003ee7c9a1b705b3f484213d1ebd96bd7f9f45cc1e10d0b8686c31616c789ecf5e17921fa3d7cef8bcef8e86d858d87f069ecbc0b8fe7ccf9316289512675c9636f874f643f37b1fc4bc98b161676683eb1a716c3f09e1a7b21fa3e1392f04cffa2e54a52898f0ba744aae341f0d87962fa8864f2fd1f384c2f1bd0989e5328cbd97262c30bfa683e1b0fe12f543ccf17e53c10f098c5c51e2705ac2d13aa1a1f13cae14bcd7b9687ce7043e1084270be0f0b0910488420c585ac34742d1386c3e14a5f1469edf9e1084273a52f9c21082cc2130f286cd8d0c3435c4f1084210989f22f5ca70a5297e09884c4208a52e5f0313c213fc1ae06317cca5e1084cd294a5fad8b8d1e5363362421a3f01058bf75c21084272a5fbe94a363e4c798c68d8dbeb106f0d8d62c5cef08421334a52e2f09fc99964265bdd677f4b0c7820fb42c5c7677898426294a5fe7c213cae35b3afc18d8f304fa1086262a232eceffaef2b8c1f4511b107121f589d6133f04868518bfdb7caf2b8a351d1e3f099d14aff00937e778825884c3189cc3e7083fef5e34599c5e17263ed1314bc5ff4ff00ffc400281001000202010303040301010000000000010011213141516171108191a1b1c1f020d1e1f130ffda0008010100013f100b644b7ab4fa04bc4057b26ecedf6ed9955580da8052adf39ecb1b52b67051f9e9e7c085f294f29487d581756204dbbb785739a8fc1230c556fbb1c3c7794214208d79cbe671ba5397ba8cb5dbe22bb36136edd3f6e5e5e4078eeab0e23658ad402f3474bbaf938971122099bdfe5cc434d154050ef579f7832ee544fe172e5cc7a5c3d03d6bd2e30b2e5cb8ff00e372e5c618bf52e5cc81763d140b60058ff0241ac4405a9ba9c6856fab105d060948b5554773372a7483581d7b401fea5d86d96b36cc5765f48aaca5f48b6ed8d43508b921456aef298a228b6242aef98b4de65aa160c829b6143cfd9509855ebdeb982041952d390f6e3a85c5cea91bd7276cf995b4888d535a72d6df6e23a62a0b15779f6afb4c75582967436aebc11b9ab05c075afc7a5dea156d2f9e1aef16d3b20b0ee987e0805e0b7803d98fac002844c245cd7331ad5e0f2b582180e5eb2e5ffe17e812bf8a545972e2cb972ff8dcb972e2cb972e5fa5c502d9921ba8825c53e80812986595ca3cfc8784c768a950ca2e88c12f5599a47996ef27ac69d0409784a5758e00620646dcc2401f6201fe08ace0c40179cea840150679889b60bd60b71778b9aa81e4a9ae504b237bf8527782bb0f7890c22ececd7e25477eb174701de6dff2128816a1caae809b6fa4bd69702c5ab91e02df68b879a63b97f7f0fa300a5614eaadfee9e919cc5a0764d9ee66248a205aefba79bab71ef0a0ef6a47c89c4c4a95ff008108e2525cbf4632a544944a952bf8acb97fcc5c800a845d44a764cbdfacb243a173a848001aa399698614d37710d68a9b42c3554676f5c543ac54dfa2deb3b10a138dc12c4855b444800000970d80de6286af3299d3c1169827d8fcc6b9db587f71187306b71b4bc4c997d04ad0dd97f9cc04f6197e565739a069a0b5feb66e0e699549b2be6ebfb809b2e29a3eff005ef0aaeaef1576b0bd0184c63da159296b9756dc4bd0d378c2e9e3f7ac751ae5da3147025e7a42d40aaeee75130295ab5e4bc1c77f84814254a0c3b01fbf6f457fe58f4b977eb7e86165cbff00c58ff1b8b0169659d677ba2dbf043246eb65afded2c96447351eea02c1acd4b08151623da5e5a86171b11432fd655596b8ccad47e20b0caf0a473a25d696a1d54a1ba2356315c5474443a54c6181ec80aef306ccc5f68b5ef2cdc211514ab2e429b3cbb4cbeb7c04d9b17cb78aff001dd7dc81cb1dab18c54a23788cb6aadde6fa4ca8a8ae82b8c60cbe0981b9288a7236632cc73dfadfd2125057c8f1225300e4bdafa2f9f78676558cb7a6462e8ae0911b1a0f6e25b172cacbeb59be90c850d10ea972e5ff00e57e81e972fd4b972e5cb972e5cb9718c479da8fec4c665481f599ba7816ae2d10354b595d8ddc6a1a855c55cad42af9433cce83acf28f54dc3ef3a5b9b5ac416f603490116ddf24bf03ef042d19996609455ad105341d600d1994b504cc096c6b52e358c418abb8a5c3c8f3171c841ceb302324b2c18822295ef0a28026786def2c003ef41161c22db78348401dfde53226c82d584e9fd1a856a4b68035f58644f51e79f97e76c2aa6e60586d0f70850254a06aa50431cc76fb55e13fb895011e44a09a27bee6524aaa67a8fb46307f85cc32a54a952a57adcbff00c6a54a944a80ba080882c1acca726597b44ad785b32ede67483e605132c4438733c6fbc41af706526edf12dd5f11566cf3116d52197630d837e63e2ab50519098bd9f69d79a7f50b888e7fd940c011438373a8e58ba3a8c4b772da946fa4576d444bc63e608216e98ade56372f00cbbd32f3b8fa834063264fac33fab6eabbf39fb778a0e4c0cbf1f3f595e49b3575bd1def9f31722b65ca52b51b4a3294bd9086b302bd5dcbf4a61969948c54cff0b97e8bf45cb972ff00885cb972e5c58242ac1c2635793cea291c99647d33348f76297b843882e1cf49798df9877a888ca7cc49af98e5825e1965aad7782b51781e21caac79a05b7290af75e81ddc1b620cc239dcbc41e90ce57053b8a085ca3ac5caaef371dc69d235a351db91844a2e00d73f495a5c0342ef8f3f49a3563d1e4f7dfb4ce8e2136f1ae98fa4208c42a2a8261966212196e36d334c182f12d1115a71dfe90b8f0a2cf9867f916fd88bd90f2225a43dcff30663be0c16c3808a17ba82d83e693e9a1176be4f54979d4a01946a6595fafa5c402b8089219d97110354b3d2a5462519e55f2101a030cec29f8656db5b4300a04a7272c7299c01eec6db281cc4580622e1f80805771b21d4764cb8b8ab83de5bc081587bc4e96f68ad84f68e848e102a87171630dd451e3ab3a68388c0fa63a7ad749bdc43afc46ee5a88e441429958b9e250c66574fac0c66f74d830395b578ce6a5279bd997d6b1de60b929418acedeaac6e8819b48b96a50d8031696ea082089623632d96c3accb4bc20ef94602582680b63780587e654f7266085043602be89b75e4b9b0f3566e01e148f31ee3f78e60fdcfea51a61dedf997eafc8fcb04aa8f17e256ba0f3fbc48e5ea90b630174d975c193ed05e850658b992fd72c1fdc425dbb3c40d65abb304dfc06617c0b42191f20fe225d9e4c08602b6263da5fa6bd185e9021b2e836abcf797f54eec77c5f02c067dd4a9fb6068bd88d5043a331dae7c44051570ce53328e2a6c73550e06a35792fcca6de3886d2d415b98fb6a2b505ccd6134dccb98ad1e86772858620f6957035125f9a8af9818e911d912f399d996312c6d3e21820eb00dac012cc9b478c57ceb32a0088af1962dd4a3a62868f980802aa41d4ccb8000a0057498812a211a23abe710c02beb3df3ce367a4b879f7c010e260d26c70cb1060208971a274711021560a6dd778ec517896d66ae134f942345d716dcb00b6d7f78b8bca8fd625283d563566e676b4bc05137cc9d614eb2efeb06408b8025f54e979172a3d1c10452a3a011428394a7d63425325147d23bc1fdf10c96bb60445fa84fee1cc8f9a953efc21bc9edf833faf7f6c0793dbfbcafe0288d8f8ff33a188d83f5fec5821b193a21ec7f12ce47b1fcce4fa28a38f831d63f3fee09ccf2bfb8fe765f89ff002617a57a0fc896a8ca3d2fe25503d62cb70b58bac51b88a2b31519869db8989d471da6d6bbf12abad6c1d6721aef002904a5a58d1d67bc397a157c08f4d5798ce082d3426eae53a496d78a88957ee6fc26982d085e32267da508d5d1d3ec7d2516a302dbbabdb5d8cd51185ddd5d45ed7842e0f88908d1562bf9e9cfd25c76900b65a4c6f31a0732de3fd8374891482e38bf1011b8aae56b03c326626d54c5732a228800f98ed2ae957d7d18ac3884f213e38013083ae702fd8894b4df0021b982d4c99d5ff93b6ad8888e87d600a53e639822cb1ad5cb80c72622831610303b7b0fd6221e2324cd06ea00dadc0720f6a809d50cbb1ffb154365bbd3ce35f370acecd23bf1d0fbca191b05be9102d15ab0af994644d26d0016d51d62360f87d2e6ac211b1f339aa7423980bd9885992c4e487bc41c432cef9c4c4a7423d07c4ff8d0ff003a3d33da057cbba996f3d8ac7da672bd276fea596afdf98c28bcc7a1ef0001a12c25aea20590be259bb7c430d46bb22f414f760d0f0eb2e85d62598f0405de45c90a07e896277eb03ce4e25a196d6c0add8f2c38e92c64b08b2ec0fbc28aa14cac2be51f93ec50f8a56b78d76a8f2205a675d7da1d0ad740a71a600280f0fc372f0352f26e895c1da102d970fbfd2562015183462abdbeb15e5e061c74afafdaea17416bd6636afe6a96c5a600562674529ebfbd219080b3456f9800556355f788a4cebfe10e05518a6fde52aaa8c1a6a0f94c3ec8e5207bc1862753faa98cabd8afef1914539d4b4f32e701b9c460f59a1e3325f6b23b3ac26c2d87eb1110ebed110e9144e9e63d68b976befc7b54b54049c37bbfa30fb82da38ea78bfbc202470de7ace97c0ff71c6de3053fdc7ab820bbf998c7c685bff6155f4ca9d7922416af04e4e8ed2dce6706fbcaba02d711b33b83d62f12e359e3a4ab68e870cc793eaa1bdc4cb13a474a020acc44a21ff4ed1955bee67d9e65da8362649d988ea1d56f895a30fcca68b21b1f741b28758ab59375ff0025b60b5442c083c01efcc05e95da598f04be04ba018606e564dd6214a797ac0402acba66ff00104170580ee5c8e44b9d3cfe34ee0cabe3d9d7e21b2cbd78839375d0ded84a60a68d29078b53b88ec978a881f31a8941d9d6634888c9dba4a19380390f7c4c87eaac77acc5b886c558dafe654a94732e115bdfbc26b55c273132f243d6e5ca1de1acee2c62a9851b5f4990269cc67664e48a720d86ff00c440dd541c314c0960ada747d231574d6dbdc950865c930401aeb140c772966887e17822719aaa5cdc42aa818792558e1d26985de27637d658bab8ec5abede87a97b9ee8ae49b176f925aa8e7af48596deb021097e8ab7a9c683071ee43dc2ed1f212d7cc2c8723da1d471f48f8b3c4cf54af8236ee2771949cbd2159c0dbaf69602c258c56e6b4e904f11703678254d4b550bed18635618a05b51bd41b82ec91f7a1742d90651a1d2c42fb8972c1dbac659db9ba97b5873c40091a590f3145b0baff673c0032b2b25e82b0ad7c4bd0aa87cb156d7da559957cb702ca22cc87b8d90823d9f32acf0ce65f58e146a3497797d171662534c68474c45bdbaf47b0d3b2176e8e6af52dabfa4fea2cc97f6e932633e11c0ef2af5f797e1abb23f307fec4fccd847ca1d5a93affaed0ad515dafe2088d5774d407c8b6817e619301d537f5842e5cfa92ab512563d39f43d2c0b6104a74eb32606e4e621931c26bd097e83d3294437c6fa9b805cec3bf241c6fe398625f3337996226688e1ac455689b53788d4c1898176c5b2377bbef0140e7cc4b097589538cbf68d1ac35073076b992d039a20229d57d63b841601a6ddd861bcd7494debda52eab4d0e5e22f0c725d4b60296d77ff006552116b75671ade9ce77090a5a69e92b8825d196e14bd0a7bb17c6fcfae8f3152add433a666d76dc0a9cc0ba753718bec25dcbc4588a977cdca8e07585f32f32e32b32724569118865224a804a22658ba251e333b12c51c9d23edf94964817e18c86938f4bf5236685b28cbfa096bd9549b7b1f68e28e0a624b73ca948d253cdfa062109b417e6812d53014029d8963e48bb95e5b78e92802bbc08ab3334d59a7c33167ef0f9250744a3c4b71c3a22b6256799d956f3d20428cfb46d46cb73a8952a2d147a1044b479442ab5b510bbb0853aa55160105b8ef0a800777a37cf68d0686342f094098bb696bb7ef68014b1766950618984c4d31be1303ac5f8a2e5c7f24d9e2622f922d396d8e837a1dc8166dc4449660f7984bce65c51d6e64837064366485d725c475a4b78d724108a952a36dfad5c63796eb2bd00bb74f270ca0343e48be4be0254058959710117fe92e8a147de3382f09f01af4146c6981a8cf10d99dc210f51e5e673182fe917f7846197da81b7a7f71d441d2310861adca45bade2363b979ccb2f1109029b1cee5af5647972d44165601d150af21285c2f8941c4cb16a50e6cdd9c46d9aa520aa8eac9ba3095e7c329b6594f5bc18edd21a28d5461c0d12055f53e52a7d9fb3d7eb89b5f1f680a6f51dcabb5230526dbbe18c15799844854cb0724a958aa8944dc14d9b7c4aba28ebd60cd33b2c1c4b4ec8005b1972e32e5cbfe15e80a6c4d27130d053cf0f99b4228685f4433bc9e9d236ee5759a9abdfed3eb9fe1945ed0e3ef914a921b9b31cbe8cf1e8855ff00c954ed0607f7035c0f21e48b56c93a474b20130c03705ab18168b8c4b9ccc9acc209cf332d23b0b5035877d673b7d439235149e1746ea181618ae90a0505b42c0c6e266e81bae92d814b5aefefb8da9834268598bbf6215a1569ebf99700511a0ddb7f7860efcf7f4fd9e0972e2f925c343553bfe31156bc7110e5068750b7753549fb91957703518cf5b104a9eaf88dff00845ecfc45ecfc4b143292cb8c105919e712de0f89d93e276c8b61e44b53e60bd6ceb2cbabcc507752ceb0a6d9b881965715994eb2c73729cf31049f403d3c47149d03ef1707bf5951952c0f9fb4dabe844832858251eff0024a8b2c78e673f4e2247d7266ea3d8ad3d4fcccbb2f81f244abb2191811ab3b4516ab3965e318f3320b9b96a5541ac31e0f622c8c1d26071730640f10ab921812f1f485343c70c45269e8d3002343d68bef702ee9c3a34e20d4b6c4b3b78e6e239b02e712a33c12ef64b972fe4fb1165c7f34bda769776ba78b99a2d058b08e33321c235624b0ca2709b9567c987fcbfee7fc2fed29c7e8779e585fabe101bdfc201dfbd025442ee7aafcb3f6b96f1f3c4787e1cc9697aad33aff0b2d4041e8a40f58794edbe73b3f9c40535c4dbc20e1a959bab784ee7c129e1f19b732fa401e47b204653ee4e03be809ed84b571162ecba2bef307b5e80fe65747d1e8b246476f40b817d58ee23f4287fda9fb54a1b25ce59973958e14fd4a7407c33c12cfee9ff006e7fcb4ff8a95fe742bfd6960505b4d8c5141737b3e638692fba20f4816aed337c4cf35e8cc621aa79371653a60c7a74951556f0151b2c71a83a727e08280a8142eff75becc38f6038d11ab3520d355c5fb12aad1b37e8cbf93ec4b971613a7bc91342815aeb140e830b77bb8d6d9670af04bed89f04255bff003320405c68eeef36cd62a77df33bef99d97e67fa49fa19d203198759d4dd2ef10284d9a88956f885af0b9a71debed1a4f574834b67a45863a0b3ad118a23857bc6db7183a45179625faa7417ccefbe67ee657cbe618ad96b719269de658a869dc2e46e6b7a860345a2154c5859f2660fac789da4c5a4ab8fad61d1ce9995405a5f31ea21a02adbcb3b984f942717ebfec1edf987627ec09dbf813b67c13b07c132e9f487c6c2095502f04c0ad436ac4f6947728ac188a830d5cb29cc5db1cebe61565cbf0961c39e202a18c19af79402162cda763c3cc5942ab900626344d3146eacf9c8304a182efae4fefd5fa87d9fc2cb3a64ccb57639c446e451edd6168718e53845018f33049dfe27097c597ebccc00d0cabea8894d61f40a3ac22aee1405d2b7312c0e928a562d7f100aadaae2ac180be2702f772f08edf57d6af3d2004750b802d011c290014b0e3cca09dc0c7b4341d0fe0f1fc0f541f020e23195ebcfa90da78626766ddcb50b63ed3a1ff251d3de556f332844da5c04c9d65da8c3f12cc1a053de179671bed2d5ef35b9861cb179a51e1752ecc2d015bfb6e2125ddaa851e3b4d0046577948463f5cfb3d7ed3f6836798ad0016528957557b4a562aa8ef0105eff005d22f8c9b2311dcaaf4e268f33ea182ab372ca1ab87e60e255e35e8efd058781a86deef5e7d2bf8ee6200cee2e6177e5f8f43d38f463fc0f5e5f11d88ffe3b7826532452a75150e76cb22ae59d03677ff260b78180ddf88c70306ca9804c20769946d050ef378659a232af64ca8c95d19ae4c8ae399616d792c07d1cf85f621e9bbe5f68b4620e4c358e9c406a0a167b63ef315d2f10c7b7367d1f53716df53d0f5544183cccedd57eff00cebd0063cdbd28bbac98bf4d710d1eb5e8ff00e1d655523eaff2742bd22f97998140cca80948155d084080638eb70585bb8581d37070d733a03197889e752a9ade6552bc8e23cddcc606fbea61364ee08b464c89c7eff50b7bb5de943c7581722e645924fdde0f5ddf2fb45f91a8a1506e1d96971a977d61534cb9d2643339c631fe0c79f43f8361c23c1de7df7eff00f8adefd52c37a8e9f41714fe118a952a54a95e81a624af4a952a3e9c4a64e080266556c67bc4615fd60b77473342c73b3113b7d7fc815b61381d8404523b875384e21b0d8d2e064dbbe1800e81cddd92cb738ed15a77d11141357c406ed30418371583bda150b1c29e2649cda54a9bbe5f6880c6fb8cc107c31bad1ed101932984817ce73f58e705a35ed39d4fca2b2dfa42d63ebcfb4e90f462d1063bcac3d59a7f854afe7c4d939868972e2cb9e8f09d420b2df329732bd6569295982591e847a12bf83e98ac68cd79a848ddf58af04d2ded025680f1704c8e1e21a4b2bccd8301de7639e90d9e1d235dab586655ac716633a8b3ce2eec98c0e37370183557f372f0cc1720199920b3aa3f58adf8007c90254faafdfd3139787ed0a2a55bb99201ea106b2d39a7f508c07502e812f48458b2c846ee21d662355ed0ac4bcfa730e21a3cfaf316c1c7a385e8cfa4f4b9898988d4c4c7adc26cf1e868f47d1fe57065d1ef2fcb73006a75020798b77166ebe265a4f99c4f83295b7c4138477971713662abaee1f008da4d5e162acc096d87f7a4be9988ab83cf5960323712a91bb9761dbaa965c3ae84bebcbab5fbc4b62abbaaf78149859ef011c8d1afd2556d236281bf896120876bb61281d87ddfea12a2fdce63e83bf0c3f2332ad2406833587c914caa87a84623e6287cc47d6a52fde071e6a05af352b8f352b8f35294f68e5d9f47e338bda63f35396351b38e332b0ed359bc032fff001d3d0d1eac58cb97e9c7a11d7a645cbf4b972e5cb1cc16ca932625ddcb9618e90630630dd622825e39b2647703a30a7338813957c77f89716a44e44523b7659130272105e718bfac48544bab31cc40a09e5e7f6e283475230b9c8c98028827d4cb48883cbbfda9a9d5b01c419fa1ea8be9c7845f2ca17d150b586a35bae5fc61ca6cf89467e65cfbdcbbe6e7dcb9f72e533df31289d652efa9317da18425d1a276a763708c3a3f680e2e253a4a4c2e04a952a57f1747f0631f47f884747a1a4fe4c08b45109416fa441617ef00971da3aaabb7b625146dde162ebb440ab666d1a98160e4eee50b96c6a867a9e3f6a60920b294b5e23ab04b0e080a356c8da7329512b406b2de3ed177000a0eb43f985721e0c6205005317c400598a8ce83ed038f4c5fdd97d4d784fa87f824fd0ecc0abcc47e939632f8812a54a95122666c7466ab15c23cbca68f1ea988e2a5e65cb972ff008dcfa3e8c627a27f023d3d0c4711fe1ccd12f398ded9508c684a942cb14dc5654e65c630bcc095f764805cb00a021ebace988855e072b88dc384c83b84b000c6ca68762a7e251803433bae3ed0682b8d812f547bf2c04523b46f5ed8fde4d21466e0e14d6e6388381be19a4b8e82655c979972e2b3c7f24cfcfebcce27e8798e9f997185af13012ff92b038dc70a76834f841b9b2f74347a5fa31ddff21f47886fd58c653d197697c444d9502fa7cca7a9f32bb904398b38114eb31cc72ee51d65799db0ef3e3d22f0f2b81b6c381851dde351aa28d6e58cbe6166382ee2c0ae678170144abf198436c738d4505e1e48a1ac856eb3105a28757efb4eba8358af989b1a6ec6425bb95669779e62b7c2398974abea2ff6a21dc77c73d38e664b914c570c4906d9776b2dc307f4bfeccda5f51303c3f27a1a9a8ee3a9a7de1147ac7067b4aa90054d3980af795eb3b84a75277a26b0dcc2dd98128561c409c30c7665b81ac0cfdae7ed73f4b9fb5ccbfd473d4b7482e84b3a132ff12badf12ba3e915cf640060b708a6ea7ee6787ef11e47ccea41e8278fe22ffc225ce27c93b2b3492f8888b0adc4342767c1289a04e912d545793d377d1ea25bca5885de233bb8d40a5ef445ac4aaebb252d87ba2ec3a1de6ddfb436035347188c1ca21b0cb561d652594e8f316ab62d5a201a8ab31c3d7e9112c158b6f15302ad806f5fbfdcac181d8f4ae97ef2e27504a527de36160e2b6f7860000aeb7fecb16170cdf681030f31d97d67117ab7d623f0e103abd263e48463b8c68f925d1d655a99e712ee3e90e97d60fafbcb783e6773e5067f6c2bb1f7940c87a4003172d4af93ed1e483d5676d661da2a1c0d8f55e9ba51968cb1c6740ce89073827788f5630648382b373143a451da7713c9f32af97e653bca4ac54ae8471007d028799f62319a8970254a209cc37e47de18616bf4800ccd5d748133a66399a58e9368de27579e60966c1a162bb9f102f6cf4836632b5730b0a2f71e946fb66e625daf033a89a23a76ce7acb7b6d60b4f8dcc453ed3d1efcc7616010140952ba5005a9c2ba7b4a000a19b117fc8b21155baed502061e6665952a0af1fe48b2c21c26f32a2bf7a5695118eedd1d989ea8eecb5de57a615caf99e4c05db1dd708144c748042a2fdbbcc1299508a9528ca892bd0ca993ed1878e0972e1eb5eaea5a5c58799b2711f435eb58952c332f39182cd515a84c8b135b958881ea86505d01c525436bbe5ad8143474329343b8ceb11bc6a5f9581757f4252af583a58d671c7c46da70e9963e4bbdd4b2992744a64b7545dc59406963238cdf1ff7ac1d9c8b8797dc85724591c7831e3e668552037b75bef087e69f4e7abb7b4d1f46062ed67d3b367a5cdc3d5f4d2e5e65b5173060c55fbf31e2520c3d187a31dc511f479feb8f449e83d35eac586a2cca0f285cda5430fa7319c7a7eae647de0d12a2b33b855ddc344ad452f117720340e88d362fadd73889569a888560667e0eec2b9bf9946c701dbfe20d940b0ddba44a97932c746e2f9658b01464bfc4b102a8b259fbf782390517bec3ae3a9114ea87c7a1fcd0d1f647d17d19a32e3a9a4c27e9789fb3c435186a12fd76e2601e8e23e843d20843d3bdc3d45c71e970e4ed3ec22e610f45f458c6f88108103f24b9cfa5fa31cfa6f3eebed168acc0f398a5158985739d4608a67bc69c96f588c20381561e31fb7199a8397d90b1902cd9acfde0360afb201516ea819d07be8b802e51763afafb40d58a3a60e5facc00ba5ab8570f898816b6873cf88823174a69cf350143a4b54f70e21a46bb1ae20c548f79f46465c7f29f666cf46351d6134fd519550254a8c3ccdb7e951f4b9b3f7acab94c25cb8ea07a547515fa336f6cdb31cc2a1e95e8fa04ac43d344cfcd398fa9af47d7a3c4b9d1b6006daa82b40dbd200db5bc5c0654b06db0c686451453c7694ac27e2351951e92c6ce168aeb017aa1d0d9506e9696db77dea2028143064d4d98046b4c7ce7fc974453374d3ab3fc8001616d87b3ebde54809a1c8ea59c7bbab5d78ebfb71b930e7ef06e5e17b4fa08c67da7d99b21348b5e908f03b26d811dc61e8ce668afe2ca983bfddc3d1843d0f563da319b7b7f33ef4a8e1c4b7aac622197ae8f1065e7f824dabd2a57ac640595d6600e055c510cdd15e313cd4b0f5f10165119eadcc682ab4f31b6d678a62f05abaad57fdf32d4c3863b91100ab74071f88195d50ed536178b5795aeb2d94ad864af4464b510adda7684242a25daf6f11453a81419d071fbf78b93a76572cd4727bbed150f12e2ccbf5e19b611d45b6e130f023f5bd1dc61af461b6397d5f459ccbcbcc1c620b59dcbcc2a5938f45dea6632e319f87f33479f4c7a9b99998a063d2b33edce5952b329127247d18f3363da25dd34b282d980767b4b4c65d562bcb2dd188c982b3c4c90727e25fac390baedfb88507034187be88dc0216a318845cf260bfdf114b01545be58f6885b07cd9f0bf88334699607f188ec761d7d8e931c905ed76901c685ddc5a2cf0d6d891c7ed619ae2c58bf6ecfa1715286fd71facfa31f45788a7c8fadc631f471ef812bd42563d144496f1352f3e8393bcd1e671097f4b97e8e59c4664cdaf6839976c25c4102210c617ab127d092ce2df925dd93dccae03d89fd8b107910c6ae641c37977ed150db1ae6a654672abfa8f4581541cfcc6188b4a835ef559f99bd301835468d451c2b5f4ade0e071c439a0daae85d6fbc2a56003bd2234a88b178c07edc0c80b6d8d805af9a66fcfb7594c00389adbe83f73861c624a98c70f6fa2c07aeaf1133f2ca891256227a064f8952a54495895026af30d1e890ef09ef0f5d253d5bff005a269ee970aa84bf4b973a153246404b2fd09d9e8f38cb7e63dd15bc880b865fc7a2d67ad12bda33824f32e32af102e03f513697e27e085ad189836780feee22b74eab3fc82adf4a50de383f73376dbb5eb144c0cda9a759fb7ccb300d74d31c0a6a9b6f5cf97e6205b1422280795f73ebb82c16c3073bfa45d12d9a2cbe2c895052dea7abe2e0af0a20aeb7a8409b02afdd81886bf730cd31f4c1272f684e5ebf663b7cfa73187a30b43f831d43d347b7a5ff000619825c44431b9789823b7157ce52120eb111ef8ce53396667a32ed7d510bb0a3090ea83acc3a30e9a00d04708fb7aa4d947eea251a48a82e2d987528e2bc92cee31594684c7eff00c841bbfa2fa362c4556ad538cc68c076d62efcc5d7aaec8d6ce9d05e2f8ebf12bca54632f860de94a52e152ee1ba79ce66ca1565da12a4c07c37de15632cda97f562545168d788c631f3fed3111dfa6ef2fe3d0311e52e1b9be0e7d2f3e84d826d5fc2e2c597285c59252526fe907a7ba379e73cfd2c2ac393aacd1ecccccccca994074832bd202221d26c461eb72e64897065c599e97bcb2af7dc899693e22872bf1cfcc4029cba2ca25d229585f76a53e5a6e98bb19b6f347c4b12c3f24a2f43f32878566e6355658ac46aec0a9cd1501e2874e9f8dcb68145d72942e5d6399d5c256ae1a88ed6aaff00caf89ad1005f5c12da98ee4c08fa6df2fe3d3618d4d8f336c25c5ccb8b894b295b94e93c3d4658b456aaa3aaff00752d9696f40e772fbffe1f79f78afd257f0117d25bab065c263e6f4a952bf862a7a2e20515d5ba85cafc6406e85758f198ed1b0c7b10c16bef05b6d074d4acf5815ca5db9580285c066cb7e6d8aa50615b869c864eb2c11668388cd32fdbeb29391cefacb50a46ec7301329605c410a6cc9d619aa140aaeb8841d125c2f1f7206224b8b2f2fe3d1e4f4b9990773d00e79be8b758295d713ea44a61705e9ac4098e92ce92fb4d7891fe17e97e972e5fa7dcfde6af55ff001b70dc21a9f55f9840f4baf4a951c07ac63a82c5f57ef11d37da0add0a81b12fda0a64cc09779e93112d0cca06bde2b7704a5264a9765b7de191cbacbe3dae167352fb2a232fdd579f781b2c00c231be3a4692970900fb1753fb8450e5fb106fd0e26cf2fe3d237e924fa17a0e7da2ee0fde7f72c55a86dbde3086e11d4e1e959819fe2d52a54a952c6254a818f4fb9fbc57e01fcba479dcb84020dc2faa0cb84e7f81b5d655134612965c4752f564d8057c665ac2a9da078bf334e1ef2d7bf66698fb44b5263ab2c2393739263410881c1a3bbf3cc5b342e6d975bd7eee3989951772da3550e12242ea13de1d9097b9900a6a09859d2db82b5043a2d327661b8c164c2bfbb9a669ea7d0bd26fe2561f10e63a66172da2a58c26d08cdfa54d7a148928a8928952a54a952a54a8287b1327edf689fc5a4dbd2e5fa0be43060cb8421eaac8dd1d058bb2a588aaf18fa442d06fa4be0a63a10b96b87eea3855d3f7ac16b57ed16e2dd50fde2582803bc0ae20c95cebfd85c0166c470633f7f88962c8cda75344b420a0a39336f8fd2018b5ead7c7fbe658290b718a804850d58e1a83a0832055e189718581d5e73fbd222aca56e88c550172f585a45fea34249ae9f3f3f11fcb9227a63fb7334435367a677758b7f32964ac7b4aaf89bed199759c1a839837026de8ff0007d1dcb972e5cb978972ff008332f13ed33fd388912543d2104244f517bbea091972e5cb8e8b166f6819318089bc5d4c472968aebc662740ef9968d1017cfc4b941eb10d2e3758f1150283da6417593115a5587a47c172392e228c9ba82610780330cd561c445e82b196243cd0a7cca00154bf18fc91d9438738fa4555d6922ac9465a6c85e58e5d1e91d84a4951d7ebcb3e8a5e23c467d54d7dd2b188983c4fea5e7f40f52b3e8eff0083e958fa2d6e5cb972e5cb972e2e27d3a7d74c46d144ccd21af512fd184623e63e85182275605972e67f64b9789e0e2174c31cb369cce4cba302a69d398d33e8cc0f72acaf7fb986403225e2ea34577998a10bd082521a029cc2bcacb445e1c92b1bc4c876f03cc02d13067170ad39c0072feb2de21f8533250d9c63f78a998778eeeb27ac10f0190ebd496375467b9d620f69f6df76698ea6917d27de4fca0c5de2e53b8e6252d12de8a8153682c11f462be9a78cda5c7d5f4bf4bf4bf4d1e23f9e158160dca30543519c497f13b32fcb1d1347a5ca7d39f42e1461277cb8e04156ebcd402c61dd7ef2bb4c9adcc611f588735f132ae28b64be252e37a828014973738e9c4691a37f985ad298bcf1080d3551d2f5d214236075771b695506a686c4fdf11976ddb6c019f9ed1150e8c57574c035e1b8582b08edf687c0bb3a330f21f77d3689a467dc7da3faf12be63f74c97da59cb2e5fa1362542f11f463e99fb66f19c7a67f9d4704313ea5e96c4203bf413172e989e59d1be6206922fa62cdcaf41db17d234329528e4831a735a9c44eb88a8d96ca5b10e853bc143225b400596dbec65fdbe6541143534b37c4a2829e201b347a4a18fab6c4814b45798188a95862004a0df2c43a9e7316d5aac5c58bb96f5149d6b4c410ea6d82b4c97310ead7ccb8a64dca134bd4465ae9d1e9d7fb95406e84367c4135fe1bde229075711d0f10fe00cda0477e95299495369189e95e8faf39f5b8fa2bf2bf8b59700016a256f71e425fb7cc0a48084305763cc5d4d5f685ebb5d083c2ed81c235e3b2ca58177502be2d89e948771f48ded8e0b6feb1da431d3f3136c41c8a9680f933f78f66ef189542f7bb99297b4396d15d66fd20619718997b303078235a3c453a0beb3752c98481b01f58aa0b1cd903415d45ddd56896ba946b20816931d49b71be822000f2fde64544b06d34236d857448aa5a97c8ad91913617555912e1c319a3c31417ed090eaaf78edcaf30094949552e0e60faa946332e72799bfa1497897e8c7f873e9bc41b8b93de5fa1b833e68836d4af62fcc4de91c317e04505a3f32d550b669b9466940d112cbb0f6fed0db4d768bb2474013357b0c952dba24295ec58201a9759ca1f23f765c2845d9612a9ab96d946e32ed1ef168fa47c4c3bcc9d13cea34990639a8b3e22f41bcee60b9bd33dce2534d7ca2d4b4bc4b160c418ab161aaeb10bc078b991bc0d0d468074e16e238e2a7b20f0e6a529422fc4d5b7b5c0c703adc016341a850457408564751fa3fdc050d6048b4c48727b47f421f8941cddc2e060a2a03acaf595f4e52ea674f5ad2f113be48abc114bdcb972f303455dbdfd28abb9cc772fd35ba8838b88eb3bd703516ac20b401eef305d52f39a20f6c471550aa9ba6411252987603812ac7d553633ece6bf686352ee5ca0ea668204ab809bab80f053d600d031da0add4b14e23a5fcc0e1691b2af158b3c40778712ad5075521362e38983ba5f102c2afcd621962ef7889560ef98e6a29782aa5064b1a39a9765a32c45a5a5748acaeb599da3df32f00e89d20568baf5c0102174596bf3116c1787896afe5d20d055d62f3a4e0d9e71194b19aa1d44a56a9c91292eddf67ee220159ac64de6306e0bafdfdcc2962f6ba31c28ac2773a7f51b9954dfe5165e4fbcbadd25bbc4c4b9798d759497063f45cb65cdde89f79a9da31f4e21110bd347a2839201c5be096a8f731360e2b6df685ab9aea2e13637651867a4d05eb89484af4053c5c06393fa6e54628990cd350a08826802a572e4ba3777ac08409d981ac87b901d06788054f094264986c8a1c5c0e853c4446d1621b069ef07816776a042acc57a703d1997de55167f71c20b8df1055c94ee451b317f0c4d5ab0fdd4c1bd3537f2f14cc9b13a473433715103e92d18ce87acc32e63191277544bb192b199a2a439bfa4182a358e7e26ce03073b25a6a2b31bde2052a07524b4c95f496ab17b0dc51505e04dc61aa7ee862d9a8920e8c77db37e257578ed1cf23745c73309529cc4b52f35629fdc1eb1afe7de02e982a0fbe4b70ee3895b5fb4bf4b85e7d09b4bc458308fca4fbcc1cd60963c20ac31da3071f012a307a96acae6df525d018d207e2057eebbf996d80fc504cef6a8b0eeab16a020db69a6837c2a2967adb7644db20f6819170759622a1fc4bfa4ecc0901fedc0175a984698e737f4dce23d12b54b77296201c22501303015a57d62582933e262ecc930dc44d0bc1bd4a05ecd555ce3612b2d16614daa03cbb4747d936d87b0dc1bfec12b5b96aa02e977af788b7548d15502e3a88d1a9a05a40b32e55dd464b24cc2f4a599bbc638854281af67f7ed321014b2dbcf795ca08e09815d2981669f8cc0a067bac32ef15751ab3ddd21283005420ac35d8fdccc99784deeb9f725d640f636cca4b2c11e1fe9950ba1d9e4980fb4364e2e613823e03f73399dff008041bc469bc405c5bc4285359bc26a697d44580c768dd4a2ad0e6ab378f61c51a9310ac928e258ab1d050420abf7c3e9282537716034df6eab989b395d088a390ebcbcad943609ca0df58d390be274201e68a0d95d1a992a5ae21ba6600143100d2e8e20d645cbc5dcb1378609786e01680be4e6378d4db58e65d719952b1d2366b172c39a942e1cc052dbed3929fccba30711b6c90282aefa46dd98f3153b310dd01e65b82ddae1774a35d22a6ce798adb08a997fd851007bc446fd99cc18faa2e64a1ca127486019ce22005c7685b6edd32fcd05d1c411366d9fd21eab40d6f5126fd4afba080c5f4dc6c82fc10a29c7595463709a03402a0652b36f1ff22c8d26e00b117cdd57e972820382710280166da8d8c64645c3fb98558a163fbcc726ef79ea758e9f304dbd665c9625b84aec5cdfff0038fbc292fcd62b73e82e04559ec87c95ef48acc4f17963aa31b207ddd7de700b39604e2870cad5dd535020bcf9cc3946343f54c215770342bc42c10ccf84132129a8892b06ad9ddcc2dae223513a1105d7c4a4b14ed2819cc7a8d768641b179ac454a56b48ee58c7754af3a38b5c446ef6ac845755346e160d9d37cca6e97ed34c295c5623cf5dae2971b2657dbbc76869e2a0811af6e26637daa5a24b18270f5e203d3de39b11f142d82a510299a7cc4ced85bc59b624705cbc967cccb2fca02bcbde328e2bef2a1ff57bc6b893965cc37804f683366537ce2026923db52ca020762380584c1c4a1641a56abe26054338b5dcc1443ad454521e526d5b7a198a1b1dd2a17d25f88600e826385ebcc1a5f83ef30cda9767b964b6e0adbdcafcc372161d1974872b0e22c840b777169773bb981c18b342e040b11ac441742c6cfdd3bef6313acaf762d865abccc80a0ec12d4698d865f581379a19c4be652df29436cd8ae250304b1292596fe20e4ad4e6f52ce908d357b19d0b6fb540267700557d252a6508f75ce7651dc81b7c5e7882e54f7998867cea2a177eb068a09828bafa4d030eb7c4546d57bd4561c93bccc6f06f11b3213cb155729d23638c7173587cc537aa85f2d3c6638325b50a696e147159ed316cf1152e01cb300f43e93369a82d86539629811f2d4ed9273c91285f86251a9c2039dc4dd230834798957a7a91546c4e30bae660414788073cf090967460959a4d9bdc51b6594cae5ab536968dfe629a2d74a856060d43a51c96d83dbac1bb437acff52f858eb88572d19b7109719ba867d8534413fb99576daf30d1d4a96d9d237101adf7c7f518ad17a6e94bd3eecbe325b4f799fcac8f47a42dcd38b24cc4c3cf781acace47fecbd0a39d41c4dc70d5c294de7b44d065196a352ac0357053624b12d5ed0de828315377caae19799adc2583eb34c544c1feb1ea489d2b31100bd2b533c28779698acf698e18002bfd4a1a33d6378baed06408de05399b82fed31cd2fa1281295d0c44ba23150556e0037778e651d3ae22704c7594bb3da23ae3bcc9de0992aea058bc42d3902b5de191454de727de59cb26e2cacab82585dcb2e80e99d4170ac76c41ae7daa6f49d8b80d58eda8b56bae7a7d271a83c5c74bc7bc5954ad95b828095d3940e2ebeb04b1e732a3a1bed2eec0339d7881e54759a8f046f515b059a15942d5ea5d5462cd59170de8bb946a4994bcf6d4e5a9cd352e6a005f3beffbd654a25301da295014ece7bc72282ccac6a0c374542a9554ea50190c79983437517551be88a19ee975c55de22a20efe918068ede208ba2aeae154fcb983216ea50340a5590b52b314858f683c0dbd4cc44c2057113363b8ab441de86e216067404122d962b81ab83658789b6d8e0e92bc01c40d2cf4ed15ad59e617c84b96fb5cd02b7cf4985ef2ecfb2033697da5f57781814e587794e9645a307d62e06a380dd71161b535701c67be65a767626202fb7480564c3af31038cf494b2dc752029ce7982ec4546ea8f696501296b71477c6de601c96748806c5608afa3eb03602a65d7bc6858a8ea54b6a37d638723775a804b1aed1d28e2f38974eba8301190dcca42b6cea64501c758696b2aadb1ad983a5625ad7d0dfb4c8d9e43825f4a3d2e0d6e0a0b11818b9ba97a00d9835f31516561bdd7449c0e43136356f786cc762ee282aceec7bca41aee46d5c305b48ac8d76853bc565bf0b1bc59bc0f481905aef3a39660bbc3aef174051d6203106dcc6ca16dd10434af77f511e01c677121a47ca59e706182295bddb8f88301ef0703b6217058099de2202b1357a99bb5d8699c4d5e00dc58c5bf589b0abe2a0852ef91ccd1abe54d4038d7612878cc1576fcc17482de0e37d20a1c17751865c2101d15d312ba2573713795dec62ddc62196f9e6669bb11c3974cdcea0df495985e72c4d8f0f0911a2831d25868af19811d768832edc9c43867310695326826dacae5c6a038e3bc45aebda32cbb1e2a05f67797586ae58b0678cee020d5e11b5f2769861c5e980ba6eee6f72a56586c7642b8bab1b8a74aeaff00714c2556a8cfde35042b94cccb9ace6c80ba2b70c32295f49485e0eb02cdb8d5c57541d78a81c59668ac4c595a6f491cec41d315169853d5d9ef30180ebddf1315b2bce2a04cc52e86500ed61f08d2b0740250b93ab535575f881323d9eb0b60f9043c8ab931b6190ba37ccbae0e5cc145d0c89c78f8965007b2e2bf1f332848374e7aff005fb8812d1e457997a3d1de2b2d3de51c2d59e80444ed43bc5a6b272d7485d5775f741b46985d3aca11e3fe20e4750b8057b058902f0850950a0c283d7514b688b95b85c33252df1160257abc4adb82b15d662680f3de2576bfaa16ae7a26d6857764108352d6c6a144fb42c34eb888daf0d40cb2540b39481daa071896563da255a5c6e05a2f39e617a7ce4cb131aed18deae042a9e199e5c5732805971014a834c4a5ce66d68485d959c4bb6d146df7a886cab73c42af5a3e265e2c77895abf31deeac98351de0834b439c67b4b30428c2f35fac549af1c9c46e85d9bad4a374aa0d3348b3a03b658b42aae1644165f63f79759bd3772b04c2b087ef58d82d5c3d62cc58db59372c0b43449bc5351294dd64e18bd21ae6eee200d157abb94b228e0ca28b0b579cde20d6c76bb388225b4efc4ffd9, NULL, NULL, NULL, '', '0.009', '2018-11-07 18:28:42', '', NULL, 0, 0, 0, 0, 170, 340, 'Semina', 'amministratore', '2018-03-14 00:20:09');

-- --------------------------------------------------------

--
-- Struttura della tabella `gaz_001camp_artico`
--

DROP TABLE IF EXISTS `gaz_001camp_artico`;
CREATE TABLE IF NOT EXISTS `gaz_001camp_artico` (
  `id_campartico` int(9) NOT NULL AUTO_INCREMENT,
  `codice` varchar(32) NOT NULL COMMENT 'Codice articolo uguale alla tabella artico',
  `or_macro` int(2) NOT NULL COMMENT 'macroarea di origine',
  `or_spec` varchar(80) NOT NULL COMMENT 'origine specifica',
  `estrazione` int(1) NOT NULL COMMENT 'Flag estrazione: 0=non specificata 1=prima spremitura a freddo 2=estratto a freddo',
  `biologico` int(1) NOT NULL COMMENT 'Flag agricoltura: 0=convenzionale 1=biologica 2=in conversione',
  `etichetta` int(1) NOT NULL COMMENT 'Flag etichettatura: 0=non etichettato 1=etichettato',
  `confezione` decimal(9,3) NOT NULL COMMENT 'CapacitĂ  singola confezione. 0=sfuso',
  `categoria` int(2) NOT NULL COMMENT 'Categoria olio come codificato dal SIAN',
  PRIMARY KEY (`id_campartico`),
  KEY `codice` (`codice`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Struttura della tabella `gaz_001camp_mov_sian`
--

DROP TABLE IF EXISTS `gaz_001camp_mov_sian`;
CREATE TABLE IF NOT EXISTS `gaz_001camp_mov_sian` (
  `id_mov_sian` int(9) NOT NULL AUTO_INCREMENT,
  `id_mov_sian_rif` int(9) NOT NULL COMMENT 'Serve in caso di produzione per connettere insieme il prodotto con i suoi componenti',
  `id_movmag` int(9) NOT NULL COMMENT 'Movimento magazzino connesso',
  `recip_stocc_destin` varchar(10) NOT NULL COMMENT 'ID recipiente stoccaggio di destinazione',
  `recip_stocc` varchar(10) NOT NULL COMMENT 'Identificativo recipiente di stoccaggio. Deve essere identico a quello inserito nel SIAN',
  `cod_operazione` varchar(10) NOT NULL COMMENT 'Codice dell''operazione esguita',
  `stabil_dep` int(10) NOT NULL COMMENT 'Identificativo dello stabilimento o deposito assegnato dal SIAN',
  `varieta` varchar(250) NOT NULL COMMENT 'Campo descrittivo della varietà da utilizzare per il campo note nel registro telematico oli SIAN',
  `status` varchar(45) NOT NULL COMMENT '0=inviare - nome del file=inviato',
  PRIMARY KEY (`id_mov_sian`),
  KEY `id_movmag` (`id_movmag`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Struttura della tabella `gaz_001camp_recip_stocc`
--

DROP TABLE IF EXISTS `gaz_001camp_recip_stocc`;
CREATE TABLE IF NOT EXISTS `gaz_001camp_recip_stocc` (
  `cod_silos` varchar(10) NOT NULL COMMENT 'Codice recipiente di stoccaggio olio. Deve essere identico a quello registrato al SIAN',
  `nome` varchar(20) NOT NULL,
  `capacita` decimal(13,3) NOT NULL COMMENT 'La capacità in kg di olio del recipiente',
  `affitto` int(1) NOT NULL COMMENT '0=di proprietà 1=in affitto',
  `dop_igp` int(1) NOT NULL COMMENT '0=non classificato 1=Recipiente destinato a olio DOP o IGP',
  PRIMARY KEY (`cod_silos`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Struttura della tabella `gaz_001cash_register`
--

DROP TABLE IF EXISTS `gaz_001cash_register`;
CREATE TABLE IF NOT EXISTS `gaz_001cash_register` (
  `id_cash` tinyint(2) NOT NULL AUTO_INCREMENT,
  `seziva` int(1) NOT NULL,
  `adminid` varchar(20) NOT NULL COMMENT 'riferimento all''ultimo utente della tabella gaz_admin che ha utilizzato il dispositivo',
  `serial_port` varchar(32) NOT NULL,
  `driver` varchar(32) NOT NULL COMMENT 'il nome del file .php contenuto nella dir librarycash_register da utilizzare come driver di comunicazione con il registratore telematico',
  `path_data` varchar(1000) NOT NULL COMMENT 'dati da passare al driver di cui sopra per raggiungere il dispositivo (path) ed eventuali dati caratteristici della macchina specifica. Contenuto e/o il formato dipende da come è scritto il driver stesso',
  `enabled_users` varchar(1000) NOT NULL COMMENT 'contiene i riferimenti agli utenti abilitati all''utilizzo del dispositivo separati da un punto e virgola',
  `descri` varchar(32) NOT NULL,
  `lotteria_scontrini` varchar(32) NOT NULL COMMENT 'stringa inviata dal driver al RT per i righi tipo "5 - Lotteria scontrini" ',
  PRIMARY KEY (`id_cash`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Struttura della tabella `gaz_001cash_register_reparto`
--

DROP TABLE IF EXISTS `gaz_001cash_register_reparto`;
CREATE TABLE IF NOT EXISTS `gaz_001cash_register_reparto` (
  `id_cash_register_reparto` int(2) NOT NULL AUTO_INCREMENT,
  `cash_register_id_cash` int(2) NOT NULL DEFAULT '0',
  `aliiva_codice` int(3) NOT NULL DEFAULT '0',
  `reparto` varchar(8) NOT NULL DEFAULT '',
  `descrizione` varchar(50) NOT NULL DEFAULT '',
  PRIMARY KEY (`id_cash_register_reparto`),
  KEY `cash_register_id_cash` (`cash_register_id_cash`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='Tabella contenente le associazioni tra id_cash della tabella gaz_NNNcash_register e codice della tabella gaz_NNNaliiva al fine di passare il valore del reparto IVA ad ogni rigo dello scontrino telematico';

-- --------------------------------------------------------

--
-- Struttura della tabella `gaz_001cash_register_tender`
--

DROP TABLE IF EXISTS `gaz_001cash_register_tender`;
CREATE TABLE IF NOT EXISTS `gaz_001cash_register_tender` (
  `id_cash_register_tender` int(2) NOT NULL AUTO_INCREMENT,
  `cash_register_id_cash` int(2) NOT NULL DEFAULT '0',
  `pagame_codice` int(2) NOT NULL DEFAULT '0',
  `tender` varchar(8) NOT NULL DEFAULT '',
  `descrizione` varchar(50) NOT NULL DEFAULT '',
  PRIMARY KEY (`id_cash_register_tender`),
  KEY `cash_register_id_cash` (`cash_register_id_cash`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='Tabella contenente le associazioni tra id_cash della tabella gaz_NNNcash_register e codice della tabella gaz_NNNpagame al fine di valorizzare il tender specifico del registratore telematico in base alla modalità di pagamento';

-- --------------------------------------------------------

--
-- Struttura della tabella `gaz_001catmer`
--

DROP TABLE IF EXISTS `gaz_001catmer`;
CREATE TABLE IF NOT EXISTS `gaz_001catmer` (
  `codice` int(3) NOT NULL DEFAULT '0',
  `descri` varchar(50) NOT NULL DEFAULT '',
  `large_descri` text NOT NULL,
  `image` blob,
  `web_url` varchar(255) NOT NULL,
  `ref_ecommerce_id_category` varchar(50) DEFAULT '' COMMENT 'Riferimento alla categoria articoli in eventuale ecommerce sincronizzato',
  `ricarico` decimal(4,1) NOT NULL,
  `top` tinyint(1) NOT NULL DEFAULT '0' COMMENT 'posizione di visualizzazione/pubblicazione',
  `annota` varchar(50) DEFAULT NULL,
  `adminid` varchar(20) NOT NULL DEFAULT '',
  `last_modified` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`codice`),
  KEY `ref_ecommerce_id_category` (`ref_ecommerce_id_category`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Dump dei dati per la tabella `gaz_001catmer`
--

INSERT INTO `gaz_001catmer` (`codice`, `descri`, `large_descri`, `image`, `web_url`, `ref_ecommerce_id_category`, `ricarico`, `top`, `annota`, `adminid`, `last_modified`) VALUES
(1, 'CATEGORIA PRINCIPALE', '', '', '', '', '0.0', 0, 'TEST', 'amministratore', '2005-09-19 04:34:13');

-- --------------------------------------------------------

--
-- Struttura della tabella `gaz_001caucon`
--

DROP TABLE IF EXISTS `gaz_001caucon`;
CREATE TABLE IF NOT EXISTS `gaz_001caucon` (
  `codice` char(3) NOT NULL DEFAULT '',
  `descri` varchar(50) NOT NULL DEFAULT '',
  `insdoc` int(1) DEFAULT '0',
  `regiva` int(1) NOT NULL DEFAULT '0',
  `operat` int(1) NOT NULL,
  `pay_schedule` int(1) NOT NULL,
  `adminid` varchar(20) NOT NULL DEFAULT '',
  `last_modified` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`codice`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Dump dei dati per la tabella `gaz_001caucon`
--

INSERT INTO `gaz_001caucon` (`codice`, `descri`, `insdoc`, `regiva`, `operat`, `pay_schedule`, `adminid`, `last_modified`) VALUES
('VER', 'VERSAMENTO SU C/C BANCARIO', 0, 0, 0, 0, 'amministratore', '2012-03-03 00:02:17'),
('FAI', 'FATTURA IMMEDIATA A CLIENTE', 1, 2, 1, 1, 'amministratore', '2013-04-11 03:01:57'),
('FAD', 'FATTURA DIFFERITA A CLIENTE', 1, 2, 1, 1, 'amministratore', '2013-04-11 03:01:57'),
('FNC', 'NOTA CREDITO A CLIENTE', 1, 2, 2, 1, 'amministratore', '2013-04-11 03:01:57'),
('FND', 'NOTA DEBITO A CLIENTE', 1, 2, 1, 1, 'amministratore', '2013-04-11 03:01:57'),
('VCO', 'VENDITA CORRISPETTIVI', 1, 4, 1, 0, 'amministratore', '2006-02-19 17:16:56'),
('AFA', 'FATTURA DI ACQUISTO IMMEDIATA', 1, 6, 1, 1, 'amministratore', '2020-05-29 12:02:18'),
('AFC', 'NOTA CREDITO DA FORNITORE', 1, 6, 2, 1, 'amministratore', '2013-04-11 03:01:57'),
('FAP', 'PARCELLA', 1, 2, 1, 1, '', '2013-04-11 03:01:57'),
('FDE', 'Fatture da emettere', 1, 2, 1, 1, 'amministratore', '2013-04-11 03:01:57'),
('FDR', 'Fatture da ricevere', 1, 6, 1, 1, 'amministratore', '2013-04-11 03:01:57'),
('PFE', 'Fattura di vendita, ex fattura da emettere', 1, 2, 0, 0, 'amministratore', '2016-01-26 01:09:25'),
('PFR', 'Fattura di acquisto, ex fattura da ricevere', 1, 6, 0, 0, 'amministratore', '2010-10-11 01:07:15'),
('RIB', 'EMESSA RICEVUTA BANCARIA', 1, 0, 0, 2, 'amministratore', '2016-01-26 01:09:25'),
('TRA', 'EMESSA CAMBIALE TRATTA', 1, 0, 0, 2, 'amministratore', '2016-01-26 01:09:25'),
('MAV', 'EMESSO MAV', 1, 0, 0, 2, 'amministratore', '2016-01-26 01:09:25'),
('RIM', 'PAGAMENTO DA CLIENTE IN CONTANTI', 0, 0, 0, 2, 'amministratore', '2016-01-26 01:09:25'),
('BON', 'RICEVUTO BONIFICO DA CLIENTE', 0, 0, 0, 2, 'amministratore', '2016-01-26 01:09:25'),
('PFC', 'PAGATO FORNITORE IN CONTANTI', 0, 0, 0, 2, 'amministratore', '2016-01-26 01:09:25'),
('PFB', 'PAGATO FORNITORE CON BONIFICO', 0, 0, 0, 2, 'amministratore', '2013-04-03 03:30:13'),
('APE', 'APERTURA CONTI', 0, 0, 0, 0, '', '2017-03-23 23:07:02'),
('CHI', 'CHIUSURA CONTI', 0, 0, 0, 0, '', '2017-03-23 23:07:02'),
('VEI', 'VERSAMENTO IVA AD ERARIO', 0, 9, 0, 0, '', '2019-03-01 00:27:03'),
('AFT', 'FATTURA DI ACQUISTO DIFFERITA', 1, 6, 1, 1, 'amministratore', '2020-05-29 12:02:18'),
('BBH', 'BONIFICO SALARI & STIPENDI', 1, 0, 0, 0, '', '2021-02-06 11:17:33'),
('BBA', 'PAGATO FORNITORE CON BONIFICO', 1, 0, 0, 0, '', '2021-02-06 11:17:33');

-- --------------------------------------------------------

--
-- Struttura della tabella `gaz_001caucon_rows`
--

DROP TABLE IF EXISTS `gaz_001caucon_rows`;
CREATE TABLE IF NOT EXISTS `gaz_001caucon_rows` (
  `caucon_cod` char(3) NOT NULL DEFAULT '',
  `clfoco_ref` int(9) NOT NULL DEFAULT '0',
  `type_imp` char(1) NOT NULL DEFAULT '',
  `dare_avere` char(1) NOT NULL DEFAULT '',
  `n_order` int(3) NOT NULL DEFAULT '0',
  KEY `idx_caucon_cod` (`caucon_cod`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Dump dei dati per la tabella `gaz_001caucon_rows`
--

INSERT INTO `gaz_001caucon_rows` (`caucon_cod`, `clfoco_ref`, `type_imp`, `dare_avere`, `n_order`) VALUES
('VER', 597000000, '', 'D', 1),
('FAI', 103000000, 'A', 'D', 1),
('FAD', 103000000, 'A', 'D', 1),
('FNC', 420000010, 'B', 'D', 1),
('FND', 420000003, 'A', 'D', 1),
('VCO', 108000030, 'A', 'D', 1),
('AFA', 330000004, 'B', 'D', 1),
('AFC', 212000000, 'A', 'D', 1),
('FAP', 103000000, 'A', 'D', 1),
('FDE', 103000000, 'A', 'D', 1),
('FDR', 330000004, 'B', 'D', 1),
('PFE', 103000000, 'A', 'D', 1),
('PFR', 212000001, 'A', 'D', 1),
('RIB', 103000000, 'A', 'A', 1),
('TRA', 103000000, 'A', 'A', 1),
('MAV', 103000000, 'A', 'A', 1),
('RIM', 103000000, 'A', 'A', 1),
('BON', 103000000, 'A', 'A', 1),
('PFC', 212000000, 'A', 'D', 1),
('PFB', 212000000, 'A', 'D', 1),
('VER', 108000030, '', 'A', 2),
('FAI', 420000006, 'B', 'A', 2),
('FAD', 420000006, 'B', 'A', 2),
('FNC', 215000001, 'C', 'D', 2),
('FND', 103000000, 'A', 'A', 2),
('VCO', 420000001, 'B', 'A', 2),
('AFA', 106000001, 'C', 'D', 2),
('AFC', 330000010, 'B', 'A', 2),
('FAP', 420000007, 'B', 'A', 2),
('FDE', 420000006, 'B', 'A', 2),
('FDR', 106000001, 'C', 'D', 2),
('PFE', 103000000, 'A', 'A', 2),
('PFR', 212000000, 'A', 'A', 2),
('RIB', 597000021, 'A', 'D', 2),
('TRA', 597000021, 'A', 'D', 2),
('MAV', 597000021, 'A', 'D', 2),
('RIM', 108000030, 'A', 'D', 2),
('BON', 597000021, 'A', 'D', 2),
('PFC', 108000030, 'A', 'A', 2),
('PFB', 597000021, 'A', 'A', 2),
('FAI', 215000001, 'C', 'A', 3),
('FAD', 215000001, 'C', 'A', 3),
('FNC', 103000000, 'A', 'A', 3),
('VCO', 215000001, 'C', 'A', 3),
('AFA', 212000000, 'A', 'A', 3),
('AFC', 106000001, 'C', 'A', 3),
('FAP', 215000001, 'C', 'A', 3),
('FDE', 215000001, 'C', 'A', 3),
('FDR', 212000001, 'A', 'A', 3),
('VEI', 597000000, '', 'A', 1),
('VEI', 215000005, '', 'D', 2),
('AFT', 212000000, 'A', 'A', 1),
('AFT', 330000004, 'B', 'D', 2),
('AFT', 106000001, 'C', 'D', 3);

-- --------------------------------------------------------

--
-- Struttura della tabella `gaz_001caumag`
--

DROP TABLE IF EXISTS `gaz_001caumag`;
CREATE TABLE IF NOT EXISTS `gaz_001caumag` (
  `codice` int(2) NOT NULL,
  `descri` varchar(50) NOT NULL DEFAULT '',
  `type_cau` tinyint(1) NOT NULL COMMENT '0=solo modulo magazzino, 1=solo quaderno di campagna, 9=tutti',
  `clifor` tinyint(1) NOT NULL,
  `insdoc` tinyint(1) NOT NULL,
  `operat` tinyint(1) NOT NULL,
  `adminid` varchar(20) NOT NULL DEFAULT '',
  `last_modified` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`codice`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Dump dei dati per la tabella `gaz_001caumag`
--

INSERT INTO `gaz_001caumag` (`codice`, `descri`, `type_cau`, `clifor`, `insdoc`, `operat`, `adminid`, `last_modified`) VALUES
(1, 'SCARICO PER VENDITA', 9, -1, 1, -1, '', '2020-10-11 18:41:25'),
(2, 'CARICO PER RESO DA CLIENTE', 9, -1, 1, 1, '', '2020-10-11 18:41:25'),
(3, 'SCARICO PER C/LAVORAZIONE', 9, 1, 1, -1, '', '2020-10-11 18:41:25'),
(4, 'SCARICO PER RESO A FORNITORE', 9, 1, 1, -1, '', '2020-10-11 18:41:25'),
(5, 'CARICO PER ACQUISTO', 9, 1, 1, 1, '', '2020-10-11 18:41:25'),
(99, 'INVENTARIO DI MAGAZZINO', 9, 0, 0, 1, '', '2020-10-11 18:41:25'),
(98, 'STORNO PER INVENTARIO', 9, 0, 0, 0, '', '2020-10-11 18:41:25'),
(82, 'CARICO DA PRODUZIONE', 9, 0, 0, 1, '', '2020-10-11 18:41:25'),
(81, 'SCARICO PER PRODUZIONE', 9, 0, 0, -1, '', '2020-10-11 18:41:25'),
(91, 'SCARICO PER MANUTENZIONE INTERNA', 9, 0, 1, -1, '', '2020-10-11 18:41:25'),
(84, 'CARICO PER TRASFERIMENTO DA ALTRO MAGAZZINO', 9, 0, 0, 1, '', '2021-12-01 12:41:39'),
(83, 'SCARICO PER TRASFERIMENTO VERSO ALTRO MAGAZZINO', 9, 0, 0, -1, '', '2021-12-01 12:41:39');

-- --------------------------------------------------------

--
-- Struttura della tabella `gaz_001clfoco`
--

DROP TABLE IF EXISTS `gaz_001clfoco`;
CREATE TABLE IF NOT EXISTS `gaz_001clfoco` (
  `codice` int(9) NOT NULL DEFAULT '0',
  `id_anagra` int(9) NOT NULL,
  `descri` varchar(100) DEFAULT NULL,
  `ref_ecommerce_id_customer` varchar(50) DEFAULT '' COMMENT 'Codice di riferimento allo stesso cliente in eventuale ecommerce collegato attraverso API',
  `print_map` tinyint(1) NOT NULL,
  `external_resp` tinyint(1) NOT NULL,
  `external_service_descri` varchar(100) NOT NULL COMMENT 'Descrizione del servizio esternalizzato, verrà riportato sulla nomina a responsabile esterno del trattamento dei dati',
  `id_agente` int(9) NOT NULL,
  `banapp` int(3) NOT NULL DEFAULT '0',
  `portos` int(2) NOT NULL DEFAULT '0',
  `spediz` int(2) NOT NULL DEFAULT '0',
  `imball` int(2) NOT NULL DEFAULT '0',
  `listin` int(1) NOT NULL DEFAULT '0',
  `destin` varchar(100) NOT NULL,
  `id_des` int(9) NOT NULL,
  `iban` varchar(32) NOT NULL DEFAULT '0',
  `sia_code` varchar(5) NOT NULL,
  `cuc_code` varchar(8) NOT NULL,
  `maxrat` decimal(8,2) DEFAULT '0.00',
  `ragdoc` char(1) NOT NULL DEFAULT '',
  `addbol` char(1) NOT NULL DEFAULT '',
  `speban` char(1) NOT NULL DEFAULT '',
  `spefat` char(1) NOT NULL DEFAULT '',
  `stapre` char(1) NOT NULL DEFAULT '',
  `codpag` int(2) NOT NULL DEFAULT '0',
  `sconto` decimal(5,2) DEFAULT '0.00' COMMENT 'Sconto di chiusura, viene applicato alla fine e riferito a tutti i righi del corpo dei documenti',
  `sconto_rigo` decimal(5,2) DEFAULT '0.00' COMMENT 'Sconto rigo, viene applicato ad ogni singolo rigo dei documenti',
  `aliiva` int(2) NOT NULL DEFAULT '0',
  `ritenuta` decimal(3,1) NOT NULL,
  `allegato` tinyint(1) NOT NULL,
  `cosric` int(9) NOT NULL,
  `ceedar` varchar(8) NOT NULL DEFAULT '',
  `ceeave` varchar(8) NOT NULL DEFAULT '',
  `paymov` varchar(1) NOT NULL DEFAULT '',
  `operation_type` varchar(15) NOT NULL DEFAULT '',
  `id_assets` int(9) NOT NULL,
  `sel4esp_art` tinyint(1) DEFAULT '0',
  `status` varchar(10) NOT NULL DEFAULT '',
  `status_SIAN` int(1) NOT NULL COMMENT '0=soggetto non trasmesso al SIAN, 1=soggetto trasmesso al SIAN',
  `annota` varchar(3000) NOT NULL,
  `visannota` char(1) NOT NULL DEFAULT 'N',
  `custom_field` text COMMENT 'Riferimenti generici utilizzabili sui moduli. Normalmente in formato json: {"nome_modulo":{"nome_variabile":{"valore_variabile": {}}}}',
  `adminid` varchar(20) NOT NULL DEFAULT '',
  `last_modified` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`codice`),
  KEY `id_agente` (`id_agente`),
  KEY `ref_ecommerce_id_customer` (`ref_ecommerce_id_customer`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Dump dei dati per la tabella `gaz_001clfoco`
--

INSERT INTO `gaz_001clfoco` (`codice`, `id_anagra`, `descri`, `ref_ecommerce_id_customer`, `print_map`, `external_resp`, `external_service_descri`, `id_agente`, `banapp`, `portos`, `spediz`, `imball`, `listin`, `destin`, `id_des`, `iban`, `sia_code`, `cuc_code`, `maxrat`, `ragdoc`, `addbol`, `speban`, `spefat`, `stapre`, `codpag`, `sconto`, `sconto_rigo`, `aliiva`, `ritenuta`, `allegato`, `cosric`, `ceedar`, `ceeave`, `paymov`, `operation_type`, `id_assets`, `sel4esp_art`, `status`, `status_SIAN`, `annota`, `visannota`, `custom_field`, `adminid`, `last_modified`) VALUES
(215000070, 0, 'Amministratori c/competenze', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 0, 0, '', 'PD00014', '', '', 0, 0, '', 0, '', 'N', NULL, 'amministratore', '2008-10-07 11:11:37'),
(100000002, 0, 'Azionisti c/versamenti richiamati', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 0, 0, 'AA00000', '', '', '', 0, 0, '', 0, '', 'N', NULL, 'amministratore', '2008-10-04 03:57:40'),
(100000000, 0, 'CREDITI VS/SOCI', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 0, 0, '', '', '', '', 0, 0, '', 0, '', 'N', NULL, 'amministratore', '2008-10-04 03:47:11'),
(210000000, 0, 'PATRIMONIO NETTO', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 1, 0, '', '', '', '', 0, 0, '', 0, '', 'N', NULL, '', '2007-05-17 02:46:32'),
(100000001, 0, 'Azionisti c/sottoscrizioni', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 0, 0, 'AA00000', '', '', '', 0, 0, '', 0, '', 'N', NULL, 'amministratore', '2008-10-04 03:57:35'),
(421000000, 0, 'RICAVI E PROVENTI DIVERSI', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 1, 0, '', '', '', '', 0, 0, '', 0, '', 'N', NULL, '', '2007-05-17 02:46:32'),
(336000000, 0, 'SVALUTAZIONI', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 1, 0, '', '', '', '', 0, 0, '', 0, '', 'N', NULL, '', '2007-05-17 02:46:32'),
(213000000, 0, 'DEBITI FINANZIARI', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 1, 0, '', '', '', '', 0, 0, '', 0, '2424, passivo D: «Debiti, con separata indicazione, per ciascuna voce, degli importi esigibili oltre l`esercizio successivo»', 'N', NULL, 'amministratore', '2010-11-12 02:06:47'),
(215000052, 0, 'Azioni c/rimborso', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 1, 0, '', 'PD00014', '', '', 0, 0, '', 0, '', 'N', NULL, '', '2007-05-17 02:46:32'),
(421000001, 0, 'Fitti Attivi', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 1, 0, '', 'EA00005', '', '', 0, 0, '', 0, '', 'N', NULL, '', '2007-05-17 02:46:32'),
(421000002, 0, 'Proventi Vari', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 1, 0, '', 'EA00005', '', '', 0, 0, '', 0, '', 'N', NULL, '', '2007-05-17 02:46:32'),
(215000050, 0, 'Azionisti c/dividendi', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 1, 0, '', 'PD00014', '', '', 0, 0, '', 0, '', 'N', NULL, '', '2007-05-17 02:46:32'),
(215000054, 0, 'Debiti per azioni estratte', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 1, 0, '', 'PD00014', '', '', 0, 0, '', 0, '', 'N', NULL, '', '2007-05-17 02:46:32'),
(215000051, 0, 'Azionisti c/acconto dividendi', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 1, 0, '', 'PD00014', '', '', 0, 0, '', 0, '', 'N', NULL, '', '2007-05-17 02:46:32'),
(100000005, 0, 'Azionisti c/reintegro', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 0, 0, 'AA00000', '', '', '', 0, 0, '', 0, '', 'N', NULL, 'amministratore', '2008-10-06 07:04:40'),
(210000002, 0, 'Capitale sociale', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 1, 0, '', 'PA01000', '', '', 0, 0, '', 0, '', 'N', NULL, '', '2008-10-06 01:54:04'),
(336000002, 0, 'Svalutazione immobilizzazioni materiali', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 0, 0, 'EB00010c', '', '', '', 0, 0, '', 0, '', 'N', NULL, 'amministratore', '2008-10-04 05:16:37'),
(215000060, 0, 'Debiti per obbligazioni estratte', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 1, 0, '', 'PD00014', '', '', 0, 0, '', 0, '', 'N', NULL, '', '2007-05-17 02:46:32'),
(421000020, 0, 'Plusvalenze ordinarie', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 1, 0, '', 'EA00005', '', '', 0, 0, '', 0, '', 'N', NULL, '', '2007-05-17 02:46:32'),
(315000001, 0, 'Costi di trasporto', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 1, 0, 'EB00007', '', '', '', 0, 0, '', 0, '', 'N', NULL, '', '2008-10-06 06:54:48'),
(421000010, 0, 'Arrotondamenti Attivi', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 1, 0, '', 'EA00005', '', '', 0, 0, '', 0, '', 'N', NULL, '', '2007-05-17 02:46:32'),
(460000000, 0, 'PROVENTI STRAORDINARI', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 1, 0, '', '', '', '', 0, 0, '', 0, '', 'N', NULL, '', '2007-05-17 02:46:32'),
(115000002, 0, 'Materie sussidiarie', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 1, 0, 'AC01001', '', '', '', 0, 0, '', 0, '', 'N', NULL, '', '2007-05-17 02:46:32'),
(336000001, 0, 'Svalutazione immobilizzazioni immateriali', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 1, 0, 'EB00010c', '', '', '', 0, 0, '', 0, '', 'N', NULL, '', '2007-05-17 02:46:32'),
(588000000, 0, 'CONTI TRANSITORI', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 1, 0, '', '', '', '', 0, 0, '', 0, 'I conti transitori non possono affluire in bilancio direttamente.', 'N', NULL, 'amministratore', '2010-11-12 01:08:53'),
(597000000, 0, 'CONTI BANCARI', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 1, 0, 'AC04001', 'PD00004', '', '', 0, 0, '', 0, '', 'N', NULL, 'amministratore', '2017-03-24 00:37:46'),
(215000061, 0, 'Obbligazionisti c/rimborsi', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 1, 0, '', 'PD00014', '', '', 0, 0, '', 0, '', 'N', NULL, '', '2007-05-17 02:46:32'),
(215000062, 0, 'Obligazionisti c/interessi', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 1, 0, '', 'PD00014', '', '', 0, 0, '', 0, '', 'N', NULL, '', '2007-05-17 02:46:32'),
(101000013, 0, 'Fondo ammortamento costi di ricerca e sviluppo', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 1, 0, '', 'AB01002', '', '', 0, 0, '', 0, '', 'N', NULL, '', '2007-05-17 02:46:32'),
(421000030, 0, 'Sopravvenienze Attive Ordinarie', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 1, 0, '', 'EA00005', '', '', 0, 0, '', 0, '', 'N', NULL, '', '2007-05-17 02:46:32'),
(101000012, 0, 'Fondo ammortamento costi di ampliamento', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 1, 0, '', 'AB01001', '', '', 0, 0, '', 0, '', 'N', NULL, '', '2007-05-17 02:46:32'),
(361000000, 0, 'ONERI STRAORDINARI', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 1, 0, '', '', '', '', 0, 0, '', 0, '', 'N', NULL, '', '2007-05-17 02:46:32'),
(215000071, 0, 'Sindaci c/competenze', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 1, 0, '', 'PD00014', '', '', 0, 0, '', 0, '', 'N', NULL, '', '2007-05-17 02:46:32'),
(336000006, 0, 'Svalutazione crediti', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 1, 0, 'EB00010d', '', '', '', 0, 0, '', 0, '', 'N', NULL, '', '2007-05-17 02:46:32'),
(330000000, 0, 'COSTI DELLE MATERIE/MERCI', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 1, 0, '', '', '', '', 0, 0, '', 0, '2425bis: «I ricavi e i proventi, i costi e gli oneri devono essere indicati al netto dei resi, degli sconti, abbuoni e premi, nonché delle imposte direttamente connesse con la vendita dei prodotti e la prestazione dei servizi»', 'N', NULL, 'amministratore', '2010-11-12 01:32:53'),
(210000005, 0, 'Riserva legale', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 1, 0, '', 'PA04000', '', '', 0, 0, '', 0, '', 'N', NULL, '', '2007-05-17 02:46:32'),
(215000090, 0, 'Creditori diversi', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 1, 0, '', 'PD00014', '', '', 0, 0, '', 0, '', 'N', NULL, '', '2007-05-17 02:46:32'),
(337000000, 0, 'VARIAZIONI DELLE RIMANENZE DI MATERIE/MERCI', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 0, 0, '', '', '', '', 0, 0, '', 0, 'La variazione delle rimanenze, corrispondente alla voce B11 del conto economico, se ha segno positivo indica una diminuzione del valore delle rimanenze finali rispetto a quello delle esistenze inziali; diversamente indica un rapporto inverso tra le due entità.', 'N', NULL, 'amministratore', '2010-11-12 01:37:07'),
(210000004, 0, 'Riserve di rivalutazione', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 1, 0, '', 'PA03000', '', '', 0, 0, '', 0, '', 'N', NULL, '', '2007-05-17 02:46:32'),
(320000001, 0, 'Fitti passivi', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 1, 0, 'EB00008', '', '', '', 0, 0, '', 0, '', 'N', NULL, '', '2007-05-17 02:46:32'),
(337000001, 0, 'Materie prime c/esistenze iniziali', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 1, 0, 'EB00011', '', '', '', 0, 0, '', 0, '', 'N', NULL, '', '2007-05-17 02:46:32'),
(216000001, 0, 'Ratei passivi', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 0, 0, '', 'PE00001', '', '', 0, 0, '', 0, '', 'N', NULL, 'amministratore', '2008-10-04 05:12:28'),
(101000014, 0, 'Fondo ammortamento costi di pubblicità', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 0, 0, '', 'AB01002', '', '', 0, 0, '', 0, '', 'N', NULL, 'amministratore', '2008-10-03 09:23:30'),
(216000002, 0, 'Risconti passivi', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 0, 0, '', 'PE00002', '', '', 0, 0, '', 0, '', 'N', NULL, 'amministratore', '2008-10-04 05:12:42'),
(210000006, 0, 'Riserve per azioni proprie', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 1, 0, '', 'PA05000', '', '', 0, 0, '', 0, '', 'N', NULL, '', '2007-05-17 02:46:32'),
(337000002, 0, 'Materie sussidiarie c/esistenze iniziali', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 1, 0, 'EB00011', '', '', '', 0, 0, '', 0, '', 'N', NULL, '', '2007-05-17 02:46:32'),
(216000003, 0, 'Aggio sui prestiti', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 0, 0, '', 'PE00003', '', '', 0, 0, '', 0, '', 'N', NULL, 'amministratore', '2008-10-04 05:12:54'),
(337000003, 0, 'Materie di consumo c/esistenze iniziali', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 1, 0, 'EB00011', '', '', '', 0, 0, '', 0, '', 'N', NULL, '', '2007-05-17 02:46:32'),
(337000010, 0, 'Materie prime c/rimanenze finali', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 1, 0, '', 'EB00011', '', '', 0, 0, '', 0, '', 'N', NULL, '', '2007-05-17 02:46:32'),
(337000011, 0, 'Materie sussidiarie c/rimanenze finali', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 1, 0, '', 'EB00011', '', '', 0, 0, '', 0, '', 'N', NULL, '', '2007-05-17 02:46:32'),
(420000000, 0, 'VALORE DELLA PRODUZIONE/VENDITE E PRESTAZIONI', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 1, 0, '', '', '', '', 0, 0, '', 0, '2425bis: «I ricavi e i proventi, i costi e gli oneri devono essere indicati al netto dei resi, degli sconti, abbuoni e premi, nonché delle imposte direttamente connesse con la vendita dei prodotti e la prestazione dei servizi»\n\nLa variazione delle rimanenze, corrispondente alla voce A2 dell`attivo, se ha segno positivo indica un incremento del valore delle rimanenze finali rispetto a quello delle esistenze inziali; diversamente indica un rapporto inverso tra le due entità.', 'N', NULL, 'amministratore', '2010-11-12 01:31:28'),
(330000001, 0, 'Materie prime c/acquisti', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 1, 0, 'EB00006', '', '', '', 0, 0, '', 0, '', 'N', NULL, '', '2007-05-17 02:46:32'),
(337000012, 0, 'Materie di consumo c/rimanenze finali', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 1, 0, '', 'EB00011', '', '', 0, 0, '', 0, '', 'N', NULL, '', '2007-05-17 02:46:32'),
(217000000, 0, 'TRATTAMENTO FINE RAPPORTO', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 1, 0, '', '', '', '', 0, 0, '', 0, '', 'N', NULL, '', '2007-05-17 02:46:32'),
(338000000, 0, 'ACCANTONAMENTI', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 1, 0, '', '', '', '', 0, 0, '', 0, '', 'N', NULL, '', '2007-05-17 02:46:32'),
(216000000, 0, 'RATEI E RISCONTI PASSIVI', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 1, 0, '', '', '', '', 0, 0, '', 0, '', 'N', NULL, '', '2007-05-17 02:46:32'),
(101000008, 0, 'Avviamento', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 1, 0, 'AB01005', '', '', '', 0, 0, '', 0, '', 'N', NULL, '', '2007-05-17 02:46:32'),
(338000004, 0, 'Accantonamento per responsabilità civile', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 0, 0, 'EB00012', '', '', '', 0, 0, '', 0, '', 'N', NULL, 'amministratore', '2008-10-03 09:23:19'),
(101000011, 0, 'Fondo ammortamento costi di impianto', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 1, 0, '', 'AB01001', '', '', 0, 0, '', 0, '', 'N', NULL, '', '2007-05-17 02:46:32'),
(338000010, 0, 'Accantonamento per garanzie prodotti', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 1, 0, 'EB00013', '', '', '', 0, 0, '', 0, '', 'N', NULL, '', '2007-05-17 02:46:32'),
(330000002, 0, 'Materie sussidiarie c/acquisti', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 0, 0, 'EB00006', '', '', '', 0, 0, '', 0, '', 'N', NULL, 'amministratore', '2008-10-06 04:29:57'),
(210000009, 0, 'Riserva conguaglio utili in corso', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 1, 0, '', 'PA07000', '', '', 0, 0, '', 0, '', 'N', NULL, '', '2007-05-17 02:46:32'),
(330000003, 0, 'Materie di consumo c/acquisti', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 0, 0, 'EB00006', '', '', '', 0, 0, '', 0, '', 'N', NULL, 'amministratore', '2008-10-06 04:30:09'),
(338000011, 0, 'Accantonamento per manutenzioni programmate', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 1, 0, 'EB00013', '', '', '', 0, 0, '', 0, '', 'N', NULL, '', '2007-05-17 02:46:32'),
(101000000, 0, 'IMMOBILIZZAZIONI IMMATERIALI', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 1, 0, '', '', '', '', 0, 0, '', 0, '2426, 1): «Le immobilizzazioni sono iscritte al costo di acquisto o di produzione. Nel costo di acquisto si computano anche i costi accessori. Il costo di produzione comprende tutti i costi direttamente imputabili al prodotto. Può comprendere anche altri costi, per la quota ragionevolmente imputabile al prodotto, relativi al periodo di fabbricazione e fino al momento dal quale il bene può essere utilizzato; con gli stessi criteri possono essere aggiunti gli oneri relativi al finanziamento della fabbricazione, interna o presso terzi»\n\n2426, 5): «I costi di impianto e di ampliamento, i costi di ricerca, di sviluppo e di pubblicità aventi utilità pluriennale possono essere iscritti nell`attivo con il consenso del collegio sindacale [omissis]»\n\n2426, 6): «L`avviamento può essere iscritto nell`attivo con il consenso del collegio sindacale, se acquisito a titolo oneroso, nei limiti del costo per esso sostenuto [omissis]»\n\nIl costo del software indispensabile al funzionamento dell`hardware, quale può essere il sistema operativo, viene patrimonializzato insieme all`hardware.\nIl costo del software applicativo va in bilancio nella voce BI3 dell`attivo (diritto di brevetto e di utilizzazione delle opere dell`ingegno), se si tratta di un lavoro prodotto in economia e tutelato dalle norme sul diritto d`autore, se l`acquisto comporta l`acquisizione del diritto d`autore, ma anche se se si tratta di una licenza d`uso a tempo indeterminato.\nIl costo del software applicativo va invece in bilancio nella voce BI4 (concessioni, licenze, marchi e diritti simili) se si tratta di una licenza d`uso a tempo determinato, con pagamento in un`unica soluzione.\nSe invece il software è stato prodotto in economia, ma senza che i diritti su questo lavoro possano essere sfruttati diversamente, il suo costo va in bilancio alla voce BI7 (altre immobilizzazioni immateriali).\n\nI fondi ammortamento e i fondi svalutazione vanno a diminuire le voci corrispondenti a cui si riferiscono.', 'N', NULL, 'amministratore', '2010-11-12 01:52:01'),
(330000005, 0, 'Materie prime c/apporti', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 0, 0, 'EB00006', '', '', '', 0, 0, '', 0, '', 'N', NULL, 'amministratore', '2008-10-06 04:28:47'),
(338000012, 0, 'Accantonamento per buoni sconto e concorsi', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 1, 0, 'EB00013', '', '', '', 0, 0, '', 0, '', 'N', NULL, '', '2007-05-17 02:46:32'),
(101000015, 0, 'Fondo ammortamento brevetti industriali', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 1, 0, '', 'AB01003', '', '', 0, 0, '', 0, '', 'N', NULL, '', '2007-05-17 02:46:32'),
(330000006, 0, 'Materie sussidiarie c/apporti', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 0, 0, 'EB00006', '', '', '', 0, 0, '', 0, '', 'N', NULL, 'amministratore', '2008-10-06 04:29:02'),
(339000000, 0, 'ONERI DIVERSI', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 1, 0, '', '', '', '', 0, 0, '', 0, '', 'N', NULL, '', '2007-05-17 02:46:32'),
(210000007, 0, 'Riserva statutaria', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 1, 0, '', 'PA06000', '', '', 0, 0, '', 0, '', 'N', NULL, '', '2007-05-17 02:46:32'),
(339000001, 0, 'Oneri fiscali diversi', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 1, 0, 'EB00014', '', '', '', 0, 0, '', 0, '', 'N', NULL, '', '2007-05-17 02:46:32'),
(330000007, 0, 'Materie di consumo c/apporti', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 0, 0, 'EB00006', '', '', '', 0, 0, '', 0, '', 'N', NULL, 'amministratore', '2008-10-06 04:29:15'),
(420000001, 0, 'Prodotti c/vendite', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 1, 0, '', 'EA00001', '', '', 0, 0, '', 0, '', 'N', NULL, '', '2007-05-17 02:46:32'),
(210000011, 0, 'Versamenti azionisti c/capitale', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 1, 0, '', 'PA07000', '', '', 0, 0, '', 0, '', 'N', NULL, '', '2007-05-17 02:46:32'),
(339000010, 0, 'Arrotondamenti passivi', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 1, 0, 'EB00014', '', '', '', 0, 0, '', 0, '', 'N', NULL, '', '2007-05-17 02:46:32'),
(101000007, 0, 'Concessioni e licenze', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 1, 0, 'AB01004', '', '', '', 0, 0, '', 0, '', 'N', NULL, '', '2007-05-17 02:46:32'),
(420000002, 0, 'Lavorazioni per c/terzi', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 1, 0, '', 'EA00001', '', '', 0, 0, '', 0, '', 'N', NULL, '', '2007-05-17 02:46:32'),
(330000010, 0, 'Resi su acquisti', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 0, 0, '', 'EB00006', '', '', 0, 0, '', 0, '', 'N', NULL, 'amministratore', '2008-10-06 04:26:11'),
(214000000, 0, 'DEBITI COMMERCIALI', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 1, 0, '', '', '', '', 0, 0, '', 0, '', 'N', NULL, '', '2007-05-17 02:46:32'),
(339000020, 0, 'Minusvalenze ordinarie', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 1, 0, 'EB00014', '', '', '', 0, 0, '', 0, '', 'N', NULL, '', '2007-05-17 02:46:32'),
(215000000, 0, 'DEBITI DIVERSI', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 1, 0, '', '', '', '', 0, 0, '', 0, '', 'N', NULL, '', '2007-05-17 02:46:32'),
(420000003, 0, 'Rimborsi costi di vendita', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 1, 0, '', 'EA00001', '', '', 0, 0, '', 0, '', 'N', NULL, '', '2008-10-06 14:47:29'),
(330000011, 0, 'Ribassi e abbuoni attivi', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 0, 0, '', 'EB00006', '', '', 0, 0, '', 0, '', 'N', NULL, 'amministratore', '2008-10-06 06:54:48'),
(339000030, 0, 'Sopravvenienze passive ordinarie', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 1, 0, 'EB00014', '', '', '', 0, 0, '', 0, '', 'N', NULL, 'amministratore', '2010-11-12 00:00:26'),
(101000006, 0, 'Software', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 1, 0, 'AB01003', '', '', '', 0, 0, '', 0, '', 'N', NULL, '', '2007-05-17 02:46:32'),
(420000004, 0, 'Lavori su ordinazioni', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 1, 0, '', 'EA00001', '', '', 0, 0, '', 0, '', 'N', NULL, '', '2007-05-17 02:46:32'),
(330000012, 0, 'Premi su acquisti', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 0, 0, '', 'EB00006', '', '', 0, 0, '', 0, '', 'N', NULL, 'amministratore', '2008-10-06 04:26:48'),
(101000003, 0, 'Costi di ricerca e di sviluppo', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 1, 0, 'AB01002', '', '', '', 0, 0, '', 0, '', 'N', NULL, '', '2007-05-17 02:46:32'),
(101000004, 0, 'Costi di pubblicità patrimonializzati', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 0, 0, 'AB01002', '', '', '', 0, 0, '', 0, '', 'N', NULL, 'amministratore', '2008-10-03 09:21:56'),
(211000000, 0, 'FONDI PER RISCHI E ONERI', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 1, 0, '', '', '', '', 0, 0, '', 0, '', 'N', NULL, '', '2007-05-17 02:46:32'),
(101000005, 0, 'Brevetti industriali', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 1, 0, 'AB01003', '', '', '', 0, 0, '', 0, '', 'N', NULL, '', '2007-05-17 02:46:32'),
(110000000, 0, 'IMMOBILIZZAZIONI FINANZIARIE', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 1, 0, '', '', '', '', 0, 0, '', 0, '2424, attivo BIII: «Immobilizzazioni finanziarie, con separata indicazione, per ciascuna voce dei crediti, degli importi esigibili entro l`esercizio successivo»', 'N', NULL, 'amministratore', '2010-11-12 02:03:48'),
(109000000, 0, 'RATEI E RISCONTI ATTIVI', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 1, 0, '', '', '', '', 0, 0, '', 0, '2426, 7): «Il disaggio su prestiti deve essere iscritto nell`attivo e ammortizzato in ogni esercizio per il periodo di durata del prestito»', 'N', NULL, 'amministratore', '2010-11-12 01:54:59'),
(101000002, 0, 'Costi di ampliamento', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 1, 0, 'AB01001', '', '', '', 0, 0, '', 0, '', 'N', NULL, '', '2007-05-17 02:46:32'),
(108000000, 0, 'DISPONIBILITÀ LIQUIDE', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 0, 0, '', '', '', '', 0, 0, '', 0, '', 'N', NULL, 'amministratore', '2008-10-03 09:22:45'),
(115000000, 0, 'RIMANENZE', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 1, 0, '', '', '', '', 0, 0, '', 0, 'I semilavorati, in quanto materie prodotte internamente, vanno in bilancio alla voce CI2 dell`attivo (prodotti in corso di lavorazione e semilavorati); se invece si tratta di materie acquistate all`esterno, vanno collocate alla voce CI1 (materie prime, sussidiarie e di consumo).', 'N', NULL, 'amministratore', '2010-11-12 00:41:21'),
(105000000, 0, 'CREDITI COMMERCIALI', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 1, 0, '', '', '', '', 0, 0, '', 0, '2424, attivo CII: «Crediti, con separata indicazione, per ciascuna voce, degli importi esigibili oltre l`esercizio successivo»\n\n2426, 8): «I crediti devono essere iscritti secondo il valore presumibile di realizzazione»\n\nFanno parte dei crediti commerciali anche tutti i crediti verso clienti, che qui hanno invece un raggruppamento separato.\n', 'N', NULL, 'amministratore', '2010-11-12 01:59:03'),
(106000000, 0, 'CREDITI DIVERSI', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 1, 0, '', '', '', '', 0, 0, '', 0, '', 'N', NULL, '', '2007-05-17 02:46:32'),
(107000000, 0, 'ATTIVITÀ FINANZIARIE', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 0, 0, '', '', '', '', 0, 0, '', 0, '', 'N', NULL, 'amministratore', '2008-10-03 09:22:29'),
(101000001, 0, 'Costi d\'impianto', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 1, 0, 'AB01001', '', '', '', 0, 0, '', 0, '', 'N', NULL, '', '2007-05-17 02:46:32'),
(315000000, 0, 'COSTI PER SERVIZI', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 1, 0, '', '', '', '', 0, 0, '', 0, '', 'N', NULL, '', '2007-05-17 02:46:32'),
(102000000, 0, 'IMMOBILIZZAZIONI MATERIALI', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 1, 0, '', '', '', '', 0, 0, '', 0, '2426, 1): «Le immobilizzazioni sono iscritte al costo di acquisto o di produzione. Nel costo di acquisto si computano anche i costi accessori. Il costo di produzione comprende tutti i costi direttamente imputabili al prodotto. Può comprendere anche altri costi, per la quota ragionevolmente imputabile al prodotto, relativi al periodo di fabbricazione e fino al momento dal quale il bene può essere utilizzato; con gli stessi criteri possono essere aggiunti gli oneri relativi al finanziamento della fabbricazione, interna o presso terzi»\n\nI fondi ammortamento e i fondi svalutazione vanno a diminuire le voci a cui si riferiscono.', 'N', NULL, 'amministratore', '2010-11-12 01:52:35'),
(110000001, 0, 'Partecipazioni in controllate', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 1, 0, 'AB03001a', '', '', '', 0, 0, '', 0, '', 'N', NULL, '', '2007-05-17 02:46:32'),
(110000002, 0, 'Partecipazioni in collegate', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 1, 0, 'AB03001b', '', '', '', 0, 0, '', 0, '', 'N', NULL, '', '2007-05-17 02:46:32'),
(110000003, 0, 'Partecipazioni in controllanti', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 1, 0, 'AB03001c', '', '', '', 0, 0, '', 0, '', 'N', NULL, '', '2007-05-17 02:46:32'),
(110000004, 0, 'Partecipazioni diverse', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 1, 0, 'AB03001d', '', '', '', 0, 0, '', 0, '', 'N', NULL, '', '2007-05-17 02:46:32'),
(110000010, 0, 'Prestiti a controllate', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 1, 0, 'AB03002a', '', '', '', 0, 0, '', 0, '', 'N', NULL, '', '2007-05-17 02:46:32'),
(320000000, 0, 'COSTI PER GODIMENTO DI BENI DI TERZI', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 1, 0, '', '', '', '', 0, 0, '', 0, '', 'N', NULL, '', '2007-05-17 02:46:32'),
(110000011, 0, 'Prestiti a collegate', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 1, 0, 'AB03002b', '', '', '', 0, 0, '', 0, '', 'N', NULL, '', '2007-05-17 02:46:32'),
(110000012, 0, 'Prestiti a controllanti', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 1, 0, 'AB03002c', '', '', '', 0, 0, '', 0, '', 'N', NULL, '', '2007-05-17 02:46:32'),
(110000020, 0, 'Mutui attivi v/terzi', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 1, 0, 'AB03002d', '', '', '', 0, 0, '', 0, '', 'N', NULL, '', '2007-05-17 02:46:32'),
(110000040, 0, 'Azioni proprie', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 1, 0, 'AB03004', '', '', '', 0, 0, '', 0, '', 'N', NULL, '', '2007-05-17 02:46:32'),
(110000050, 0, 'Titoli immobilizzati', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 1, 0, 'AB03003', '', '', '', 0, 0, '', 0, '', 'N', NULL, '', '2007-05-17 02:46:32'),
(115000001, 0, 'Materie prime', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 1, 0, 'AC01001', '', '', '', 0, 0, '', 0, '', 'N', NULL, '', '2007-05-17 02:46:32'),
(210000013, 0, 'Riserva per rinnovi', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 1, 0, '', 'PA07000', '', '', 0, 0, '', 0, '', 'N', NULL, '', '2007-05-17 02:46:32'),
(370000000, 0, 'IMPOSTE DELL\'ESERCIZIO', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 1, 0, '', '', '', '', 0, 0, '', 0, '', 'N', NULL, '', '2007-05-17 02:46:32'),
(450000000, 0, 'RIVALUTAZIONI DI ATTIVITÀ FINANZIARIE', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 0, 0, '', '', '', '', 0, 0, '', 0, '', 'N', NULL, 'amministratore', '2008-10-06 01:35:05'),
(210000003, 0, 'Riserva da sopraprezzo azioni', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 1, 0, '', 'PA02000', '', '', 0, 0, '', 0, '', 'N', NULL, '', '2007-05-17 02:46:32'),
(351000000, 0, 'SVALUTAZIONI DI ATTIVITÀ FINANZIARIE', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 0, 0, '', '', '', '', 0, 0, '', 0, '', 'N', NULL, 'amministratore', '2008-10-03 09:23:02'),
(101000016, 0, 'Fondo ammortamento software', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 1, 0, '', 'AB01003', '', '', 0, 0, '', 0, '', 'N', NULL, '', '2007-05-17 02:46:32'),
(400000000, 0, 'PROVENTI FINANZIARI', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 1, 0, '', '', '', '', 0, 0, '', 0, '', 'N', NULL, '', '2007-05-17 02:46:32'),
(341000000, 0, 'ONERI FINANZIARI', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 1, 0, '', '', '', '', 0, 0, '', 0, '', 'N', NULL, '', '2007-05-17 02:46:32'),
(322000000, 0, 'COSTI PER IL PERSONALE', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 1, 0, '', '', '', '', 0, 0, '', 0, '', 'N', NULL, '', '2007-05-17 02:46:32'),
(340000000, 0, 'AMMORTAMENTI IMMOBILIZZAZIONI IMMATERIALI', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 1, 0, '', '', '', '', 0, 0, '', 0, '', 'N', NULL, '', '2007-05-17 02:46:32'),
(350000000, 0, 'AMMORTAMENTI IMMOBILIZZAZIONI MATERIALI', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 1, 0, '', '', '', '', 0, 0, '', 0, '', 'N', NULL, '', '2007-05-17 02:46:32'),
(210000012, 0, 'Versamenti in c/aumento di capitale', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 0, 0, '', 'PA01000', '', '', 0, 0, '', 0, '', 'N', NULL, 'amministratore', '2008-10-07 10:29:32'),
(320000002, 0, 'Canoni leasing', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 1, 0, 'EB00008', '', '', '', 0, 0, '', 0, '', 'N', NULL, '', '2007-05-17 02:46:32'),
(210000008, 0, 'Riserva straordinaria', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 1, 0, '', 'PA07000', '', '', 0, 0, '', 0, '', 'N', NULL, '', '2007-05-17 02:46:32'),
(101000017, 0, 'Fondo ammortamento concessioni e licenze', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 1, 0, '', 'AB01004', '', '', 0, 0, '', 0, '', 'N', NULL, '', '2007-05-17 02:46:32'),
(199000000, 0, 'SISTEMI MINORI', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 1, 0, '', '', '', '', 0, 0, '', 0, 'Conti di memoria o conti d`ordine.', 'N', NULL, 'amministratore', '2010-11-12 01:17:18'),
(400000001, 0, 'Proventi da partecipazioni', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 1, 0, '', 'EC00015', '', '', 0, 0, '', 0, '', 'N', NULL, '', '2007-05-17 02:46:32'),
(322000001, 0, 'Salari e stipendi', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 1, 0, 'EB00009a', '', '', '', 0, 0, '', 0, '', 'N', NULL, '', '2008-10-06 06:54:48'),
(101000018, 0, 'Fondo ammortamento avviamento', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 1, 0, '', 'AB01005', '', '', 0, 0, '', 0, '', 'N', NULL, '', '2007-05-17 02:46:32'),
(341000001, 0, 'Interessi passivi verso fornitori', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 1, 0, 'EC00017', '', '', '', 0, 0, '', 0, '', 'N', NULL, '', '2007-05-17 02:46:32'),
(315000002, 0, 'Costi per energia', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 1, 0, 'EB00007', '', '', '', 0, 0, '', 0, '', 'N', NULL, '', '2007-05-17 02:46:32'),
(299000000, 0, 'SISTEMI MINORI', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 1, 0, '', '', '', '', 0, 0, '', 0, 'Conti di memoria o di conti d`ordine.', 'N', NULL, 'amministratore', '2010-11-12 01:16:40'),
(450000001, 0, 'Rivalutazione partecipazioni', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 1, 0, '', 'ED00018a', '', '', 0, 0, '', 0, '', 'N', NULL, '', '2007-05-17 02:46:32'),
(341000002, 0, 'Interessi passivi bancari', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 1, 0, 'EC00017', '', '', '', 0, 0, '', 0, '', 'N', NULL, '', '2007-05-17 02:46:32'),
(322000002, 0, 'Oneri sociali', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 1, 0, 'EB00009b', '', '', '', 0, 0, '', 0, '', 'N', NULL, '', '2008-10-06 06:54:48'),
(101000030, 0, 'Immobilizzazioni immateriali in corso', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 0, 0, 'AB01006', '', '', '', 0, 0, '', 0, '', 'N', NULL, 'amministratore', '2008-10-04 04:08:34'),
(450000005, 0, 'Rivalutazione titoli', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 1, 0, '', 'ED00018c', '', '', 0, 0, '', 0, '', 'N', NULL, '', '2007-05-17 02:46:32'),
(400000010, 0, 'Interessi attivi v/controllate', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 1, 0, '', 'EC00016a', '', '', 0, 0, '', 0, '', 'N', NULL, '', '2007-05-17 02:46:32'),
(341000003, 0, 'Sconti passivi bancari', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 1, 0, 'EC00017', '', '', '', 0, 0, '', 0, '', 'N', NULL, '', '2007-05-17 02:46:32'),
(322000003, 0, 'TFRL', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 1, 0, 'EB00009c', '', '', '', 0, 0, '', 0, '', 'N', NULL, '', '2008-10-06 06:54:33'),
(400000011, 0, 'Interessi attivi v/collegate', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 1, 0, '', 'EC00016a', '', '', 0, 0, '', 0, '', 'N', NULL, '', '2007-05-17 02:46:32'),
(101000031, 0, 'Fornitori immobilizzazioni immateriali c/acconti', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 0, 0, 'AB01006', '', '', '', 0, 0, '', 0, '', 'N', NULL, 'amministratore', '2008-10-07 09:52:47'),
(341000010, 0, 'Interessi passivi su mutui', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 1, 0, 'EC00017', '', '', '', 0, 0, '', 0, '', 'N', NULL, '', '2007-05-17 02:46:32'),
(351000001, 0, 'Svalutazione partecipazioni', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 1, 0, 'ED00019a', '', '', '', 0, 0, '', 0, '', 'N', NULL, '', '2007-05-17 02:46:32'),
(400000012, 0, 'Interessi Attivi v/controllanti', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 1, 0, '', 'EC00016a', '', '', 0, 0, '', 0, '', 'N', NULL, '', '2007-05-17 02:46:32'),
(341000012, 0, 'Interessi su obbligazioni', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 1, 0, 'EC00017', '', '', '', 0, 0, '', 0, '', 'N', NULL, '', '2007-05-17 02:46:32'),
(315000003, 0, 'Costi di publicita', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 1, 0, 'EB00007 ', ' ', '', '', 0, 0, '', 0, '', 'N', NULL, 'amministratore', '2007-05-17 02:46:32'),
(351000005, 0, 'Svalutazione titoli', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 1, 0, 'ED00019a', '', '', '', 0, 0, '', 0, '', 'N', NULL, '', '2007-05-17 02:46:32'),
(102000001, 0, 'Terreni e fabbricati', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 1, 0, 'AB02001', '', '', '', 0, 0, '', 0, '', 'N', NULL, '', '2008-10-06 06:54:48'),
(102000015, 0, 'Fondo ammortamento macchine d\'ufficio', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 1, 0, '', 'AB02004', '', '', 0, 0, '', 0, '', 'N', NULL, '', '2008-10-06 06:54:38'),
(341000013, 0, 'Ammortamento disagio', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 1, 0, 'EC00017', '', '', '', 0, 0, '', 0, '', 'N', NULL, '', '2007-05-17 02:46:32'),
(400000015, 0, 'Proventi su titolo immobilizzati', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 1, 0, '', 'EC00016b', '', '', 0, 0, '', 0, '', 'N', NULL, '', '2007-05-17 02:46:32'),
(102000002, 0, 'Impianti e macchinari', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 1, 0, 'AB02002', '', '', '', 0, 0, '', 0, '', 'N', NULL, '', '2007-05-17 02:46:32'),
(103000000, 0, 'CREDITI V/CLIENTI', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 0, 0, 'AC02001', '', '', '', 0, 0, '', 0, '', 'N', NULL, 'amministratore', '2008-10-03 09:26:20'),
(102000003, 0, 'Attrezzature industriali', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 1, 0, 'AB02003', '', '', '', 0, 0, '', 0, '', 'N', NULL, '', '2007-05-17 02:46:32'),
(102000004, 0, 'Attrezzature commerciali', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 1, 0, 'AB02003', '', '', '', 0, 0, '', 0, '', 'N', NULL, '', '2007-05-17 02:46:32'),
(400000020, 0, 'Interessi su titoli', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 1, 0, '', 'EC00016c', '', '', 0, 0, '', 0, '', 'N', NULL, '', '2007-05-17 02:46:32'),
(210000032, 0, 'Perdita d\'esercizio', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 0, 0, 'PA09000', '', '', '', 0, 0, '', 0, '', 'N', NULL, 'amministratore', '2008-10-07 10:31:41'),
(315000004, 0, 'Consulenze', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 1, 0, 'EB00007', '', '', '', 0, 0, '', 0, '', 'N', NULL, '', '2008-10-06 06:54:48'),
(460000001, 0, 'Plusvalenze straordinarie', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 1, 0, '', 'ED00020', '', '', 0, 0, '', 0, '', 'N', NULL, '', '2007-05-17 02:46:32'),
(212000000, 0, 'DEBITI V/FORNITORI', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 0, 0, '', 'PD00007', '', '', 0, 0, '', 0, '', 'N', NULL, 'amministratore', '2008-10-04 03:15:55'),
(400000025, 0, 'Utile su titoli', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 1, 0, '', 'EC00016c', '', '', 0, 0, '', 0, '', 'N', NULL, '', '2007-05-17 02:46:32'),
(340000002, 0, 'Ammortamento costi di ampliamento', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 1, 0, 'EB00010a', '', '', '', 0, 0, '', 0, '', 'N', NULL, '', '2007-05-17 02:46:32'),
(102000005, 0, 'Macchine d\'ufficio', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 1, 0, 'AB02004', '', '', '', 0, 0, '', 0, '', 'N', NULL, '', '2008-10-06 06:54:48'),
(588000010, 0, 'IVA c/liquidazione', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 0, 0, '', '', '', '', 0, 0, '', 0, '', 'N', NULL, 'amministratore', '2008-09-27 06:58:53'),
(400000030, 0, 'Interessi attivi v/clienti', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 1, 0, '', 'EC00016d', '', '', 0, 0, '', 0, '', 'N', NULL, '', '2007-05-17 02:46:32'),
(102000006, 0, 'Arredamento', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 1, 0, 'AB02004', '', '', '', 0, 0, '', 0, '', 'N', NULL, '', '2008-10-04 03:45:43'),
(460000002, 0, 'Sopravvenienze attive straordinarie', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 1, 0, '', 'ED00020', '', '', 0, 0, '', 0, '', 'N', NULL, '', '2007-05-17 02:46:32'),
(588000011, 0, 'Istituti previdenziali', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 1, 0, '', '', '', '', 0, 0, '', 0, '', 'N', NULL, '', '2008-10-06 06:54:48'),
(400000031, 0, 'Interessi attivi bancari', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 1, 0, '', 'EC00016d', '', '', 0, 0, '', 0, '', 'N', NULL, '', '2007-05-17 02:46:32'),
(315000005, 0, 'Costi postali', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 1, 0, 'EB00007', '', '', '', 0, 0, '', 0, '', 'N', NULL, '', '2007-05-17 02:46:32'),
(341000015, 0, 'Premi di rimborso', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 1, 0, 'EC00017', '', '', '', 0, 0, '', 0, '', 'N', NULL, '', '2007-05-17 02:46:32'),
(102000007, 0, 'Automezzi', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 1, 0, 'AB02004', '', '', '', 0, 0, '', 0, '', 'N', NULL, '', '2007-05-17 02:46:32'),
(340000001, 0, 'Ammortamento costo di impianto', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 1, 0, 'EB00010a', '', '', '', 0, 0, '', 0, '', 'N', NULL, '', '2007-05-17 02:46:32'),
(400000032, 0, 'Interessi attivi postali', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 1, 0, '', 'EC00016d', '', '', 0, 0, '', 0, '', 'N', NULL, '', '2007-05-17 02:46:32'),
(341000016, 0, 'Interessi passivi su cambiali', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 1, 0, 'EC00017', '', '', '', 0, 0, '', 0, '', 'N', NULL, '', '2007-05-17 02:46:32'),
(210000014, 0, 'Riserva ammortamenti anticipati', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 1, 0, '', 'PA07000', '', '', 0, 0, '', 0, '', 'N', NULL, '', '2007-05-17 02:46:32'),
(315000008, 0, 'Costi di vigilanza', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 1, 0, 'EB00007', '', '', '', 0, 0, '', 0, '', 'N', NULL, '', '2007-05-17 02:46:32'),
(102000008, 0, 'Imballaggi durevoli', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 1, 0, 'AB02004', '', '', '', 0, 0, '', 0, '', 'N', NULL, '', '2007-05-17 02:46:32'),
(361000001, 0, 'Minusvalenze straordinarie', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 1, 0, 'ED00021', '', '', '', 0, 0, '', 0, '', 'N', NULL, '', '2007-05-17 02:46:32'),
(588000030, 0, 'Personale c/arrotondamenti', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 1, 0, '', '', '', '', 0, 0, '', 0, '', 'N', NULL, '', '2007-05-17 02:46:32'),
(341000020, 0, 'Interessi passivi v/controllate', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 1, 0, 'EC00017', '', '', '', 0, 0, '', 0, '', 'N', NULL, '', '2007-05-17 02:46:32'),
(400000060, 0, 'Proventi finanziari diversi', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 1, 0, '', 'EC00016d', '', '', 0, 0, '', 0, '', 'N', NULL, '', '2007-05-17 02:46:32');
INSERT INTO `gaz_001clfoco` (`codice`, `id_anagra`, `descri`, `ref_ecommerce_id_customer`, `print_map`, `external_resp`, `external_service_descri`, `id_agente`, `banapp`, `portos`, `spediz`, `imball`, `listin`, `destin`, `id_des`, `iban`, `sia_code`, `cuc_code`, `maxrat`, `ragdoc`, `addbol`, `speban`, `spefat`, `stapre`, `codpag`, `sconto`, `sconto_rigo`, `aliiva`, `ritenuta`, `allegato`, `cosric`, `ceedar`, `ceeave`, `paymov`, `operation_type`, `id_assets`, `sel4esp_art`, `status`, `status_SIAN`, `annota`, `visannota`, `custom_field`, `adminid`, `last_modified`) VALUES
(210000016, 0, 'Riserva contributi in c/capitale', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 1, 0, '', 'PA07000', '', '', 0, 0, '', 0, '', 'N', NULL, '', '2007-05-17 02:46:32'),
(315000006, 0, 'Costi telefonici', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 1, 0, 'EB00007', '', '', '', 0, 0, '', 0, '', 'N', NULL, '', '2007-05-17 02:46:32'),
(199000001, 0, 'Beni di terzi', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 1, 0, '', '', '', '', 0, 0, '', 0, '', 'N', NULL, '', '2007-05-17 02:46:32'),
(588000031, 0, 'Societa di factoring c/c', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 1, 0, ' ', ' ', '', '', 0, 0, '', 0, '', 'N', NULL, 'amministratore', '2007-05-17 02:46:32'),
(361000002, 0, 'Sopravvenienze passive straordinarie', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 1, 0, 'ED00021', '', '', '', 0, 0, '', 0, '', 'N', NULL, '', '2007-05-17 02:46:32'),
(341000021, 0, 'Interessi passivi v/collegate', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 1, 0, 'EC00017', '', '', '', 0, 0, '', 0, '', 'N', NULL, '', '2007-05-17 02:46:32'),
(102000011, 0, 'Fondo ammortamento fabbricati', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 1, 0, '', 'AB02001', '', '', 0, 0, '', 0, '', 'N', NULL, '', '2008-10-06 06:54:48'),
(102000014, 0, 'Fondo ammortamento attrezzature commerciali', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 1, 0, '', 'AB02003', '', '', 0, 0, '', 0, '', 'N', NULL, '', '2007-05-17 02:46:32'),
(361000003, 0, 'Imposte esercizi precedenti', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 1, 0, 'ED00021', '', '', '', 0, 0, '', 0, '', 'N', NULL, '', '2007-05-17 02:46:32'),
(341000022, 0, 'Interessi passivi v/controllanti', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 1, 0, 'EC00017', '', '', '', 0, 0, '', 0, '', 'N', NULL, '', '2007-05-17 02:46:32'),
(210000021, 0, 'Utile a nuovo', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 1, 0, '', 'PA08000', '', '', 0, 0, '', 0, '', 'N', NULL, '', '2007-05-17 02:46:32'),
(315000007, 0, 'Assicurazioni', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 1, 0, 'EB00007', '', '', '', 0, 0, '', 0, '', 'N', NULL, '', '2007-05-17 02:46:32'),
(102000012, 0, 'Fondo ammortamento impianti e macchinari', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 1, 0, '', 'AB02002', '', '', 0, 0, '', 0, '', 'N', NULL, '', '2007-05-17 02:46:32'),
(210000022, 0, 'Perdite a nuovo', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 0, 0, 'PA08000', '', '', '', 0, 0, '', 0, '', 'N', NULL, 'amministratore', '2008-10-04 04:39:03'),
(341000030, 0, 'Perdite su titoli', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 1, 0, 'EC00017', '', '', '', 0, 0, '', 0, '', 'N', NULL, '', '2007-05-17 02:46:32'),
(102000013, 0, 'Fondo ammortamento attrezzature industriali', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 1, 0, '', 'AB02003', '', '', 0, 0, '', 0, '', 'N', NULL, '', '2007-05-17 02:46:32'),
(370000001, 0, 'Imposte dell\'esercizio', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 1, 0, 'E 00022', '', '', '', 0, 0, '', 0, '', 'N', NULL, '', '2008-10-06 06:54:22'),
(341000040, 0, 'Oneri finanziari diversi', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 1, 0, 'EC00017', '', '', '', 0, 0, '', 0, '', 'N', NULL, '', '2007-05-17 02:46:32'),
(210000031, 0, 'Utile d\'esercizio', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 0, 0, '', 'PA09000', '', '', 0, 0, '', 0, '', 'N', NULL, 'amministratore', '2008-10-07 10:30:56'),
(299000001, 0, 'Depositanti beni di terzi', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 1, 0, '', '', '', '', 0, 0, '', 0, '', 'N', NULL, '', '2007-05-17 02:46:32'),
(340000003, 0, 'Ammortamento costi di ricerca e sviluppo', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 1, 0, 'EB00010a', '', '', '', 0, 0, '', 0, '', 'N', NULL, '', '2007-05-17 02:46:32'),
(315000009, 0, 'Costi per i locali', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 1, 0, 'EB00007', '', '', '', 0, 0, '', 0, '', 'N', NULL, '', '2007-05-17 02:46:32'),
(102000016, 0, 'Fondo ammortamento arredamento', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 1, 0, '', 'AB02004', '', '', 0, 0, '', 0, '', 'N', NULL, '', '2008-10-04 03:45:43'),
(199000002, 0, 'Materie da ricevere', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 1, 0, '', '', '', '', 0, 0, '', 0, '', 'N', NULL, '', '2007-05-17 02:46:32'),
(340000004, 0, 'Ammortamento costi di pubblicità', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 0, 0, 'EB00010a', '', '', '', 0, 0, '', 0, '', 'N', NULL, 'amministratore', '2008-10-03 09:23:43'),
(299000002, 0, 'Fornitori c/impegni', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 1, 0, '', '', '', '', 0, 0, '', 0, '', 'N', NULL, '', '2007-05-17 02:46:32'),
(102000017, 0, 'Fondo ammortamento automezzi', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 1, 0, '', 'AB02004', '', '', 0, 0, '', 0, '', 'N', NULL, '', '2007-05-17 02:46:32'),
(340000005, 0, 'Ammortamento brevetti', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 1, 0, 'EB00010a', '', '', '', 0, 0, '', 0, '', 'N', NULL, '', '2007-05-17 02:46:32'),
(109000001, 0, 'Ratei attivi', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 0, 0, 'AD00001', '', '', '', 0, 0, '', 0, '', 'N', NULL, 'amministratore', '2008-10-04 04:25:00'),
(217000001, 0, 'Debiti per TFRL', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 1, 0, '', 'PC00000', '', '', 0, 0, '', 0, '', 'N', NULL, '', '2008-10-06 06:54:48'),
(199000003, 0, 'Clienti c/impegni', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 1, 0, '', '', '', '', 0, 0, '', 0, '', 'N', NULL, '', '2007-05-17 02:46:32'),
(213000001, 0, 'Prestiti obbligazionari', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 1, 0, '', 'PD00001', '', '', 0, 0, '', 0, '', 'N', NULL, '', '2007-05-17 02:46:32'),
(340000006, 0, 'Ammortamento software', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 1, 0, 'EB00010a', '', '', '', 0, 0, '', 0, '', 'N', NULL, '', '2007-05-17 02:46:32'),
(299000003, 0, 'Prodotti da consegnare', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 1, 0, '', '', '', '', 0, 0, '', 0, '', 'N', NULL, '', '2007-05-17 02:46:32'),
(102000018, 0, 'Fondo ammortamento imballaggi durevoli', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 1, 0, '', 'AB02004', '', '', 0, 0, '', 0, '', 'N', NULL, '', '2007-05-17 02:46:32'),
(340000007, 0, 'Ammortamento concessioni e licenze', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 1, 0, 'EB00010a', '', '', '', 0, 0, '', 0, '', 'N', NULL, '', '2007-05-17 02:46:32'),
(199000004, 0, 'Impegni per beni in leasing', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 1, 0, '', '', '', '', 0, 0, '', 0, '', 'N', NULL, '', '2007-05-17 02:46:32'),
(211000002, 0, 'Fondo per imposte', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 0, 0, '', 'PB00002', '', '', 0, 0, '', 0, '', 'N', NULL, 'amministratore', '2008-10-04 04:42:40'),
(213000002, 0, 'Prestiti obbligazionari convertibili', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 1, 0, '', 'PD00002', '', '', 0, 0, '', 0, '', 'N', NULL, '', '2007-05-17 02:46:32'),
(340000008, 0, 'Ammortamento avviamento', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 1, 0, 'EB00010a', '', '', '', 0, 0, '', 0, '', 'N', NULL, '', '2007-05-17 02:46:32'),
(299000004, 0, 'Creditori c/leasing', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 1, 0, '', '', '', '', 0, 0, '', 0, '', 'N', NULL, '', '2007-05-17 02:46:32'),
(102000021, 0, 'Fondo svalutazione terreni e fabbricati', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 1, 0, '', 'AB02001', '', '', 0, 0, '', 0, '', 'N', NULL, '', '2007-05-17 02:46:32'),
(109000002, 0, 'Risconti attivi', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 0, 0, 'AD00002', '', '', '', 0, 0, '', 0, '', 'N', NULL, 'amministratore', '2008-10-04 04:25:27'),
(199000005, 0, 'Rischi per effetti scontati', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 1, 0, '', '', '', '', 0, 0, '', 0, '', 'N', NULL, '', '2007-05-17 02:46:32'),
(109000003, 0, 'Disaggio su prestiti', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 0, 0, 'AD00003', '', '', '', 0, 0, '', 0, '', 'N', NULL, 'amministratore', '2008-10-04 04:26:34'),
(315000010, 0, 'Costi esercizio automezzi', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 1, 0, 'EB00007', '', '', '', 0, 0, '', 0, '', 'N', NULL, '', '2007-05-17 02:46:32'),
(102000022, 0, 'Fondo svalutazione impianti', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 1, 0, '', 'AB02002', '', '', 0, 0, '', 0, '', 'N', NULL, '', '2007-05-17 02:46:32'),
(350000001, 0, 'Ammortamento fabbricati', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 1, 0, 'EB00010b', '', '', '', 0, 0, '', 0, '', 'N', NULL, '', '2008-10-06 06:54:36'),
(350000002, 0, 'Ammortamento impianti e macchinari', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 1, 0, 'EB00010b', '', '', '', 0, 0, '', 0, '', 'N', NULL, '', '2007-05-17 02:46:32'),
(211000004, 0, 'Fondo resposabilità civile', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 1, 0, ' ', 'PB00003 ', '', '', 0, 0, '', 0, '', 'N', NULL, 'amministratore', '2007-05-17 02:46:32'),
(350000003, 0, 'Ammortamento attrezzature industriali', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 1, 0, 'EB00010b', '', '', '', 0, 0, '', 0, '', 'N', NULL, '', '2007-05-17 02:46:32'),
(213000040, 0, 'Debiti v/altri finanziatori', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 0, 0, '', 'PD00005', '', '', 0, 0, '', 0, '', 'N', NULL, 'amministratore', '2008-10-04 04:51:51'),
(299000005, 0, 'Banche c/effetti scontati', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 1, 0, '', '', '', '', 0, 0, '', 0, '', 'N', NULL, '', '2007-05-17 02:46:32'),
(211000010, 0, 'Fondo garanzie prodotti', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 1, 0, '', 'PB00003', '', '', 0, 0, '', 0, '', 'N', NULL, '', '2007-05-17 02:46:32'),
(350000004, 0, 'Ammortamento attrezzature commerciali', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 1, 0, 'EB00010b', '', '', '', 0, 0, '', 0, '', 'N', NULL, '', '2007-05-17 02:46:32'),
(199000006, 0, 'Rischi per fideiussioni', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 1, 0, '', '', '', '', 0, 0, '', 0, '', 'N', NULL, '', '2007-05-17 02:46:32'),
(211000011, 0, 'Fondo manutenzioni programmate', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 1, 0, '', 'PB00003', '', '', 0, 0, '', 0, '', 'N', NULL, '', '2007-05-17 02:46:32'),
(350000005, 0, 'Ammortamento macchine d\'ufficio', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 1, 0, 'EB00010b', '', '', '', 0, 0, '', 0, '', 'N', NULL, '', '2008-10-06 06:54:38'),
(299000006, 0, 'Creditori per fideiussioni', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 1, 0, '', '', '', '', 0, 0, '', 0, '', 'N', NULL, '', '2007-05-17 02:46:32'),
(350000006, 0, 'Ammortamento arredamento', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 1, 0, 'EB00010b', '', '', '', 0, 0, '', 0, '', 'N', NULL, '', '2007-05-17 02:46:32'),
(315000011, 0, 'Manutenzioni e riparazioni', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 1, 0, 'EB00007', '', '', '', 0, 0, '', 0, '', 'N', NULL, '', '2007-05-17 02:46:32'),
(211000012, 0, 'Fondo buoni sconto e concorsi a premio', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 0, 0, '', 'PB00003', '', '', 0, 0, '', 0, '', 'N', NULL, 'amministratore', '2008-10-07 10:37:58'),
(199000007, 0, 'Rischi per avalli', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 1, 0, '', '', '', '', 0, 0, '', 0, '', 'N', NULL, '', '2007-05-17 02:46:32'),
(350000007, 0, 'Ammortamento automezzi', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 1, 0, 'EB00010b', '', '', '', 0, 0, '', 0, '', 'N', NULL, '', '2007-05-17 02:46:32'),
(299000007, 0, 'Creditori per avalli', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 1, 0, '', '', '', '', 0, 0, '', 0, '', 'N', NULL, '', '2007-05-17 02:46:32'),
(350000008, 0, 'Ammortamento imballaggi durevoli', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 1, 0, 'EB00010b', '', '', '', 0, 0, '', 0, '', 'N', NULL, '', '2007-05-17 02:46:32'),
(213000032, 0, 'Prestiti da controllanti', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 0, 0, '', 'PD00011', '', '', 0, 0, '', 0, '', 'N', NULL, 'amministratore', '2008-10-04 04:51:25'),
(108000020, 0, 'Assegni', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 0, 0, 'AC04002', '', '', '', 0, 0, '', 0, '', 'N', NULL, 'amministratore', '2008-10-04 04:22:12'),
(115000003, 0, 'Materie di consumo', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 1, 0, 'AC01001', '', '', '', 0, 0, '', 0, '', 'N', NULL, '', '2007-05-17 02:46:32'),
(108000030, 0, 'Denaro in cassa', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 0, 0, 'AC04003', '', '', '', 0, 0, '', 0, '', 'N', NULL, 'amministratore', '2008-10-06 06:54:48'),
(315000012, 0, 'Provvigioni passive', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 1, 0, 'EB00007', '', '', '', 0, 0, '', 0, '', 'N', NULL, '', '2007-05-17 02:46:32'),
(213000031, 0, 'Prestiti da collegate', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 1, 0, '', 'PD00009', '', '', 0, 0, '', 0, '', 'N', NULL, '', '2007-05-17 02:46:32'),
(115000004, 0, 'Prodotti in lavorazione', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 1, 0, 'AC01002', '', '', '', 0, 0, '', 0, '', 'N', NULL, '', '2007-05-17 02:46:32'),
(108000031, 0, 'Valori bollati', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 0, 0, 'AC04003', '', '', '', 0, 0, '', 0, '', 'N', NULL, 'amministratore', '2008-10-04 04:22:48'),
(115000005, 0, 'Semilavorati', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 1, 0, 'AC01002', '', '', '', 0, 0, '', 0, '', 'N', NULL, '', '2007-05-17 02:46:32'),
(213000030, 0, 'Prestiti da controllate', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 0, 0, '', 'PD00009', '', '', 0, 0, '', 0, '', 'N', NULL, 'amministratore', '2008-10-04 04:50:41'),
(588000033, 0, 'Gestione titoli', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 1, 0, '', '', '', '', 0, 0, '', 0, '', 'N', NULL, '', '2007-05-17 02:46:32'),
(107000001, 0, 'Partecipazioni', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 1, 0, 'AC03004', '', '', '', 0, 0, '', 0, '', 'N', NULL, '', '2007-05-17 02:46:32'),
(115000006, 0, 'Lavori in corso su ordinazione', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 1, 0, 'AC01003', '', '', '', 0, 0, '', 0, '', 'N', NULL, '', '2007-05-17 02:46:32'),
(420000005, 0, 'Prodotti c/vendite interne', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 1, 0, '', 'EA00001', '', '', 0, 0, '', 0, '', 'N', NULL, '', '2007-05-17 02:46:32'),
(115000007, 0, 'Prodotti finiti', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 1, 0, 'AC01004', '', '', '', 0, 0, '', 0, '', 'N', NULL, '', '2007-05-17 02:46:32'),
(106000006, 0, 'IVA c/acconto', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 0, 0, 'AC02004b', '', '', '', 0, 0, '', 0, 'Non dovrebbe affluire direttamente in bilancio: il saldo deve essere trasferito nel conto IVA c/liquidazione (conto transitorio), il quale, a sua volta, deve essere trasferito nel conto Crediti per IVA o Debiti per IVA, a seconda del segno che si trova ad avere.', 'N', NULL, 'amministratore', '2010-11-12 00:57:24'),
(107000004, 0, 'Azioni proprie da annullare', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 0, 0, 'AC03005', '', '', '', 0, 0, '', 0, '', 'N', NULL, 'amministratore', '2008-10-07 10:15:39'),
(115000010, 0, 'Fornitori materie c/acconti', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 0, 0, 'AC01005', '', '', '', 0, 0, '', 0, '', 'N', NULL, 'amministratore', '2008-10-03 09:24:03'),
(213000025, 0, 'Cambiali passive finanziarie', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 0, 0, '', 'PD00008', '', '', 0, 0, '', 0, '', 'N', NULL, 'amministratore', '2008-10-04 04:50:24'),
(107000005, 0, 'Titoli', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 0, 0, 'AC03006', '', '', '', 0, 0, '', 0, '', 'N', NULL, 'amministratore', '2008-10-07 10:14:57'),
(213000020, 0, 'Mutui ipotecari', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 0, 0, '', 'PD00004', '', '', 0, 0, '', 0, '', 'N', NULL, 'amministratore', '2008-10-04 04:48:30'),
(107000007, 0, 'Obbligazioni sociali', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 0, 0, 'AC03006', '', '', '', 0, 0, '', 0, '', 'N', NULL, 'amministratore', '2008-10-07 10:16:01'),
(214000020, 0, 'Cambiali passive', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 0, 0, '', 'PD00008', '', '', 0, 0, '', 0, '', 'N', NULL, 'amministratore', '2008-10-06 06:54:48'),
(315000021, 0, 'Competenze sindacali', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 1, 0, 'EB00007', '', '', '', 0, 0, '', 0, '', 'N', NULL, '', '2007-05-17 02:46:32'),
(213000016, 0, 'Banche c/sovvenzioni garantite', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 0, 0, '', 'PD00004', '', '', 0, 0, '', 0, '', 'N', NULL, 'amministratore', '2008-10-04 04:48:08'),
(105000002, 0, 'Crediti commerciali diversi', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 0, 0, 'AC02001', '', '', '', 0, 0, '', 0, '', 'N', NULL, 'amministratore', '2008-10-04 04:12:52'),
(213000015, 0, 'Banche c/sovvenzioni cambiarie', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 0, 0, '', 'PD00004', '', '', 0, 0, '', 0, '', 'N', NULL, 'amministratore', '2008-10-04 04:47:44'),
(214000040, 0, 'Debiti v/controllate', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 0, 0, '', 'PD00009', '', '', 0, 0, '', 0, '', 'N', NULL, 'amministratore', '2008-10-04 04:55:00'),
(105000003, 0, 'Clienti c/costi anticipati', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 0, 0, 'AC02001', '', '', '', 0, 0, '', 0, '', 'N', NULL, 'amministratore', '2008-10-03 09:24:58'),
(106000001, 0, 'IVA ns/credito', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 1, 0, 'AC02004b', '', '', '', 0, 0, '', 0, 'Non dovrebbe affluire direttamente in bilancio: il saldo deve essere trasferito nel conto IVA c/liquidazione (conto transitorio), il quale, a sua volta, deve essere trasferito nel conto Crediti per IVA o Debiti per IVA, a seconda del segno che si trova ad avere.', 'N', NULL, 'amministratore', '2010-11-12 00:55:05'),
(213000012, 0, 'Banche c/cambiali all\'incasso', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 0, 0, '', 'PD00004', '', '', 0, 0, '', 0, '', 'N', NULL, 'amministratore', '2008-10-04 04:47:27'),
(105000004, 0, 'Crediti fattorizzati', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 1, 0, 'AC02001', '', '', '', 0, 0, '', 0, '', 'N', NULL, '', '2007-05-17 02:46:32'),
(214000041, 0, 'Debiti v/collegate', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 0, 0, '', 'PD00010', '', '', 0, 0, '', 0, '', 'N', NULL, 'amministratore', '2008-10-04 04:55:09'),
(105000005, 0, 'Cambiali attive', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 1, 0, 'AC02001', '', '', '', 0, 0, '', 0, '', 'N', NULL, '', '2008-10-06 06:54:48'),
(106000002, 0, 'Imposte c/acconto', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 0, 0, 'AC02004b', '', '', '', 0, 0, '', 0, 'Non dovrebbe affluire direttamente in bilancio: il saldo si compensa con il debito per le imposte di competenza.', 'N', NULL, 'amministratore', '2010-11-12 00:55:35'),
(105000006, 0, 'Cambiali allo sconto', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 1, 0, 'AC02001', '', '', '', 0, 0, '', 0, '', 'N', NULL, '', '2007-05-17 02:46:32'),
(214000042, 0, 'Debiti v/controllanti', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 0, 0, '', 'PD00011', '', '', 0, 0, '', 0, '', 'N', NULL, 'amministratore', '2008-10-04 04:55:37'),
(105000007, 0, 'Cambiali all\'incasso', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 1, 0, 'AC02001', '', '', '', 0, 0, '', 0, '', 'N', NULL, '', '2008-10-06 14:47:26'),
(106000003, 0, 'Crediti per ritenute subite', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 0, 0, 'AC02004b', '', '', '', 0, 0, '', 0, 'Non dovrebbe affluire direttamente in bilancio: il saldo si compensa con il debito per le imposte di competenza.', 'N', NULL, 'amministratore', '2010-11-12 00:55:58'),
(213000011, 0, 'Banche c/ri.ba. all\'ncasso', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 0, 0, '', 'PD00004', '', '', 0, 0, '', 0, '', 'N', NULL, 'amministratore', '2008-10-04 04:47:09'),
(106000004, 0, 'Crediti d\'imposta', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 0, 0, 'AC02004b', '', '', '', 0, 0, '', 0, 'Non dovrebbe affluire direttamente in bilancio: il saldo si compensa con il debito per le imposte di competenza.', 'N', NULL, 'amministratore', '2010-11-12 00:56:27'),
(105000010, 0, 'Crediti insoluti', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 1, 0, 'AC02001', '', '', '', 0, 0, '', 0, '', 'N', NULL, '', '2007-05-17 02:46:32'),
(598000000, 0, 'BILANCI (TRANSITORI)', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 1, 0, '', '', '', '', 0, 0, '', 0, '', 'N', NULL, '', '2007-05-17 02:46:32'),
(106000005, 0, 'Crediti per IVA', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 1, 0, 'AC02004b', '', '', '', 0, 0, '', 0, '', 'N', NULL, '', '2007-05-17 02:46:32'),
(105000011, 0, 'Cambiali insolute', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 1, 0, 'AC02001', '', '', '', 0, 0, '', 0, '', 'N', NULL, '', '2007-05-17 02:46:32'),
(106000007, 0, 'Crediti per imposte', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 1, 0, 'AC02004b', '', '', '', 0, 0, '', 0, '', 'N', NULL, '', '2007-05-17 02:46:32'),
(213000005, 0, 'Azionisti c/finanziamenti', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 0, 0, '', 'PD00003', '', '', 0, 0, '', 0, '', 'N', NULL, 'amministratore', '2008-10-07 10:40:06'),
(105000020, 0, 'Crediti v/controllate', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 0, 0, 'AC02002', '', '', '', 0, 0, '', 0, '', 'N', NULL, 'amministratore', '2008-10-03 09:25:46'),
(315000013, 0, 'Costi d\'incasso', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 1, 0, 'EB00007', '', '', '', 0, 0, '', 0, '', 'N', NULL, '', '2007-05-17 02:46:32'),
(106000010, 0, 'Crediti per cauzioni', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 0, 0, 'AC02005', '', '', '', 0, 0, '', 0, '', 'N', NULL, 'amministratore', '2008-10-07 10:11:57'),
(106000020, 0, 'Personale c/acconti', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 0, 0, 'AC02005', '', '', '', 0, 0, '', 0, '', 'N', NULL, 'amministratore', '2008-10-07 10:12:21'),
(315000014, 0, 'Oneri di factoring', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 1, 0, 'EB00007', '', '', '', 0, 0, '', 0, '', 'N', NULL, '', '2007-05-17 02:46:32'),
(106000030, 0, 'Crediti v/Istituti previdenziali', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 0, 0, 'AC02005', '', '', '', 0, 0, '', 0, '', 'N', NULL, 'amministratore', '2008-10-07 10:12:36'),
(105000021, 0, 'Crediti v/collegate', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 0, 0, 'AC02003', '', '', '', 0, 0, '', 0, '', 'N', NULL, 'amministratore', '2008-10-03 09:25:53'),
(215000001, 0, 'IVA ns/debito', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 0, 0, '', 'PD00012', '', '', 0, 0, '', 0, 'Non dovrebbe affluire direttamente in bilancio: il saldo deve essere trasferito nel conto IVA c/liquidazione (conto transitorio), il quale, a sua volta, deve essere trasferito nel conto Crediti per IVA o Debiti per IVA, a seconda del segno che si trova ad avere.', 'N', NULL, 'amministratore', '2010-11-12 01:06:12'),
(106000060, 0, 'Obbligazionisti c/sottoscrizioni', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 0, 0, 'AC02005', '', '', '', 0, 0, '', 0, '', 'N', NULL, 'amministratore', '2008-10-07 10:12:54'),
(106000090, 0, 'Debitori diversi', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 0, 0, 'AC02005', '', '', '', 0, 0, '', 0, '', 'N', NULL, 'amministratore', '2008-10-07 10:13:12'),
(215000002, 0, 'Debiti per ritenute da versare', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 1, 0, '', 'PD00012', '', '', 0, 0, '', 0, '', 'N', NULL, '', '2007-05-17 02:46:32'),
(105000022, 0, 'Crediti v/controllanti', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 0, 0, 'AC02004', '', '', '', 0, 0, '', 0, '', 'N', NULL, 'amministratore', '2008-10-03 09:26:00'),
(215000003, 0, 'Debiti per imposte', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 1, 0, '', 'PD00012', '', '', 0, 0, '', 0, '', 'N', NULL, '', '2008-10-06 06:54:48'),
(215000005, 0, 'Debiti per IVA', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 1, 0, '', 'PD00012', '', '', 0, 0, '', 0, '', 'N', NULL, '', '2008-10-06 06:54:48'),
(105000040, 0, 'Fondo svalutazione crediti', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 1, 0, '', 'AC02001', '', '', 0, 0, '', 0, '', 'N', NULL, '', '2008-10-06 06:54:48'),
(105000041, 0, 'Fondo rischi su crediti', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 1, 0, '', 'AC02001', '', '', 0, 0, '', 0, '', 'N', NULL, '', '2007-05-17 02:46:32'),
(315000020, 0, 'Competenze amministratori', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 1, 0, 'EB00007', '', '', '', 0, 0, '', 0, '', 'N', NULL, '', '2007-05-17 02:46:32'),
(215000010, 0, 'Debiti v/istituti previdenziali', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 1, 0, '', 'PD00013', '', '', 0, 0, '', 0, '', 'N', NULL, '', '2008-10-06 06:54:15'),
(215000011, 0, 'Debiti v/fondi pensione', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 1, 0, '', 'PD00014', '', '', 0, 0, '', 0, '', 'N', NULL, '', '2007-05-17 02:46:32'),
(215000020, 0, 'Personale c/retribuzioni', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 1, 0, '', 'PD00014', '', '', 0, 0, '', 0, '', 'N', NULL, '', '2007-05-17 02:46:32'),
(103000008, 3, 'De Medici', '', 0, 0, '', 0, 1, 1, 1, 1, 1, '', 0, '', '', '', '0.00', 'S', 'S', 'S', 'N', 'S', 3, '0.00', '0.00', 0, '0.0', 1, 0, '', '', '', '', 0, 0, '', 0, '', 'N', NULL, 'amministratore', '2010-01-31 23:00:27'),
(103000002, 4, 'Fermi ', '', 0, 0, '', 0, 4, 1, 1, 1, 1, '', 0, '', '', '', '0.00', 'S', 'S', 'S', 'N', 'S', 2, '0.00', '0.00', 0, '0.0', 1, 0, '', '', '', '', 0, 0, '', 0, '', 'N', NULL, 'amministratore', '2010-12-28 02:43:55'),
(215000021, 0, 'Personale c/liquidazione', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 1, 0, '', 'PD00014', '', '', 0, 0, '', 0, '', 'N', NULL, '', '2007-05-17 02:46:32'),
(215000030, 0, 'Debiti per cauzioni', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 0, 0, '', 'PD00014', '', '', 0, 0, '', 0, '', 'N', NULL, 'amministratore', '2008-10-07 11:12:55'),
(315000022, 0, 'Competenze societa di revisione', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 1, 0, 'EB00007', '', '', '', 0, 0, '', 0, '', 'N', NULL, '', '2007-05-17 02:46:32'),
(420000010, 0, 'Resi su vendite', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 1, 0, 'EA00001', '', '', '', 0, 0, '', 0, '', 'N', NULL, '', '2007-05-17 02:46:32'),
(420000006, 0, 'Merci c/vendite', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 1, 0, '', 'EA00001', '', '', 0, 0, '', 0, '', 'N', NULL, '', '2008-10-06 14:47:29'),
(420000011, 0, 'Ribassi e abbuoni passivi', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 1, 0, 'EA00001', '', '', '', 0, 0, '', 0, '', 'N', NULL, '', '2008-10-06 06:54:48'),
(420000012, 0, 'Premi su vendite', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 1, 0, 'EA00001', '', '', '', 0, 0, '', 0, '', 'N', NULL, '', '2007-05-17 02:46:32'),
(420000020, 0, 'Prodotti in lavorazione c/esistenze iniziali', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 0, 0, 'EA00002', '', '', '', 0, 0, '', 0, '', 'N', NULL, 'amministratore', '2008-10-07 11:30:50'),
(315000025, 0, 'Oneri contributivi', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 1, 0, 'EB00007', '', '', '', 0, 0, '', 0, '', 'N', NULL, '', '2007-05-17 02:46:32'),
(420000021, 0, 'Semilavorati c/esistenze iniziali', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 1, 0, 'EA00002', '', '', '', 0, 0, '', 0, '', 'N', NULL, '', '2007-05-17 02:46:32'),
(330000004, 0, 'Merci c/acquisti', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 1, 0, 'EB00006', '', '', '', 0, 0, '', 0, '', 'N', NULL, '', '2008-10-06 06:54:48'),
(420000022, 0, 'Prodotti c/esistenze iniziali', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 1, 0, 'EA00002', '', '', '', 0, 0, '', 0, '', 'N', NULL, '', '2007-05-17 02:46:32'),
(420000025, 0, 'Semilavorati c/apporti', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 1, 0, 'EA00002', '', '', '', 0, 0, '', 0, '', 'N', NULL, '', '2007-05-17 02:46:32'),
(420000026, 0, 'Prodotti c/apporti', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 1, 0, 'EA00002', '', '', '', 0, 0, '', 0, '', 'N', NULL, '', '2007-05-17 02:46:32'),
(420000030, 0, 'Prodotti in lavorazione c/rimanenze finali', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 0, 0, '', 'EA00002', '', '', 0, 0, '', 0, '', 'N', NULL, 'amministratore', '2008-10-07 11:31:02'),
(420000031, 0, 'Semilavorati c/rimanenze finali', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 1, 0, '', 'EA00002', '', '', 0, 0, '', 0, '', 'N', NULL, '', '2007-05-17 02:46:32'),
(420000032, 0, 'Prodotti c/rimanenze finali', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 1, 0, '', 'EA00002', '', '', 0, 0, '', 0, '', 'N', NULL, '', '2007-05-17 02:46:32'),
(420000040, 0, 'Lavori in corso c/esistenze iniziali', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 1, 0, 'EA00003', '', '', '', 0, 0, '', 0, '', 'N', NULL, '', '2007-05-17 02:46:32'),
(420000041, 0, 'Lavori in corso c/rimanenze finali', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 1, 0, '', 'EA00003', '', '', 0, 0, '', 0, '', 'N', NULL, '', '2007-05-17 02:46:32'),
(420000050, 0, 'Costruzioni interne', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 1, 0, '', 'EA00004', '', '', 0, 0, '', 0, '', 'N', NULL, '', '2007-05-17 02:46:32'),
(420000051, 0, 'Costi di ricerca e sviluppo rinviati', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 1, 0, '', 'EA00004', '', '', 0, 0, '', 0, '', 'N', NULL, '', '2007-05-17 02:46:32'),
(420000007, 0, 'Prestazioni servizi', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 1, 0, '', 'EA00001', '', '', 0, 0, '', 0, '', 'N', NULL, '', '2007-05-17 02:46:32'),
(215000040, 0, 'Debiti per co.co.pro.', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 1, 0, '', 'PD00014', '', '', 0, 0, '', 0, '', 'N', NULL, '', '2007-05-17 02:46:32'),
(315000015, 0, 'Costi per co.co.pro.', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 1, 0, 'EB00007', '', '', '', 0, 0, '', 0, '', 'N', NULL, '', '2007-05-17 02:46:32'),
(337000004, 0, 'Merci c/esistenze iniziali', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 1, 0, 'EB00011', '', '', '', 0, 0, '', 0, '', 'N', NULL, '', '2007-05-17 02:46:32'),
(337000013, 0, 'Merci c/rimanenze finali', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 0, 0, '', 'EB00011', '', '', 0, 0, '', 0, '', 'N', NULL, 'amministratore', '2010-11-09 02:06:23'),
(115000009, 0, 'Merci', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 1, 0, 'AC01004', '', '', '', 0, 0, '', 0, '', 'N', NULL, '', '2008-10-06 06:54:25'),
(598000002, 0, 'Bilancio di chiusura', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 1, 0, '', '', '', '', 0, 0, '', 0, '', 'N', NULL, '', '2008-10-06 06:54:07'),
(598000001, 0, 'Bilancio di apertura', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 1, 0, '', '', '', '', 0, 0, '', 0, '', 'N', NULL, '', '2008-10-06 06:53:55'),
(598000003, 0, 'Risultato economico', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 1, 0, '', '', '', '', 0, 0, '', 0, '', 'N', NULL, '', '2008-10-06 06:54:12'),
(212000008, 5, 'Canossa ', '', 0, 0, '', 0, 1, 1, 1, 1, 1, '', 0, '', '', '', '0.00', 'S', 'S', 'S', 'N', 'N', 2, '0.00', '0.00', 0, '0.0', 1, 330000004, '', '', '', '', 0, 0, '', 0, '', 'N', NULL, 'amministratore', '2010-12-17 01:56:22'),
(212000002, 6, 'Pavoni ', '', 0, 0, '', 0, 1, 1, 1, 1, 1, '', 0, '', '', '', '0.00', 'S', 'S', 'S', 'N', 'N', 2, '0.00', '0.00', 0, '0.0', 1, 315000002, '', '', '', '', 0, 0, '', 0, '', 'N', NULL, 'amministratore', '2010-12-28 02:49:57'),
(103000003, 7, 'Pineta ', '', 0, 0, '', 0, 2, 1, 1, 1, 1, '', 0, '', '', '', '0.00', 'S', 'S', 'S', 'N', 'S', 17, '0.00', '0.00', 0, '0.0', 1, 0, '', '', '', '', 0, 0, '', 0, '', 'N', NULL, 'amministratore', '2015-01-26 18:01:01'),
(103000004, 8, 'Casati ', '', 0, 0, '', 0, 2, 1, 1, 1, 1, '', 0, '', '', '', '0.00', 'S', 'S', 'S', 'N', 'S', 7, '0.00', '0.00', 0, '0.0', 1, 0, '', '', '', '', 0, 0, '', 0, '', 'N', NULL, 'amministratore', '2010-12-28 02:44:38'),
(103000005, 9, 'Borbone', '', 0, 0, '', 0, 0, 1, 1, 1, 1, '', 0, '', '', '', '0.00', 'S', 'S', 'S', 'N', 'S', 11, '0.00', '0.00', 0, '0.0', 1, 0, '', '', '', '', 0, 0, '', 0, '', 'N', NULL, 'amministratore', '2010-01-31 23:00:27'),
(103000006, 10, 'Brioschi ', '', 0, 0, '', 0, 1, 1, 1, 1, 1, '', 0, '', '', '', '0.00', 'S', 'S', 'S', 'N', 'S', 2, '0.00', '0.00', 0, '0.0', 1, 0, '', '', '', '', 0, 0, '', 0, '', 'N', NULL, 'amministratore', '2010-12-28 02:44:17'),
(103000007, 11, 'Svevia ', '', 0, 0, '', 0, 5, 1, 1, 1, 1, '', 0, '', '', '', '0.00', 'S', 'S', 'S', 'N', 'S', 2, '0.00', '0.00', 0, '0.0', 1, 0, '', '', '', '', 0, 0, '', 0, '', 'N', NULL, 'amministratore', '2010-12-28 02:44:06'),
(212000003, 12, 'Patavina ', '', 0, 0, '', 0, 1, 1, 1, 1, 1, '', 0, '', '', '', '0.00', 'S', 'S', 'S', 'N', 'N', 2, '0.00', '0.00', 0, '0.0', 1, 315000006, '', '', '', '', 0, 0, '', 0, '', 'N', NULL, 'amministratore', '2010-12-28 02:49:46'),
(212000004, 13, 'Fibonacci ', '', 0, 0, '', 0, 1, 1, 1, 1, 1, '', 0, '', '', '', '0.00', 'S', 'S', 'S', 'N', 'N', 18, '0.00', '0.00', 0, '0.0', 1, 330000004, '', '', '', '', 0, 0, '', 0, '', 'N', NULL, 'amministratore', '2010-12-28 02:49:28'),
(212000005, 14, 'Pillio ', '', 0, 0, '', 0, 1, 1, 1, 1, 1, '', 0, '', '', '', '0.00', 'S', 'S', 'S', 'N', 'N', 2, '0.00', '0.00', 0, '0.0', 1, 330000004, '', '', '', '', 0, 0, '', 0, '', 'N', NULL, 'amministratore', '2010-12-28 02:47:46'),
(212000006, 15, 'Rivera ', '', 0, 0, '', 0, 1, 1, 1, 1, 1, '', 0, '', '', '', '0.00', 'S', 'S', 'S', 'N', 'N', 2, '0.00', '0.00', 0, '0.0', 1, 315000001, '', '', '', '', 0, 0, '', 0, '', 'N', NULL, 'amministratore', '2010-12-28 02:49:02'),
(212000007, 16, 'Esquivel ', '', 0, 0, '', 0, 1, 1, 1, 1, 1, '', 0, '', '', '', '0.00', 'S', 'S', 'S', 'N', 'N', 2, '0.00', '0.00', 0, '0.0', 1, 330000004, '', '', '', '', 0, 0, '', 0, '', 'N', NULL, 'amministratore', '2010-12-28 02:48:51'),
(102000030, 0, 'Immobilizzazioni materiali in corso', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 0, 0, 'AB02005 ', '', '', '', 0, 0, '', 0, '', 'N', NULL, 'amministratore', '2008-10-04 06:07:32'),
(102000031, 0, 'Fornitori immobilizzazioni materiali c/acconti', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 0, 0, 'AB02005', '', '', '', 0, 0, '', 0, '', 'N', NULL, 'amministratore', '2008-10-07 09:57:17'),
(210000001, 0, 'Patrimonio netto', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 0, 0, '', 'PA01000', '', '', 0, 0, '', 0, '', 'N', NULL, 'amministratore', '2008-10-06 06:54:48'),
(210000035, 0, 'Prelevamenti extragestione', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 0, 0, 'PA01000', '', '', '', 0, 0, '', 0, '', 'N', NULL, 'amministratore', '2008-10-07 10:33:18'),
(210000036, 0, 'Titolare c/ritenute subite', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 0, 0, 'PA01000', '', '', '', 0, 0, '', 0, '', 'N', NULL, 'amministratore', '2008-10-07 10:33:40'),
(101000025, 0, 'Fondo svalutazione brevetti industriali', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 0, 0, '', 'AB01003 ', '', '', 0, 0, '', 0, '', 'N', NULL, 'amministratore', '2008-10-07 09:51:09'),
(105000012, 0, 'Crediti da liquidare', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 0, 0, 'AC02001 ', '', '', '', 0, 0, '', 0, '', 'N', NULL, 'amministratore', '2008-10-07 10:02:32'),
(106000009, 0, 'Crediti per imposte anticipate', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 0, 0, 'AC02004c', '', '', '', 0, 0, '', 0, '', 'N', NULL, 'amministratore', '2008-10-07 10:08:19'),
(211000003, 0, 'Fondo imposte differite', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 0, 0, '', 'PB00002 ', '', '', 0, 0, '', 0, '', 'N', NULL, 'amministratore', '2008-10-07 10:36:29'),
(213000013, 0, 'Banche c/anticipi su fatture', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 0, 0, '', 'PD00004 ', '', '', 0, 0, '', 0, '', 'N', NULL, 'amministratore', '2008-10-07 10:42:43'),
(214000001, 0, 'Clienti c/acconti', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 0, 0, '', 'PD00006 ', '', '', 0, 0, '', 0, '', 'N', NULL, 'amministratore', '2008-10-07 10:48:16'),
(214000021, 0, 'Debiti da liquidare', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 0, 0, '', 'PD00007 ', '', '', 0, 0, '', 0, '', 'N', NULL, 'amministratore', '2008-10-07 10:51:30'),
(215000045, 0, 'Azionisti c/competenze', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 0, 0, '', 'PD00014 ', '', '', 0, 0, '', 0, '', 'N', NULL, 'amministratore', '2008-10-07 10:54:18'),
(215000022, 0, 'Cedente c/cessione', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 0, 0, '', 'PD00014 ', '', '', 0, 0, '', 0, '', 'N', NULL, 'amministratore', '2008-10-07 11:14:08'),
(199000010, 0, 'Merci da ricevere', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 0, 0, '', '', '', '', 0, 0, '', 0, '', 'N', NULL, 'amministratore', '2008-10-07 11:24:24'),
(299000010, 0, 'Merci da consegnare', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 0, 0, '', '', '', '', 0, 0, '', 0, '', 'N', NULL, 'amministratore', '2008-10-07 11:24:35'),
(421000040, 0, 'Contributi in c/esercizio', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 0, 0, '', 'EA00005 ', '', '', 0, 0, '', 0, '', 'N', NULL, 'amministratore', '2008-10-07 11:34:02'),
(421000042, 0, 'Contributi in c/impianti', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 0, 0, '', 'EA00005 ', '', '', 0, 0, '', 0, '', 'N', NULL, 'amministratore', '2008-10-07 11:34:44'),
(421000031, 0, 'Insussistenze attive ordinarie', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 0, 0, '', 'EA00005 ', '', '', 0, 0, '', 0, '', 'N', NULL, 'amministratore', '2008-10-07 11:36:49'),
(330000008, 0, 'Merci c/apporti', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 0, 0, 'EB00006 ', '', '', '', 0, 0, '', 0, '', 'N', NULL, 'amministratore', '2008-10-07 11:41:30'),
(315000016, 0, 'Lavorazioni presso terzi', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 0, 0, 'EB00007 ', '', '', '', 0, 0, '', 0, '', 'N', NULL, 'amministratore', '2008-10-07 11:44:27'),
(315000030, 0, 'Commissioni bancarie', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 0, 0, 'EB00007 ', '', '', '', 0, 0, '', 0, '', 'N', NULL, 'amministratore', '2008-10-07 11:48:36'),
(315000031, 0, 'Costi di etichettatura', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 0, 0, 'EB00007 ', '', '', '', 0, 0, '', 0, '', 'N', NULL, 'amministratore', '2008-10-07 11:49:18'),
(315000032, 0, 'Abbonamenti', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 0, 0, 'EB00007 ', '', '', '', 0, 0, '', 0, '', 'N', NULL, 'amministratore', '2008-10-07 11:49:49'),
(322000004, 0, 'Costi lavoro interinale', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 0, 0, 'EB00009e', '', '', '', 0, 0, '', 0, '', 'N', NULL, 'amministratore', '2008-10-07 11:51:15');
INSERT INTO `gaz_001clfoco` (`codice`, `id_anagra`, `descri`, `ref_ecommerce_id_customer`, `print_map`, `external_resp`, `external_service_descri`, `id_agente`, `banapp`, `portos`, `spediz`, `imball`, `listin`, `destin`, `id_des`, `iban`, `sia_code`, `cuc_code`, `maxrat`, `ragdoc`, `addbol`, `speban`, `spefat`, `stapre`, `codpag`, `sconto`, `sconto_rigo`, `aliiva`, `ritenuta`, `allegato`, `cosric`, `ceedar`, `ceeave`, `paymov`, `operation_type`, `id_assets`, `sel4esp_art`, `status`, `status_SIAN`, `annota`, `visannota`, `custom_field`, `adminid`, `last_modified`) VALUES
(339000005, 0, 'Perdite su crediti', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 0, 0, 'EB00014', '', '', '', 0, 0, '', 0, '', 'N', NULL, 'amministratore', '2010-10-10 09:01:05'),
(597000021, 19, 'BANCA DEL LAGO AG.c/c', '', 0, 0, '', 0, 1, 0, 0, 0, 0, '', 0, 'IT65Q0000000000000000000021', '12345', '12345678', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 0, 0, '', '', '', '', 0, 0, '', 0, '', 'N', NULL, 'amministratore', '2010-12-23 06:33:53'),
(105000009, 0, 'Fatture da emettere', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 0, 0, 'AC02001', '', '', '', 0, 0, '', 0, '', 'N', NULL, 'amministratore', '2016-01-26 01:09:25'),
(214000019, 0, 'Fatture da ricevere', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 0, 0, '', 'PD00007', '', '', 0, 0, '', 0, '', 'N', NULL, 'amministratore', '2016-01-26 01:09:25'),
(210000040, 0, 'Soci c/prelevamento', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 0, 0, 'PA01000', '', '', '', 0, 0, '', 0, '', 'N', NULL, 'amministratore', '2016-01-26 01:09:25'),
(210000010, 0, 'Riserva volontaria', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 0, 0, '', 'PA07000', '', '', 0, 0, '', 0, '', 'N', NULL, 'amministratore', '2016-01-26 01:09:25'),
(315000099, 0, 'Costi per servizi diversi', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 0, 0, 'EB00007', '', '', '', 0, 0, '', 0, '', 'N', NULL, 'amministratore', '2016-01-26 01:09:25'),
(339000099, 0, 'Altri oneri diversi', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 0, 0, 'EB00014', '', '', '', 0, 0, '', 0, '', 'N', NULL, 'amministratore', '2016-01-26 01:09:25'),
(100000101, 0, 'Socio u c/conferimenti', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 0, 0, 'AA00000', '', '', '', 0, 0, '', 0, '', 'N', NULL, 'amministratore', '2010-11-07 20:29:17'),
(100000102, 0, 'Socio v c/conferimenti', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 0, 0, 'AA00000', '', '', '', 0, 0, '', 0, '', 'N', NULL, 'amministratore', '2010-11-07 20:29:53'),
(100000103, 0, 'Socio w c/conferimenti', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 0, 0, 'AA00000', '', '', '', 0, 0, '', 0, '', 'N', NULL, 'amministratore', '2016-01-26 01:09:25'),
(100000104, 0, 'Socio x c/conferimenti', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 0, 0, 'AA00000', '', '', '', 0, 0, '', 0, '', 'N', NULL, 'amministratore', '2016-01-26 01:09:25'),
(100000105, 0, 'Socio y c/conferimenti', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 0, 0, 'AA00000', '', '', '', 0, 0, '', 0, '', 'N', NULL, 'amministratore', '2016-01-26 01:09:25'),
(100000106, 0, 'Socio x c/conferimenti', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 0, 0, 'AA00000', '', '', '', 0, 0, '', 0, '', 'N', NULL, 'amministratore', '2016-01-26 01:09:25'),
(215000101, 0, 'Socio u c/utili', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 0, 0, '', 'PD00014', '', '', 0, 0, '', 0, '', 'N', NULL, 'amministratore', '2010-11-07 20:32:48'),
(215000102, 0, 'Socio v c/utili', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 0, 0, '', 'PD00014', '', '', 0, 0, '', 0, '', 'N', NULL, 'amministratore', '2010-11-07 20:32:48'),
(215000103, 0, 'Socio w c/utili', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 0, 0, '', 'PD00014', '', '', 0, 0, '', 0, '', 'N', NULL, 'amministratore', '2010-11-07 20:32:48'),
(215000104, 0, 'Socio x c/utili', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 0, 0, '', 'PD00014', '', '', 0, 0, '', 0, '', 'N', NULL, 'amministratore', '2010-11-07 20:32:48'),
(215000105, 0, 'Socio y c/utili', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 0, 0, '', 'PD00014', '', '', 0, 0, '', 0, '', 'N', NULL, 'amministratore', '2010-11-07 20:32:48'),
(215000106, 0, 'Socio z c/utili', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 0, 0, '', 'PD00014', '', '', 0, 0, '', 0, '', 'N', NULL, 'amministratore', '2010-11-07 20:32:48'),
(215000201, 0, 'Socio u c/rimborsi', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 0, 0, '', 'PD00014', '', '', 0, 0, '', 0, '', 'N', NULL, 'amministratore', '2010-11-07 20:34:47'),
(215000202, 0, 'Socio v c/rimborsi', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 0, 0, '', 'PD00014', '', '', 0, 0, '', 0, '', 'N', NULL, 'amministratore', '2010-11-07 20:34:47'),
(215000203, 0, 'Socio w c/rimborsi', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 0, 0, '', 'PD00014', '', '', 0, 0, '', 0, '', 'N', NULL, 'amministratore', '2010-11-07 20:34:47'),
(215000204, 0, 'Socio x c/rimborsi', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 0, 0, '', 'PD00014', '', '', 0, 0, '', 0, '', 'N', NULL, 'amministratore', '2010-11-07 20:34:47'),
(215000205, 0, 'Socio y c/rimborsi', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 0, 0, '', 'PD00014', '', '', 0, 0, '', 0, '', 'N', NULL, 'amministratore', '2010-11-07 20:34:47'),
(215000206, 0, 'Socio z c/rimborsi', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 0, 0, '', 'PD00014', '', '', 0, 0, '', 0, '', 'N', NULL, 'amministratore', '2010-11-07 20:34:47'),
(215000301, 0, 'Socio u c/liquidazione', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 0, 0, '', 'PD00014', '', '', 0, 0, '', 0, '', 'N', NULL, 'amministratore', '2010-11-07 20:34:47'),
(215000302, 0, 'Socio v c/liquidazione', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 0, 0, '', 'PD00014', '', '', 0, 0, '', 0, '', 'N', NULL, 'amministratore', '2010-11-07 20:34:47'),
(215000303, 0, 'Socio w c/liquidazione', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 0, 0, '', 'PD00014', '', '', 0, 0, '', 0, '', 'N', NULL, 'amministratore', '2010-11-07 20:34:47'),
(215000304, 0, 'Socio x c/liquidazione', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 0, 0, '', 'PD00014', '', '', 0, 0, '', 0, '', 'N', NULL, 'amministratore', '2010-11-07 20:34:47'),
(215000305, 0, 'Socio y c/liquidazione', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 0, 0, '', 'PD00014', '', '', 0, 0, '', 0, '', 'N', NULL, 'amministratore', '2010-11-07 20:34:47'),
(215000306, 0, 'Socio z c/liquidazione', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 0, 0, '', 'PD00014', '', '', 0, 0, '', 0, '', 'N', NULL, 'amministratore', '2010-11-07 20:34:47'),
(100000201, 0, 'Socio u c/reintegro', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 0, 0, 'AA00000', '', '', '', 0, 0, '', 0, '', 'N', NULL, 'amministratore', '2016-01-26 01:09:25'),
(100000202, 0, 'Socio v c/reintegro', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 0, 0, 'AA00000', '', '', '', 0, 0, '', 0, '', 'N', NULL, 'amministratore', '2016-01-26 01:09:25'),
(100000203, 0, 'Socio w c/reintegro', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 0, 0, 'AA00000', '', '', '', 0, 0, '', 0, '', 'N', NULL, 'amministratore', '2016-01-26 01:09:25'),
(100000204, 0, 'Socio x c/reintegro', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 0, 0, 'AA00000', '', '', '', 0, 0, '', 0, '', 'N', NULL, 'amministratore', '2016-01-26 01:09:25'),
(100000205, 0, 'Socio y c/reintegro', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 0, 0, 'AA00000', '', '', '', 0, 0, '', 0, '', 'N', NULL, 'amministratore', '2016-01-26 01:09:25'),
(100000206, 0, 'Socio z c/reintegro', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 0, 0, 'AA00000', '', '', '', 0, 0, '', 0, '', 'N', NULL, 'amministratore', '2016-01-26 01:09:25'),
(100000301, 0, 'Socio u c/prelevamenti', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 0, 0, 'AA00000', '', '', '', 0, 0, '', 0, '', 'N', NULL, 'amministratore', '2016-01-26 01:09:25'),
(100000302, 0, 'Socio v c/prelevamenti', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 0, 0, 'AA00000', '', '', '', 0, 0, '', 0, '', 'N', NULL, 'amministratore', '2016-01-26 01:09:25'),
(100000303, 0, 'Socio w c/prelevamenti', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 0, 0, 'AA00000', '', '', '', 0, 0, '', 0, '', 'N', NULL, 'amministratore', '2016-01-26 01:09:25'),
(100000304, 0, 'Socio x c/prelevamenti', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 0, 0, 'AA00000', '', '', '', 0, 0, '', 0, '', 'N', NULL, 'amministratore', '2016-01-26 01:09:25'),
(100000305, 0, 'Socio y c/prelevamenti', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 0, 0, 'AA00000', '', '', '', 0, 0, '', 0, '', 'N', NULL, 'amministratore', '2016-01-26 01:09:25'),
(100000306, 0, 'Socio z c/prelevamenti', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 0, 0, 'AA00000', '', '', '', 0, 0, '', 0, '', 'N', NULL, 'amministratore', '2016-01-26 01:09:25'),
(337000014, 0, 'Imballaggi c/rimanenze finali', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 0, 0, '', 'EB00011', '', '', 0, 0, '', 0, '', 'N', NULL, 'amministratore', '2016-01-26 01:09:25'),
(337000005, 0, 'Imballaggi c/esistenze iniziali', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 0, 0, 'EB00011', '', '', '', 0, 0, '', 0, '', 'N', NULL, 'amministratore', '2016-01-26 01:09:25'),
(361000004, 0, 'Insussistenze passive straordinarie', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 0, 0, 'ED00021', '', '', '', 0, 0, '', 0, '', 'N', NULL, 'amministratore', '2016-01-26 01:09:25'),
(420000009, 0, 'Imballaggi c/vendite', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 0, 0, '', 'EA00001', '', '', 0, 0, '', 0, '', 'N', NULL, 'amministratore', '2016-01-26 01:09:25'),
(330000013, 0, 'Acquisti vari', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 0, 0, 'EB00006', '', '', '', 0, 0, '', 0, '', 'N', NULL, 'amministratore', '2016-01-26 01:09:25'),
(330000009, 0, 'Imballaggi c/acquisti', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 0, 0, 'EB00006', '', '', '', 0, 0, '', 0, '', 'N', NULL, 'amministratore', '2016-01-26 01:09:25'),
(339000031, 0, 'Insussistenze passive ordinarie', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 0, 0, 'EB00014', '', '', '', 0, 0, '', 0, '', 'N', NULL, 'amministratore', '2016-01-26 01:09:25'),
(215000012, 0, 'Debiti per cassa di previdenza', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 0, 0, '', 'PD00013', '', '', 0, 0, '', 0, '', 'N', NULL, 'amministratore', '2016-01-26 01:09:25'),
(197000001, 25, 'Banca del lago', '', 0, 0, '', 0, 5, 0, 0, 0, 0, '', 0, 'IT96R0123454321000000012345', '', '', '0.00', '', 'N', '', '', '', 0, '0.00', '0.00', 0, '0.0', 0, 0, '', '', '', '', 0, 0, '', 0, '', 'N', NULL, 'amministratore', '2016-01-26 01:09:25'),
(588000020, 0, 'IVA Split Payment PA', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 0, 0, '', '', '', '', 0, 0, '', 0, '', 'N', NULL, 'amministratore', '2008-09-27 06:58:53'),
(220000000, 0, 'PERSONALE/COLLABORATORI', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 0, 0, 'PD00014', 'PD00014', '', '', 0, 0, '', 0, '', 'N', NULL, 'amministratore', '2016-01-26 01:09:25'),
(220000001, 20, 'Gigolò Joe', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 0, 0, '', '', '', '', 0, 0, '', 0, '', 'N', NULL, 'amministratore', '2015-12-21 23:55:10'),
(250000000, 0, 'FONDO AMMORTAMENTI ', '', 0, 0, '', 0, 0, 0, 0, 0, 0, '', 0, '', '', '', '0.00', '', '', '', '', '', 0, '0.00', '0.00', 0, '0.0', 0, 0, '', '', '', '', 0, 0, '', 0, '', 'N', NULL, 'amministratore', '2004-01-27 03:20:00');

-- --------------------------------------------------------

--
-- Struttura della tabella `gaz_001company_config`
--

DROP TABLE IF EXISTS `gaz_001company_config`;
CREATE TABLE IF NOT EXISTS `gaz_001company_config` (
  `id` int(6) NOT NULL AUTO_INCREMENT,
  `description` varchar(100) DEFAULT '',
  `var` varchar(100) NOT NULL DEFAULT '',
  `val` varchar(2000) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `var` (`var`),
  KEY `val` (`val`(333)),
  KEY `description` (`description`)
) ENGINE=MyISAM AUTO_INCREMENT=72 DEFAULT CHARSET=utf8;

--
-- Dump dei dati per la tabella `gaz_001company_config`
--

INSERT INTO `gaz_001company_config` (`id`, `description`, `var`, `val`) VALUES
(1, 'FTP server name for upload catalogue', 'server', 'localhost'),
(2, 'Username for access to FTP server', 'user', 'user'),
(3, 'Password for access to FTP server', 'pass', 'password'),
(4, 'Website root directory', 'path', 'htdocs/'),
(5, 'GAzie school or order mail address', 'order_mail', 'order@mydomain.com'),
(6, 'Server address', 'order_server', 'in.mydomain.com'),
(7, 'Password for access', 'order_pass', 'password'),
(8, 'SMTP Mail Server', 'smtp_server', 'localhost'),
(9, 'Mail Notification Request', 'return_notification', 'yes'),
(10, 'Mailer (mail,smtp,sendmail,qmail)', 'mailer', 'smtp'),
(11, 'SMTP Port (25,587,465)', 'smtp_port', '25'),
(12, 'SMTP Secure (tls,ssl)', 'smtp_secure', ''),
(13, 'SMTP Username (empty for no auth)', 'smtp_user', ''),
(14, 'SMTP Password', 'smtp_password', ''),
(15, 'Casella di posta', 'cemail', ''),
(16, 'Password', 'cpassword', ''),
(17, 'Filtro casella di posta', 'cfiltro', ''),
(18, 'Configurazione pop imap', 'cpopimap', ''),
(19, 'Ultima mail fatture elettroniche', 'last_fae_email', ''),
(20, 'GAzie - Gestionale', 'ruburl', 'http://gazie.sourceforge.net/'),
(21, 'Descrizione contributo cassa previdenziale', 'payroll_tax_descri', 'Contributo integrativo cassa previdenziale'),
(22, 'Modo di selezione dei clienti/fornitori sui report delle fatture.<br>Dropdown=0, Ricerca testuale=1', 'partner_select_mode', '1'),
(23, 'Testo in HTML delle email inviate dall\'azienda', 'company_email_text', 'La presente e-mail per trasmetterVi i documenti che troverete in allegato.'),
(24, 'Visualizzazione scadenzario in Home page (0=No,1=Si)', 'schedule_view', '1'),
(25, 'Controlla regolarità indirizzo in inserimento cliente (0=No, 1=Si)', 'check_cust_address', '1'),
(26, 'Permetti caratteri speciali su codici articoli (0=No, 1=Si)', 'codart_special_char', '0'),
(27, 'Usa art. composti per seconda unità di misura (0=No, 1=Si)', 'show_artico_composit', '0'),
(28, 'Indirizzo mail al quale inviare i pacchetti di fatture elettroniche', 'dest_fae_zip_package', ''),
(29, 'Apre dialog per impostazione prezzo IVA compresa(0=No,1=Si)', 'vat_price', '0'),
(30, 'Eventuale ultimo rigo descrittivo su fatture es. Contributo CONAI', 'descriptive_last_row', ''),
(31, 'Eventuale ultimo rigo descrittivo su ddt (multiriga)', 'descriptive_last_ddt', ''),
(32, 'Nome della libreria di terze parti da usare per la eventuale trasmissione delle fatture elettroniche', 'send_fae_zip_package', ''),
(33, 'Nome della libreria di terze parti da usare per inviare sms', 'send_sms', ''),
(35, 'Eventuale collegamento Sezione IVA - Regime Fiscale es.1=RF04;2=RF12', 'sezione_regime_fiscale', ''),
(36, 'Usa articoli composti come Kit o come Standard (KIT o STD)', 'tipo_composti', 'STD'),
(37, 'Layout posizione logo su documenti (LEFT o DEFAULT)', 'layout_pos_logo_on_doc', 'DEFAULT'),
(38, 'Stampa Documenti di Trasporto in modalità 2xA5 (affiancati)', 'ddt_A5', '0'),
(39, 'Stampa Ricevute su moduli prenumerati es.\'buffetti\' per Buffetti art.8205L2000', 'received_template', ''),
(40, 'Foglio di stile xsl per visualizzazione della fattura elettronica (nella directory /library/include)', 'fae_style', 'fatturaordinaria_v1.2.1'),
(41, 'Identificativo dello stabilimento o deposito del SIAN', 'id_sian', '0'),
(42, 'Allerta se la lunghezza del codice articolo è diverso da', 'codart_len', '0'),
(43, 'Destinazione testo descrittivo articolo (0=solo su documenti, 1=entrambi, 2=solo su web, 9=nessuno)', 'article_text', '0'),
(44, 'Percorso FTP con radice per il nome di dominio primario. Ad esempio: public_html/yourUploadFolder/', 'ftp_path', ''),
(45, 'Giorni di validità dei preventivi di vendita (default)', 'day_of_validity', '30'),
(46, 'Tempi di consegna in giorni lavorativi (default)', 'delivery_time', '15'),
(47, 'Valore di default per stampa totali sui preventivi (0=No, 1=Si)', 'print_total', '1'),
(48, 'Nome della libreria di terze parti da usare per inviare sms', 'send_sms', ''),
(49, 'Periodicità in minuti per i controlli di presenza alerts (su menù) ', 'menu_alerts_check', '15'),
(50, 'Codice univoco assegnato al Creditore per SEPA', 'sepa_creditor_identifier', 'IT55ZZZ00000000000000001'),
(51, 'Abilita la richiesta di scelta template per carta intestata 0=No 1=Si', 'enable_lh_print_dialog', '1'),
(52, 'Ritorno dopo inserimento documento 0=Nuovo inserimento 1=Report', 'after_newdoc_back_to_doclist', '0'),
(53, 'Stampa produzioni 0=Solo ordinati 1=Ordinati e Acquistati 2=Solo Acquistati', 'orderman_report_choice', '0'),
(54, 'JSON con orari apertura/chiusura settimanali 1-7=lun-dom', 'json_weekly_openings', '{\"1\":{\"amop\":\"08:30\",\"amcl\":\"12:30\",\"pmop\":\"15:30\",\"pmcl\":\"19:30\"},\"2\":{\"amop\":\"08:30\",\"amcl\":\"12:30\",\"pmop\":\"15:30\",\"pmcl\":\"19:30\"},\"3\":{\"amop\":\"08:30\",\"amcl\":\"12:30\",\"pmop\":\"15:30\",\"pmcl\":\"19:30\"},\"4\":{\"amop\":\"08:30\",\"amcl\":\"12:30\",\"pmop\":\"15:30\",\"pmcl\":\"19:30\"},\"5\":{\"amop\":\"08:30\",\"amcl\":\"12:30\",\"pmop\":\"15:30\",\"pmcl\":\"19:30\"},\"6\":{\"amop\":\"08:30\",\"amcl\":\"12:30\"},\"7\":{}}'),
(55, 'Permetti anagrafiche senza dati fiscali', 'consenti_nofisc', '0'),
(56, 'Invia i pdf dei reports in finestra modale (0=No, 1=Si)', 'pdf_reports_send_to_modal', '1'),
(57, 'Attiva lo scroll automatico sull\'ultimo rigo dei documenti (0=No, 1=Si)', 'autoscroll_to_last_row', '1'),
(58, 'PEC SMTP Server', 'pec_smtp_server', ''),
(59, 'PEC SMTP Port (25,587,465)', 'pec_smtp_port', ''),
(60, 'PEC SMTP Secure (tls,ssl)', 'pec_smtp_secure', ''),
(61, 'PEC SMTP User', 'pec_smtp_usr', ''),
(62, 'PEC SMTP Password', 'pec_smtp_psw', ''),
(63, 'PEC IMAP Server', 'pec_imap_server', ''),
(64, 'PEC IMAP Port (143,993)', 'pec_imap_port', '993'),
(65, 'PEC IMAP Secure (tls,ssl)', 'pec_imap_secure', 'tls'),
(66, 'PEC IMAP User', 'pec_imap_usr', ''),
(67, 'PEC IMAP Password', 'pec_imap_psw', ''),
(68, 'Numerazione delle Fatture separate da quella di Note Credito/Debito (0=No 1=Si-default)', 'num_note_separate', '1'),
(69, 'Numeroi/codicei entei controllo/certificazione (può essere anche json o csv)', 'company_certifications', ''),
(70, 'Autoincrementa referenza artico (ID) su e-commerce sincronizzato (0=No, 1=Si)', 'autoincrement_id_ecomm', ''),
(71, 'Impacchetta le fatture elettroniche degli scontrini non anonimi (0=No, 1=Si)', 'fae_ticket_pack', '1');

-- --------------------------------------------------------

--
-- Struttura della tabella `gaz_001company_data`
--

DROP TABLE IF EXISTS `gaz_001company_data`;
CREATE TABLE IF NOT EXISTS `gaz_001company_data` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `description` varchar(100) DEFAULT '',
  `var` varchar(100) NOT NULL DEFAULT '',
  `data` text,
  `dataes` mediumblob COMMENT 'consente l''utilizzo di AES_ENCRYPT',
  `ref` varchar(100) NOT NULL,
  `adminid` varchar(20) NOT NULL,
  `last_modified` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `idx_ref` (`ref`) USING BTREE,
  KEY `idx_var` (`var`) USING BTREE,
  KEY `idx_description` (`description`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=67 DEFAULT CHARSET=utf8;

--
-- Dump dei dati per la tabella `gaz_001company_data`
--

INSERT INTO `gaz_001company_data` (`id`, `description`, `var`, `data`, `dataes`, `ref`, `adminid`, `last_modified`) VALUES
(1, '', 'website_title', '- website generator', NULL, '', '', '2022-10-02 07:36:54'),
(2, '', 'website_subtitle', 'erp free and open source', NULL, '', '', '2022-10-02 07:36:54'),
(3, '', 'website_meta_author', 'Antonio de Vincentiis - http://devincentiis.it', NULL, '', '', '2022-10-02 07:36:54'),
(4, '', 'website_meta_keywords', 'software libero open source erp crm magazzino gestionale contabilità iva registi magazzino azienda partitario scadenzario saldo acconto fattura ddt bolla parcella cliente fornitore sollecito scarico carico bilancio cee consolidato utile perdita registro libro', NULL, '', '', '2022-10-02 07:36:54'),
(5, 'Azienda', 'website_page_index', '<p>Il contenuto di questa pagina iniziale la potrai modificare a piacimento prima della pubblicazione descrivendo l\'attività svolta dalla tua azienda.</p><p>\r\nGazie o GAzie - Gestione Aziendale è un programma gestionale multiaziendale eseguibile su web server Apache con il supporto per il PHP e database MySQL. Con esso è possibile emettere ogni tipo di documento di vendita (DdT, Fatture Immediate, Fatture Differite, Note di Credito e Debito, Parcelle, Contratti, ecc.) ed eventualmente i relativi effetti (Ri.Ba elettroniche/cartacee, Cambiali-tratte) per il loro pagamento</p><p>\r\nGAzie emette tutti i libri obbligatori per la contabilità semplificata, ordinaria e di magazzino di una piccola/media azienda. Ogni operazione di stampa cartacea genera comunque il documento in formato PDF che in automatico può essere spedito via mail ai destinatari.</p>\r\n<br/>\r\n<p class=\"gazie_other\">Orari nei quali è probabile che stiamo lavorando con GAzie:</p>\r\n<p>Dal lunedì al venerdì dalle 8:00 alle 12:15 e dalle 14:30 alle 17:45 </p>', NULL, '', '', '2022-10-02 07:36:54'),
(6, 'Prodotti', 'website_page_product', '<p>Di seguito sono elencati i nostri prodotti </p>', NULL, '', '', '2022-10-02 07:36:54'),
(7, 'Contatti', 'website_page_contact', '	<table width=\"100%\" border=\"0\" cellspacing=\"0\" cellpadding=\"0\" align=\"center\">\r\n	<tbody>\r\n		<tr>\r\n			<td height=\"20\" class=\"gazie_other\">Nome</td>\r\n			<td height=\"20\" class=\"gazie_other\">Ruolo</td>\r\n			<td height=\"20\" class=\"gazie_other\">Telefono</td>\r\n			<td height=\"20\" class=\"gazie_other\">Cellulare</td>\r\n			<td height=\"20\" class=\"gazie_other\">Fax</td>\r\n			<td height=\"20\" class=\"gazie_other\">E-mail</td>\r\n		</tr>\r\n		<tr>\r\n			<td height=\"20\">Amministrazione</td>\r\n			<td>Informazioni</td>\r\n			<td>085 42 21 477</td>\r\n			<td></td>\r\n			<td>085 42 21 477</td>\r\n			<td>gazie-list@lists.sourceforge.net</td>\r\n		</tr>\r\n		<tr>\r\n			<td height=\"20\">Antonio</td>\r\n			<td>Vendite, acquisti, contabilità</td>\r\n			<td></td>\r\n			<td>338 31 21 161</td>\r\n			<td></td>\r\n			<td>a.devincentiis@tiscali.it</td>\r\n		</tr>\r\n		<tr>\r\n			<td height=\"20\">Fax</td>\r\n			<td>Vendite, acquisti, magazzino</td>\r\n			<td></td>\r\n			<td>085 42 21 477</td>\r\n			<td></td>\r\n			<td></td>\r\n		</tr>\r\n	</tbody>\r\n	</table>\r\n', NULL, '', '', '2022-10-02 07:36:54'),
(8, 'Dove siamo', 'website_page_where', '		<p> Via Volturno 2 - 65016 MONTESILVANO PESCARA (PE)\r\n		<p><iframe width=\"425\" height=\"350\" frameborder=\"0\" scrolling=\"no\" marginheight=\"0\" marginwidth=\"0\" src=\"http://www.openstreetmap.org/export/embed.html?bbox=14.163796305656433%2C42.505353124694636%2C14.166789650917053%2C42.50649207518226&amplayer=mapnik&ampmarker=42.50592260253225%2C14.165292978286743\" style=\"border: 1px solid black\"></iframe><br/><small><a href=\"http://www.openstreetmap.org/?mlat=42.50592&ampmlon=14.16529#map=19/42.50592/14.16529\">Visualizza mappa ingrandita</a></small></p>', NULL, '', '', '2022-10-02 07:36:54'),
(9, 'Ultima pagina riepilogativo IVA', 'upgrie', '0', NULL, '', '', '2022-10-02 07:36:54'),
(10, 'Ultima pagina Libro Giornale', 'upggio', '0', NULL, '', '', '2022-10-02 07:36:54'),
(11, 'Ultima pagina Libro Inventari', 'upginv', '0', NULL, '', '', '2022-10-02 07:36:54'),
(12, 'Ultima pagina Registro Fatture di Vendita della sezione IVA 1', 'upgve1', '0', NULL, '', '', '2022-10-02 07:36:54'),
(13, 'Ultima pagina Registro Fatture di Vendita della sezione IVA 2', 'upgve2', '0', NULL, '', '', '2022-10-02 07:36:54'),
(14, 'Ultima pagina Registro Fatture di Vendita della sezione IVA 3', 'upgve3', '0', NULL, '', '', '2022-10-02 07:36:54'),
(15, 'Ultima pagina Registro Fatture di Vendita della sezione IVA 4', 'upgve4', '0', NULL, '', '', '2022-10-02 07:36:54'),
(16, 'Ultima pagina Registro Fatture di Vendita della sezione IVA 5', 'upgve5', '0', NULL, '', '', '2022-10-02 07:36:54'),
(17, 'Ultima pagina Registro Fatture di Vendita della sezione IVA 6', 'upgve6', '0', NULL, '', '', '2022-10-02 07:36:54'),
(18, 'Ultima pagina Registro Fatture di Vendita della sezione IVA 7', 'upgve7', '0', NULL, '', '', '2022-10-02 07:36:54'),
(19, 'Ultima pagina Registro Fatture di Vendita della sezione IVA 8', 'upgve8', '0', NULL, '', '', '2022-10-02 07:36:54'),
(20, 'Ultima pagina Registro Fatture di Vendita della sezione IVA 9', 'upgve9', '0', NULL, '', '', '2022-10-02 07:36:54'),
(21, 'Ultima pagina Registro Fatture degli Acquisti della sezione IVA 1', 'upgac1', '0', NULL, '', '', '2022-10-02 07:36:54'),
(22, 'Ultima pagina Registro Fatture degli Acquisti della sezione IVA 2', 'upgac2', '0', NULL, '', '', '2022-10-02 07:36:54'),
(23, 'Ultima pagina Registro Fatture degli Acquisti della sezione IVA 3', 'upgac3', '0', NULL, '', '', '2022-10-02 07:36:54'),
(24, 'Ultima pagina Registro Fatture degli Acquisti della sezione IVA 4', 'upgac4', '0', NULL, '', '', '2022-10-02 07:36:54'),
(25, 'Ultima pagina Registro Fatture degli Acquisti della sezione IVA 5', 'upgac5', '0', NULL, '', '', '2022-10-02 07:36:54'),
(26, 'Ultima pagina Registro Fatture degli Acquisti della sezione IVA 6', 'upgac6', '0', NULL, '', '', '2022-10-02 07:36:54'),
(27, 'Ultima pagina Registro Fatture degli Acquisti della sezione IVA 7', 'upgac7', '0', NULL, '', '', '2022-10-02 07:36:54'),
(28, 'Ultima pagina Registro Fatture degli Acquisti della sezione IVA 8', 'upgac8', '0', NULL, '', '', '2022-10-02 07:36:54'),
(29, 'Ultima pagina Registro Fatture degli Acquisti della sezione IVA 9', 'upgac9', '0', NULL, '', '', '2022-10-02 07:36:54'),
(30, 'Ultima pagina Registro dei Corrispettivi della sezione IVA 1', 'upgco1', '0', NULL, '', '', '2022-10-02 07:36:54'),
(31, 'Ultima pagina Registro dei Corrispettivi della sezione IVA 2', 'upgco2', '0', NULL, '', '', '2022-10-02 07:36:54'),
(32, 'Ultima pagina Registro dei Corrispettivi della sezione IVA 3', 'upgco3', '0', NULL, '', '', '2022-10-02 07:36:54'),
(33, 'Ultima pagina Registro dei Corrispettivi della sezione IVA 4', 'upgco4', '0', NULL, '', '', '2022-10-02 07:36:54'),
(34, 'Ultima pagina Registro dei Corrispettivi della sezione IVA 5', 'upgco5', '0', NULL, '', '', '2022-10-02 07:36:54'),
(35, 'Ultima pagina Registro dei Corrispettivi della sezione IVA 6', 'upgco6', '0', NULL, '', '', '2022-10-02 07:36:54'),
(36, 'Ultima pagina Registro dei Corrispettivi della sezione IVA 7', 'upgco7', '0', NULL, '', '', '2022-10-02 07:36:54'),
(37, 'Ultima pagina Registro dei Corrispettivi della sezione IVA 8', 'upgco8', '0', NULL, '', '', '2022-10-02 07:36:54'),
(38, 'Ultima pagina Registro dei Corrispettivi della sezione IVA 9', 'upgco9', '0', NULL, '', '', '2022-10-02 07:36:54'),
(39, 'Ultimo mese stampato del Registro dei Corrispettivi della sezione IVA 1', 'umeco1', '0', NULL, '', '', '2022-10-02 07:36:54'),
(40, 'Ultimo mese stampato del Registro dei Corrispettivi della sezione IVA 2', 'umeco2', '0', NULL, '', '', '2022-10-02 07:36:54'),
(41, 'Ultimo mese stampato del Registro dei Corrispettivi della sezione IVA 3', 'umeco3', '0', NULL, '', '', '2022-10-02 07:36:54'),
(42, 'Ultimo mese stampato del Registro dei Corrispettivi della sezione IVA 4', 'umeco4', '0', NULL, '', '', '2022-10-02 07:36:54'),
(43, 'Ultimo mese stampato del Registro dei Corrispettivi della sezione IVA 5', 'umeco5', '0', NULL, '', '', '2022-10-02 07:36:54'),
(44, 'Ultimo mese stampato del Registro dei Corrispettivi della sezione IVA 6', 'umeco6', '0', NULL, '', '', '2022-10-02 07:36:54'),
(45, 'Ultimo mese stampato del Registro dei Corrispettivi della sezione IVA 7', 'umeco7', '0', NULL, '', '', '2022-10-02 07:36:54'),
(46, 'Ultimo mese stampato del Registro dei Corrispettivi della sezione IVA 8', 'umeco8', '0', NULL, '', '', '2022-10-02 07:36:54'),
(47, 'Ultimo mese stampato del Registro dei Corrispettivi della sezione IVA 9', 'umeco9', '0', NULL, '', '', '2022-10-02 07:36:54'),
(48, 'Ultimo mese stampato del Registro delle Fatture di vendita della sezione IVA 1', 'umeve1', '0', NULL, '', '', '2022-10-02 07:36:54'),
(49, 'Ultimo mese stampato del Registro delle Fatture di vendita della sezione IVA 2', 'umeve2', '0', NULL, '', '', '2022-10-02 07:36:54'),
(50, 'Ultimo mese stampato del Registro delle Fatture di vendita della sezione IVA 3', 'umeve3', '0', NULL, '', '', '2022-10-02 07:36:54'),
(51, 'Ultimo mese stampato del Registro delle Fatture di vendita della sezione IVA 4', 'umeve4', '0', NULL, '', '', '2022-10-02 07:36:54'),
(52, 'Ultimo mese stampato del Registro delle Fatture di vendita della sezione IVA 5', 'umeve5', '0', NULL, '', '', '2022-10-02 07:36:54'),
(53, 'Ultimo mese stampato del Registro delle Fatture di vendita della sezione IVA 6', 'umeve6', '0', NULL, '', '', '2022-10-02 07:36:54'),
(54, 'Ultimo mese stampato del Registro delle Fatture di vendita della sezione IVA 7', 'umeve7', '0', NULL, '', '', '2022-10-02 07:36:54'),
(55, 'Ultimo mese stampato del Registro delle Fatture di vendita della sezione IVA 8', 'umeve8', '0', NULL, '', '', '2022-10-02 07:36:54'),
(56, 'Ultimo mese stampato del Registro delle Fatture di vendita della sezione IVA 9', 'umeve9', '0', NULL, '', '', '2022-10-02 07:36:54'),
(57, 'Ultimo mese stampato del Registro delle Fatture di acquito della sezione IVA 1', 'umeac1', '0', NULL, '', '', '2022-10-02 07:36:54'),
(58, 'Ultimo mese stampato del Registro delle Fatture di acquito della sezione IVA 2', 'umeac2', '0', NULL, '', '', '2022-10-02 07:36:54'),
(59, 'Ultimo mese stampato del Registro delle Fatture di acquito della sezione IVA 3', 'umeac3', '0', NULL, '', '', '2022-10-02 07:36:54'),
(60, 'Ultimo mese stampato del Registro delle Fatture di acquito della sezione IVA 4', 'umeac4', '0', NULL, '', '', '2022-10-02 07:36:54'),
(61, 'Ultimo mese stampato del Registro delle Fatture di acquito della sezione IVA 5', 'umeac5', '0', NULL, '', '', '2022-10-02 07:36:54'),
(62, 'Ultimo mese stampato del Registro delle Fatture di acquito della sezione IVA 6', 'umeac6', '0', NULL, '', '', '2022-10-02 07:36:54'),
(63, 'Ultimo mese stampato del Registro delle Fatture di acquito della sezione IVA 7', 'umeac7', '0', NULL, '', '', '2022-10-02 07:36:54'),
(64, 'Ultimo mese stampato del Registro delle Fatture di acquito della sezione IVA 8', 'umeac8', '0', NULL, '', '', '2022-10-02 07:36:54'),
(65, 'Ultimo mese stampato del Registro delle Fatture di acquito della sezione IVA 9', 'umeac9', '0', NULL, '', '', '2022-10-02 07:36:54'),
(66, 'Valori settaggio IERincludeExcludeRows', 'magazz/admin_artico.IER', '', NULL, '', '', '2022-10-02 07:36:54');

-- --------------------------------------------------------

--
-- Struttura della tabella `gaz_001comunicazioni_dati_fatture`
--

DROP TABLE IF EXISTS `gaz_001comunicazioni_dati_fatture`;
CREATE TABLE IF NOT EXISTS `gaz_001comunicazioni_dati_fatture` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `anno` int(4) DEFAULT NULL,
  `periodicita` varchar(1) NOT NULL DEFAULT 'M',
  `trimestre_semestre` int(2) DEFAULT NULL,
  `nome_file_DTE` varchar(100) DEFAULT '',
  `nome_file_DTR` varchar(100) DEFAULT '',
  `nome_file_ZIP` varchar(100) DEFAULT '',
  `IdFile` varchar(18) DEFAULT '',
  `nome_file_ANN` varchar(100) DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='tabella contenente i dati delle Comunicazioni dati fatture (spesometro) secondo le specifiche tecniche dell''Agenzia delle Entrate';

-- --------------------------------------------------------

--
-- Struttura della tabella `gaz_001contract`
--

DROP TABLE IF EXISTS `gaz_001contract`;
CREATE TABLE IF NOT EXISTS `gaz_001contract` (
  `id_contract` int(9) NOT NULL AUTO_INCREMENT,
  `id_customer` int(9) NOT NULL DEFAULT '0',
  `id_assets` int(9) NOT NULL DEFAULT '0' COMMENT 'Utilizzato in caso di contratto asssociato ad un bene strumentale che è soggetto a manutenzione periodica',
  `vat_section` int(1) NOT NULL DEFAULT '0',
  `doc_number` int(9) NOT NULL DEFAULT '0',
  `doc_type` varchar(3) NOT NULL,
  `conclusion_date` date DEFAULT '2004-01-27',
  `start_date` date DEFAULT '2004-01-27',
  `months_duration` int(3) NOT NULL DEFAULT '0',
  `initial_fee` decimal(15,2) NOT NULL DEFAULT '0.00',
  `periodic_reassessment` int(1) NOT NULL DEFAULT '0',
  `periodicity` int(2) NOT NULL DEFAULT '0',
  `payment_method` int(2) NOT NULL DEFAULT '0',
  `mndtritdinf` int(9) NOT NULL DEFAULT '0' COMMENT 'Riferimento ad id_doc della tabella gaz_NNNfiles in cui sono contenuti i dati dell''eventuale mandato che autorizza l''emissione dei RID',
  `bank` int(3) NOT NULL DEFAULT '0',
  `tacit_renewal` int(1) NOT NULL DEFAULT '0',
  `current_fee` decimal(15,2) NOT NULL DEFAULT '0.00',
  `cod_revenue` int(9) NOT NULL DEFAULT '0',
  `id_con` int(9) NOT NULL,
  `vat_code` int(2) NOT NULL DEFAULT '0',
  `id_body_text` int(9) NOT NULL DEFAULT '0',
  `last_reassessment` date DEFAULT '2004-01-27',
  `id_agente` int(9) NOT NULL,
  `provvigione` decimal(4,2) NOT NULL,
  `status` varchar(10) NOT NULL,
  `note` varchar(64) NOT NULL,
  `adminid` varchar(20) NOT NULL DEFAULT '',
  `last_modified` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id_contract`),
  KEY `id_assets` (`id_assets`),
  KEY `id_customer` (`id_customer`),
  KEY `vat_section` (`vat_section`),
  KEY `conclusion_date` (`conclusion_date`),
  KEY `start_date` (`start_date`),
  KEY `periodicity` (`periodicity`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Struttura della tabella `gaz_001contract_row`
--

DROP TABLE IF EXISTS `gaz_001contract_row`;
CREATE TABLE IF NOT EXISTS `gaz_001contract_row` (
  `id_row` int(9) NOT NULL AUTO_INCREMENT,
  `id_contract` int(9) NOT NULL DEFAULT '0',
  `descri` varchar(100) DEFAULT NULL,
  `unimis` char(3) NOT NULL DEFAULT '',
  `quanti` decimal(12,3) DEFAULT NULL,
  `price` decimal(14,5) DEFAULT '0.00000',
  `discount` decimal(4,1) DEFAULT '0.0',
  `vat_code` int(2) NOT NULL DEFAULT '0',
  `cod_revenue` int(9) NOT NULL DEFAULT '0',
  `id_con` int(9) NOT NULL,
  `status` varchar(10) NOT NULL DEFAULT '',
  PRIMARY KEY (`id_row`) USING BTREE,
  KEY `id_contract` (`id_contract`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Struttura della tabella `gaz_001distinta_base`
--

DROP TABLE IF EXISTS `gaz_001distinta_base`;
CREATE TABLE IF NOT EXISTS `gaz_001distinta_base` (
  `id` int(9) UNSIGNED ZEROFILL NOT NULL AUTO_INCREMENT,
  `codice_composizione` varchar(32) CHARACTER SET utf8mb4 NOT NULL COMMENT 'è il codice dell''articolo composito',
  `codice_artico_base` varchar(32) NOT NULL COMMENT 'codice dell''articolo base',
  `quantita_artico_base` decimal(14,5) NOT NULL DEFAULT '0.00000' COMMENT 'quantità di articoli base necessari per costituire l''articolo composito',
  `id_movmag` int(9) UNSIGNED DEFAULT NULL COMMENT 'Riferimento ad id_mag del movimento di magazzino. Se =0 indica la struttura di una composizione e verrà utilizzata per generare i relativi movimenti di magazzino, quando valorizzato serve per ricordare l''albero da cui sono stati generati i relativi movimenti di magazzino',
  PRIMARY KEY (`id`),
  KEY `codice_composizione` (`codice_composizione`),
  KEY `codice_artico_base` (`codice_artico_base`),
  KEY `id_movmag` (`id_movmag`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='Tabella per creare gli "articoli compositi" (distinta base). Un articolo è composito quando è presente in almeno una di queste righe e qundi fa riferimento ad almeno un altro articolo di magazzino. Questi righi si potranno aggiungere tramite lo script admin_artico,  alla fine con il bottone "aggiungi articolo di base" ed immettendo la sola quantità, l''unità di misura ed il prezzo per i documenti di vendita  saranno quelli di sempre ma presi dall''articolo composito, molto facile perchè resterà tutto come prima, mentre la contabilità di magazzino verrà aggiornata tenendo conto di questi righi e non dell''articolo composito.';

-- --------------------------------------------------------

--
-- Struttura della tabella `gaz_001effett`
--

DROP TABLE IF EXISTS `gaz_001effett`;
CREATE TABLE IF NOT EXISTS `gaz_001effett` (
  `id_tes` int(9) NOT NULL AUTO_INCREMENT,
  `tipeff` char(1) NOT NULL DEFAULT '0',
  `datemi` date DEFAULT '2004-01-27',
  `progre` int(9) NOT NULL DEFAULT '0',
  `numfat` int(9) NOT NULL DEFAULT '0',
  `seziva` int(1) NOT NULL DEFAULT '0',
  `protoc` int(9) NOT NULL,
  `datfat` date DEFAULT '2004-01-27',
  `totfat` decimal(11,2) DEFAULT '0.00',
  `salacc` char(1) NOT NULL DEFAULT '',
  `impeff` decimal(11,2) DEFAULT '0.00',
  `scaden` date DEFAULT '2004-01-27',
  `clfoco` int(9) NOT NULL DEFAULT '0',
  `pagame` int(2) NOT NULL DEFAULT '0',
  `banapp` int(3) NOT NULL DEFAULT '0',
  `iban` varchar(32) DEFAULT NULL,
  `banacc` int(9) NOT NULL DEFAULT '0',
  `id_doc` int(9) NOT NULL,
  `id_con` int(9) NOT NULL DEFAULT '0',
  `id_distinta` int(9) DEFAULT NULL COMMENT 'Riferimento alla distinta degli effetti che a partire dalla versione 7.46 è contenuta in gaz_NNNfiles) ',
  `mndtritdinf` int(9) DEFAULT NULL COMMENT 'Riferimento ad id_doc della tabella gaz_NNNfiles in cui sono contenuti i dati del mandato che ha autorizzato l''emissione del RID',
  `cigcup` varchar(40) NOT NULL,
  `status` varchar(10) NOT NULL DEFAULT '',
  `adminid` varchar(20) NOT NULL DEFAULT '',
  `last_modified` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id_tes`),
  KEY `id_doc` (`id_doc`),
  KEY `progre` (`progre`),
  KEY `id_distinta` (`id_distinta`),
  KEY `id_con` (`id_con`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Struttura della tabella `gaz_001expdoc`
--

DROP TABLE IF EXISTS `gaz_001expdoc`;
CREATE TABLE IF NOT EXISTS `gaz_001expdoc` (
  `id_exp` int(9) NOT NULL AUTO_INCREMENT,
  `id_tes` int(9) NOT NULL DEFAULT '0',
  `CondizioniPagamento` varchar(4) NOT NULL DEFAULT '0',
  `ModalitaPagamento` varchar(4) NOT NULL DEFAULT '',
  `DataRiferimentoTerminiPagamento` date DEFAULT NULL,
  `GiorniTerminiPagamento` int(4) NOT NULL DEFAULT '0',
  `DataScadenzaPagamento` date DEFAULT NULL,
  `ImportoPagamento` decimal(10,2) NOT NULL DEFAULT '0.00',
  PRIMARY KEY (`id_exp`) USING BTREE,
  KEY `DataScadenzaPagamento` (`DataScadenzaPagamento`),
  KEY `id_tes` (`id_tes`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='Tabella contenente gli stessi dati degli elementi  <DatiPagamento>della fattura elettronica ed i riferimenti alla tabella gaz_NNNtesdoc. In fase di contabilizzazione delle fatture d''acquisto si avranno i dati necessari per aprire le partite  (gaz_NNNpaymov) con le scadenze  giuste. Solo se l''XML della fattura acquisita non contiene questo dettaglio allora per generarle verrà usata la modalità archiviata in anagrafica fornitore. ';

-- --------------------------------------------------------

--
-- Struttura della tabella `gaz_001extcon`
--

DROP TABLE IF EXISTS `gaz_001extcon`;
CREATE TABLE IF NOT EXISTS `gaz_001extcon` (
  `year` int(4) NOT NULL,
  `cos_serv_ind` decimal(11,2) DEFAULT '0.00',
  `cos_serv_amm` decimal(11,2) DEFAULT '0.00',
  `cos_serv_com` decimal(11,2) DEFAULT '0.00',
  `cos_godb_ind` decimal(11,2) DEFAULT '0.00',
  `cos_godb_amm` decimal(11,2) DEFAULT '0.00',
  `cos_godb_com` decimal(11,2) DEFAULT '0.00',
  `cos_pers_ind` decimal(11,2) DEFAULT '0.00',
  `cos_pers_amm` decimal(11,2) DEFAULT '0.00',
  `cos_pers_com` decimal(11,2) DEFAULT '0.00',
  `cos_amms_ind` decimal(11,2) DEFAULT '0.00',
  `cos_amms_amm` decimal(11,2) DEFAULT '0.00',
  `cos_amms_com` decimal(11,2) DEFAULT '0.00',
  `cos_accr_ind` decimal(11,2) DEFAULT '0.00',
  `cos_accr_amm` decimal(11,2) DEFAULT '0.00',
  `cos_accr_com` decimal(11,2) DEFAULT '0.00',
  `cos_acca_ind` decimal(11,2) DEFAULT '0.00',
  `cos_acca_amm` decimal(11,2) DEFAULT '0.00',
  `cos_acca_com` decimal(11,2) DEFAULT '0.00',
  `cos_divg_ind` decimal(11,2) DEFAULT '0.00',
  `cos_divg_amm` decimal(11,2) DEFAULT '0.00',
  `cos_divg_com` decimal(11,2) DEFAULT '0.00',
  `deb_breve` decimal(11,2) DEFAULT '0.00',
  `deb_medio` decimal(11,2) DEFAULT '0.00',
  `deb_lungo` decimal(11,2) DEFAULT '0.00',
  `num_dip` int(6) DEFAULT '0',
  PRIMARY KEY (`year`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Struttura della tabella `gaz_001fae_flux`
--

DROP TABLE IF EXISTS `gaz_001fae_flux`;
CREATE TABLE IF NOT EXISTS `gaz_001fae_flux` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `filename_ori` varchar(30) NOT NULL,
  `filename_zip_package` varchar(50) NOT NULL COMMENT 'Nome del pacchetto zip contenitore dei file xml, è un metodo utilizzato quando lo si trasmette massivamente ad un intermediario',
  `id_tes_ref` int(9) NOT NULL DEFAULT '0',
  `exec_date` datetime NOT NULL,
  `received_date` datetime NOT NULL,
  `delivery_date` datetime NOT NULL,
  `filename_son` varchar(30) NOT NULL,
  `id_SDI` varchar(20) NOT NULL DEFAULT '0',
  `filename_ret` varchar(30) NOT NULL,
  `mail_id` varchar(50) NOT NULL,
  `data` blob,
  `flux_status` varchar(10) NOT NULL COMMENT 'Stato del flusso verso SdI DI=da inviare, IV=inviata, PC=presa in carico, RC=consegnata, NS=scartata, MC=mancata consegna, NA=accettata(PA), NR=rifiutata(PA), AT=recapito impossibile, DT=decorrenza termini(PA)',
  `n_invio` int(1) NOT NULL DEFAULT '1',
  `progr_ret` varchar(4) NOT NULL,
  `flux_descri` text COMMENT 'Descrizione della notifica, ad esempio l''errore causa dello scarto o del rifiuto',
  PRIMARY KEY (`id`),
  KEY `filename_ori` (`filename_ori`),
  KEY `filename_zip_package` (`filename_zip_package`),
  KEY `id_tes_ref` (`id_tes_ref`),
  KEY `filename_son` (`filename_son`),
  KEY `id_SDI` (`id_SDI`),
  KEY `flux_status` (`flux_status`),
  KEY `mail_id` (`mail_id`),
  KEY `exec_date` (`exec_date`),
  KEY `received_date` (`received_date`),
  KEY `delivery_date` (`delivery_date`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Struttura della tabella `gaz_001files`
--

DROP TABLE IF EXISTS `gaz_001files`;
CREATE TABLE IF NOT EXISTS `gaz_001files` (
  `id_doc` int(9) UNSIGNED NOT NULL AUTO_INCREMENT,
  `table_name_ref` varchar(50) NOT NULL DEFAULT '',
  `id_ref` int(9) NOT NULL DEFAULT '0',
  `item_ref` varchar(100) NOT NULL COMMENT 'a secondo dell''utilizzo che se ne fà può contenere il codice articolo, il filename o altre referenze',
  `status` int(11) NOT NULL DEFAULT '0' COMMENT 'se usato quando item_ref =''faesync'' indica lo stato della fattura di acquisto (1=acquisita) ',
  `extension` varchar(4) NOT NULL,
  `title` varchar(255) NOT NULL,
  `content` mediumblob COMMENT 'per contenere riferimenti o l''intero file dentro il database, eventualemente criptato',
  `custom_field` text COMMENT 'Riferimenti generici utilizzabili sui moduli. Normalmente in formato json: {"nome_modulo":{"nome_variabile":{"valore_variabile": {}}}}',
  `adminid` varchar(20) NOT NULL,
  `last_modified` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id_doc`),
  KEY `table_name_ref` (`table_name_ref`),
  KEY `id_ref` (`id_ref`),
  KEY `item_ref` (`item_ref`),
  KEY `status` (`status`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

--
-- Dump dei dati per la tabella `gaz_001files`
--

INSERT INTO `gaz_001files` (`id_doc`, `table_name_ref`, `id_ref`, `item_ref`, `status`, `extension`, `title`, `content`, `custom_field`, `adminid`, `last_modified`) VALUES
(1, 'effett', 0, 'distinta', 0, '', 'Distinta fittizia per retrocompatibilità 7.46', NULL, NULL, '', '2021-08-31 10:12:26');

-- --------------------------------------------------------

--
-- Struttura della tabella `gaz_001imball`
--

DROP TABLE IF EXISTS `gaz_001imball`;
CREATE TABLE IF NOT EXISTS `gaz_001imball` (
  `codice` int(2) NOT NULL DEFAULT '0',
  `descri` varchar(50) NOT NULL DEFAULT '',
  `weight` decimal(8,2) NOT NULL,
  `annota` varchar(50) DEFAULT NULL,
  `adminid` varchar(20) NOT NULL DEFAULT '',
  `last_modified` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`codice`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Dump dei dati per la tabella `gaz_001imball`
--

INSERT INTO `gaz_001imball` (`codice`, `descri`, `weight`, `annota`, `adminid`, `last_modified`) VALUES
(1, 'Scatole di cartone', '0.00', '', '', '2008-09-27 07:46:34'),
(2, 'Sacchi di plastica', '0.00', '', 'amministratore', '2008-09-27 07:46:49'),
(3, 'Alla rinfusa', '0.00', '', '', '2008-09-27 07:47:02');

-- --------------------------------------------------------

--
-- Struttura della tabella `gaz_001instal`
--

DROP TABLE IF EXISTS `gaz_001instal`;
CREATE TABLE IF NOT EXISTS `gaz_001instal` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `codice` int(11) NOT NULL,
  `clfoco` int(11) NOT NULL,
  `oggetto` varchar(100) NOT NULL,
  `descrizione` varchar(255) NOT NULL,
  `seriale` varchar(255) NOT NULL,
  `datainst` date NOT NULL,
  `note` text NOT NULL,
  PRIMARY KEY (`id`),
  KEY `clfoco` (`clfoco`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Struttura della tabella `gaz_001letter`
--

DROP TABLE IF EXISTS `gaz_001letter`;
CREATE TABLE IF NOT EXISTS `gaz_001letter` (
  `id_let` int(9) NOT NULL AUTO_INCREMENT,
  `write_date` date DEFAULT '2004-01-27',
  `numero` varchar(20) NOT NULL,
  `revision` char(3) NOT NULL,
  `clfoco` int(9) NOT NULL,
  `email` varchar(50) DEFAULT '' COMMENT 'Utilizzato per inviare i documenti ad un indirizzo diverso da quello in anagrafica',
  `tipo` char(3) NOT NULL,
  `c_a` varchar(60) NOT NULL,
  `oggetto` varchar(128) NOT NULL,
  `corpo` text,
  `signature` tinyint(1) NOT NULL,
  `note` varchar(64) NOT NULL,
  `status` varchar(16) NOT NULL,
  `adminid` varchar(20) NOT NULL,
  `last_modified` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id_let`),
  KEY `write_date` (`write_date`),
  KEY `clfoco` (`clfoco`),
  KEY `tipo` (`tipo`),
  KEY `status` (`status`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Struttura della tabella `gaz_001liquidazioni_iva`
--

DROP TABLE IF EXISTS `gaz_001liquidazioni_iva`;
CREATE TABLE IF NOT EXISTS `gaz_001liquidazioni_iva` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `anno` int(4) DEFAULT NULL,
  `periodicita` varchar(1) NOT NULL DEFAULT 'M',
  `mese_trimestre` int(2) DEFAULT NULL,
  `nome_file_xml` varchar(100) DEFAULT '',
  `subforniture` int(1) DEFAULT '0',
  `eventi_eccezionali` int(1) DEFAULT '0',
  `vp2` decimal(12,2) DEFAULT '0.00',
  `vp3` decimal(12,2) DEFAULT '0.00',
  `vp4` decimal(12,2) DEFAULT '0.00',
  `vp5` decimal(12,2) DEFAULT '0.00',
  `vp7` decimal(12,2) DEFAULT '0.00',
  `vp8` decimal(12,2) DEFAULT '0.00',
  `vp9` decimal(12,2) DEFAULT '0.00',
  `vp10` decimal(12,2) DEFAULT '0.00',
  `vp11` decimal(12,2) DEFAULT '0.00',
  `vp12` decimal(12,2) DEFAULT '0.00',
  `vp13` decimal(12,2) DEFAULT '0.00',
  `vp13m` int(1) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='tabella contenente i dati delle Comunicazioni delle liquidazioni periodiche dell''IVA secondo le specifiche tecniche dell''Agenzia delle Entrate';

-- --------------------------------------------------------

--
-- Struttura della tabella `gaz_001lotmag`
--

DROP TABLE IF EXISTS `gaz_001lotmag`;
CREATE TABLE IF NOT EXISTS `gaz_001lotmag` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `codart` varchar(32) NOT NULL DEFAULT '',
  `id_movmag` int(9) NOT NULL,
  `id_rigdoc` int(9) NOT NULL,
  `identifier` varchar(100) NOT NULL,
  `expiry` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `codart` (`codart`),
  KEY `id_movmag` (`id_movmag`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Struttura della tabella `gaz_001movmag`
--

DROP TABLE IF EXISTS `gaz_001movmag`;
CREATE TABLE IF NOT EXISTS `gaz_001movmag` (
  `id_mov` int(9) NOT NULL AUTO_INCREMENT,
  `caumag` int(2) NOT NULL DEFAULT '0',
  `type_mov` int(1) NOT NULL DEFAULT '0' COMMENT 'Quaderno di campagna: 1=si 0=no  ',
  `operat` tinyint(1) NOT NULL,
  `datreg` date NOT NULL,
  `tipdoc` char(3) NOT NULL,
  `desdoc` varchar(100) NOT NULL,
  `datdoc` date NOT NULL,
  `clfoco` int(9) NOT NULL,
  `scochi` decimal(5,2) NOT NULL,
  `id_rif` int(9) NOT NULL,
  `artico` varchar(50) NOT NULL DEFAULT '',
  `id_warehouse` int(9) DEFAULT NULL COMMENT 'Ref. alla tabella gaz_NNNwarehouse',
  `id_lotmag` int(9) NOT NULL,
  `id_orderman` int(9) NOT NULL COMMENT 'Ref. alla tabella gaz_001orderman (produzioni-contabilità industriale) ',
  `id_assets` int(9) NOT NULL COMMENT 'Ref. alla tabella gaz_001assets (riferito a bene ammortizzabile)',
  `quanti` decimal(14,5) DEFAULT NULL,
  `prezzo` decimal(14,5) DEFAULT '0.00000',
  `scorig` decimal(4,1) DEFAULT '0.0',
  `campo_impianto` int(3) NOT NULL DEFAULT '0' COMMENT 'Referenza alla colonna codice della tabella edv_NNNcampi, è il luogo o campo di produzione',
  `id_avversita` int(3) DEFAULT NULL COMMENT 'Avversità nel quaderno di campagna ma può essere usato per altri inconvenienti verificatesi nella movimentazione ',
  `id_colture` int(3) DEFAULT NULL COMMENT 'Riferito al tipo di coltura e/o altre specifiche',
  `custom_field` text COMMENT 'Riferimenti generici utilizzabili sui moduli. Normalmente in formato json: {"nome_modulo":{"nome_variabile":{"valore_variabile": {}}}}',
  `status` varchar(10) NOT NULL DEFAULT '',
  `adminid` varchar(20) NOT NULL,
  `last_modified` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id_mov`) USING BTREE,
  KEY `datreg` (`datreg`),
  KEY `artico` (`artico`),
  KEY `caumag` (`caumag`),
  KEY `campo_impianto` (`campo_impianto`),
  KEY `id_avversita` (`id_avversita`),
  KEY `operat` (`operat`),
  KEY `id_lotmag` (`id_lotmag`),
  KEY `id_assets` (`id_assets`),
  KEY `datdoc` (`datdoc`),
  KEY `id_warehouse` (`id_warehouse`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Struttura della tabella `gaz_001orderman`
--

DROP TABLE IF EXISTS `gaz_001orderman`;
CREATE TABLE IF NOT EXISTS `gaz_001orderman` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `order_type` varchar(3) DEFAULT NULL,
  `description` varchar(80) NOT NULL,
  `add_info` text,
  `id_tesbro` int(9) NOT NULL,
  `id_rigbro` int(9) NOT NULL COMMENT 'Riferimento al rigo ordine da cliente del modulo vendite',
  `id_lotmag` int(9) NOT NULL COMMENT 'Riferimento al lotto (tabella gaz_NNNlotmag) per la tracciabilità e/o certificazione delle produzioni ',
  `campo_impianto` int(3) NOT NULL COMMENT 'Se valorizzata questa referenza assegna l''ordine/commessa/produzione ad un impianto specifico, ovvero al campo del modulo camp (se azienda agricola)',
  `duration` int(3) NOT NULL COMMENT 'Durata della produzione',
  `id_staff_def` int(9) NOT NULL COMMENT 'Utilizzabile per la preselezione della persona addetta alla produzione/consulenza/intervento e/o al collaboratore responsabile della stessa',
  `start_work` datetime DEFAULT NULL,
  `end_work` datetime DEFAULT NULL,
  `stato_lavorazione` int(1) NOT NULL COMMENT '0=aperto, 1=in attesa, 2=in lavorazione, 3=materiale ordinato, 4=incontrate difficoltà, 5=in attesa di spedizione, 6=spedito, 7=consegnato, 8=non chiuso, 9=chiuso',
  `tracking_no` varchar(50) NOT NULL,
  `adminid` varchar(20) NOT NULL DEFAULT '',
  `last_modified` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `idx_id_rigbro` (`id_rigbro`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Struttura della tabella `gaz_001pagame`
--

DROP TABLE IF EXISTS `gaz_001pagame`;
CREATE TABLE IF NOT EXISTS `gaz_001pagame` (
  `codice` int(2) NOT NULL DEFAULT '0',
  `descri` varchar(50) NOT NULL DEFAULT '',
  `tippag` char(1) NOT NULL DEFAULT '',
  `incaut` int(9) NOT NULL DEFAULT '0',
  `pagaut` int(9) DEFAULT '0',
  `tipdec` char(1) NOT NULL DEFAULT '',
  `giodec` int(3) NOT NULL DEFAULT '0',
  `mesesc` int(2) NOT NULL DEFAULT '0',
  `messuc` int(2) NOT NULL DEFAULT '0',
  `giosuc` int(2) NOT NULL DEFAULT '0',
  `numrat` int(2) NOT NULL DEFAULT '0',
  `tiprat` char(1) NOT NULL DEFAULT '0',
  `fae_mode` varchar(4) NOT NULL,
  `id_bank` int(9) NOT NULL,
  `web_payment_ref` varchar(50) NOT NULL COMMENT 'Riferimento al metodo di pagamento utilizzato dall''ecommerce',
  `annota` varchar(50) DEFAULT NULL,
  `adminid` varchar(20) NOT NULL DEFAULT '',
  `last_modified` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`codice`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Dump dei dati per la tabella `gaz_001pagame`
--

INSERT INTO `gaz_001pagame` (`codice`, `descri`, `tippag`, `incaut`, `pagaut`, `tipdec`, `giodec`, `mesesc`, `messuc`, `giosuc`, `numrat`, `tiprat`, `fae_mode`, `id_bank`, `web_payment_ref`, `annota`, `adminid`, `last_modified`) VALUES
(1, 'Contanti', 'C', 108000030, 108000030, 'D', 0, 0, 0, 0, 1, 'M', 'MP01', 0, '', '', '', '2017-03-23 23:06:57'),
(8, 'Ricevuta bancaria 60 g.d.f.', 'B', 0, 0, 'D', 60, 0, 0, 0, 1, 'M', 'MP12', 597000021, '', '', '', '2014-06-06 09:06:45'),
(3, 'Rimessa diretta 30 g.d.f.', 'O', 0, 0, 'D', 30, 0, 0, 0, 1, 'M', 'MP05', 597000021, '', '', 'amministratore', '2021-01-27 06:22:05'),
(4, 'Rimessa diretta 60 g.d.f.', 'O', 0, 0, 'D', 60, 0, 0, 0, 1, 'M', 'MP05', 597000021, '', '', 'amministratore', '2021-01-27 06:22:05'),
(7, 'Ricevuta bancaria 30 g.d.f.', 'B', 0, 0, 'D', 30, 0, 0, 0, 1, 'M', 'MP12', 597000021, '', '', '', '2014-06-06 09:06:45'),
(11, 'Tratta 30 g.d.f.', 'T', 0, 0, 'D', 30, 0, 0, 0, 1, 'M', 'MP16', 597000021, '', '', '', '2018-12-26 19:19:28'),
(12, 'Tratta 60 g.d.f.', 'T', 0, 0, 'D', 60, 0, 0, 0, 1, 'M', 'MP16', 597000021, '', '', '', '2018-12-26 19:19:16'),
(17, 'Ricevuta bancaria 30-60 gg. f.m.', 'B', 0, 0, 'F', 30, 0, 0, 0, 2, 'M', 'MP12', 0, '', '', '', '2014-06-06 09:06:45'),
(2, 'Vista fattura', 'O', 0, 0, 'D', 0, 0, 0, 0, 1, 'M', 'MP05', 597000021, '', '', '', '2021-01-27 06:22:05'),
(15, 'Mediante avviso (MAV) 30 g.d.f.', 'V', 0, 0, 'D', 30, 0, 0, 0, 1, 'M', 'MP13', 597000021, '', '', '', '2018-12-26 19:20:28'),
(16, 'Mediante avviso (MAV) 60 g.d.f.', 'V', 0, 0, 'D', 60, 0, 0, 0, 1, 'M', 'MP13', 597000021, '', '', '', '2018-12-26 19:20:39'),
(18, 'Bonifico bancario 30gg D.F.', 'O', 0, 0, 'D', 30, 0, 0, 0, 1, 'M', 'MP05', 597000021, '', '', '', '2021-01-27 06:22:05');

-- --------------------------------------------------------

--
-- Struttura della tabella `gaz_001paymov`
--

DROP TABLE IF EXISTS `gaz_001paymov`;
CREATE TABLE IF NOT EXISTS `gaz_001paymov` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `id_tesdoc_ref` varchar(15) NOT NULL,
  `id_rigmoc_pay` int(9) NOT NULL,
  `id_rigmoc_doc` int(9) NOT NULL,
  `amount` decimal(11,2) NOT NULL,
  `expiry` date NOT NULL,
  PRIMARY KEY (`id`),
  KEY `id_rigmoc_doc` (`id_rigmoc_doc`),
  KEY `expiry` (`expiry`),
  KEY `id_tesdoc_ref` (`id_tesdoc_ref`),
  KEY `id_rigmoc_pay` (`id_rigmoc_pay`) USING HASH
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Struttura della tabella `gaz_001portos`
--

DROP TABLE IF EXISTS `gaz_001portos`;
CREATE TABLE IF NOT EXISTS `gaz_001portos` (
  `codice` int(2) NOT NULL DEFAULT '0',
  `descri` varchar(50) NOT NULL DEFAULT '',
  `incoterms` varchar(3) NOT NULL,
  `annota` varchar(50) DEFAULT NULL,
  `adminid` varchar(20) NOT NULL DEFAULT '',
  `last_modified` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`codice`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Dump dei dati per la tabella `gaz_001portos`
--

INSERT INTO `gaz_001portos` (`codice`, `descri`, `incoterms`, `annota`, `adminid`, `last_modified`) VALUES
(1, 'FMV - franco magazzino venditore', 'EXW', '', 'amministratore', '2014-06-06 09:06:45'),
(2, 'FMC - franco magazzino compratore', 'EXW', '', 'amministratore', '2014-06-06 09:06:45');

-- --------------------------------------------------------

--
-- Struttura della tabella `gaz_001provvigioni`
--

DROP TABLE IF EXISTS `gaz_001provvigioni`;
CREATE TABLE IF NOT EXISTS `gaz_001provvigioni` (
  `id_provvigione` int(9) NOT NULL AUTO_INCREMENT,
  `id_agente` int(9) NOT NULL,
  `cod_articolo` varchar(32) NOT NULL,
  `cod_catmer` int(3) NOT NULL,
  `percentuale` decimal(4,2) NOT NULL,
  PRIMARY KEY (`id_provvigione`),
  KEY `id_agente` (`id_agente`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Struttura della tabella `gaz_001ragstat`
--

DROP TABLE IF EXISTS `gaz_001ragstat`;
CREATE TABLE IF NOT EXISTS `gaz_001ragstat` (
  `codice` char(32) NOT NULL,
  `descri` varchar(50) NOT NULL DEFAULT '',
  `image` blob,
  `web_url` varchar(255) NOT NULL,
  `ricarico` decimal(4,1) NOT NULL,
  `annota` varchar(50) DEFAULT NULL,
  `adminid` varchar(20) NOT NULL DEFAULT '',
  `last_modified` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`codice`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Struttura della tabella `gaz_001registro_trattamento_dati`
--

DROP TABLE IF EXISTS `gaz_001registro_trattamento_dati`;
CREATE TABLE IF NOT EXISTS `gaz_001registro_trattamento_dati` (
  `revision` int(9) NOT NULL AUTO_INCREMENT,
  `data_emissione` date NOT NULL,
  `A01` tinytext NOT NULL COMMENT 'Attività svolta',
  `A02` tinytext NOT NULL COMMENT 'Forma sociale',
  `A03` tinytext NOT NULL COMMENT 'Sede dell''attività',
  `A04` tinytext NOT NULL COMMENT 'Struttura dei luoghi di svolgimento dell''attività',
  `A05` int(4) NOT NULL DEFAULT '0' COMMENT 'Numero dei titolari dell''attività',
  `A06` int(4) NOT NULL DEFAULT '0' COMMENT 'Numero dei dipendenti',
  `A07` int(4) NOT NULL DEFAULT '0' COMMENT 'Numero dei collaboratori',
  `A08E` tinyint(1) NOT NULL DEFAULT '0' COMMENT 'Raccolta e gestione dei dati elettronica',
  `A08C` tinyint(1) NOT NULL DEFAULT '0' COMMENT 'Raccolta e gestione dei dati cartacea',
  `A09` text NOT NULL COMMENT 'Descrizione sistemi informatici presenti',
  `A10` tinytext NOT NULL COMMENT 'Titolare del trattamento (Nominativo e dati di contatto)',
  `A11` tinytext NOT NULL COMMENT 'Contitolare del trattamento (se presente, nominativo e dati di contatto)',
  `A12` tinytext NOT NULL COMMENT 'Rappresentante del titolare del trattamento (se presente, nominativo e dati di contatto)',
  `A13` tinytext NOT NULL COMMENT 'Responsabile del titolare del trattamento (se presente, nominativo e dati di contatto)',
  `A14` tinyint(1) NOT NULL DEFAULT '0' COMMENT 'Il titolare ha aderito ad un codice di condotta (si-no)',
  `A15` tinyint(1) NOT NULL DEFAULT '0' COMMENT 'Il titolare ha aderito ad un sistema di certificazione art.42 Regolamento (si-no)',
  `B01A` tinyint(1) NOT NULL DEFAULT '0' COMMENT 'Finalità del trattamento dei dati personali degli interessati raccolti dal titolare: anagrafica',
  `B01B` tinyint(1) NOT NULL DEFAULT '0' COMMENT 'Finalità del trattamento dei dati personali degli interessati raccolti dal titolare: svolgimento attività principali e accessorie',
  `B01C` tinyint(1) NOT NULL DEFAULT '0' COMMENT 'Finalità del trattamento dei dati personali degli interessati raccolti dal titolare: promozione servizi del titolare',
  `B01D` tinyint(1) NOT NULL DEFAULT '0' COMMENT 'Finalità del trattamento dei dati personali degli interessati raccolti dal titolare: promozione servizi terzi',
  `B01E` tinyint(1) NOT NULL DEFAULT '0' COMMENT 'Finalità del trattamento dei dati personali degli interessati raccolti dal titolare: rilevazione abitudini di consumo',
  `B01F` tinyint(1) NOT NULL DEFAULT '0' COMMENT 'Finalità del trattamento dei dati personali degli interessati raccolti dal titolare: profilazione dei dati ex art.4 n.4 del Regolamento',
  `B01G` tinyint(1) NOT NULL DEFAULT '0' COMMENT 'Finalità del trattamento dei dati personali degli interessati raccolti dal titolare: rapporto di lavoro /collaborazione',
  `B02A` tinyint(1) NOT NULL DEFAULT '0' COMMENT 'Trattamento dei dati personali per finalità anagrafica: clienti',
  `B02B` tinyint(1) NOT NULL DEFAULT '0' COMMENT 'Trattamento dei dati personali per finalità anagrafica: fornitori',
  `B02C` tinyint(1) NOT NULL DEFAULT '0' COMMENT 'Trattamento dei dati personali per finalità anagrafica: dipendenti/collaboratori',
  `B03A` tinyint(1) NOT NULL DEFAULT '0' COMMENT 'Trattamento dei dati personali per finalità di svolgimento delle attività principali e accessorie del titolare: clienti',
  `B03B` tinyint(1) NOT NULL DEFAULT '0' COMMENT 'Trattamento dei dati personali per finalità di svolgimento delle attività principali e accessorie del titolare: fornitori',
  `B03C` tinyint(1) NOT NULL DEFAULT '0' COMMENT 'Trattamento dei dati personali per finalità di svolgimento delle attività principali e accessorie del titolare: dipendenti/collaboratori',
  `B04A` tinyint(1) NOT NULL DEFAULT '0' COMMENT 'Trattamento dei dati personali per finalità di promozione dei servizi del titolare: clienti',
  `B04B` tinyint(1) NOT NULL DEFAULT '0' COMMENT 'Trattamento dei dati personali per finalità di promozione dei servizi del titolare: fornitori',
  `B04C` tinyint(1) NOT NULL DEFAULT '0' COMMENT 'Trattamento dei dati personali per finalità di promozione dei servizi del titolare: dipendenti/collaboratori',
  `B05A` tinyint(1) NOT NULL DEFAULT '0' COMMENT 'Trattamento dei dati personali per finalità di promozione dei servizi di terzi: clienti',
  `B05B` tinyint(1) NOT NULL DEFAULT '0' COMMENT 'Trattamento dei dati personali per finalità di promozione dei servizi di terzi: fornitori',
  `B05C` tinyint(1) NOT NULL DEFAULT '0' COMMENT 'Trattamento dei dati personali per finalità di promozione dei servizi di terzi: dipendenti/collaboratori',
  `B06A` tinyint(1) NOT NULL DEFAULT '0' COMMENT 'Trattamento dei dati personali per rilevamento delle abitudini di consumo dell''interessato: clienti',
  `B06B` tinyint(1) NOT NULL DEFAULT '0' COMMENT 'Trattamento dei dati personali per rilevamento delle abitudini di consumo dell''interessato: fornitori',
  `B06C` tinyint(1) NOT NULL DEFAULT '0' COMMENT 'Trattamento dei dati personali per rilevamento delle abitudini di consumo dell''interessato: dipendenti/collaboratori',
  `B07A` tinyint(1) NOT NULL DEFAULT '0' COMMENT 'Trattamento dei dati personali per i fini e con le modalità di cui all''art.4 n.4 del Regolamento (profilazione dati): clienti',
  `B07B` tinyint(1) NOT NULL DEFAULT '0' COMMENT 'Trattamento dei dati personali per i fini e con le modalità di cui all''art.4 n.4 del Regolamento (profilazione dati): fornitori',
  `B07C` tinyint(1) NOT NULL DEFAULT '0' COMMENT 'Trattamento dei dati personali per i fini e con le modalità di cui all''art.4 n.4 del Regolamento (profilazione dati): dipendenti/collaboratori',
  `B08A` tinyint(1) NOT NULL DEFAULT '0' COMMENT 'Trattamento dei dati personali per finalità relative al rapporto di lavoro/collaborazione: clienti',
  `B08B` tinyint(1) NOT NULL DEFAULT '0' COMMENT 'Trattamento dei dati personali per finalità relative al rapporto di lavoro/collaborazione: fornitori',
  `B08C` tinyint(1) NOT NULL DEFAULT '0' COMMENT 'Trattamento dei dati personali per finalità relative al rapporto di lavoro/collaborazione: dipendenti/collaboratori',
  `C01A` tinyint(1) NOT NULL DEFAULT '0' COMMENT 'Base giuridica del trattamento dei dati: legge',
  `C01B` tinyint(1) NOT NULL DEFAULT '0' COMMENT 'Base giuridica del trattamento dei dati: contratto',
  `C01C` tinyint(1) NOT NULL DEFAULT '0' COMMENT 'Base giuridica del trattamento dei dati: standard internazionale',
  `C02A` int(3) NOT NULL DEFAULT '0' COMMENT 'Termini massimi consentiti per la cancellazione dei dati: Dati personali art.4 (Ai fini del presente regolamento s''intende per: 1) «dato personale»: qualsiasi informazione riguardante una persona fisica identificata o identificabile («interessato»); si considera identificabile la persona fisica che può essere identificata, direttamente o indirettamente, con particolare riferimento a un identificativo come il nome, un numero di identificazione, dati relativi all''ubicazione, un identificativo online o a uno o più elementi caratteristici della sua identità fisica, fisiologica, genetica, psichica, economica, culturale o sociale)',
  `C02B` int(3) NOT NULL DEFAULT '0' COMMENT 'Termini massimi consentiti per la cancellazione dei dati: Dati personali art.9 ( È vietato trattare dati personali che rivelino l''origine razziale o etnica, le opinioni politiche, le convinzioni religiose o filosofiche, o l''appartenenza sindacale, nonché trattare dati genetici, dati biometrici intesi a identificare in modo univoco una persona fisica, dati relativi alla salute o alla vita sessuale o all''orientamento sessuale della persona)',
  `C02C` int(3) NOT NULL DEFAULT '0' COMMENT 'Termini massimi consentiti per la cancellazione dei dati: Dati personali art.10 (Il trattamento dei dati personali relativi alle condanne penali e ai reati o a connesse misure di sicurezza sulla base dell''articolo 6, paragrafo 1, deve avvenire soltanto sotto il controllo dell''autorità pubblica o se il trattamento è autorizzato dal diritto dell''Unione o degli Stati membri che preveda garanzie appropriate per i diritti e le libertà degli interessati. Un eventuale registro completo delle condanne penali deve essere tenuto soltanto sotto il controllo dell''autorità pubblica)',
  `C03` tinyint(1) NOT NULL DEFAULT '0' COMMENT 'Vengono eseguiti trattamenti in cui i dati sono comunicati a terzi? (0=NO, 1=SI)',
  `C03_tipo_descri` text NOT NULL COMMENT 'Se Si quali trattamenti? descrivi',
  `C03A` tinyint(1) NOT NULL DEFAULT '0' COMMENT 'Se Si verso quali categorie di terzi: 1) fornitori di annunci / pubblicità, 2) mediatori (art. 1754 c.c.), 3) notai, 4) assicurazioni, 5) architetti, 6) avvocati, 7) commercialisti, 8) istituti di credito, 9) altri soggetti esercenti attività finanziarie, 0) altre categorie descritte sotto',
  `C03A_altra_cat_descri` tinytext NOT NULL COMMENT 'Descrizione altra  categorie di terzi (quando sopra = 0)',
  `C04` text NOT NULL COMMENT 'Vengono eseguiti trattamenti in cui i dati sono comunicati a destinatari di Paesi terzi e/o Organizzazioni internazionali? (Se no lasciare vuoto)',
  `D01A` tinyint(1) NOT NULL DEFAULT '0' COMMENT 'Descrizione dei sistemi informatici: computer singolo',
  `D01B` tinyint(1) NOT NULL DEFAULT '0' COMMENT 'Descrizione dei sistemi informatici: più computer non collegati tra loro',
  `D01C` tinyint(1) NOT NULL DEFAULT '0' COMMENT 'Descrizione dei sistemi informatici: sistemi connessi ad internet',
  `D01D` tinyint(1) NOT NULL DEFAULT '0' COMMENT 'Descrizione dei sistemi informatici: sistemi connessi ad entranet',
  `D01E` tinyint(1) NOT NULL DEFAULT '0' COMMENT 'Descrizione dei sistemi informatici: sistemi connessi a cloud',
  `D01F` tinyint(1) NOT NULL DEFAULT '0' COMMENT 'Descrizione dei sistemi informatici: presenza di server',
  `D02A` tinyint(1) NOT NULL DEFAULT '0' COMMENT 'Sistemi di sicurezza dei dati personali: pseudonimizzazione ',
  `D02B` tinyint(1) NOT NULL DEFAULT '0' COMMENT 'Sistemi di sicurezza dei dati personali: cifratura',
  `D02C` tinyint(1) NOT NULL DEFAULT '0' COMMENT 'Sistemi di sicurezza dei dati personali: sistemi protetti da password',
  `D02D` tinyint(1) NOT NULL DEFAULT '0' COMMENT 'Sistemi di sicurezza dei dati personali: sistemi antivirus',
  `D02E` tinyint(1) NOT NULL DEFAULT '0' COMMENT 'Sistemi di sicurezza dei dati personali: sistemi anti malware',
  `D02F` tinyint(1) NOT NULL DEFAULT '0' COMMENT 'Sistemi di sicurezza dei dati personali: sistemi firewall',
  `D02G` tinyint(1) NOT NULL DEFAULT '0' COMMENT 'Sistemi di sicurezza dei dati personali: sistemi di backup',
  `D03` text NOT NULL COMMENT 'Sistemi di pseudonimizzazione dei dati adottati, Art. 4 Regolamento 679/2016: “1. 5) «pseudonimizzazione»: il trattamento dei dati personali in modo tale che i dati personali non possano più essere attribuiti a un interessato specifico senza l''utilizzo di informazioni aggiuntive, a condizione che tali informazioni aggiuntive siano conservate separatamente e soggette a misure tecniche e organizzative intese a garantire che tali dati personali non siano attribuiti a una persona fisica identificata o identificabile"',
  `D04` text NOT NULL COMMENT 'Sistemi di cifratura dei dati adottati',
  `D05` text NOT NULL COMMENT 'Sistemi di protezione mediante password adottati',
  `D05_giorni` int(3) NOT NULL DEFAULT '0' COMMENT 'Giorni aggiornamento password',
  `D06` text NOT NULL COMMENT 'Sistemi antivirus adottati',
  `D06_giorni` int(3) NOT NULL DEFAULT '0' COMMENT 'Giorni aggiornamento antivirus',
  `D07` text NOT NULL COMMENT 'Sistemi anti malware adottati',
  `D07_giorni` int(3) NOT NULL DEFAULT '0' COMMENT 'Giorni aggiornamento anti malware',
  `D08` text NOT NULL COMMENT 'Sistemi firewall adottati',
  `D08_giorni` int(3) NOT NULL DEFAULT '0' COMMENT 'Giorni aggiornamento firewall',
  `D09` text NOT NULL COMMENT 'Sistemi back up adottati',
  `D09_giorni` int(3) NOT NULL DEFAULT '0' COMMENT 'Giorni intervallo backup',
  `D10` tinyint(1) NOT NULL DEFAULT '0' COMMENT 'Le misure di sicurezza adottate nel loro insieme garantiscono un adeguato livello di sicurezza?',
  `D11` tinyint(1) NOT NULL DEFAULT '0' COMMENT 'Livello di attuazione del codice di condotta (0=nullo, 1-8=parziale, 9=totale)',
  `D11_descri` text NOT NULL COMMENT 'Il codice di condotta adottato quali adempimenti prescrive in materia di sicurezza? (es."ogni utente è stato edotto tramite il REGOLAMENTO PER L''UTILIZZO DELLE RISORSE INFORMATICHE")',
  `D12` tinyint(1) NOT NULL DEFAULT '0' COMMENT 'Livello di attuazione delle prescrizioni imposte da sistema di certificazione adottato (0=nullo, 1-8=parziale, 9=totale)',
  `D12_descri` text NOT NULL COMMENT 'Descrizione degli adempimenti del sistema di certificazione adottato in materia di sicurezza dei dati',
  `E01` text NOT NULL COMMENT 'Archivi elettronici: descrizione dei sistemi hardware e software utilizzati per archiviare i dati',
  `E02` text NOT NULL COMMENT 'Archivi cartacei: Descrizione dei sistemi utilizzati per archiviare i dati',
  `E03` tinyint(1) NOT NULL DEFAULT '0' COMMENT 'Luogo di presenza degli archivi elettronici (0=presso il titolare nella propria sede, 1=presso il titolare ma in altri luoghi in territorio italiano, 2=presso il titolare ma in altri luoghi in territorio UE, 3=presso il titolare ma in altri luoghi in territorio extra UE, 4=presso soggeti terzi in territorio Italiano, 5=presso soggeti terzi in territorio UE, 6=presso soggeti terzi in territorio extra UE)',
  `E03_extra` text NOT NULL COMMENT 'eventuale territorio extra UE',
  `E04` tinyint(1) NOT NULL DEFAULT '0' COMMENT 'Luogo di presenza degli archivi cartacei (0=presso il titolare nella propria sede, 1=presso il titolare ma in altri luoghi in territorio italiano, 2=presso il titolare ma in altri luoghi in territorio UE, 3=presso il titolare ma in altri luoghi in territorio extra UE, 4=presso soggeti terzi in territorio Italiano, 5=presso soggeti terzi in territorio UE, 6=presso soggeti terzi in territorio extra UE)',
  `E04_extra` text NOT NULL COMMENT 'eventuale territorio extra UE',
  `F01` tinyint(1) NOT NULL DEFAULT '0' COMMENT 'Sono effettuati trattamenti che possono presentare rischi per i diritti e le libertà degli interessati? ',
  `F02` tinyint(1) NOT NULL DEFAULT '0' COMMENT 'In caso di risposta positiva al punto F.01: i trattamenti sono occasionali?',
  `F03` tinyint(1) NOT NULL DEFAULT '0' COMMENT 'In caso di risposta positiva al punto F.01: i trattamenti includono categorie di dati di cui all’art. 9 del Regolamento (dati sensibili, genetici e biometrici)?',
  `F04` tinyint(1) NOT NULL DEFAULT '0' COMMENT 'In caso di risposta positiva al punto F.01: i trattamenti includono categorie di dati di cui all’art. 10 del Regolamento (dati relativi a condanne penali e/o a reati)?',
  `G01A` tinyint(1) NOT NULL DEFAULT '0' COMMENT 'Rischi individuati relativi alla possibile perdita di dati: a) rottura dei sistemi di archiviazione dati elettronici ',
  `G01B` tinyint(1) NOT NULL DEFAULT '0' COMMENT 'Rischi individuati relativi alla possibile perdita di dati: b) interruzione non programmata dell’alimentazione dei sistemi informatici',
  `G01C` tinyint(1) NOT NULL DEFAULT '0' COMMENT 'Rischi individuati relativi alla possibile perdita di dati: c) furto degli archivi informatici',
  `G01D` tinyint(1) NOT NULL DEFAULT '0' COMMENT 'Rischi individuati relativi alla possibile perdita di dati: d) furto degli archivi cartacei',
  `G01E` tinyint(1) NOT NULL DEFAULT '0' COMMENT 'Rischi individuati relativi alla possibile perdita di dati: e) perdita dei dati informatici a causa di virus o di altri agenti informatici automatizzati',
  `G01F` tinyint(1) NOT NULL DEFAULT '0' COMMENT 'Rischi individuati relativi alla possibile perdita di dati: f) perdita dei dati informatici a causa di intrusione nei sistemi informatici dall’esterno',
  `G01G` tinyint(1) NOT NULL DEFAULT '0' COMMENT 'Rischi individuati relativi alla possibile perdita di dati: g) cancellazione non volontaria dei dati',
  `G01H` tinyint(1) NOT NULL DEFAULT '0' COMMENT 'Rischi individuati relativi alla possibile perdita di dati: h) distruzione non volontaria di documenti contenti dati',
  `G02A` tinyint(1) NOT NULL DEFAULT '0' COMMENT 'Rischi individuati relativi alla possibile sottrazione e divulgazione non autorizzata di dati: a) furto degli archivi informatici',
  `G02B` tinyint(1) NOT NULL DEFAULT '0' COMMENT 'Rischi individuati relativi alla possibile sottrazione e divulgazione non autorizzata di dati: b) furto degli archivi cartacei',
  `G02C` tinyint(1) NOT NULL DEFAULT '0' COMMENT 'Rischi individuati relativi alla possibile sottrazione e divulgazione non autorizzata di dati: c) sottrazione di dati contenuti in archivi informatici a causa di virus o di altri agenti informatici automatizzati',
  `G02D` tinyint(1) NOT NULL DEFAULT '0' COMMENT 'Rischi individuati relativi alla possibile sottrazione e divulgazione non autorizzata di dati: d) sottrazione di dati contenuti in archivi informatici a causa di intrusione di nei sistemi informatici di soggetti dall’esterno',
  `G03A` text NOT NULL COMMENT 'Individuazione soluzioni relative ai rischi inerenti alla possibile perdita di dati (G.01) per: a) rottura dei sistemi di archiviazione dati elettronici ',
  `G03B` text NOT NULL COMMENT 'Individuazione soluzioni relative ai rischi inerenti alla possibile perdita di dati (G.01) per: b) interruzione non programmata dell’alimentazione dei sistemi informatici',
  `G03C` text NOT NULL COMMENT 'Individuazione soluzioni relative ai rischi inerenti alla possibile perdita di dati (G.01) per: c) furto degli archivi informatici',
  `G03D` text NOT NULL COMMENT 'Individuazione soluzioni relative ai rischi inerenti alla possibile perdita di dati (G.01) per: d) furto degli archivi cartacei',
  `G03E` text NOT NULL COMMENT 'Individuazione soluzioni relative ai rischi inerenti alla possibile perdita di dati (G.01) per: e) perdita dei dati informatici a causa di virus o di altri agenti informatici automatizzati',
  `G03F` text NOT NULL COMMENT 'Individuazione soluzioni relative ai rischi inerenti alla possibile perdita di dati (G.01) per: f) perdita dei dati informatici a causa di intrusione nei sistemi informatici dall’esterno',
  `G03G` text NOT NULL COMMENT 'Individuazione soluzioni relative ai rischi inerenti alla possibile perdita di dati (G.01) per: g) cancellazione non volontaria dei dati',
  `G03H` text NOT NULL COMMENT 'Individuazione soluzioni relative ai rischi inerenti alla possibile perdita di dati (G.01) per: h) distruzione non volontaria di documenti contenti dati',
  `G04A` text NOT NULL COMMENT 'Individuazione soluzioni relative ai rischi inerenti alla possibile sottrazione e divulgazione non autorizzata di dati (G.02):  a) furto degli archivi informatici',
  `G04B` text NOT NULL COMMENT 'Individuazione soluzioni relative ai rischi inerenti alla possibile sottrazione e divulgazione non autorizzata di dati (G.02):  b) furto degli archivi cartacei',
  `G04C` text NOT NULL COMMENT 'Individuazione soluzioni relative ai rischi inerenti alla possibile sottrazione e divulgazione non autorizzata di dati (G.02): c) sottrazione di dati contenuti in archivi informatici a causa di virus o di altri agenti informatici automatizzati',
  `G04D` text NOT NULL COMMENT 'Individuazione soluzioni relative ai rischi inerenti alla possibile sottrazione e divulgazione non autorizzata di dati (G.02): d) sottrazione di dati contenuti in archivi informatici a causa di intrusione di nei sistemi informatici di soggetti dall’esterno',
  `G05` text NOT NULL COMMENT 'Procedure di comunicazione di Data Breach relative ai rischi inerenti alla possibile perdita di dati (G.01)',
  `G06` text NOT NULL COMMENT 'Procedure di comunicazione di Data Breach relative alla possibile sottrazione e divulgazione non autorizzata di dati (G.02)',
  `G07` text NOT NULL COMMENT 'Registro dei Data Breach (Data, tipo di evento, rimedi posti in atto e comunicazione)',
  `H01` tinytext NOT NULL COMMENT 'Modalità di conservazione del Registro (cartaceo o elettronico, in quest''ultimo caso indicare il software utilizzato: es. GAzie) ',
  `H02` tinytext NOT NULL COMMENT 'Elenco dei soggetti autorizzati ad accedere al Registro',
  `H03` tinytext NOT NULL COMMENT 'Soggetto responsabile alla conservazione e distribuzione del Registro',
  `H04` date NOT NULL COMMENT 'Prossima revisione del Registro',
  `adminid` varchar(20) NOT NULL,
  `last_modified` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`revision`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='Registro dei trattamenti (ex art.30 Regolamento UE 2016/679 - GDPR)';

-- --------------------------------------------------------

--
-- Struttura della tabella `gaz_001rigbro`
--

DROP TABLE IF EXISTS `gaz_001rigbro`;
CREATE TABLE IF NOT EXISTS `gaz_001rigbro` (
  `id_rig` int(9) NOT NULL AUTO_INCREMENT,
  `id_tes` int(9) NOT NULL DEFAULT '0',
  `tiprig` int(1) NOT NULL DEFAULT '0',
  `codart` varchar(32) NOT NULL DEFAULT '',
  `codice_fornitore` varchar(50) NOT NULL,
  `descri` varchar(1000) NOT NULL COMMENT '1000 caratteri per uniformarsi al tracciato della fattura elettronica',
  `quality` varchar(50) NOT NULL COMMENT 'per indicare la qualità del materiale richiesto, normativa, ecc',
  `id_body_text` int(9) NOT NULL,
  `unimis` char(3) NOT NULL DEFAULT '',
  `larghezza` decimal(10,3) DEFAULT NULL COMMENT 'espresso in mm',
  `lunghezza` decimal(10,3) DEFAULT NULL COMMENT 'espresso in mm',
  `spessore` decimal(10,3) DEFAULT NULL COMMENT 'espresso in mm',
  `peso_specifico` decimal(10,3) DEFAULT NULL COMMENT 'non necessariamente in kg/l, potrà moltiplicare anche con i ml, mq, pezzi',
  `pezzi` int(9) DEFAULT NULL,
  `quanti` decimal(14,5) DEFAULT NULL,
  `prelis` decimal(14,5) DEFAULT '0.00000',
  `sconto` decimal(6,3) DEFAULT '0.000',
  `codvat` int(2) NOT NULL DEFAULT '0',
  `pervat` decimal(3,1) DEFAULT '0.0',
  `codric` int(9) NOT NULL DEFAULT '0',
  `provvigione` decimal(4,2) NOT NULL,
  `ritenuta` decimal(3,1) NOT NULL,
  `delivery_date` date DEFAULT '2004-01-27',
  `id_doc` int(9) NOT NULL,
  `id_mag` int(9) NOT NULL,
  `id_orderman` int(9) DEFAULT NULL COMMENT 'Per avere riferimenti uno a molti, e viceversa, con le produzioni (orderman)',
  `id_rigmoc` int(9) DEFAULT NULL COMMENT 'Riferimento ad id_rig della tabella gaz_NNNrigmoc',
  `status` varchar(100) NOT NULL DEFAULT '',
  PRIMARY KEY (`id_rig`) USING BTREE,
  KEY `id_orderman` (`id_orderman`),
  KEY `id_tes` (`id_tes`),
  KEY `id_rigmoc` (`id_rigmoc`),
  KEY `codart` (`codart`),
  KEY `tiprig` (`tiprig`),
  KEY `id_doc` (`id_doc`),
  KEY `id_mag` (`id_mag`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='Righi dei documenti le cui testate sono contenute in gaz_NNNtesbro';

-- --------------------------------------------------------

--
-- Struttura della tabella `gaz_001rigdoc`
--

DROP TABLE IF EXISTS `gaz_001rigdoc`;
CREATE TABLE IF NOT EXISTS `gaz_001rigdoc` (
  `id_rig` int(9) NOT NULL AUTO_INCREMENT,
  `id_tes` int(9) NOT NULL DEFAULT '0',
  `tiprig` int(2) NOT NULL DEFAULT '0',
  `codart` varchar(32) NOT NULL DEFAULT '',
  `codice_fornitore` varchar(50) NOT NULL DEFAULT '',
  `descri` varchar(1000) NOT NULL COMMENT '1000 caratteri per uniformarsi al tracciato della fattura elettronica',
  `quality` varchar(50) NOT NULL COMMENT 'per indicare la qualità del materiale richiesto, normativa, ecc',
  `id_body_text` int(9) NOT NULL,
  `unimis` char(3) NOT NULL DEFAULT '',
  `larghezza` decimal(10,3) DEFAULT NULL COMMENT 'espresso in mm',
  `lunghezza` decimal(10,3) DEFAULT NULL COMMENT 'espresso in mm',
  `spessore` decimal(10,3) DEFAULT NULL COMMENT 'espresso in mm',
  `peso_specifico` decimal(10,3) DEFAULT NULL COMMENT 'non necessariamente in kg/l, potrà moltiplicare anche con i ml, mq, pezzi',
  `pezzi` int(9) DEFAULT NULL,
  `quanti` decimal(14,5) DEFAULT NULL,
  `prelis` decimal(17,8) DEFAULT '0.00000000',
  `sconto` decimal(6,3) DEFAULT NULL,
  `codvat` int(2) NOT NULL DEFAULT '0',
  `pervat` decimal(3,1) DEFAULT '0.0',
  `codric` int(9) NOT NULL DEFAULT '0',
  `provvigione` decimal(4,2) NOT NULL COMMENT 'Provvigione in caso di agente oppure percentuale cassa previdenziale in caso di tipo rigo = 4',
  `ritenuta` decimal(3,1) NOT NULL,
  `id_order` int(9) NOT NULL,
  `id_mag` int(9) NOT NULL,
  `id_orderman` int(9) NOT NULL DEFAULT '0' COMMENT 'Ref. alla tabella gaz_001orderman (produzioni-contabilità industriale) ',
  `status` varchar(10) NOT NULL DEFAULT '',
  PRIMARY KEY (`id_rig`) USING BTREE,
  KEY `id_order` (`id_order`),
  KEY `id_tes` (`id_tes`),
  KEY `id_mag` (`id_mag`),
  KEY `codice_fornitore` (`codice_fornitore`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='Righi dei documenti le cui testate sono contenute in gaz_NNNtesdoc';

-- --------------------------------------------------------

--
-- Struttura della tabella `gaz_001rigmoc`
--

DROP TABLE IF EXISTS `gaz_001rigmoc`;
CREATE TABLE IF NOT EXISTS `gaz_001rigmoc` (
  `id_rig` int(9) NOT NULL AUTO_INCREMENT,
  `id_tes` int(9) NOT NULL DEFAULT '0',
  `darave` char(1) NOT NULL DEFAULT '0',
  `codcon` int(9) NOT NULL DEFAULT '0',
  `import` decimal(11,2) DEFAULT '0.00',
  `id_orderman` int(9) NOT NULL DEFAULT '0' COMMENT 'Ref. alla tabella gaz_001orderman (produzioni-contabilità industriale) ',
  PRIMARY KEY (`id_rig`) USING BTREE,
  KEY `codcon` (`codcon`),
  KEY `id_tes` (`id_tes`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='Righi dei movimenti contabili le cui testate sono contenute in gaz_NNNtesmov';

-- --------------------------------------------------------

--
-- Struttura della tabella `gaz_001rigmoi`
--

DROP TABLE IF EXISTS `gaz_001rigmoi`;
CREATE TABLE IF NOT EXISTS `gaz_001rigmoi` (
  `id_rig` int(9) NOT NULL AUTO_INCREMENT,
  `id_tes` int(9) NOT NULL DEFAULT '0',
  `tipiva` char(1) NOT NULL DEFAULT '0',
  `reverse_charge_idtes` int(9) NOT NULL,
  `operation_type` varchar(15) NOT NULL,
  `codiva` int(2) NOT NULL DEFAULT '0',
  `periva` decimal(3,1) DEFAULT '0.0',
  `imponi` decimal(11,2) DEFAULT '0.00',
  `impost` decimal(11,2) DEFAULT '0.00',
  PRIMARY KEY (`id_rig`) USING BTREE,
  KEY `id_tes` (`id_tes`),
  KEY `reverse_charge_idtes` (`reverse_charge_idtes`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='Righi dei movimenti IVA le cui testate sono contenute in gaz_NNNtesmov';

-- --------------------------------------------------------

--
-- Struttura della tabella `gaz_001sconti_articoli`
--

DROP TABLE IF EXISTS `gaz_001sconti_articoli`;
CREATE TABLE IF NOT EXISTS `gaz_001sconti_articoli` (
  `clfoco` int(9) NOT NULL,
  `codart` varchar(32) NOT NULL,
  `sconto` decimal(6,3) DEFAULT NULL,
  `prezzo_netto` decimal(14,5) DEFAULT NULL,
  KEY `clfoco` (`clfoco`),
  KEY `codart` (`codart`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Struttura della tabella `gaz_001sconti_raggruppamenti`
--

DROP TABLE IF EXISTS `gaz_001sconti_raggruppamenti`;
CREATE TABLE IF NOT EXISTS `gaz_001sconti_raggruppamenti` (
  `clfoco` int(9) NOT NULL,
  `ragstat` char(32) NOT NULL,
  `sconto` decimal(6,3) DEFAULT NULL,
  KEY `ragstat` (`ragstat`),
  KEY `clfoco` (`clfoco`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Struttura della tabella `gaz_001shelves`
--

DROP TABLE IF EXISTS `gaz_001shelves`;
CREATE TABLE IF NOT EXISTS `gaz_001shelves` (
  `id_shelf` int(3) NOT NULL AUTO_INCREMENT,
  `id_warehouse` int(3) DEFAULT NULL,
  `descri` varchar(50) NOT NULL DEFAULT '',
  `code` varchar(32) NOT NULL DEFAULT '',
  `image` blob,
  `custom_field` text COMMENT 'Riferimenti generici utilizzabili sui moduli. Normalmente in formato json: {"nome_modulo":{"nome_variabile":{"valore_variabile": {}}}}',
  `adminid` varchar(20) NOT NULL DEFAULT '',
  `last_modified` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id_shelf`) USING BTREE,
  UNIQUE KEY `id_shelf_id_warehouse` (`id_shelf`,`id_warehouse`),
  KEY `id_warehouse` (`id_warehouse`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

-- --------------------------------------------------------

--
-- Struttura della tabella `gaz_001spediz`
--

DROP TABLE IF EXISTS `gaz_001spediz`;
CREATE TABLE IF NOT EXISTS `gaz_001spediz` (
  `codice` int(2) NOT NULL DEFAULT '0',
  `descri` varchar(50) NOT NULL DEFAULT '',
  `annota` varchar(50) DEFAULT NULL,
  `adminid` varchar(20) NOT NULL DEFAULT '',
  `last_modified` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`codice`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Dump dei dati per la tabella `gaz_001spediz`
--

INSERT INTO `gaz_001spediz` (`codice`, `descri`, `annota`, `adminid`, `last_modified`) VALUES
(1, 'A MEZZO DESTINATARIO', '', '', '2005-07-14 17:12:57'),
(2, ' A MEZZO VETTORE', '', '', '2005-07-14 17:12:57'),
(3, 'A MEZZO MITTENTE', '', '', '2005-07-14 17:12:57');

-- --------------------------------------------------------

--
-- Struttura della tabella `gaz_001staff`
--

DROP TABLE IF EXISTS `gaz_001staff`;
CREATE TABLE IF NOT EXISTS `gaz_001staff` (
  `id_staff` int(9) NOT NULL AUTO_INCREMENT,
  `id_clfoco` int(9) NOT NULL,
  `id_contract` int(9) NOT NULL,
  `id_worker_type` int(3) NOT NULL,
  `job_title` varchar(100) DEFAULT NULL,
  `employment_status` int(2) DEFAULT NULL,
  `last_hourly_cost` decimal(6,2) DEFAULT NULL COMMENT 'Costo orario del lavoro',
  `joined_date` date DEFAULT '2004-01-27',
  `job_grade` varchar(50) DEFAULT NULL,
  `title` varchar(100) DEFAULT NULL,
  `institution` varchar(100) DEFAULT NULL,
  `graduation_year` date DEFAULT '2004-01-27',
  `start_date` date DEFAULT '2004-01-27',
  `end_date` date DEFAULT '2004-01-27',
  `Codice_CCNL` varchar(30) NOT NULL,
  PRIMARY KEY (`id_staff`),
  KEY `id_contract` (`id_contract`),
  KEY `id_clfoco` (`id_clfoco`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

--
-- Dump dei dati per la tabella `gaz_001staff`
--

INSERT INTO `gaz_001staff` (`id_staff`, `id_clfoco`, `id_contract`, `id_worker_type`, `job_title`, `employment_status`, `last_hourly_cost`, `joined_date`, `job_grade`, `title`, `institution`, `graduation_year`, `start_date`, `end_date`, `Codice_CCNL`) VALUES
(1, 220000001, 0, 0, 'MECHA AMANTE', 0, NULL, '2004-01-27', '', '', '', '2004-01-27', '2004-01-27', '2094-01-27', 'G352020');

-- --------------------------------------------------------

--
-- Struttura della tabella `gaz_001staff_skills`
--

DROP TABLE IF EXISTS `gaz_001staff_skills`;
CREATE TABLE IF NOT EXISTS `gaz_001staff_skills` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `id_staff` int(9) NOT NULL,
  `variable_name` varchar(50) DEFAULT NULL,
  `skill_data` varchar(100) DEFAULT NULL,
  `skill_description` varchar(100) DEFAULT NULL,
  `skill_cost` decimal(8,2) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `id_staff` (`id_staff`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Struttura della tabella `gaz_001staff_worked_hours`
--

DROP TABLE IF EXISTS `gaz_001staff_worked_hours`;
CREATE TABLE IF NOT EXISTS `gaz_001staff_worked_hours` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `id_staff` int(9) NOT NULL DEFAULT '0',
  `work_day` date DEFAULT NULL,
  `hours_normal` decimal(3,2) NOT NULL,
  `id_work_type_extra` int(3) NOT NULL DEFAULT '0',
  `hours_extra` decimal(3,2) NOT NULL,
  `id_absence_type` int(3) NOT NULL DEFAULT '0',
  `hours_absence` decimal(3,2) NOT NULL,
  `id_other_type` int(3) NOT NULL DEFAULT '0',
  `hours_other` decimal(3,2) NOT NULL,
  `note` varchar(255) DEFAULT NULL,
  `id_orderman` int(9) DEFAULT NULL COMMENT 'sarà legato al piano dei conti per gestire le commesse (centri di costo)',
  `id_tes` int(9) DEFAULT NULL COMMENT 'può essere usato per link con tesbro al fine di aver un documento/resoconto del lavoro eseguito',
  `custom_field` text COMMENT 'Riferimenti generici utilizzabili sui moduli. Normalmente in formato json: {"nome_modulo":{"nome_variabile":{"valore_variabile": {}}}}',
  PRIMARY KEY (`id`),
  KEY `idx_id_staff` (`id_staff`) USING BTREE,
  KEY `work_day` (`work_day`),
  KEY `id_orderman` (`id_orderman`),
  KEY `id_tes` (`id_tes`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='Tabella contenente i dati per la generazione del "Registro delle presenze", ossia dei riepiloghi giornalieri delle ore/tipo di lavoro eseguito da ciascun lavoratore. Può essere scritta manualente dalla apposita interfaccia o, eventualemente, generata a fine mese dai movimenti registrati su gaz_NNNstaff_work_movements a sua volta frutto di inserimento manuale o se collegato tramite un marcatempo a badge.';

-- --------------------------------------------------------

--
-- Struttura della tabella `gaz_001staff_work_movements`
--

DROP TABLE IF EXISTS `gaz_001staff_work_movements`;
CREATE TABLE IF NOT EXISTS `gaz_001staff_work_movements` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `id_staff` int(3) NOT NULL DEFAULT '0',
  `start_work` datetime DEFAULT NULL,
  `end_work` datetime DEFAULT NULL,
  `id_work_type` int(3) NOT NULL DEFAULT '0' COMMENT 'Quando riferito forza la scelta automatica. Esempio ''nromale'', straordinario, notturno',
  `min_delay` decimal(3,1) NOT NULL DEFAULT '0.0' COMMENT 'Minuti di ritardo',
  `hourly_cost` decimal(6,2) NOT NULL DEFAULT '0.00' COMMENT 'Costo orario',
  `note` varchar(255) DEFAULT NULL,
  `id_orderman` int(9) DEFAULT NULL COMMENT 'sarà legato al piano dei conti per gestire le commesse (centri di costo)',
  `id_staff_worked_hours` int(9) DEFAULT NULL COMMENT 'Se maggiore di 0 il rigo è già stato usato per calcolare il valore del rigo a cui si riferisce su gaz_NNN_staff_worked_hours',
  `custom_field` text COMMENT 'Riferimenti generici utilizzabili sui moduli. Normalmente in formato json: {"nome_modulo":{"nome_variabile":{"valore_variabile": {}}}}',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `id_staff` (`id_staff`) USING BTREE,
  KEY `id_orderman` (`id_orderman`) USING BTREE,
  KEY `work_day` (`start_work`) USING BTREE,
  KEY `id_tes` (`id_staff_worked_hours`) USING BTREE,
  KEY `end_work` (`end_work`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='Tabella contenente i singoli movimenti del lavoratore. Può essere scritta manualente dalla apposita interfaccia o, se collegato, tramite un marcatempo a badge. Offre la possibilità di indicare la produzione/commessa (id_orderman) sulla quale sta lavorando.' ROW_FORMAT=DYNAMIC;

-- --------------------------------------------------------

--
-- Struttura della tabella `gaz_001tesbro`
--

DROP TABLE IF EXISTS `gaz_001tesbro`;
CREATE TABLE IF NOT EXISTS `gaz_001tesbro` (
  `id_tes` int(9) NOT NULL AUTO_INCREMENT,
  `seziva` int(1) NOT NULL DEFAULT '0',
  `tipdoc` char(3) NOT NULL DEFAULT '',
  `ref_ecommerce_id_order` varchar(50) DEFAULT '' COMMENT 'Identificativo ordine attribuito dall''eventuale ecommerce collegato attraverso API',
  `template` varchar(32) DEFAULT '',
  `email` varchar(50) DEFAULT '' COMMENT 'Utilizzato per inviare i documenti ad un indirizzo diverso da quello in anagrafica',
  `print_total` int(1) NOT NULL,
  `delivery_time` int(3) NOT NULL,
  `day_of_validity` int(3) NOT NULL,
  `datemi` date DEFAULT '2004-01-27',
  `weekday_repeat` int(2) NOT NULL DEFAULT '0',
  `protoc` int(9) NOT NULL DEFAULT '0',
  `numdoc` bigint(14) NOT NULL DEFAULT '0',
  `numfat` varchar(20) NOT NULL DEFAULT '0',
  `datfat` date DEFAULT '2004-01-27',
  `clfoco` int(9) NOT NULL DEFAULT '0',
  `pagame` int(2) NOT NULL DEFAULT '0',
  `banapp` int(3) NOT NULL DEFAULT '0',
  `vettor` int(2) NOT NULL DEFAULT '0',
  `listin` int(1) NOT NULL DEFAULT '0',
  `destin` varchar(100) NOT NULL,
  `id_des` int(9) NOT NULL,
  `id_des_same_company` int(9) NOT NULL,
  `spediz` varchar(50) NOT NULL DEFAULT '',
  `portos` varchar(50) NOT NULL DEFAULT '',
  `imball` varchar(50) NOT NULL DEFAULT '',
  `traspo` decimal(6,2) DEFAULT '0.00',
  `speban` decimal(6,2) DEFAULT '0.00',
  `spevar` decimal(6,2) DEFAULT '0.00',
  `round_stamp` tinyint(3) NOT NULL DEFAULT '5',
  `cauven` int(2) NOT NULL,
  `caucon` char(3) NOT NULL,
  `caumag` int(2) NOT NULL,
  `id_agente` int(9) NOT NULL,
  `id_parent_doc` int(9) NOT NULL COMMENT 'riferimento ad id_tes del documento genitore  (es. ordine riferito a preventivo genitore)',
  `sconto` decimal(5,2) DEFAULT '0.00',
  `expense_vat` int(2) NOT NULL DEFAULT '0',
  `stamp` decimal(6,2) NOT NULL,
  `taxstamp` decimal(5,2) NOT NULL,
  `virtual_taxstamp` tinyint(1) NOT NULL,
  `net_weight` decimal(12,2) NOT NULL,
  `gross_weight` decimal(12,2) NOT NULL,
  `units` int(6) NOT NULL,
  `volume` decimal(8,2) NOT NULL,
  `initra` datetime DEFAULT '2004-01-27 18:20:00',
  `geneff` char(1) NOT NULL DEFAULT '',
  `id_contract` int(9) NOT NULL DEFAULT '0',
  `id_con` int(9) NOT NULL DEFAULT '0',
  `id_orderman` int(9) NOT NULL DEFAULT '0',
  `status` varchar(10) NOT NULL DEFAULT '',
  `custom_field` text COMMENT 'Riferimenti generici utilizzabili sui moduli. Normalmente in formato json: {"nome_modulo":{"nome_variabile":{"valore_variabile": {}}}}',
  `adminid` varchar(20) NOT NULL DEFAULT '',
  `last_modified` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id_tes`),
  KEY `idx_seziva` (`seziva`) USING BTREE,
  KEY `idx_datemi` (`datemi`) USING BTREE,
  KEY `ref_ecommerce_id_order` (`ref_ecommerce_id_order`),
  KEY `numdoc` (`numdoc`),
  KEY `clfoco` (`clfoco`),
  KEY `id_contract` (`id_contract`),
  KEY `id_con` (`id_con`),
  KEY `id_orderman` (`id_orderman`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='Testate documenti che non hanno valenza fiscale. Ordini, preventivi, commesse, ecc';

-- --------------------------------------------------------

--
-- Struttura della tabella `gaz_001tesdoc`
--

DROP TABLE IF EXISTS `gaz_001tesdoc`;
CREATE TABLE IF NOT EXISTS `gaz_001tesdoc` (
  `id_tes` int(9) NOT NULL AUTO_INCREMENT,
  `seziva` int(1) NOT NULL DEFAULT '0',
  `tipdoc` char(3) NOT NULL DEFAULT '',
  `ddt_type` char(1) NOT NULL,
  `id_doc_ritorno` int(9) NOT NULL DEFAULT '0',
  `template` varchar(32) DEFAULT '',
  `email` varchar(50) DEFAULT '' COMMENT 'Utilizzato per inviare i documenti ad un indirizzo diverso da quello in anagrafica',
  `datemi` date DEFAULT '2004-01-27',
  `weekday_repeat` int(11) NOT NULL DEFAULT '0',
  `data_ordine` date DEFAULT '2004-01-27',
  `protoc` int(9) NOT NULL DEFAULT '0',
  `numdoc` int(9) NOT NULL DEFAULT '0',
  `numfat` varchar(20) NOT NULL DEFAULT '0',
  `datfat` date DEFAULT '2004-01-27',
  `clfoco` int(9) NOT NULL DEFAULT '0',
  `pagame` int(2) NOT NULL DEFAULT '0',
  `ragbol` int(11) NOT NULL DEFAULT '0',
  `banapp` int(3) NOT NULL DEFAULT '0',
  `vettor` int(2) NOT NULL DEFAULT '0',
  `listin` int(1) NOT NULL DEFAULT '0',
  `destin` varchar(100) NOT NULL,
  `id_des` int(9) NOT NULL,
  `id_des_same_company` int(9) NOT NULL,
  `spediz` varchar(50) NOT NULL DEFAULT '',
  `portos` varchar(50) NOT NULL DEFAULT '',
  `imball` varchar(50) NOT NULL DEFAULT '',
  `traspo` decimal(6,2) DEFAULT '0.00',
  `speban` decimal(6,2) DEFAULT '0.00',
  `spevar` decimal(6,2) DEFAULT '0.00',
  `round_stamp` tinyint(3) NOT NULL DEFAULT '5',
  `cauven` int(2) NOT NULL,
  `caucon` char(3) NOT NULL,
  `caumag` int(2) NOT NULL,
  `id_agente` int(9) NOT NULL,
  `id_parent_doc` int(9) NOT NULL COMMENT 'riferimento ad id_tes del documento genitore  (es. ordine riferito a preventivo genitore)',
  `sconto` decimal(5,2) DEFAULT '0.00',
  `expense_vat` int(2) NOT NULL DEFAULT '0',
  `stamp` decimal(6,2) NOT NULL,
  `taxstamp` decimal(5,2) NOT NULL,
  `virtual_taxstamp` tinyint(1) NOT NULL,
  `net_weight` decimal(12,2) NOT NULL,
  `gross_weight` decimal(12,2) NOT NULL,
  `units` int(6) NOT NULL,
  `volume` decimal(8,2) NOT NULL,
  `initra` datetime DEFAULT '2004-01-27 18:20:00',
  `geneff` char(1) NOT NULL DEFAULT '',
  `id_contract` int(9) NOT NULL DEFAULT '0' COMMENT 'In caso di corrispettivo, scontrino con causale VCO, viene usato per contenere l''id del registratore ovvero id_cash della tabella gaz_NNNcash_register, se "0" verrà generato un file XML, altrimenti verranno inviati i dati al RT in base a quanto indicato sul rigo della tabella citata',
  `id_con` int(9) NOT NULL DEFAULT '0',
  `datreg` date DEFAULT NULL COMMENT 'Data in cui si vuole venga registrata in contabilità la fattura d''acquisto (prima veniva messo in impropriamente in datemi)',
  `fattura_elettronica_zip_package` varchar(100) DEFAULT NULL COMMENT 'Nome del file zip in cui è contenuto la fattura elettronica',
  `fattura_elettronica_original_name` varchar(100) DEFAULT NULL,
  `fattura_elettronica_original_content` mediumblob,
  `fattura_elettronica_reinvii` int(1) DEFAULT '0' COMMENT 'Numero di reinvii allo SdI della fattura elettronica, assieme alla sezione, alla data fattura e al numero di protocollo e dopo un encode in base 36 determinerà gli ultimi cinque caratteri del nome file',
  `status` varchar(10) NOT NULL DEFAULT '',
  `adminid` varchar(20) NOT NULL DEFAULT '',
  `last_modified` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id_tes`),
  KEY `tipdoc` (`tipdoc`),
  KEY `datfat` (`datfat`),
  KEY `numfat` (`numfat`),
  KEY `idx_tipdoc1` (`tipdoc`(1)) USING BTREE,
  KEY `idx_seziva` (`seziva`) USING BTREE,
  KEY `idx_protoc` (`protoc`) USING BTREE,
  KEY `datreg` (`datreg`),
  KEY `clfoco` (`clfoco`),
  KEY `datemi` (`datemi`),
  KEY `fattura_elettronica_zip_package` (`fattura_elettronica_zip_package`),
  KEY `ddt_type` (`ddt_type`),
  KEY `id_contract` (`id_contract`),
  KEY `id_con` (`id_con`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='Testate documenti fiscalmente validi. Fatture, Note credito, , Documenti di Trasporto, ecc';

-- --------------------------------------------------------

--
-- Struttura della tabella `gaz_001tesmov`
--

DROP TABLE IF EXISTS `gaz_001tesmov`;
CREATE TABLE IF NOT EXISTS `gaz_001tesmov` (
  `id_tes` int(9) NOT NULL AUTO_INCREMENT,
  `caucon` char(3) NOT NULL DEFAULT '',
  `descri` varchar(100) NOT NULL DEFAULT '',
  `notess` text COMMENT 'Note che NON vengono stampate sui registri contabili',
  `datreg` date DEFAULT '2004-01-27',
  `datliq` date DEFAULT '2004-01-27' COMMENT 'Data di riferimento del periodo della liquidazione periodica dell''IVA, non può precedere la data del documento (datdoc)',
  `seziva` int(1) NOT NULL DEFAULT '0',
  `id_doc` int(9) NOT NULL,
  `protoc` int(9) NOT NULL DEFAULT '0',
  `numdoc` varchar(20) NOT NULL DEFAULT '0',
  `datdoc` date DEFAULT '2004-01-27',
  `clfoco` int(9) NOT NULL DEFAULT '0',
  `regiva` char(1) NOT NULL DEFAULT '',
  `operat` int(1) NOT NULL,
  `libgio` char(1) NOT NULL DEFAULT '',
  `adminid` varchar(20) NOT NULL DEFAULT '',
  `last_modified` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id_tes`),
  KEY `datreg` (`datreg`),
  KEY `datliq` (`datliq`),
  KEY `clfoco` (`clfoco`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='Testate dei movimenti contabili';

-- --------------------------------------------------------

--
-- Struttura della tabella `gaz_001vettor`
--

DROP TABLE IF EXISTS `gaz_001vettor`;
CREATE TABLE IF NOT EXISTS `gaz_001vettor` (
  `codice` int(2) NOT NULL DEFAULT '0',
  `id_anagra` int(9) NOT NULL DEFAULT '0',
  `ragione_sociale` varchar(100) NOT NULL,
  `indirizzo` varchar(100) NOT NULL,
  `cap` varchar(5) NOT NULL,
  `citta` varchar(100) NOT NULL,
  `provincia` varchar(100) NOT NULL,
  `partita_iva` varchar(12) NOT NULL,
  `codice_fiscale` varchar(16) NOT NULL,
  `n_albo` varchar(50) NOT NULL,
  `conducente` varchar(100) NOT NULL DEFAULT '',
  `telefo` varchar(50) NOT NULL DEFAULT '',
  `targa` varchar(20) NOT NULL DEFAULT '',
  `annota` varchar(50) NOT NULL DEFAULT '',
  `adminid` varchar(20) NOT NULL DEFAULT '',
  `last_modified` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`codice`),
  KEY `id_anagra` (`id_anagra`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Dump dei dati per la tabella `gaz_001vettor`
--

INSERT INTO `gaz_001vettor` (`codice`, `id_anagra`, `ragione_sociale`, `indirizzo`, `cap`, `citta`, `provincia`, `partita_iva`, `codice_fiscale`, `n_albo`, `conducente`, `telefo`, `targa`, `annota`, `adminid`, `last_modified`) VALUES
(11, 27, 'Ramirez', 'via Dritta, 2', '31033', 'Castelfranco Veneto', 'TV', '22222222220', '22222222220', '', '', '', '', '', 'amministratore', '2021-02-25 17:03:20'),
(12, 28, 'Pagliano e Gori', 'via Curva, 3', '31057', 'Silea', 'TV', '11111111115', '11111111115', '', '', '', '', '', 'amministratore', '2021-02-25 17:03:20');

-- --------------------------------------------------------

--
-- Struttura della tabella `gaz_001warehouse`
--

DROP TABLE IF EXISTS `gaz_001warehouse`;
CREATE TABLE IF NOT EXISTS `gaz_001warehouse` (
  `id` int(3) NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL DEFAULT '',
  `image` blob,
  `web_url` varchar(255) DEFAULT NULL,
  `custom_field` text COMMENT 'Riferimenti generici utilizzabili sui moduli. Normalmente in formato json: {"nome_modulo":{"nome_variabile":{"valore_variabile": {}}}}',
  `note_other` varchar(50) DEFAULT NULL,
  `adminid` varchar(20) NOT NULL DEFAULT '',
  `last_modified` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

-- --------------------------------------------------------

--
-- Struttura della tabella `gaz_admin`
--

DROP TABLE IF EXISTS `gaz_admin`;
CREATE TABLE IF NOT EXISTS `gaz_admin` (
  `image` blob,
  `lang` varchar(15) NOT NULL,
  `style` varchar(15) NOT NULL,
  `skin` varchar(60) NOT NULL DEFAULT 'default.css',
  `Abilit` int(1) NOT NULL DEFAULT '0',
  `Access` int(7) NOT NULL DEFAULT '0',
  `last_ip` varchar(39) NOT NULL,
  `user_id` int(6) NOT NULL AUTO_INCREMENT,
  `id_anagra` int(9) DEFAULT NULL COMMENT 'Riferimento alla tabella anagrafiche comuni (gaz_anagra)',
  `user_firstname` varchar(30) NOT NULL COMMENT 'user''s first name',
  `user_lastname` varchar(30) NOT NULL COMMENT 'user''s last name',
  `user_name` varchar(64) NOT NULL COMMENT 'user''s name, unique',
  `user_password_hash` varchar(255) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL COMMENT 'user''s password in salted and hashed format',
  `aes_key` tinytext NOT NULL,
  `user_email` varchar(64) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL COMMENT 'user''s email, unique',
  `user_telephone` varchar(30) NOT NULL COMMENT 'user''s telephone number',
  `user_active` tinyint(1) NOT NULL DEFAULT '0' COMMENT 'user''s activation status',
  `user_activation_hash` varchar(40) CHARACTER SET utf8 COLLATE utf8_unicode_ci DEFAULT NULL COMMENT 'user''s email verification hash string',
  `user_password_reset_hash` char(40) CHARACTER SET utf8 COLLATE utf8_unicode_ci DEFAULT NULL COMMENT 'user''s password reset code',
  `user_password_reset_timestamp` bigint(20) DEFAULT NULL COMMENT 'timestamp of the password reset request',
  `user_rememberme_token` varchar(64) CHARACTER SET utf8 COLLATE utf8_unicode_ci DEFAULT NULL COMMENT 'user''s remember-me cookie token',
  `user_failed_logins` tinyint(1) NOT NULL DEFAULT '0' COMMENT 'user''s failed login attemps',
  `user_last_failed_login` int(10) DEFAULT NULL COMMENT 'unix timestamp of last failed login attempt',
  `user_registration_datetime` datetime NOT NULL DEFAULT '2004-01-27 00:00:00',
  `user_registration_ip` varchar(39) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL DEFAULT '0.0.0.0',
  `company_id` int(3) NOT NULL,
  `datacc` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `datpas` date DEFAULT '2004-01-27',
  PRIMARY KEY (`user_id`),
  KEY `id_anagra` (`id_anagra`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

--
-- Dump dei dati per la tabella `gaz_admin`
--

INSERT INTO `gaz_admin` (`image`, `lang`, `style`, `skin`, `Abilit`, `Access`, `last_ip`, `user_id`, `id_anagra`, `user_firstname`, `user_lastname`, `user_name`, `user_password_hash`, `aes_key`, `user_email`, `user_telephone`, `user_active`, `user_activation_hash`, `user_password_reset_hash`, `user_password_reset_timestamp`, `user_rememberme_token`, `user_failed_logins`, `user_last_failed_login`, `user_registration_datetime`, `user_registration_ip`, `company_id`, `datacc`, `datpas`) VALUES
(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, 'italian', 'default.css', 'default.css', 9, 0, '127.0.0.1', 1, 29, 'Antonio', 'de Vincentiis', 'amministratore', '$2y$10$FwOW.X3S2534JLuwGE3Ugeh3Hfe01sxC6UpEqn6t03Nk6FcQ/OTs.', '', '', '', 1, '', '', 0, NULL, 0, 0, '2004-01-27 00:00:00', '0.0.0.0', 1, NOW(), NOW());

-- --------------------------------------------------------

--
-- Struttura della tabella `gaz_admin_config`
--

DROP TABLE IF EXISTS `gaz_admin_config`;
CREATE TABLE IF NOT EXISTS `gaz_admin_config` (
  `id` int(9) UNSIGNED NOT NULL AUTO_INCREMENT,
  `adminid` varchar(20) NOT NULL DEFAULT '',
  `var_descri` varchar(100) NOT NULL DEFAULT '',
  `var_name` varchar(100) NOT NULL DEFAULT '',
  `var_value` text,
  PRIMARY KEY (`id`),
  KEY `adminid` (`adminid`),
  KEY `var_name` (`var_name`)
) ENGINE=MyISAM AUTO_INCREMENT=8 DEFAULT CHARSET=utf8;

--
-- Dump dei dati per la tabella `gaz_admin_config`
--

INSERT INTO `gaz_admin_config` (`id`, `adminid`, `var_descri`, `var_name`, `var_value`) VALUES
(1, 'amministratore', 'Contenuto in HTML del testo del corpo delle email inviate dell\'utente', 'body_send_doc_email', ''),
(2, 'amministratore', 'Menu/header/footer personalizzabile', 'theme', '/library/theme/lte'),
(3, 'amministratore', 'Attiva lo stile ', 'LTE_Fixed', 'true'),
(4, 'amministratore', 'Attiva lo stile boxed', 'LTE_Boxed', 'false'),
(5, 'amministratore', 'Collassa il menu principale', 'LTE_Collapsed', 'false'),
(6, 'amministratore', 'Espandi automaticamente il menu', 'LTE_Onhover', 'true'),
(7, 'amministratore', 'Mantieni la barra aperta', 'LTE_SidebarOpen', 'false');

-- --------------------------------------------------------

--
-- Struttura della tabella `gaz_admin_login_history`
--

DROP TABLE IF EXISTS `gaz_admin_login_history`;
CREATE TABLE IF NOT EXISTS `gaz_admin_login_history` (
  `login_user_id` int(6) NOT NULL,
  `login_datetime` datetime DEFAULT NULL,
  `login_user_ip` varchar(39) DEFAULT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='Tabella che tiene traccia di tutti i login effettuati dagli utenti, unito ai campi <last_modified> sulle varie tabelle e la tabella <gaz_menu_usage> servirà agli amministratori di sistema per controllare le attività degli utenti';

--
-- Dump dei dati per la tabella `gaz_admin_login_history`
--

INSERT INTO `gaz_admin_login_history` (`login_user_id`, `login_datetime`, `login_user_ip`) VALUES
(1, '2022-07-30 06:02:50', '127.0.0.1');

-- --------------------------------------------------------

--
-- Struttura della tabella `gaz_admin_module`
--

DROP TABLE IF EXISTS `gaz_admin_module`;
CREATE TABLE IF NOT EXISTS `gaz_admin_module` (
  `adminid` varchar(20) NOT NULL DEFAULT '',
  `company_id` int(3) NOT NULL,
  `moduleid` int(11) NOT NULL DEFAULT '0',
  `custom_field` text COMMENT 'Usabile per contenere le scelte dell''utente in ambito dello specifico modulo.Normalmente in formato json: {"nome_variabile":{"valore_variabile": {}}',
  `access` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`adminid`,`company_id`,`moduleid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Dump dei dati per la tabella `gaz_admin_module`
--

INSERT INTO `gaz_admin_module` (`adminid`, `company_id`, `moduleid`, `custom_field`, `access`) VALUES
('amministratore', 1, 1, NULL, 3),
('amministratore', 1, 2, NULL, 3),
('amministratore', 1, 3, NULL, 3),
('amministratore', 1, 4, NULL, 3),
('amministratore', 1, 5, '{\"user_id_warehouse\":0}', 3),
('amministratore', 1, 6, NULL, 3),
('amministratore', 1, 7, NULL, 3),
('amministratore', 1, 8, NULL, 3),
('amministratore', 1, 10, NULL, 3),
('amministratore', 1, 11, NULL, 0),
('amministratore', 1, 12, NULL, 3),
('amministratore', 1, 13, NULL, 0),
('amministratore', 1, 15, NULL, 3),
('amministratore', 1, 16, NULL, 3),
('amministratore', 1, 17, NULL, 3);

-- --------------------------------------------------------

--
-- Struttura della tabella `gaz_anagra`
--

DROP TABLE IF EXISTS `gaz_anagra`;
CREATE TABLE IF NOT EXISTS `gaz_anagra` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `ragso1` varchar(50) NOT NULL DEFAULT '',
  `ragso2` varchar(50) NOT NULL DEFAULT '',
  `sedleg` varchar(100) NOT NULL DEFAULT '',
  `legrap_pf_nome` varchar(60) NOT NULL DEFAULT '',
  `legrap_pf_cognome` varchar(60) NOT NULL DEFAULT '',
  `fiscal_rapresentative_id` int(9) NOT NULL COMMENT 'riferito all'' id  del record di questa tabella  contenente l''anagrafica del rappresentente fiscale',
  `sexper` char(1) NOT NULL DEFAULT '',
  `datnas` date DEFAULT '1900-01-01',
  `luonas` varchar(50) NOT NULL DEFAULT '',
  `pronas` char(2) NOT NULL DEFAULT '',
  `counas` varchar(3) NOT NULL,
  `indspe` varchar(60) NOT NULL,
  `capspe` varchar(10) NOT NULL DEFAULT '',
  `citspe` varchar(60) NOT NULL,
  `prospe` char(2) NOT NULL DEFAULT '',
  `country` varchar(3) NOT NULL,
  `id_currency` int(3) NOT NULL,
  `id_language` int(3) NOT NULL,
  `latitude` decimal(8,5) NOT NULL,
  `longitude` decimal(8,5) NOT NULL,
  `telefo` varchar(50) NOT NULL DEFAULT '',
  `fax` varchar(32) NOT NULL DEFAULT '',
  `cell` varchar(32) NOT NULL DEFAULT '',
  `codfis` varchar(16) NOT NULL DEFAULT '',
  `pariva` varchar(12) NOT NULL DEFAULT '0',
  `fe_cod_univoco` varchar(7) NOT NULL,
  `e_mail` varchar(60) NOT NULL,
  `e_mail2` varchar(60) NOT NULL,
  `pec_email` varchar(60) NOT NULL,
  `fatt_email` tinyint(1) NOT NULL DEFAULT '0',
  `id_SIAN` int(10) DEFAULT NULL COMMENT 'identificativo stabilimento assegnato dal SIAN',
  `custom_field` text COMMENT 'Riferimenti generici utilizzabili sui moduli. Normalmente in formato json: {"nome_modulo":{"nome_variabile":{"valore_variabile": {}}}}',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=30 DEFAULT CHARSET=utf8;

--
-- Dump dei dati per la tabella `gaz_anagra`
--

INSERT INTO `gaz_anagra` (`id`, `ragso1`, `ragso2`, `sedleg`, `legrap_pf_nome`, `legrap_pf_cognome`, `fiscal_rapresentative_id`, `sexper`, `datnas`, `luonas`, `pronas`, `counas`, `indspe`, `capspe`, `citspe`, `prospe`, `country`, `id_currency`, `id_language`, `latitude`, `longitude`, `telefo`, `fax`, `cell`, `codfis`, `pariva`, `fe_cod_univoco`, `e_mail`, `e_mail2`, `pec_email`, `fatt_email`, `id_SIAN`, `custom_field`) VALUES
(3, 'De Medici', '', '', '', '', 0, 'G', '2004-01-27', '', '', '', 'Piazza S.Marco, 4', '50121', 'Firenze', 'FI', 'IT', 1, 1, '0.00000', '0.00000', '', '', '', '01720430485', '01720430485', '', '', '', '', 0, NULL, NULL),
(4, 'Fermi', '', '', '', '', 0, 'G', '2004-01-27', '', '', '', 'Piazzale Aldo Moro, 2', '00185 ', 'Roma', 'RM', 'IT', 1, 1, '0.00000', '0.00000', '', '', '', '02403210269', '02403210269', '', '', '', '', 0, NULL, NULL),
(5, 'Canossa', '', '', '', '', 0, 'G', '2004-01-27', '', '', '', ' Via Zamboni, 33', '40126', 'Bologna', 'BO', 'IT', 1, 1, '0.00000', '0.00000', '', '', '', '04732150158', '04732150158', '', '', '', '', 0, NULL, NULL),
(6, 'Pavoni', '', '', '', '', 0, 'G', '2004-01-27', '', '', '', 'Via Lodovico Menicucci, 6', '60121', 'Ancona', 'AN', 'IT', 1, 1, '0.00000', '0.00000', '', '', '', '05779711000', '05779711000', '', '', '', '', 0, NULL, NULL),
(7, 'Pineta', '', '', '', '', 0, 'G', '2000-01-01', '', '', '', 'Viale Pindaro, 42', '65127', 'Pescara', 'PE', 'IT', 1, 1, '0.00000', '0.00000', '', '', '', '01620430403', '01620430403', '', '', '', '', 0, NULL, NULL),
(8, 'Casati', '', '', '', '', 0, 'G', '2004-01-27', '', '', '', 'Corso Duca degli Abruzzi, 24', '10129', 'Torino', 'TO', 'IT', 1, 1, '0.00000', '0.00000', '', '', '', '02513310017', '02513310017', '', '', '', '', 0, NULL, NULL),
(9, 'Borbone', '', '', '', '', 0, 'G', '2004-01-27', '', '', '', 'Piazza Marina, 61', '90133', 'Palermo', 'PA', 'IT', 1, 1, '0.00000', '0.00000', '', '', '', '00496700261', '00496700261', '', '', '', '', 0, NULL, NULL),
(10, 'Brioschi', '', '', '', '', 0, 'G', '2004-01-27', '', '', '', 'Piazza Leonardo da Vinci, 32', '20133', 'Milano', 'MI', 'IT', 1, 1, '0.00000', '0.00000', '', '', '', '01920430483', '01920430483', '', '', '', '', 0, NULL, NULL),
(11, 'Svevia', '', '', '', '', 0, 'G', '2004-01-27', '', '', '', 'Corso Umberto I, 40', '80138', 'Napoli', 'NA', 'IT', 1, 1, '0.00000', '0.00000', '', '', '', '02413310018', '02413310018', '', '', '', '', 0, NULL, NULL),
(12, 'Patavina', '', '', '', '', 0, 'G', '2004-01-27', '', '', '', 'Via 8 Febbraio, 2', '35122', 'Padova', 'PD', 'IT', 1, 1, '0.00000', '0.00000', '', '', '', '00488410010', '00488410010', '', '', '', '', 0, NULL, NULL),
(13, 'Fibonacci', '', '', '', '', 0, 'G', '2004-01-27', '', '', '', 'Lungarno Pacinotti, 43', '50126', 'Pisa', 'PI', 'IT', 1, 1, '0.00000', '0.00000', '', '', '', '04832150157', '04832150157', '', '', '', '', 0, NULL, NULL),
(14, 'Pillio', '', '', '', '', 0, 'G', '2004-01-27', '', '', '', 'Via Università, 4', '41121', 'Modena', 'MO', 'IT', 1, 1, '0.00000', '0.00000', '', '', '', '01250490263', '01250490263', '', '', '', '', 0, NULL, NULL),
(15, 'Rivera', '', '', '', '', 0, 'G', '2004-01-27', '', '', '', 'Piazza Santa Margherita, 2', '67100', 'L\'Aquila', 'AQ', 'IT', 1, 1, '0.00000', '0.00000', '', '', '', '02850410388', '02850410388', '', '', '', '', 0, NULL, NULL),
(16, 'Esquivel', '', '', '', '', 0, 'G', '2004-01-27', '', '', '', 'Via Università, 40', '67100', 'Cagliari', 'CA', 'IT', 1, 1, '0.00000', '0.00000', '', '', '', '04932150156', '04932150156', '', '', '', '', 0, NULL, NULL),
(19, 'BANCA DEL LAGO AG. c/c', '', '', '', '', 0, 'G', '2004-01-27', '', '', '', 'via Bianca, 1', '31100', 'Treviso', 'TV', 'IT', 1, 1, '0.00000', '0.00000', '', '', '', '', '0', '', '', '', '', 0, NULL, NULL),
(20, 'Gigolò', 'Joe', '', '', '', 0, 'M', '1970-01-01', '', '', 'IT', 'Via Giacomo Puccini, 6', '00198', 'Roma', 'PE', 'IT', 0, 0, '0.00000', '0.00000', '3383121161', '', '', 'GGLJOE25A27Z404S', '', '', '', '', '', 0, NULL, NULL),
(27, 'Ramirez', '', '', '', '', 0, 'G', '1900-01-01', '', '', '', 'Via Federico II di Svevia, 6738', '70023', ' Gioia del Colle', 'BA', 'IT', 1, 1, '0.00000', '0.00000', '', '', '', '', '22222222220', '', '', '', '', 0, NULL, NULL),
(28, 'Pagliano e Gori', '', '', '', '', 0, 'G', '1900-01-01', '', '', '', 'Via Pordenone, 52', '33081', 'Aviano', 'PN', 'IT', 1, 1, '0.00000', '0.00000', '', '', '', '', '11111111115', '', '', '', '', 0, NULL, NULL),
(29, 'Antonio', 'de Vincentiis', '', 'Antonio', 'de Vincentiis', 0, '', '1900-01-01', '', '', '', '', '', '', '', '', 0, 0, '0.00000', '0.00000', '', '', '', '', '0', '', '', '', '', 0, NULL, NULL);

-- --------------------------------------------------------

--
-- Struttura della tabella `gaz_anagraes`
--

DROP TABLE IF EXISTS `gaz_anagraes`;
CREATE TABLE IF NOT EXISTS `gaz_anagraes` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `ragso1` tinyblob,
  `ragso2` tinyblob,
  `sedleg` blob,
  `legrap_pf_nome` tinyblob,
  `legrap_pf_cognome` tinyblob,
  `sexper` tinyblob,
  `datnas` tinyblob,
  `luonas` tinyblob,
  `pronas` tinyblob,
  `counas` tinyblob,
  `indspe` tinyblob,
  `capspe` tinyblob,
  `citspe` tinyblob,
  `prospe` tinyblob,
  `country` tinyblob,
  `telefo` tinyblob,
  `fax` tinyblob,
  `cell` tinyblob,
  `codfis` tinyblob,
  `pariva` tinyblob,
  `fe_cod_univoco` tinyblob,
  `e_mail` tinyblob,
  `e_mail2` tinyblob,
  `pec_email` tinyblob,
  `adminid` varchar(20) DEFAULT NULL,
  `last_modified` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=latin1 COMMENT='Per contenere le anagrafiche criptate, utilizzabile in abbinamento con altre tabelle contenenti dati particolarmente sensibili criptati anch''essi .';

-- --------------------------------------------------------

--
-- Struttura della tabella `gaz_aziend`
--

DROP TABLE IF EXISTS `gaz_aziend`;
CREATE TABLE IF NOT EXISTS `gaz_aziend` (
  `codice` int(3) NOT NULL,
  `ragso1` varchar(50) NOT NULL DEFAULT '',
  `ragso2` varchar(50) NOT NULL DEFAULT '',
  `image` blob,
  `sedleg` varchar(100) NOT NULL DEFAULT '',
  `legrap_pf_nome` varchar(60) NOT NULL DEFAULT '',
  `legrap_pf_cognome` varchar(60) NOT NULL DEFAULT '',
  `REA_ufficio` varchar(2) NOT NULL DEFAULT '' COMMENT 'Fattura elettronica 1.2.4.1: Sigla della provincia dell''Ufficio del registro delle imprese presso il quale è registrata la società',
  `REA_numero` varchar(20) NOT NULL DEFAULT '' COMMENT 'Fattura elettronica 1.2.4.2: Numero di iscrizione al registro delle imprese',
  `REA_capitale` decimal(10,2) DEFAULT NULL COMMENT 'Fattura elettronica 1.2.4.3: Nei soli casi di società di capitali (SpA, SApA, SRL), l''elemento informativo va valorizzato per indicare il capitale sociale',
  `REA_socio` varchar(2) NOT NULL DEFAULT '' COMMENT 'Fattura elettronica 1.2.4.4: Nei casi di spa e srl, l''elemento informativo va valorizzato per indicare se vi è un socio unico oppure se vi sono più soci, valori ammessi [SU] socio unico e [SM] più soci',
  `REA_stato` varchar(2) NOT NULL DEFAULT '' COMMENT 'Fattura elettronica 1.2.4.5: Indica se la Società si trova in stato di liquidazione oppure no, valori ammessi [LS] in liquidazione [LN] non in liquidazione',
  `sexper` char(1) NOT NULL DEFAULT '',
  `datnas` date DEFAULT '1900-01-01',
  `order_type` char(3) NOT NULL DEFAULT '' COMMENT 'Tipo produzione: agricola, industriale, professionale, artigianale, ricerca e sviluppo; viene usato nel modulo orderman (produzioni)',
  `luonas` varchar(50) NOT NULL DEFAULT '',
  `pronas` char(2) NOT NULL DEFAULT '',
  `indspe` varchar(50) NOT NULL DEFAULT '',
  `capspe` varchar(10) NOT NULL DEFAULT '',
  `citspe` varchar(50) NOT NULL DEFAULT '',
  `prospe` char(2) NOT NULL DEFAULT '',
  `country` varchar(2) NOT NULL,
  `id_currency` int(3) NOT NULL,
  `id_language` int(3) NOT NULL,
  `telefo` varchar(50) NOT NULL DEFAULT '',
  `fax` varchar(32) NOT NULL DEFAULT '',
  `codfis` varchar(16) NOT NULL DEFAULT '',
  `pariva` varchar(12) DEFAULT NULL,
  `pec` varchar(50) NOT NULL DEFAULT 'gazie@pecazienda.it',
  `e_mail` varchar(50) NOT NULL DEFAULT '',
  `web_url` varchar(255) NOT NULL,
  `gazSynchro` varchar(100) NOT NULL DEFAULT '' COMMENT 'Indico i moduli dove trovare i file contenenti la classe "gazSynchro" con le funzioni  necessarie per eseguire aggiornamenti e/o sincronizzazioni; \r\nè indispensabile che la classe stessa contenga le funzioni api_token e get_sync_status.  \r\nAd ogni cambiamento di movimento di magazzino, cliente, articolo, categoria merceologica, aliquota IVA, presenza di nuovi ordini e/o clienti inseriti dal sito\r\nsi provvederà a fare delle chiamate alle funzioni contenute in essa.',
  `cod_ateco` int(6) NOT NULL DEFAULT '0',
  `regime` varchar(1) NOT NULL,
  `fiscal_reg` varchar(4) NOT NULL,
  `amm_min` varchar(20) NOT NULL,
  `fae_tipo_cassa` varchar(4) NOT NULL COMMENT 'eventualmente con uno dei valori dell''elemento <TipoCassa> della fattura elettronica TC01,TC02,ecc',
  `ra_cassa` tinyint(1) DEFAULT NULL COMMENT 'scelta se applicare o meno la ritenuta d''acconto sulla cassa previdenziale',
  `vat_susp` tinyint(1) NOT NULL COMMENT 'Se a 1 si indica che si sta operando in  regime di “Iva per cassa ex art. 32 bis del D.p.r. 83/2012”',
  `decimal_quantity` int(1) NOT NULL,
  `decimal_price` int(1) NOT NULL,
  `stock_eval_method` int(1) NOT NULL,
  `mascli` int(3) NOT NULL DEFAULT '0',
  `masfor` int(3) NOT NULL DEFAULT '0',
  `masban` int(3) NOT NULL DEFAULT '0',
  `mas_fixed_assets` int(3) NOT NULL DEFAULT '0',
  `mas_found_assets` int(3) NOT NULL DEFAULT '0',
  `mas_cost_assets` int(3) NOT NULL DEFAULT '0',
  `lost_cost_assets` int(9) NOT NULL DEFAULT '0',
  `super_amm_account` int(9) NOT NULL DEFAULT '0',
  `super_amm_rate` decimal(4,1) NOT NULL DEFAULT '40.0',
  `min_rate_deprec` decimal(4,1) NOT NULL DEFAULT '0.0',
  `capital_gains_account` int(9) NOT NULL DEFAULT '0',
  `capital_loss_account` int(9) NOT NULL DEFAULT '0',
  `mas_staff` int(3) NOT NULL,
  `cassa_` int(9) NOT NULL DEFAULT '0',
  `ivaacq` int(9) NOT NULL DEFAULT '0',
  `ivaven` int(9) NOT NULL DEFAULT '0',
  `ivacor` int(9) NOT NULL DEFAULT '0',
  `ivaera` int(9) NOT NULL DEFAULT '0',
  `split_payment` int(9) NOT NULL,
  `impven` int(9) NOT NULL DEFAULT '0',
  `imptra` int(9) NOT NULL DEFAULT '0',
  `impimb` int(9) NOT NULL DEFAULT '0',
  `impspe` int(9) NOT NULL DEFAULT '0',
  `impvar` int(9) NOT NULL DEFAULT '0',
  `boleff` int(9) NOT NULL DEFAULT '0' COMMENT 'Conto dei ricavi per bolli su vendite (il conto di costo su acquisti è la colonna taxstamp_account)',
  `omaggi` int(9) NOT NULL DEFAULT '0',
  `sales_return` int(9) NOT NULL,
  `impacq` int(9) NOT NULL DEFAULT '0',
  `cost_tra` int(9) NOT NULL,
  `cost_imb` int(9) NOT NULL,
  `cost_var` int(9) NOT NULL,
  `purchases_return` int(9) NOT NULL,
  `latitude` decimal(8,5) NOT NULL,
  `longitude` decimal(8,5) NOT NULL,
  `coriba` int(9) NOT NULL DEFAULT '0',
  `cotrat` int(9) NOT NULL DEFAULT '0',
  `cocamb` int(9) NOT NULL DEFAULT '0',
  `c_ritenute` int(9) NOT NULL COMMENT 'conto ritenute subite',
  `c_ritenute_autonomi` int(9) NOT NULL COMMENT 'conto ritenute autonomi da versare ',
  `c_payroll_tax` int(9) NOT NULL DEFAULT '0',
  `closing_balance` int(9) NOT NULL,
  `economic_result` int(9) NOT NULL,
  `operating_profit` int(9) NOT NULL,
  `operating_losses` int(9) NOT NULL,
  `opening_balance` int(9) NOT NULL,
  `ritenuta` decimal(3,1) NOT NULL,
  `payroll_tax` decimal(3,1) NOT NULL,
  `acciva` decimal(4,1) DEFAULT '0.0',
  `taxstamp_limit` decimal(5,2) NOT NULL,
  `taxstamp` decimal(5,2) NOT NULL,
  `perbol` decimal(5,2) DEFAULT '0.00',
  `taxstamp_vat` int(2) NOT NULL DEFAULT '0',
  `taxstamp_account` int(9) NOT NULL DEFAULT '0' COMMENT 'Conto di costo su acquisti per bolli ( quello di ricavo su vendite è sulla colonna boleff)',
  `round_bol` tinyint(3) NOT NULL,
  `virtual_taxstamp` tinyint(1) NOT NULL,
  `virtual_stamp_auth_prot` varchar(14) NOT NULL,
  `virtual_stamp_auth_date` date NOT NULL,
  `causale_pagam_770` varchar(1) NOT NULL,
  `sperib` decimal(5,2) DEFAULT '0.00',
  `desez1` varchar(50) NOT NULL DEFAULT '',
  `desez2` varchar(50) NOT NULL DEFAULT '',
  `desez3` varchar(50) NOT NULL DEFAULT '',
  `desez4` varchar(50) NOT NULL DEFAULT '',
  `desez5` varchar(50) NOT NULL DEFAULT '',
  `desez6` varchar(50) NOT NULL DEFAULT '',
  `desez7` varchar(50) NOT NULL DEFAULT '',
  `desez8` varchar(50) NOT NULL DEFAULT '',
  `desez9` varchar(50) NOT NULL DEFAULT 'AUTOFATTURE - REVERSE CHARGE',
  `reverse_charge_sez` int(1) NOT NULL DEFAULT '9',
  `fatimm` varchar(1) NOT NULL,
  `artsea` varchar(1) NOT NULL,
  `template` varchar(50) NOT NULL,
  `colore` varchar(6) NOT NULL,
  `conmag` int(1) NOT NULL,
  `ivam_t` char(1) NOT NULL DEFAULT '',
  `interessi` decimal(3,1) NOT NULL,
  `preeminent_vat` int(2) NOT NULL DEFAULT '0',
  `adminid` varchar(20) NOT NULL DEFAULT '',
  `last_modified` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`codice`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Dump dei dati per la tabella `gaz_aziend`
--

INSERT INTO `gaz_aziend` (`codice`, `ragso1`, `ragso2`, `image`, `sedleg`, `legrap_pf_nome`, `legrap_pf_cognome`, `REA_ufficio`, `REA_numero`, `REA_capitale`, `REA_socio`, `REA_stato`, `sexper`, `datnas`, `order_type`, `luonas`, `pronas`, `indspe`, `capspe`, `citspe`, `prospe`, `country`, `id_currency`, `id_language`, `telefo`, `fax`, `codfis`, `pariva`, `pec`, `e_mail`, `web_url`, `gazSynchro`, `cod_ateco`, `regime`, `fiscal_reg`, `amm_min`, `fae_tipo_cassa`, `ra_cassa`, `vat_susp`, `decimal_quantity`, `decimal_price`, `stock_eval_method`, `mascli`, `masfor`, `masban`, `mas_fixed_assets`, `mas_found_assets`, `mas_cost_assets`, `lost_cost_assets`, `super_amm_account`, `super_amm_rate`, `min_rate_deprec`, `capital_gains_account`, `capital_loss_account`, `mas_staff`, `cassa_`, `ivaacq`, `ivaven`, `ivacor`, `ivaera`, `split_payment`, `impven`, `imptra`, `impimb`, `impspe`, `impvar`, `boleff`, `omaggi`, `sales_return`, `impacq`, `cost_tra`, `cost_imb`, `cost_var`, `purchases_return`, `latitude`, `longitude`, `coriba`, `cotrat`, `cocamb`, `c_ritenute`, `c_ritenute_autonomi`, `c_payroll_tax`, `closing_balance`, `economic_result`, `operating_profit`, `operating_losses`, `opening_balance`, `ritenuta`, `payroll_tax`, `acciva`, `taxstamp_limit`, `taxstamp`, `perbol`, `taxstamp_vat`, `taxstamp_account`, `round_bol`, `virtual_taxstamp`, `virtual_stamp_auth_prot`, `virtual_stamp_auth_date`, `causale_pagam_770`, `sperib`, `desez1`, `desez2`, `desez3`, `desez4`, `desez5`, `desez6`, `desez7`, `desez8`, `desez9`, `reverse_charge_sez`, `fatimm`, `artsea`, `template`, `colore`, `conmag`, `ivam_t`, `interessi`, `preeminent_vat`, `adminid`, `last_modified`) VALUES
(1, 'AZIENDA DI PROVA', 'di GAzie', 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, '', 'Gestione', 'AZIEndale', '', '', '0.00', '', 'LN', 'M', '2004-01-27', 'RIC', 'MONTESILVANO', 'PE', 'Via Volturno, 2', '65015', 'MONTESILVANO', 'PE', 'IT', 1, 1, '3383121161', '', 'GZAGPL05B01F646C', '01234567897', '', 'gazie-list@lists.sourceforge.net', 'http://gazie.sourceforge.net', '', 10000, '0', 'RF01', '22IV', 'TC22', 1, 0, 9, 3, 1, 103, 212, 597, 102, 250, 350, 361000002, 340000001, '40.0', '0.0', 421000020, 339000020, 220, 108000030, 106000001, 215000001, 215000001, 588000010, 588000020, 420000006, 420000003, 420000003, 420000003, 420000003, 420000003, 330000012, 330000010, 330000001, 315000001, 315000099, 315000099, 420000010, '42.50593', '14.16524', 105000007, 105000007, 105000007, 106000003, 215000002, 215000012, 598000002, 598000003, 210000031, 210000032, 598000001, '20.0', '4.0', '88.0', '77.47', '2.00', '1.20', 4, 339000001, 5, 1, '', '2004-01-27', 'A', '4.55', 'PRINCIPALE', 'SERVIZI', '', '', '', '', '', '', 'AUTOFATTURE - REVERSE CHARGE', 9, 'R', 'D', '', 'D6C1FF', 2, 'M', '1.0', 1, 'amministratore', '2022-08-05 06:34:24');

-- --------------------------------------------------------

--
-- Struttura della tabella `gaz_bank`
--

DROP TABLE IF EXISTS `gaz_bank`;
CREATE TABLE IF NOT EXISTS `gaz_bank` (
  `id` int(6) NOT NULL AUTO_INCREMENT,
  `iso_country` varchar(2) NOT NULL DEFAULT '',
  `codabi` int(5) NOT NULL DEFAULT '0',
  `descriabi` varchar(1000) NOT NULL DEFAULT '',
  `codcab` int(5) NOT NULL DEFAULT '0',
  `descricab` varchar(1000) NOT NULL DEFAULT '',
  `indiri` varchar(1000) NOT NULL DEFAULT '',
  `id_municipalities` int(9) NOT NULL DEFAULT '0',
  `cap` int(5) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `codabi_codcab` (`codabi`,`codcab`),
  KEY `codabi` (`codabi`),
  KEY `descriabi` (`descriabi`(333)),
  KEY `codcab` (`codcab`),
  KEY `descricab` (`descricab`(333)),
  KEY `indiri` (`indiri`(333)),
  KEY `iso_country` (`iso_country`),
  KEY `id_municipalities` (`id_municipalities`)
) ENGINE=MyISAM AUTO_INCREMENT=70870 DEFAULT CHARSET=utf8;

--
-- Dump dei dati per la tabella `gaz_bank`
--

INSERT INTO `gaz_bank` (`id`, `iso_country`, `codabi`, `descriabi`, `codcab`, `descricab`, `indiri`, `id_municipalities`, `cap`) VALUES
(1, 'IT', 1000, 'BANCA D\'ITALIA', 1000, '', 'VIA ARSENALE, 8', 272, 10121),
(2, 'IT', 1000, 'BANCA D\'ITALIA', 1001, 'BONIFICI DA FILIALE', 'VIA ARSENALE, 8', 272, 10121),
(3, 'IT', 1000, 'BANCA D\'ITALIA', 1200, '', 'AVENUE DU CONSEIL DES COMMIS, 21', 1050, 11100),
(4, 'IT', 1000, 'BANCA D\'ITALIA', 1201, 'BONIFICI DA FILIALE', 'AVENUE DU CONSEIL DES COMMIS, 21', 1050, 11100),
(5, 'IT', 1000, 'BANCA D\'ITALIA', 1400, '', 'VIA DANTE, 3', 1282, 16121),
(6, 'IT', 1000, 'BANCA D\'ITALIA', 1401, 'BONIFICI DA FILIALE', 'VIA DANTE, 3', 1282, 16121),
(7, 'IT', 1000, 'BANCA D\'ITALIA', 1600, '', 'P.ZZA EDISON, 3', 1844, 20123),
(8, 'IT', 1000, 'BANCA D\'ITALIA', 1601, '', 'CORSO SEMPIONE, 57 - MILANO SUCCURSALE', 1844, 20100),
(9, 'IT', 1000, 'BANCA D\'ITALIA', 1602, 'LODI C.TO MILANO', 'C.SO SEMPIONE, 57', 1844, 20100),
(10, 'IT', 1000, 'BANCA D\'ITALIA', 1603, 'FILIALE DI MILANO', 'VIA CORDUSIO, 5', 1844, 20123),
(11, 'IT', 1000, 'BANCA D\'ITALIA', 1604, 'BONIFICI DA FILIALE', 'VIA CORDUSIO, 5', 1844, 20123),
(12, 'IT', 1000, 'BANCA D\'ITALIA', 1800, '', 'PIAZZA A. VITTORIA, 6', 3069, 38100),
(13, 'IT', 1000, 'BANCA D\'ITALIA', 1801, 'BONIFICI DA FILIALE', 'PIAZZA ALESSANDRO VITTORIA, 6', 3069, 38122),
(14, 'IT', 1000, 'BANCA D\'ITALIA', 2000, '', 'CALLE LARGA MAZZINI - 4799/A S.MARCO', 3515, 30124),
(15, 'IT', 1000, 'BANCA D\'ITALIA', 2001, 'BONIFICI DA FILIALE', 'CALLE LARGA MAZZINI, 4799/A SAN MARCO', 3515, 30124),
(16, 'IT', 1000, 'BANCA D\'ITALIA', 2200, '', 'CORSO CAVOUR, 13', 3839, 34132),
(17, 'IT', 1000, 'BANCA D\'ITALIA', 2201, 'BONIFICI DA FILIALE', 'CORSO CAVOUR, 13', 3839, 34132),
(18, 'IT', 1000, 'BANCA D\'ITALIA', 2400, '', 'PIAZZA CAVOUR, 6', 4032, 40124),
(19, 'IT', 1000, 'BANCA D\'ITALIA', 2401, 'BONIFICI DA FILIALE', 'PIAZZA CAVOUR, 6', 4032, 40124),
(20, 'IT', 1000, 'BANCA D\'ITALIA', 2600, '', 'PIAZZA KENNEDY, 9', 4229, 60100),
(21, 'IT', 1000, 'BANCA D\'ITALIA', 2601, 'BONIFICI DA FILIALE', 'PIAZZA KENNEDY, 9', 4229, 60122),
(22, 'IT', 1000, 'BANCA D\'ITALIA', 2800, '', 'VIA DELL\'ORIUOLO, 37/39', 4495, 50122),
(23, 'IT', 1000, 'BANCA D\'ITALIA', 2801, 'PRATO C.TO FIRENZE', 'VIA DELL\'ORIUOLO, 37-39', 4495, 50122),
(24, 'IT', 1000, 'BANCA D\'ITALIA', 2802, 'PRATO C.TO FIRENZE', 'VIA DELL\'ORIUOLO,37-39', 4495, 50122),
(25, 'IT', 1000, 'BANCA D\'ITALIA', 2803, 'BONIFICI DA FILIALE', 'VIA DELL\'ORIUOLO, 37/39', 4495, 50122),
(26, 'IT', 1000, 'BANCA D\'ITALIA', 3000, '', 'PIAZZA ITALIA, 15', 4725, 6100),
(27, 'IT', 1000, 'BANCA D\'ITALIA', 3001, 'BONIFICI DA FILIALE', 'PIAZZA ITALIA, 15', 4725, 6121),
(28, 'IT', 1000, 'BANCA D\'ITALIA', 3200, '', 'VIA MILANO,60/G - ROMA SEDE', 223, 184),
(29, 'IT', 1000, 'BANCA D\'ITALIA', 3201, '', 'VIA DEI MILLE,52 - ROMA SUCCURSALE', 223, 185),
(30, 'IT', 1000, 'BANCA D\'ITALIA', 3202, '', 'VIA MILANO, 60 G', 223, 181),
(31, 'IT', 1000, 'BANCA D\'ITALIA', 3203, '', 'VIA NAZIONALE, 91 - ROMA CASSA CENTRALE', 223, 184),
(32, 'IT', 1000, 'BANCA D\'ITALIA', 3204, 'SISTEMI DI PAGAMENTO', 'VIA MILANO 60 G', 223, 181),
(33, 'IT', 1000, 'BANCA D\'ITALIA', 3205, 'SESI DIVISIONE PRESIDIO LIVELLI SERVIZIO', 'VIA MILANO 60 G', 223, 181),
(34, 'IT', 1000, 'BANCA D\'ITALIA', 3206, 'TESORERIA CENTRALE', 'VIA XX SETTEMBRE, 97E', 223, 187),
(35, 'IT', 1000, 'BANCA D\'ITALIA', 3207, 'CONTABILITA\' SPECIALI', 'VIA MILANO, 60 G', 223, 184),
(36, 'IT', 1000, 'BANCA D\'ITALIA', 3208, 'ORDINATIVI TELEMATICI SU OA', 'VIA MILANO, 60/G', 223, 185),
(37, 'IT', 1000, 'BANCA D\'ITALIA', 3209, 'BONIFICI DA FILIALE', 'VIA XX SETTEMBRE, 97/E', 223, 187),
(38, 'IT', 1000, 'BANCA D\'ITALIA', 3210, 'BONIFICI DA FILIALE', 'VIA DEI MILLE, 52', 223, 185),
(39, 'IT', 1000, 'BANCA D\'ITALIA', 3211, 'CASSA GENERALE', 'VIA NAZIONALE, 91', 223, 184),
(40, 'IT', 1000, 'BANCA D\'ITALIA', 3212, 'PINE-OPERATIVITA\' MANUALE', 'VIA MILANO, 60/G', 223, 184),
(41, 'IT', 1000, 'BANCA D\'ITALIA', 3213, 'TESORERIA ESTERA', 'VIA MILANO 60-G', 223, 185),
(42, 'IT', 1000, 'BANCA D\'ITALIA', 3214, 'ILOR', 'VIA MILANO 60 G', 223, 100),
(43, 'IT', 1000, 'BANCA D\'ITALIA', 3215, 'STIPENDI DIPEND. AMM.NI CENTRALI STATO', 'VIA MILANO 60 G', 223, 100),
(44, 'IT', 1000, 'BANCA D\'ITALIA', 3216, 'PENSIONI INPDAP', 'VIA MILANO 60 G', 223, 100),
(45, 'IT', 1000, 'BANCA D\'ITALIA', 3217, 'IRPEF TASSAZIONE ORDINARIA', 'VIA MILANO 60 G', 223, 100),
(46, 'IT', 1000, 'BANCA D\'ITALIA', 3218, 'IRPEF TASSAZIONE SEPARATA', 'VIA MILANO 60 G', 223, 100),
(47, 'IT', 1000, 'BANCA D\'ITALIA', 3219, 'CONCESSIONI GOVERNATIVE', 'VIA MILANO 60 G', 223, 100),
(48, 'IT', 1000, 'BANCA D\'ITALIA', 3220, 'MANDATO INFORMATICO DI PAGAMENTO', 'VIA MILANO 60 G', 223, 100),
(49, 'IT', 1000, 'BANCA D\'ITALIA', 3221, 'APPL. VERSAMENTI DELEGA UNICA', 'VIA MILANO 60 G', 223, 181),
(50, 'IT', 1000, 'BANCA D\'ITALIA', 3224, 'PROGETTO TARGET', 'VIA MILANO 60 G', 223, 181),
(51, 'IT', 1000, 'BANCA D\'ITALIA', 3225, 'OPERAZIONI DVP PORTIT CON MT', 'VIA MILANO 60 G', 223, 181),
(52, 'IT', 1000, 'BANCA D\'ITALIA', 3226, 'SERVIZIO FINANZIARIO MT', 'VIA MILANO, 60G', 223, 181),
(53, 'IT', 1000, 'BANCA D\'ITALIA', 3227, 'BONIFICI AL DETTAGLIO', 'VIA MILANO, 60 G', 223, 181),
(54, 'IT', 1000, 'BANCA D\'ITALIA', 3228, 'AGENZIA FISCALE DELLE ENTRATE', 'VIA MILANO, 60 G', 223, 100),
(55, 'IT', 1000, 'BANCA D\'ITALIA', 3229, 'AGENZIA FISCALE DEL TERRITORIO', 'VIA MILANO, 60 G', 223, 100),
(56, 'IT', 1000, 'BANCA D\'ITALIA', 3230, 'AGENZIA FISCALE DELLE DOGANE', 'VIA MILANO, 60 G', 223, 100),
(57, 'IT', 1000, 'BANCA D\'ITALIA', 3231, 'AGENZIA FISCALE DEL DEMANIO', 'VIA MILANO, 60 G', 223, 100),
(58, 'IT', 1000, 'BANCA D\'ITALIA', 3232, 'RITENUTE SU STIPENDI STATALI', 'VIA MILANO, 60 G', 223, 181),
(59, 'IT', 1000, 'BANCA D\'ITALIA', 3233, 'SPESE FISSE VARIE', 'VIA MILANO, 60 G', 223, 181),
(60, 'IT', 1000, 'BANCA D\'ITALIA', 3234, 'SCUOLA SUPERIORE DELL\'ECONOMIA - FINANZE', 'VIA MILANO, 60 G', 223, 100),
(61, 'IT', 1000, 'BANCA D\'ITALIA', 3235, 'PROCEDURA AUTOMATICA', 'VIA MILANO, 60 G', 223, 100),
(62, 'IT', 1000, 'BANCA D\'ITALIA', 3240, 'DELEGA UNICA - RIPARTIZIONE', 'VIA MILANO, 60 G', 223, 100),
(63, 'IT', 1000, 'BANCA D\'ITALIA', 3245, 'VERSAMENTI DI TESORERIA - BON', 'VIA MILANO, 60 G', 223, 100),
(64, 'IT', 1000, 'BANCA D\'ITALIA', 3246, 'ESTINZIONE TITOLI SPESA TESORERIA STATO', 'VIA MILANO 60 BITAITRRUSC', 223, 100),
(65, 'IT', 1000, 'BANCA D\'ITALIA', 3247, 'VERSAMENTI TESORERIA STATO', 'VIA MILANO, 60 G BITAITRRENT', 223, 100),
(66, 'IT', 1000, 'BANCA D\'ITALIA', 3248, 'PENSIONI BANCA D\'ITALIA', 'VIA MILANO 60/G', 223, 100),
(67, 'IT', 1000, 'BANCA D\'ITALIA', 3250, 'ASPIS BONIFICI - INCASSI', 'VIA MILANO, 60 G', 223, 184),
(68, 'IT', 1000, 'BANCA D\'ITALIA', 3251, 'ASPIS BONIFICI - PAGAMENTI', 'VIA MILANO, 60 G', 223, 184),
(69, 'IT', 1000, 'BANCA D\'ITALIA', 3252, 'STIPENDI STATALI SPESE FISSE', 'VIA MILANO 60 G', 223, 100),
(70, 'IT', 1000, 'BANCA D\'ITALIA', 3253, 'PENSIONI TESORO', 'VIA MILANO 60 G', 223, 100),
(71, 'IT', 1000, 'BANCA D\'ITALIA', 3400, '', 'VIA MIGUEL CERVANTES, 71', 5387, 80133),
(72, 'IT', 1000, 'BANCA D\'ITALIA', 3401, 'NAPOLI SUCCURSALE', 'VIA M. CERVANTES, 71', 5387, 80133),
(73, 'IT', 1000, 'BANCA D\'ITALIA', 3402, 'BONIFICI DA FILIALE', 'VIA MIGUEL CERVANTES, 71', 5387, 80133),
(74, 'IT', 1000, 'BANCA D\'ITALIA', 3600, '', 'CORSO FEDERICO II, 1', 5756, 67100),
(75, 'IT', 1000, 'BANCA D\'ITALIA', 3601, 'BONIFICI DA FILIALE', 'CORSO FEDERICO II, 1', 5756, 67100),
(76, 'IT', 1000, 'BANCA D\'ITALIA', 3800, 'CAMPO TURES', 'VIA MAZZINI, 2', 6018, 86100),
(77, 'IT', 1000, 'BANCA D\'ITALIA', 3801, 'BONIFICI DA FILIALE', 'CORSO G. MAZZINI, 2', 6018, 86100),
(78, 'IT', 1000, 'BANCA D\'ITALIA', 4000, '', 'CORSO CAVOUR, 4', 1946, 70121),
(79, 'IT', 1000, 'BANCA D\'ITALIA', 4001, 'FILIALE DI BARI', 'CORSO CAVOUR, 4', 1946, 70121),
(80, 'IT', 1000, 'BANCA D\'ITALIA', 4002, 'BONIFICI DA FILIALE', 'CORSO CAVOUR, 4', 1946, 70121),
(81, 'IT', 1000, 'BANCA D\'ITALIA', 4200, '', 'VIA PRETORIA, 175', 4319, 85100),
(82, 'IT', 1000, 'BANCA D\'ITALIA', 4201, 'BONIFICI DA FILIALE', 'VIA PRETORIA, 175', 4319, 85100),
(83, 'IT', 1000, 'BANCA D\'ITALIA', 4400, '', 'PIAZZA A.SERRAVALLE, 1', 6653, 88100),
(84, 'IT', 1000, 'BANCA D\'ITALIA', 4401, 'CROTONE C.TO CATANZARO', 'P.ZZA SERRAVALLE, 1', 6653, 88100),
(85, 'IT', 1000, 'BANCA D\'ITALIA', 4402, 'VIBO VALENTIA C.TO CATANZARO', 'P.ZZA SERRAVALLE, 1', 6653, 88100),
(86, 'IT', 1000, 'BANCA D\'ITALIA', 4403, 'BONIFICI DA FILIALE', 'PIAZZA A. SERRAVALLE, 1', 6653, 88100),
(87, 'IT', 1000, 'BANCA D\'ITALIA', 4600, '', 'VIA CAVOUR, 131/A', 6894, 90133),
(88, 'IT', 1000, 'BANCA D\'ITALIA', 4601, 'BONIFICI DA FILIALE', 'VIA CAVOUR, 131/A', 6894, 90133),
(89, 'IT', 1000, 'BANCA D\'ITALIA', 4800, '', 'LARGO CARLO FELICE,13', 7331, 9100),
(90, 'IT', 1000, 'BANCA D\'ITALIA', 4801, 'BONIFICI DA FILIALE', 'LARGO CARLO FELICE, 13', 7331, 9124),
(91, 'IT', 1000, 'BANCA D\'ITALIA', 10000, '', 'VIA G. MAMELI, 9', 398, 13100),
(92, 'IT', 1000, 'BANCA D\'ITALIA', 10001, 'BIELLA C.TO VERCELLI', 'VIA G. MAMELI, 9', 398, 13100),
(93, 'IT', 1000, 'BANCA D\'ITALIA', 10100, '', 'VIA C. NEGRONI, 8', 459, 28100),
(94, 'IT', 1000, 'BANCA D\'ITALIA', 10101, 'VERBANIA C.TO NOVARA', 'VIA C. NEGRONI, 8', 459, 28100),
(95, 'IT', 1000, 'BANCA D\'ITALIA', 10102, 'BONIFICI DA FILIALE', 'VIA C. NEGRONI, 8', 459, 28100),
(96, 'IT', 1000, 'BANCA D\'ITALIA', 10200, '', 'CORSO NIZZA, 3', 567, 12100),
(97, 'IT', 1000, 'BANCA D\'ITALIA', 10300, '', 'VIA G.VERDI, 15', 744, 14100),
(98, 'IT', 1000, 'BANCA D\'ITALIA', 10400, '', 'PIAZZA DELLA LIBERTA\',19', 860, 15100),
(99, 'IT', 1000, 'BANCA D\'ITALIA', 10500, '', 'VIA F.CASCIONE, 39', 1152, 18100),
(100, 'IT', 1000, 'BANCA D\'ITALIA', 10600, '', 'PIAZZA MAMELI, 3', 1244, 17100),
(101, 'IT', 1000, 'BANCA D\'ITALIA', 10700, '', 'VIA S.ANTONIO, 19', 1339, 19100),
(102, 'IT', 1000, 'BANCA D\'ITALIA', 10701, 'BONIFICI DA FILIALE', 'VIA S. ANTONIO, 19', 1339, 19121),
(103, 'IT', 1000, 'BANCA D\'ITALIA', 10800, '', 'VIA SACCO, 1 (ANG. VIA BERNASCONE)', 1353, 21100),
(104, 'IT', 1000, 'BANCA D\'ITALIA', 10801, 'BONIFICI DA FILIALE', 'VIA SACCO, 1', 1353, 21100),
(105, 'IT', 1000, 'BANCA D\'ITALIA', 10900, '', 'PIAZZA PERRETTA, 15', 1550, 22100),
(106, 'IT', 1000, 'BANCA D\'ITALIA', 10901, 'LECCO C.TO COMO', 'P.ZZA PERRETTA, 15', 1550, 22100),
(107, 'IT', 1000, 'BANCA D\'ITALIA', 10902, 'BONIFICI DA FILIALE', 'PIAZZA PERRETTA, 15', 1550, 22100),
(108, 'IT', 1000, 'BANCA D\'ITALIA', 11000, '', 'PIAZZA GARIBALDI, 21', 1720, 23100),
(109, 'IT', 1000, 'BANCA D\'ITALIA', 11001, 'BONIFICI DA FILIALE', 'PIAZZA GARIBALDI, 21', 1720, 23100),
(110, 'IT', 1000, 'BANCA D\'ITALIA', 11100, '', 'VIALE ROMA, 1', 1950, 24100),
(111, 'IT', 1000, 'BANCA D\'ITALIA', 11101, 'BONIFICI DA FILIALE', 'VIALE ROMA, 1', 1950, 24121),
(112, 'IT', 1000, 'BANCA D\'ITALIA', 11200, '', 'CORSO MARTIRI DELLA LIBERTA\', 19', 2199, 25100),
(113, 'IT', 1000, 'BANCA D\'ITALIA', 11201, 'BONIFICI DA FILIALE', 'CORSO MARTIRI DELLA LIBERTA\', 19', 2199, 25122),
(114, 'IT', 1000, 'BANCA D\'ITALIA', 11300, '', 'VIA XX SETTEMBRE, 41', 2486, 27100),
(115, 'IT', 1000, 'BANCA D\'ITALIA', 11400, '', 'VIA G.VERDI, 3', 2602, 26100),
(116, 'IT', 1000, 'BANCA D\'ITALIA', 11500, '', 'VIA B. CASTIGLIONI, 3', 2711, 46100),
(117, 'IT', 1000, 'BANCA D\'ITALIA', 11600, '', 'VIA ORAZIO 1/E', 2759, 39100),
(118, 'IT', 1000, 'BANCA D\'ITALIA', 11601, 'BONIFICI DA FILIALE', 'VIA ORAZIO, 1/E', 2759, 39100),
(119, 'IT', 1000, 'BANCA D\'ITALIA', 11700, '', 'CORSO CAVOUR, 42', 3181, 37121),
(120, 'IT', 1000, 'BANCA D\'ITALIA', 11701, 'FILIALE DI VERONA', 'CORSO CAVOUR, 42', 3181, 37121),
(121, 'IT', 1000, 'BANCA D\'ITALIA', 11702, 'BONIFICI DA FILIALE', 'CORSO CAVOUR, 38', 3181, 37121),
(122, 'IT', 1000, 'BANCA D\'ITALIA', 11800, '', 'PIAZZA S.LORENZO, 1', 3303, 36100),
(123, 'IT', 1000, 'BANCA D\'ITALIA', 11900, '', 'PIAZZA DEI MARTIRI, 29', 3315, 32100),
(124, 'IT', 1000, 'BANCA D\'ITALIA', 12000, '', 'PIAZZA POLA, 14', 2361, 31100),
(125, 'IT', 1000, 'BANCA D\'ITALIA', 12001, 'BONIFICI DA FILIALE', 'PIAZZA POLA, 14', 2361, 31100),
(126, 'IT', 1000, 'BANCA D\'ITALIA', 12100, '', 'RIVIERA TITO LIVIO, 28', 3575, 35100),
(127, 'IT', 1000, 'BANCA D\'ITALIA', 12101, 'BONIFICI DA FILIALE', 'RIVIERA TITO LIVIO, 28', 3575, 35123),
(128, 'IT', 1000, 'BANCA D\'ITALIA', 12200, '', 'VIA DOMENICO PIVA, 19', 3660, 45100),
(129, 'IT', 1000, 'BANCA D\'ITALIA', 12300, '', 'VIA GEMONA, 3', 3800, 33100),
(130, 'IT', 1000, 'BANCA D\'ITALIA', 12400, '', 'VIA CODELLI, 11', 3815, 34170),
(131, 'IT', 1000, 'BANCA D\'ITALIA', 12500, '', 'VIA G.MAZZINI, 8', 7428, 33170),
(132, 'IT', 1000, 'BANCA D\'ITALIA', 12600, '', 'VIA MANDELLI, 14', 3577, 29100),
(133, 'IT', 1000, 'BANCA D\'ITALIA', 12601, 'BONIFICI DA FILIALE', 'VIA MANDELLI, 14', 3577, 29121),
(134, 'IT', 1000, 'BANCA D\'ITALIA', 12700, '', 'VIA FARINI, 32', 3914, 43100),
(135, 'IT', 1000, 'BANCA D\'ITALIA', 12800, '', 'PIAZZA MARTIRI DEL 7 LUGLIO, 1', 3967, 42100),
(136, 'IT', 1000, 'BANCA D\'ITALIA', 12801, 'FILIALE DI REGGIO EMILIA', 'PIAZZA MARTIRI DEL VII LUGLIO-1', 3967, 42100),
(137, 'IT', 1000, 'BANCA D\'ITALIA', 12802, 'BONIFICI DA FILIALE', 'PIAZZA MARTIRI DEL 7 LUGLIO, 1', 3967, 42121),
(138, 'IT', 1000, 'BANCA D\'ITALIA', 12900, '', 'CORSO CANALGRANDE, 84', 4002, 41100),
(139, 'IT', 1000, 'BANCA D\'ITALIA', 13000, '', 'PIAZZA T.TASSO, 1', 3124, 44100),
(140, 'IT', 1000, 'BANCA D\'ITALIA', 13100, '', 'VIA R.GESSI, 13', 4126, 48100),
(141, 'IT', 1000, 'BANCA D\'ITALIA', 13200, '', 'CORSO DELLA REPUBBLICA, 36', 4140, 47100),
(142, 'IT', 1000, 'BANCA D\'ITALIA', 13201, 'RIMINI C.TO FORLI\'', 'C.SO DELLA REPUBBLICA, 36', 4140, 47100),
(143, 'IT', 1000, 'BANCA D\'ITALIA', 13202, 'BONIFICI DA FILIALE', 'CORSO DELLA REPUBBLICA, 36', 4140, 47121),
(144, 'IT', 1000, 'BANCA D\'ITALIA', 13300, '', 'VIA ROSSINI, 79', 4204, 61100),
(145, 'IT', 1000, 'BANCA D\'ITALIA', 13301, 'BONIFICI DA FILIALE', 'VIA ROSSINI, 79', 4204, 61121),
(146, 'IT', 1000, 'BANCA D\'ITALIA', 13400, '', 'VIA G. MATTEOTTI, 37', 4183, 62100),
(147, 'IT', 1000, 'BANCA D\'ITALIA', 13500, '', 'CORSO MAZZINI, 207', 4340, 63100),
(148, 'IT', 1000, 'BANCA D\'ITALIA', 13501, 'BONIFICI DA FILIALE', 'CORSO MAZZINI, 207', 4340, 63100),
(149, 'IT', 1000, 'BANCA D\'ITALIA', 13600, '', 'PIAZZA GARIBALDI, 4', 3565, 54100),
(150, 'IT', 1000, 'BANCA D\'ITALIA', 13700, '', 'VIA M. CIVITALI, 191', 4440, 55100),
(151, 'IT', 1000, 'BANCA D\'ITALIA', 13800, '', 'VIA CINO, 12', 4472, 51100),
(152, 'IT', 1000, 'BANCA D\'ITALIA', 13900, '', 'PIAZZA DEL MUNICIPIO, 47', 357, 57100),
(153, 'IT', 1000, 'BANCA D\'ITALIA', 13901, 'BONIFICI DA FILIALE', 'PIAZZA DEL MUNICIPIO, 47', 357, 57123),
(154, 'IT', 1000, 'BANCA D\'ITALIA', 14000, '', 'VIA S.MARTINO, 100', 466, 56100),
(155, 'IT', 1000, 'BANCA D\'ITALIA', 14100, '', 'VIA XXV APRILE, 3', 4585, 52100),
(156, 'IT', 1000, 'BANCA D\'ITALIA', 14101, 'BONIFICI DA FILIALE', 'VIA XXV APRILE, 3', 4585, 52100),
(157, 'IT', 1000, 'BANCA D\'ITALIA', 14200, '', 'VIA DI CITTA\', 126', 4654, 53100),
(158, 'IT', 1000, 'BANCA D\'ITALIA', 14201, 'BONIFICI DA FILIALE', 'VIA DELLA STUFA SECCA, 34', 4654, 53100),
(159, 'IT', 1000, 'BANCA D\'ITALIA', 14300, '', 'VIALE MATTEOTTI, 35/37', 4669, 58100),
(160, 'IT', 1000, 'BANCA D\'ITALIA', 14301, 'BONIFICI DA FILIALE', 'VIALE MATTEOTTI, 35/37', 4669, 58100),
(161, 'IT', 1000, 'BANCA D\'ITALIA', 14400, '', 'PIAZZA TACITO, 1', 4777, 5100),
(162, 'IT', 1000, 'BANCA D\'ITALIA', 14500, '', 'VIA MARCONI, 26', 4837, 1100),
(163, 'IT', 1000, 'BANCA D\'ITALIA', 14501, 'BONIFICI DA FILIALE', 'VIA GUGLIELMO MARCONI, 26', 4837, 1100),
(164, 'IT', 1000, 'BANCA D\'ITALIA', 14600, '', 'VIA GARIBALDI, 263', 4897, 2100),
(165, 'IT', 1000, 'BANCA D\'ITALIA', 14700, '', 'PIAZZA DELLA LIBERTA\', 11', 5043, 4100),
(166, 'IT', 1000, 'BANCA D\'ITALIA', 14701, 'BONIFICI DA FILIALE', 'PIAZZA DELLA LIBERTA\' 11', 5043, 4100),
(167, 'IT', 1000, 'BANCA D\'ITALIA', 14800, '', 'PIAZZALE V.VENETO, 1', 5103, 3100),
(168, 'IT', 1000, 'BANCA D\'ITALIA', 14900, '', 'PIAZZA VANVITELLI, 10', 5178, 81100),
(169, 'IT', 1000, 'BANCA D\'ITALIA', 14901, 'BONIFICI DA FILIALE', 'PIAZZA VANVITELLI, 1/2', 5178, 81100),
(170, 'IT', 1000, 'BANCA D\'ITALIA', 15000, '', 'PIAZZALE RISORGIMENTO, 7', 5268, 82100),
(171, 'IT', 1000, 'BANCA D\'ITALIA', 15100, '', 'CORSO V.EMANUELE, 185', 5438, 83100),
(172, 'IT', 1000, 'BANCA D\'ITALIA', 15101, 'BONIFICI DA FILIALE', 'CORSO VITTORIO EMANUELE, 185', 5438, 83100),
(173, 'IT', 1000, 'BANCA D\'ITALIA', 15200, '', 'CORSO V.EMANUELE, 177', 5665, 84100),
(174, 'IT', 1000, 'BANCA D\'ITALIA', 15201, 'BONIFICI DA FILIALE', 'CORSO VITTORIO EMANUELE, 177', 5665, 84122),
(175, 'IT', 1000, 'BANCA D\'ITALIA', 15300, '', 'VIA CARDUCCI, 33', 5856, 64100),
(176, 'IT', 1000, 'BANCA D\'ITALIA', 15400, '', 'CORSO V.EMANUELE, 65', 5890, 65100),
(177, 'IT', 1000, 'BANCA D\'ITALIA', 15401, 'BONIFICI DA FILIALE', 'CORSO VITTORIO EMANUELE II, 65', 5890, 65121),
(178, 'IT', 1000, 'BANCA D\'ITALIA', 15500, '', 'CORSO MARRUCINO, 81', 5930, 66100),
(179, 'IT', 1000, 'BANCA D\'ITALIA', 15600, '', 'VIA XXIV MAGGIO, 162', 7470, 86170),
(180, 'IT', 1000, 'BANCA D\'ITALIA', 15700, '', 'VIALE XXIV MAGGIO, 7', 6120, 71100),
(181, 'IT', 1000, 'BANCA D\'ITALIA', 15701, 'BONIFICI DA FILIALE', 'VIA XXIV MAGGIO, 7', 6120, 71121),
(182, 'IT', 1000, 'BANCA D\'ITALIA', 15800, '', 'PIAZZA EBALIA, 10', 6235, 74100),
(183, 'IT', 1000, 'BANCA D\'ITALIA', 15801, 'BONIFICI DA FILIALE', 'PIAZZA EBALIA, 10', 6235, 74123),
(184, 'IT', 1000, 'BANCA D\'ITALIA', 15900, '', 'PIAZZA V.EMANUELE, 4', 6238, 72100),
(185, 'IT', 1000, 'BANCA D\'ITALIA', 16000, '', 'VIA R.S. CONSIGLIO, 5', 5757, 73100),
(186, 'IT', 1000, 'BANCA D\'ITALIA', 16001, 'BONIFICI DA FILIALE', 'VIA R.S. CONSIGLIO, 5', 5757, 73100),
(187, 'IT', 1000, 'BANCA D\'ITALIA', 16100, '', 'PIAZZA S. FRANCESCO, 1-2', 6468, 75100),
(188, 'IT', 1000, 'BANCA D\'ITALIA', 16200, '', 'CORSO UMBERTO I, 2/C', 6530, 87100),
(189, 'IT', 1000, 'BANCA D\'ITALIA', 16300, '', 'CORSO GARIBALDI, 160', 6783, 89100),
(190, 'IT', 1000, 'BANCA D\'ITALIA', 16301, 'BONIFICI DA FILIALE', 'CORSO GARIBALDI, 160', 6783, 89125),
(191, 'IT', 1000, 'BANCA D\'ITALIA', 16400, '', 'PIAZZA SCARLATTI, 7', 6838, 91100),
(192, 'IT', 1000, 'BANCA D\'ITALIA', 16401, 'BONIFICI DA FILIALE', 'PIAZZA SCARLATTI, 7', 6838, 91100),
(193, 'IT', 1000, 'BANCA D\'ITALIA', 16500, '', 'P.ZZA CAVALLOTTI, 1', 6971, 98100),
(194, 'IT', 1000, 'BANCA D\'ITALIA', 16501, 'BONIFICI DA FILIALE', 'PIAZZA CAVALLOTTI, 1', 6971, 98122),
(195, 'IT', 1000, 'BANCA D\'ITALIA', 16600, '', 'VIA FRANCESCO CRISPI,6', 7032, 92100),
(196, 'IT', 1000, 'BANCA D\'ITALIA', 16601, 'BONIFICI DA FILIALE', 'VIA FRANCESCO CRISPI, 6', 7032, 92100),
(197, 'IT', 1000, 'BANCA D\'ITALIA', 16700, '', 'CORSO UMBERTO I, 126', 7078, 93100),
(198, 'IT', 1000, 'BANCA D\'ITALIA', 16800, '', 'PIAZZA GARIBALDI, 4', 7105, 94100),
(199, 'IT', 1000, 'BANCA D\'ITALIA', 16900, '', 'PIAZZA DELLA REPUBBLICA, 49', 7131, 95131),
(200, 'IT', 1000, 'BANCA D\'ITALIA', 16901, 'BONIFICI DA FILIALE', 'PIAZZA DELLA REPUBBLICA, 49', 7131, 95131),
(201, 'IT', 1000, 'BANCA D\'ITALIA', 17000, '', 'PIAZZA MATTEOTTI, 11', 7183, 97100),
(202, 'IT', 1000, 'BANCA D\'ITALIA', 17001, 'BONIFICI DA FILIALE', 'PIAZZA MATTEOTTI, 11', 7183, 97100),
(203, 'IT', 1000, 'BANCA D\'ITALIA', 17100, '', 'PIAZZA ARCHIMEDE, 7', 7203, 96100),
(204, 'IT', 1000, 'BANCA D\'ITALIA', 17200, '', 'VIA CARLO FELICE, 2', 7255, 7100),
(205, 'IT', 1000, 'BANCA D\'ITALIA', 17201, 'BONNIFICI DA FILIALE', 'LARGO MOLINO A VENTO, 2', 7255, 7100),
(206, 'IT', 1000, 'BANCA D\'ITALIA', 17300, '', 'VIALE EUROPA, 1', 7299, 8100),
(207, 'IT', 1000, 'BANCA D\'ITALIA', 17400, '', 'VIA DONIZZETTI, 1', 7537, 9170),
(208, 'IT', 1000, 'BANCA D\'ITALIA', 39100, 'BONIFICI DA FILIALE', 'LARGO GUIDO CARLI, 1', 4950, 44),
(209, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 1000, 'FILIALE DI TORINO', 'VIA XX SETTEMBRE, 40', 272, 10121),
(210, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 1001, 'AG.1', 'VIA CERNAIA, 30/A', 272, 10122),
(211, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 1002, 'AG.2', 'VIA MILANO, 12', 272, 10122),
(212, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 1003, 'AG.3', 'CORSO GIULIO CESARE, 97', 272, 10155),
(213, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 1004, 'AGENZIA DI CITTA\' N. 4', 'PIAZZA CARDUCCI, 161-A', 272, 10126),
(214, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 1005, 'AGENZIA DI CITTA\' N. 5', 'VIA MONGINEVRO, 61-65', 272, 10141),
(215, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 1006, 'AGENZIA DI CITTA\' N. 6', 'PIAZZA PITAGORA, 14', 272, 10137),
(216, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 1007, 'AGENZIA DI CITTA\' N. 7', 'CORSO FRANCIA, 335-A', 272, 10142),
(217, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 1008, 'AG.8', 'VIA LIVORNO ANG.VIA TREVISO CO CC DORA', 272, 10149),
(218, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 1009, 'NUOVA CITTADELLA GIUDIZIARIA DI TORINO', 'CORSO VITTORIO EMANUELE II, 130', 272, 10100),
(219, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 1010, 'AG.10', 'PIAZZA BENGASI, 9', 272, 10127),
(220, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 1011, 'AG. DI CITTA\' N.11', 'VIA BORGOMANERO, 43', 272, 10145),
(221, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 1012, 'AGENZIA DI CITTA\' N. 12', 'VIA GIORDANO BRUNO, 93', 272, 10134),
(222, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 1013, 'AGENZIA DI CITTA\' N. 15', 'VIA MONFERRATO, 2', 272, 10131),
(223, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 1014, 'AGENZIA DI CITTA\' N.16', 'VIA CAVOUR, 28', 272, 10123),
(224, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 1015, 'APAC F.P. TORINO', 'VIA XX SETTEMBRE 40', 272, 10121),
(225, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 1016, 'TORINO AG.19', 'VIA MADAMA CRISTINA,52', 272, 10125),
(226, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 1017, 'TORINO AG.18', 'VIA TRIPOLI 93 C', 272, 10137),
(227, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 1018, 'TORINO AG.20', 'CORSO BELGIO,97', 272, 10153),
(228, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 1019, 'TORINO AG.21', 'CORSO SAN MAURIZIO,97', 272, 10124),
(229, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 1020, 'TORINO AG.22', 'VIA ALCIDE DE GASPERI, 21', 272, 10129),
(230, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 1021, 'AG. 23', 'VIA CIBRARIO, 79G', 272, 10143),
(231, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 1022, 'AG.24 TORINO', 'PIAZZA RIVOLI, 1', 272, 10138),
(232, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 1023, 'CENTRO PRIVATE BANKING TORINO', 'VIA CAVOUR, 30', 272, 20123),
(233, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 1109, 'FILIALE IMPRESA TORINO TAZZOLI', 'CORSO ORBASSANO, 336 TORRE C', 272, 27052),
(234, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 1170, 'AG.9', 'C.SO PRINCIPE ODDONE 2', 272, 10141),
(235, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 1177, 'SPORTELLO PRESSO FIAT AUTO SPA', 'CORSO GIOVANNI AGNELLI, 200 - MIRAFIORI', 272, 10134),
(236, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 1198, 'SPORTELLO PRESSO REALE MUTUA ASS.NI SPA', 'VIA CORTE D\'APPELLO, 11', 272, 10122),
(237, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 1199, 'AG.13', 'VIA SAN SECONDO, 44', 272, 10128),
(238, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 1200, 'AG.AOSTA', 'CORSO SAINT MARTIN DE CORLEANS, 73', 1050, 11100),
(239, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 1400, 'FILIALE DI GENOVA', 'LARGO EROS LANFRANCO, 2', 1282, 16121),
(240, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 1401, 'GENOVA AG.1 STURLA', 'VIA CAPRERA, 16-16A-16B ROSSI', 1282, 16146),
(241, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 1402, 'AGENZIA DI CITTA\' DI GENOVA MARASSI', 'VIA TORTOSA, 71-R', 1282, 16100),
(242, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 1403, 'GENOVA AG.3 BRIGNOLE', 'VIA BRIGATA LIGURIA, 20-34 ROSSI', 1282, 16121),
(243, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 1404, 'GENOVA AG.4 ANNUNZIATA', 'VIA PAOLO EMILIO BENSA, 7-9 ROSSI', 1282, 16124),
(244, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 1405, 'GENOVA AG.5 SAN LUCA', 'VIA S. LUCA, 23-25 ROSSI', 1282, 16124),
(245, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 1406, 'GENOVA AG.6 SAN FRUTTUOSO', 'VIA GIOVANNI TORTI, 32 ROSSO', 1282, 16143),
(246, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 1407, 'GENOVA AG.7 MATTEOTTI', 'PIAZZA MATTEOTTI, 21 ROSSO', 1282, 16123),
(247, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 1408, 'GENOVA AG.8 FOCE', 'CORSO TORINO, 92 ROSSO', 1282, 16129),
(248, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 1409, 'AG. BOLZANETO', 'VIA BOLZANETO, 31 R', 1282, 16162),
(249, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 1410, 'AG. SESTRI PONENTE', 'VIA A.CATALANI, 6/R', 1282, 16154),
(250, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 1411, 'GENOVA-NERVI', 'VIA MURCAROLO, 15 ROSSO', 1282, 16167),
(251, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 1412, 'AGENZIA DI GENOVA-PEGLI', 'VIA MARTIRI DELLA LIBERTA\', 33/R', 1282, 16156),
(252, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 1413, 'SPOR AG.9 BOLZANETO \'A\'', 'PASSO S. RONCALLO, 11', 1282, 16162),
(253, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 1414, 'APAC FLUSSI E PRODOTTI GENOVA', 'LARGO EROS LANFRANCO 2', 1282, 16121),
(254, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 1415, 'CENTRO PRIVATE BANKING LIGURIA', 'LARGO S. GIUSEPPE, 3 INT 7', 1282, 16121),
(255, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 1443, 'AG. SAMPIERDARENA', 'PIAZZA MONTANO, 7/R', 1282, 16151),
(256, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 1576, 'AG. DI GENOVA RIVAROLO', 'VIA G.JORI, 77/R', 1282, 16159),
(257, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 1577, 'AGENZIA TERMINAL TRAGHETTI', 'VIA MILANO, 100-R', 1282, 16126),
(258, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 1597, 'AG. DI MOLASSANA', 'VIA L.GHERZI, 32', 1282, 16138),
(259, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 1600, 'FILIALE DI MILANO', 'PIAZZA SAN FEDELE, 3', 1844, 20121),
(260, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 1601, 'AGENZIA DI CITTA\' N. 1', 'CORSO XXII MARZO ANG. VIA L.MANCINI, 1', 1844, 20129),
(261, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 1602, 'AG.2', 'PIAZZALE XXIV MAGGIO, 18 ANG. VIA GIAN GALEAZZO, 3', 1844, 20136),
(262, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 1603, 'AG.3', 'GALLERIA BUENOS AIRES, 15 ANG. PIAZZA LIMA', 1844, 20124),
(263, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 1604, 'AG.4', 'VIA CIMAROSA, 3', 1844, 20144),
(264, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 1605, 'AG.5', 'CORSO LODI, 37', 1844, 20135),
(265, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 1606, 'AG.6', 'VIA TURATI, 29 ANG. PIAZZA DELLA REPUBBLICA', 1844, 20121),
(266, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 1607, 'AG.7', 'VIA MOSCOVA ANG. LARGO LA FOPPA', 1844, 20121),
(267, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 1608, 'AG.8', 'CORSO VITTORIO EMANUELE, 30/32', 1844, 20122),
(268, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 1610, 'AGENZIA DI CITTA\' N. 10', 'PIAZZA G.PASOLINI ANG. VIA MENABREA, 24', 1844, 20159),
(269, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 1611, 'AG.11', 'VIA PANTANO, 2 ANG. PIAZZA VELASCA', 1844, 20122),
(270, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 1612, 'MILANO AG.12', 'VIA VITTOR PISANI, 15', 1844, 20124),
(271, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 1613, 'AG.13', 'PIAZZA FIRENZE, 21', 1844, 20149),
(272, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 1614, 'SUCCURSALE METROPOLITANA PASTEUR', 'VIALE MONZA, 62 ANG. VIA ROGGIA SCAGNA', 1844, 20127),
(273, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 1615, 'AGENZIA DI CITTA\' N. 15', 'VIA ANDREA SOLARI, 15 ANG. VIA MONTECATINI, 14', 1844, 20144),
(274, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 1616, 'AGENZIA DI CITTA\' N. 16', 'PIAZZA VIRGILIO ANG. VIA CARADOSSO, 18', 1844, 20123),
(275, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 1617, 'UFFICIO CASSA TITOLI MILANO', 'VIA BENIGNO CRESPI, 24', 1844, 20121),
(276, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 1618, 'AG.18', 'VIA MONTE VELINO, 26', 1844, 20137),
(277, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 1619, 'AG.19', 'VIA SACCARDO,30-ANG.VIA CONSOLE FLAMINIO', 1844, 20134),
(278, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 1620, 'AG.20', 'PIAZZA GIOVANNI DALLE BANDE NERE - ANG. VIA BARTOL', 1844, 20146),
(279, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 1621, 'AG.21', 'VIA MARCO D\'AGRATE, 18', 1844, 20139),
(280, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 1622, 'AG.22', 'VIA ALESSANDRO ASTESANI, 47', 1844, 20161),
(281, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 1623, 'AGENZIA DI CITTA N.23', 'VIA RIPAMONTI, 332/10', 1844, 20141),
(282, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 1624, 'CENTRO SERVIZI', 'VIA BENIGNO CRESPI 26', 1844, 20159),
(283, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 1625, '', 'BNL - CENTRO AMMINISTRATIVO TITOLI - VIA SENIGALLI', 1844, 20156),
(284, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 1626, 'AGENZIA DI CITTA\' N. 26', 'VIA CENISIO, 5', 1844, 20154),
(285, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 1627, 'AGENZIA DI CITTA\' N. 27', 'VIA E. BROGLIO, 1 ANG. VIA A. BROFFERIO, 2', 1844, 20158),
(286, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 1628, 'AGENZIA DI CITTA\' N.28', 'VIA GUGLIELMO SILVA, 36', 1844, 20149),
(287, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 1629, 'MI-SOC. UMANITARIA', 'VIALE MONTE NERO, 71', 1844, 20135),
(288, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 1630, 'MILANO AG. 32', 'CORSO GENOVA,27', 1844, 20123),
(289, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 1631, 'CENTRO PRIVATE GRANDI PATRIMONI', 'VIA DANTE,15', 1844, 20123),
(290, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 1632, 'AG. N 33 - MILANO', 'VIA LUIGI CANONICA 13', 1844, 20144),
(291, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 1633, 'AG. 34 MILANO', 'VIALE UMBRIA, 76', 1844, 2013),
(292, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 1634, 'AGENZIA DI CITTA\' N. 24', 'VIA PORDENONE, 13', 1844, 20132),
(293, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 1635, 'AGENZIA DI CITTA\' N. 25', 'VIALE GRAN SASSO ANG. VIA F.LIPPI, 19', 1844, 20131),
(294, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 1636, 'MILANO AG. 35', 'VIA DELL\'ORSO, 3', 1844, 20121),
(295, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 1637, 'MILANO AG.36', 'CORSO INDIPENDENZA, 12', 1844, 20129),
(296, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 1638, 'AG.37 MILANO', 'CORSO LODI, 90', 1844, 20139),
(297, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 1639, 'APAC FLUSSI MILANO', 'VIA DERUTA 19', 1844, 20132),
(298, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 1640, 'AG. 38 MILANO', 'PIAZZA TRIVULZIANA, 5', 1844, 20126),
(299, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 1641, 'AG. 39', 'VIA MERAVIGLI, 16', 1844, 20123),
(300, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 1642, 'AG. 40', 'CORSO DI PORTA ROMANA, 51', 1844, 20122),
(301, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 1643, 'AG. 41', 'VIA RISMONDO, ANG VIA DELLE FORZE ARMATE', 1844, 20152),
(302, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 1644, 'AG. 45', 'VIALE MONZA, 158', 1844, 20127),
(303, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 1645, 'MILANO AG.51', 'CORSO SEMPIONE ANG. VIA AGAUDIO, 1', 1844, 20149),
(304, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 1646, 'AG. 56 MILANO', 'VIALE PREMUDA ANG. PIETRO MAESTRI 2', 1844, 20129),
(305, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 1647, 'CENTRO AFFARI TERRITORIALE MILANO', 'VIA DERUTA, 19', 1844, 20132),
(306, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 1660, 'AGENZIA DI CITTA\' N. 30 - ACCURSIO', 'VIA VARESINA, 43', 1844, 20156),
(307, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 1773, 'AGENZIA PALAZZO DI GIUSTIZIA', 'VIA FREGUGLIA, 1', 1844, 20122),
(308, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 1798, 'SPORTELLO UFFICI FINANZIARI', 'VIA BASSI, 8', 1844, 20159),
(309, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 1800, 'FILIALE DI TRENTO', 'VIA VANNETTI, 18', 3069, 38100),
(310, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 1801, 'AGENZIA DI CITTA\' N. 1', 'CORSO 3 NOVEMBRE, 21-23', 3069, 38100),
(311, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 1802, 'AG.2 TRENTO', 'VIA FELICE E GREGORIO FONTANA, 34', 3069, 38122),
(312, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 2000, 'FILIALE DI VENEZIA', 'SAN MARCO-BACINO ORSEOLO, RAMO SAN GALLO, 1118/112', 3515, 30124),
(313, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 2001, 'AG. ZELARINO', 'VIA CASTELLANA, 124 LOC. ZELARINO', 3515, 30174),
(314, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 2002, 'AGENZIA DI FAVARO VENETO', 'VIA TRIESTINA, 48', 3515, 30030),
(315, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 2003, 'SPORTELLO MERCATO ITTICO - VENEZIA', 'S.CROCE N.491 - LOC. TRONCHETTO', 3515, 30125),
(316, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 2004, 'AGENZIA MESTREDUE', 'VIA TRENTO, 41-43', 3515, 30171),
(317, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 2005, 'CENTRO PRIVATE BANKING MESTRE', 'VIA MIRANESE, 91', 3515, 30174),
(318, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 2006, 'APAC FLUSSI E PRODOTTI MESTRE', 'VIA ANCONA 5', 3515, 30172),
(319, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 2007, 'AG.2 VENEZIA', 'RIO TERRA\'FARSETTI, 1836 A,B,C', 3515, 30121),
(320, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 2008, 'MESTRE TRE', 'VIA CAPPUCCINA 19 D E', 3515, 30172),
(321, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 2009, 'MESTRE QUATTRO', 'VIA SAN PIO X', 3515, 30174),
(322, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 2045, 'AG. DI MARGHERA', 'VIA BERNARDO CANAL,10', 3515, 30175),
(323, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 2046, 'SUCCURSALE DI MESTRE', 'CORSO DEL POPOLO, 21', 3515, 30172),
(324, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 2196, 'AG. 1 \'ACCADEMIA\'', 'RIO TERRA A. FOSCARINI, 877/D', 3515, 30123),
(325, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 2200, 'FILIALE DI TRIESTE', 'PIAZZA PONTEROSSO, 1', 3839, 34121),
(326, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 2201, 'AG.1', 'VIA MORPURGO, 7', 3839, 34147),
(327, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 2202, 'AG.2', 'PORTICI DI CHIOZZA ANG. VIA CARDUCCI, 18', 3839, 34125),
(328, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 2203, 'AG.3', 'VIA ALFREDO ORIANI, 10 ANG. VIA UGO FOSCOLO', 3839, 34129),
(329, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 2204, 'SPORT. CTO MERCATO ITTICO INGROSSO', 'P.LE DEI LEGNAMI, 1', 3839, 34125),
(330, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 2205, 'AG.5 TRIESTE', 'VIA FABIO SEVERO, 46', 3839, 34127),
(331, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 2398, 'SPORT. C/O ENTE AUTONOMO PORTO TRIESTE', 'PRESSO ENTE AUTONOMO DEL PORTO - PUNTO FRANCO NUOV', 3839, 34123),
(332, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 2399, 'C/O ENTE AUTON. PORTO DI TRIESTE', 'PRESSO ENTE AUTONOMO DEL PORTO - PUNTO FRANCO VECC', 3839, 34135),
(333, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 2400, 'FILIALE DI BOLOGNA', 'VIA RIZZOLI, 26', 4032, 40125),
(334, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 2402, 'AG.2', 'VIA AURELIO SAFFI, 30/A', 4032, 40131),
(335, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 2403, 'AG.3', 'VIA MARCONI, 7', 4032, 40122),
(336, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 2404, 'AGENZIA DI CITTA\' N. 4', 'PIAZZA DELL\'UNITA\', 8/G ANG. VIA F.BOLOGNESE', 4032, 40128),
(337, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 2405, 'SPORTELLO LEGIONE CARABINIERI DI BOLOGNA', 'PRESSO LEGIONE CARABINIERI - VIA DEI BERSAGLIERI, ', 4032, 40125),
(338, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 2406, 'AGENZIA DI CITTA\' N. 5', 'VIA LOMBARDIA, 15/E', 4032, 40139),
(339, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 2407, 'AGENZIA DI CITTA\' N.7', 'VIA AUGUSTO MURRI, 189 F', 4032, 40137),
(340, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 2408, 'AGENZIA DI CITTA\' N. 6', 'VIA BERTINI, 1/D', 4032, 40127),
(341, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 2409, 'APAC F.P. BOLOGNA', 'VIA DEL FAGGIOLO 1-11', 4032, 40132),
(342, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 2410, 'AG. 9 BOLOGNA', 'VIA ANDREA COSTA, 71', 4032, 40134),
(343, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 2411, 'AGENZIA N.10', 'VIA DEGLI ORTI, 16 2[ B', 4032, 40137),
(344, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 2412, 'BOLOGNA AG.11', 'VIA EMILIA PONENTE, 221', 4032, 40133),
(345, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 2413, 'CENTRO IMPRESE BOLOGNA', 'VIA MARCONI, 9', 4032, 40122),
(346, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 2414, 'CENTRO PRIV.BANKING EMILIA EST ROMAGNA', 'VIA RIZZOLI 1 2 PALAZZO RONZANI', 4032, 40125),
(347, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 2598, 'SPORT. PRESSO CONS.AGRARIO PROVINCIALE', 'VIA MATTEI, 6', 4032, 40100),
(348, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 2599, 'AG. 1', 'PRESSO AUTOSTAZIONE DI BOLOGNA - PIAZZA XX SETTEMB', 4032, 40121),
(349, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 2600, 'FILIALE DI ANCONA', 'CORSO STAMIRA, 10', 4229, 60100),
(350, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 2601, 'AGENZIA N.1 - ANCONA', 'VIA MARCONI, 18', 4229, 60100),
(351, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 2603, 'AGENZIA N[2', 'PIAZZA PEZZOTTI,20', 4229, 60127),
(352, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 2604, 'AG. 3 ANCONA', 'VIA LUIGI RUGGERI SNC', 4229, 60131),
(353, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 2800, 'AGENZIA DI PIAZZA DELLA REPUBBLICA', 'PIAZZA DELLA REPUBBLICA, 21/R', 4495, 50123),
(354, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 2801, 'AGENZIA DI CITTA\' N. 1', 'VIA DE\' CERRETANI N. 6-N', 4495, 50123),
(355, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 2802, 'AGENZIA DI CITTA\' N. 2', 'VIA GIOBERTI, 26/AR', 4495, 50121),
(356, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 2803, 'AG.3', 'VIA G.B. MORGAGNI, 8/G', 4495, 50134),
(357, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 2804, 'AG. DI CITTA\' VIALE EUROPA', 'VIALE EUROPA, 95', 4495, 50126),
(358, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 2805, 'AGENZIA DI CITTA\' N. 10', 'VIA SENESE NN. 35-37', 4495, 50124),
(359, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 2807, 'AGENZIA DI CITTA\' N.7', 'VIA VALDINIEVOLE, 57', 4495, 50127),
(360, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 2809, 'CENTRO SERVIZI', 'VIA DE\' CERRETANI, 6/N', 4495, 50123),
(361, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 2810, 'CASERMA BALDISSERA', 'LUNGARNO PECORI GIRALDI, 4', 4495, 50122),
(362, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 2811, 'CENTRO PRIVATE BANKING FIRENZE', 'VIA CAVOUR, 81', 4495, 50129),
(363, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 2812, 'APAC F.P. FIRENZE', 'VIA DEI CERRETANI 6', 4495, 50123),
(364, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 2813, 'SP. CO QUESTURA', 'VIALE LUIGI GORI, 60', 4495, 50127),
(365, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 2814, 'AG. N 11 - FIRENZE', 'VIALE FRANCESCO REDI, 35', 4495, 50144),
(366, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 2815, 'FIRENZE AG.12', 'VIA DEI MILLE, 62', 4495, 50131),
(367, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 2816, 'FIRENZE AG.13', 'VIA FEDERICO CAMMEO, 7', 4495, 50127),
(368, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 2817, 'AG. 14', 'VIA IL PRATO 99-101 ROSSO', 4495, 50123),
(369, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 2818, 'AG.15 FIRENZE', 'VIA GABRIELE D\'ANNUNZIO 21B', 4495, 50135),
(370, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 2819, 'CASERMA GOFFREDO MAMELI', 'PIAZZA STAZIONE 7', 4495, 5012),
(371, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 2820, 'CENTRO IMPRESE FIRENZE', 'VIA DE\' CERRETANI, 6N', 4495, 50123),
(372, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 2970, 'AGENZIA N.4', 'VIA GHIBELLINA ANG. VIA VERDI', 4495, 50122),
(373, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 2971, 'SPORTELLO F.S. SERV. MATERIALE-TRAZIONE', 'VIA LORENZO IL MAGNIFICO', 4495, 50129),
(374, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 2996, 'SPORTELLO UFF. GIUDIZIARI', 'VIA CAVOUR, 59', 4495, 50129),
(375, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 2997, 'AG. C/O UFFICI FINANZIARI', 'VIALE SPARTACO LAVAGNINI, 27', 4495, 50129),
(376, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 2998, 'AG. DI BORGO PINTI', 'IN VIA G. GIUSTI, 2R', 4495, 50121),
(377, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 3000, 'FILIALE DI PERUGIA', 'PIAZZA ITALIA, 13 - LARGO DELLA LIBERTA\'', 4725, 6100),
(378, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 3001, 'AG.1', 'VIA SETTEVALLI, 7/C', 4725, 6100),
(379, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 3002, 'PERUGIA AG.2', 'VIA G.DETTORI, 61', 4725, 6100),
(380, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 3003, 'AG. N 3 - PERUGIA', 'VIA DELLA SCUOLA, 130*', 4725, 6135),
(381, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 3200, 'FILIALE DI ROMA', 'VIA LEONIDA BISSOLATI, 2', 223, 187),
(382, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 3201, 'AG.1', 'PIAZZA VITTORIO EMANUELE, 36-37', 223, 185),
(383, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 3202, 'AGENZIA DI CITTA\' N. 2', 'PIAZZA IRNERIO, 1', 223, 165),
(384, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 3203, 'AGENZIA DI CITTA\' N. 3', 'PIAZZA BOLOGNA, 4B', 223, 162),
(385, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 3204, 'AG.4', 'VIA OSTIENSE, 107', 223, 154),
(386, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 3205, 'AG.5', 'PIAZZA FIUME, 53', 223, 198),
(387, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 3206, 'AG.6', 'LARGO ARENULA, 28/29', 223, 186),
(388, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 3207, 'AG.7', 'PIAZZA RISORGIMENTO,27', 223, 192),
(389, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 3208, 'AG.8', 'VIA APPIA NUOVA, 119', 223, 183),
(390, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 3209, 'SP. CO I.N.P.D.A.P.', 'VIALE ALDO BALLARIN 42', 223, 142),
(391, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 3210, 'AG.10', 'VIA APPIA NUOVA, 533', 223, 181),
(392, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 3211, 'AG.11', 'VIA MARSALA, 6', 223, 185),
(393, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 3212, 'AG.12', 'PIAZZA SANTA EMERENZIANA, 24/29', 223, 199),
(394, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 3213, 'AG.13', 'VIALE BRUNO BUOZZI, 54', 223, 197),
(395, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 3214, 'AGENZIA DI CITTA\' N. 14', 'VIA N. DEL GRANDE, 56/60 ANG. VIA S. FRANCESCO A R', 223, 153),
(396, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 3215, 'AGENZIA DI CITTA\' N. 15', 'VIA DELLA ROSETTA, 1 ANG. VIA GIUSTINIANI, 24', 223, 186),
(397, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 3216, 'AG.16', 'PIAZZALE MEDAGLIE D\'ORO, 14 ANG. VIA CADLOLO, 2', 223, 136),
(398, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 3217, 'AG.32', 'VIA FERRAIRONI, 88/A', 223, 172),
(399, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 3218, 'AGENZIA DI CITTA\' N. 18', 'VIALE C.COLOMBO, 550 ANG. VIALE CIVILTA\' DEL LAVOR', 223, 144),
(400, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 3219, 'AG.19', 'VIA S.PRISCA, 28 ANG. PIAZZA ALBANIA', 223, 153),
(401, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 3220, 'ROMA AG.20', 'VIALE MARCO FULVIO NOBILIORE, 1', 223, 175),
(402, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 3221, 'AG.21', 'VIA TIBURTINA, 399', 223, 159),
(403, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 3222, 'AG.22', 'PIAZZA MAZZINI, 36', 223, 195),
(404, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 3223, 'AG.23', 'PIAZZALE JONIO, 1 ANG. VIALE JONIO', 223, 141),
(405, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 3224, 'AG.24', 'VIA CRISTOFORO COLOMBO, 279', 223, 147),
(406, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 3225, 'AG.25', 'VIA FLAMINIA,672', 223, 191),
(407, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 3226, 'AG.26', 'CIRCONVALLAZIONE GIANICOLENSE,203', 223, 152),
(408, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 3227, 'AG.27', 'VIA VINCENZO BRUNACCI,41', 223, 146),
(409, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 3228, 'AG.28', 'VIA GIORGIO ENRICO FALCK,37', 223, 155),
(410, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 3229, 'AG.29', 'PIAZZA ROBERTO MALATESTA, 27', 223, 176),
(411, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 3230, 'AG.30', 'VIA NOMENTANA, 677/679', 223, 141),
(412, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 3231, 'AGENZIA DI CITTA\' N. 63', 'VIALE PARIOLI, 9 ANGOLO VIA STOPPANI', 223, 197),
(413, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 3232, 'DIVISIONE CREDITO FONDIARIO', 'PIAZZALE DELL\'AGRICOLTURA, 24', 223, 144),
(414, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 3233, 'DIVISIONE CREDITO INDUSTRIALE', 'PIAZZALE DELL\'AGRICOLTURA, 24', 223, 144),
(415, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 3234, 'AGENZIA DI CITTA\' N. 34', 'VIA DEL FORTE TRIONFALE, 1/D-F', 223, 136),
(416, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 3235, 'AG. DI CITTA\' N.35', 'VIA CASILINA, 1129', 223, 133),
(417, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 3236, 'AGENZIA DI CITTA\' N. 44', 'PIAZZA DE LUCIA, 86 ANGOLO VIALE LINA CAVALIERI', 223, 139),
(418, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 3237, 'AG. 31', 'PIAZZA VENEZIA, 6 ANG. VIA C.BATTISTI, 122/C', 223, 187),
(419, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 3238, 'AGENZIA LIDO DI OSTIA', 'VIA CONSACCHI,1', 223, 121),
(420, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 3239, 'AGENZIA DI CITTA\' N. 9', 'VIA SALARIA, 228 ANG. VIA TIRSO', 223, 198),
(421, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 3240, 'AGENZIA CORSO', 'VIA DEL CORSO, 471', 223, 186),
(422, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 3241, 'AGENZIA DI CITTA\' N. 41', 'VIA CASSIA, 1803-A', 223, 123),
(423, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 3242, 'ROMA NORD AG.42', 'PIAZZALE CLODIO, 26 ANG.VIA GOLAMETTO, 1', 223, 195),
(424, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 3243, 'SPORTELLO DI VIA LANZA', 'VIA GIOVANNI LANZA 194', 223, 184),
(425, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 3244, 'C/O CORTE COSTITUZIONALE', 'PRESSO CORTE COSTITUZIONALE - PIAZZA DEL QUIRINALE', 223, 187),
(426, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 3245, '', 'PRESSO AZIENDA AUTONOMA DI ASSISTENZA AL VOLO - VI', 223, 199),
(427, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 3246, '', 'CENTRO CARTE DI CREDITO - VIA DEGLI ALDOBRANDESCHI', 223, 163),
(428, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 3247, '', 'CENTRO SERVIZI - VIA DEGLI ALDOBRANDESCHI, 300', 223, 100),
(429, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 3248, 'SP. C/O FIAT AUTO SPA', 'PRESSO FIAT AUTO SPA - VIALE MANZONI, 65', 223, 185),
(430, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 3249, 'ROMA NORD CONI AG.A', 'VIA FLAMINIA NUOVA, 830', 223, 100),
(431, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 3250, 'SPORTELLO C.R.AV.-CIAMPINO', 'VIA APPIA NUOVA, 1491', 223, 43),
(432, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 3253, 'ROMA AG.46', 'VIA CASAL DE PAZZI, 94A 94B', 223, 156),
(433, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 3254, 'ARTIGIANCASSA', 'VIA CRESCENZO DEL MONTE, 25-45', 223, 153),
(434, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 3255, 'AGENZIA N.49', 'CORSO TRIESTE, 148-B', 223, 198),
(435, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 3256, 'ROMA EST REBBIBBIA', 'VIA RAFFAELE MAJETTI, 165', 223, 156),
(436, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 3257, 'RM NORD CONI FED.SP.', 'VIALE TIZIANO, 70', 223, 196),
(437, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 3258, 'SERVIZIO FIDELITY', 'VIA CRISTOFORO COLOMBO, 283-A', 223, 174),
(438, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 3259, 'INTERNET-BNL EDIWAY LIGHT', 'VIA DEGLI ALDOBRANDESCHI, 300', 223, 163),
(439, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 3260, 'SPORTELLO C/O CASSA DEPOSITI E PRESTITI', 'PRESSO CASSA DEPOSITI E PRESTITI - VIA GOITO, 4', 223, 185),
(440, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 3261, 'SPORTELLO C/O LE SCUOLE CENT. ANTINCENDI', 'PRESSO SCUOLE CENTRALI ANTINCENDI - PIAZZA SCILLA,', 223, 178),
(441, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 3262, 'SPORTELLO PRESSO IL CENTRO RAI NOMENTANO', 'VIA E. ROMAGNOLI, 1', 223, 137),
(442, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 3264, 'ROMA SUD AG.51', 'VIA GIORDANO CALCEDONIO, 11', 223, 128),
(443, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 3265, 'AGENZIA 43', 'VIA DELLA GRANDE MURAGLIA 286', 223, 144),
(444, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 3266, 'AGENZIA DI ACILIA', 'VIA DI ACILIA, 24 ANG. VIA G. COLETTI', 223, 125),
(445, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 3267, 'AGENZIA DI CITTA\' N.52', 'VIA COLLATINA, 69', 223, 177),
(446, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 3268, 'AGENZIA DI CITTA\' N[54', 'VIA FRANCESCO COLETTI, 48', 223, 191),
(447, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 3269, 'C/O TESORERIA DEL COMUNE DI ROMA', 'FILIALE DI ROMA - SERVIZIO DI TESORERIA DEL COMUNE', 223, 186),
(448, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 3270, 'ROMA AG.55', 'VIA ESCHILO, 194B', 223, 152),
(449, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 3271, 'ROMA AG.53', 'VIA DEGLI ALDOBRANDESCHI, 300', 223, 163),
(450, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 3272, 'ROMA VIA SUEZ', 'VIA SUEZ, 27-29', 223, 144),
(451, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 3273, 'ROMA TERMINI', 'VIA GIOLITTI, 34', 223, 185),
(452, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 3274, 'RM-CENTRO CORPORATE', 'VIA LAMARO, 41', 223, 173),
(453, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 3275, 'AGENZIA N. 64', 'VIA GREGORIO VII, 176', 223, 165),
(454, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 3276, 'AGENZIA N. 57', 'VIA TUSCOLANA, 950', 223, 174),
(455, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 3277, 'SP. CO COMPENDIO DEL DIP. DI PP.SS', 'VIA TORRE DI MEZZAVIA - LOC. ANAGNINA', 223, 173),
(456, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 3278, 'AGENZIA 66', 'VIA M.B. TOSATTI 47', 223, 137),
(457, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 3279, 'CONTAB. FORNITORI', 'VIA DEGLI ALDOBRANDESCHI, 300', 223, 163),
(458, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 3280, 'CONTABILITA\' FORNITORI RISORSE UMANE', 'VIA DEGLI ALDOBRANDESCHI,300', 223, 163),
(459, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 3281, 'S. CO COMANDO MILITARE DELLA CAPITALE', 'VIA SCIPIO SLATAPER 2', 223, 197),
(460, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 3282, 'AGENZIA N. 56', 'VIALE DELLA PRIMAVERA, 22', 223, 172),
(461, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 3283, 'AGENZIA N. 67', 'VIALE FRANCESCO CALTAGIRONE 339-341', 223, 132),
(462, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 3284, 'SP. CONS. MINISTRI', 'VIA DELLA MERCEDE, 96', 223, 187),
(463, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 3285, 'ROMA AG.70', 'VIA DEI COLLI PORTUENSI,551', 223, 151),
(464, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 3286, 'AG. N 72 - ROMA', 'LARGO GIORGIO MACCAGNO 14', 223, 136);
INSERT INTO `gaz_bank` (`id`, `iso_country`, `codabi`, `descriabi`, `codcab`, `descricab`, `indiri`, `id_municipalities`, `cap`) VALUES
(465, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 3287, 'AG. N 73 - ROMA', 'VIA DELLA PISANA, 110', 223, 163),
(466, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 3288, 'AG.74 -ROMA', 'VIA L. MANCINELLI,2', 223, 199),
(467, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 3289, 'ROMA AG.77', 'VIA A. BALDOVINETTI, 58', 223, 142),
(468, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 3290, 'DIVIS.BNPP-BNL CORPORATEE INVESTMENT BK', 'VIA VENETO, 19', 223, 187),
(469, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 3291, 'SPOR PRESSO IBM-ROMA', 'VIA SCIANGAI, 53', 223, 144),
(470, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 3292, 'APAC FLUSSI', 'PIAZZA ALBANIA 35', 223, 153),
(471, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 3293, 'AG. 79 ROMA', 'VIA ALBERTO LIONELLO, 201 CO PORTA DI ROMA', 223, 139),
(472, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 3294, 'CALL CENTRE', 'VIA DEGLI ALDOBRANDESCHI, 300', 223, 163),
(473, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 3295, 'ROMA AG. 80', 'VIA PICO DELLA MIRANDOLA, 84', 223, 142),
(474, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 3296, 'AG.83 ROMA', 'VIA GALLIA, 232', 223, 183),
(475, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 3297, 'AG.84 ROMA', 'P.ZZA OTTAVIANO VIMERCATI, 3', 223, 139),
(476, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 3298, '', 'VIA VITTORIO VENETO, 119', 223, 187),
(477, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 3299, 'AG.85 ROMA', 'VIA NOMENTANA, 523', 223, 141),
(478, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 3300, 'AG.86 ROMA', 'VIA MONTI TIBURTINI, 572', 223, 157),
(479, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 3301, 'AG.82 ROMA', 'VIALE DEGLI AMMIRAGLI, 9', 223, 136),
(480, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 3302, 'ROMA AG.87', 'VIALE LUIGI SCHIAVONETTI, 426 ROMA CO TOR VERGATA', 223, 173),
(481, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 3303, 'ROMA AG.88', 'PIAZZA IPPOLITO NIEVO, 35', 223, 153),
(482, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 3304, 'ROMA AG. 89', 'VIA NICOLA ZABAGLIA 13 13A', 223, 153),
(483, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 3305, 'C/O AMBASCIATA STATI UNITI D\'AMERICA', 'PRESSO AMBASCIATA USA - VIA VITTORIO VENETO,119', 223, 187),
(484, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 3306, 'AG.90 ROMA', 'VIA MARCO TABARRINI, 54', 223, 179),
(485, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 3307, 'AG.97 ROMA', 'VIA ALESSANDRIA, 161', 223, 198),
(486, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 3308, 'ROMA AG.99', 'VIA GABRIELLO CHIABRERA 114-120', 223, 145),
(487, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 3309, 'C/O C.O.N.I.', 'PRESSO C.O.N.I.- VIA NIGRA,15', 223, 194),
(488, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 3310, 'ROMA AG.100', 'VIA DONNA OLIMPIA, 55-59A', 223, 152),
(489, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 3311, 'ROMA AG.101', 'VIA TOR DE\' SCHIAVI, 377-385', 223, 171),
(490, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 3312, 'AG.102 ROMA', 'VIA DEI PRATI FISCALI, 241-243', 223, 141),
(491, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 3313, 'ROMA AG.103', 'VIA FLAMINIA, 407 407A 409 411 413', 223, 196),
(492, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 3314, 'IMMOBILIARE', 'V. S. ANSELMO, 45 ANG. V. S.PRISCA, 26', 223, 153),
(493, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 3315, 'ACILIA', 'VIA SAPONARA 110', 223, 125),
(494, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 3316, 'SPORTELLO AMA CO VERANO', 'VIA DEL VERANO N. 74', 223, 185),
(495, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 3317, 'CENTRO AFFARI TERRITORIALE CENTRO NORD', 'VIA DEGLI SCIALOIA, 20', 223, 196),
(496, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 3318, 'CENTRO AFFARI TERRIT. PUBB. AMM.NE', 'VIA CRESCENZO DEL MONTE, 27', 223, 153),
(497, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 3319, 'CENTRO PRIVATE BANKING ROMA EST', 'VIA SAMBUCUCCIO D\'ALANDO, 3', 223, 162),
(498, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 3320, 'AGENZIA DI CITTA\' N.36', 'VIA CALPURNIO PISONE, 92', 223, 175),
(499, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 3321, 'CENTRO PRIVATEBANKING ROMA VIA VENETO', 'VIA VENETO, 111', 223, 187),
(500, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 3322, 'CENTRO PRIVATE BANKING SENATO', 'VIA DEGLI STADERARI, 4', 223, 186),
(501, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 3323, 'PRESIDIO PRIVATE BANKING LAZIO PANTHEON', 'VIA DELLA ROSETTA, 1', 223, 186),
(502, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 3324, 'APAC TESORERIA', 'VIA DEGLI ALDOBRANDESCHI 300', 223, 163),
(503, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 3332, 'C/O MERCATO DELLE CARNI', 'VIA PALMIRO TOGLIATTI, 1202/1206', 223, 155),
(504, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 3333, 'C/O R.A.I.', 'PRESSO COMANDO DIVISIONE CARABINIERI PALIDORO - VI', 223, 187),
(505, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 3337, 'AGENZIA DI CITTA\' N. 37', 'PIAZZALE DELL\'AGRICOLTURA, 24/26', 223, 144),
(506, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 3338, 'AGENZIA DI CITTA\' N. 38', 'VIA DI TORREVECCHIA, 230', 223, 168),
(507, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 3339, 'AGENZIA DI CITTA\' N.39', 'VIA DEI GRACCHI, 122', 223, 192),
(508, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 3340, 'AGENZIA DI CITTA\' N.40', 'VIA CASSIA, 600', 223, 189),
(509, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 3341, 'C/O COM. GEN. GUARDIA DI FINANZA', 'PRESSO COMANDO GENERALE GUARDIA DI FINANZA CASERMA', 223, 162),
(510, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 3342, 'QUESTURA DI ROMA - ENTE P.S.', 'PRESSO QUESTURA DI ROMA - CASERMA M. GIGLIO - VIA ', 223, 196),
(511, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 3343, 'AGENZIA DI VIA BELSIANA', 'VIA BELSIANA, 67', 223, 187),
(512, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 3344, 'C/O SCUOLA ALLIEVI CARABINIERI', 'PRESSO SCUOLA ALLIEVI CARABINIERI - VIA CARLO ALBE', 223, 192),
(513, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 3345, 'LEGIONE CARABINIERI DI ROMA', 'VIA CORSINI, 16', 223, 165),
(514, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 3347, 'AGENZIA OSTIA LIDO BIS', 'VIALE PAOLO ORLANDO 27-35', 223, 122),
(515, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 3350, 'ROMA AG.50', 'VIA BOCCEA, 678', 223, 166),
(516, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 3366, 'AG. C/O LA PRESIDENZA DELLA REPUBBLICA', 'PRESSO SEGRETARIATO GENERALE DELLA PRESIDENZA DELL', 223, 187),
(517, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 3367, 'SP PRESSO IST. SUP. PRA(PROT. RIC. AMB.)', 'VIA VITALIANO BRANCATI 48', 223, 144),
(518, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 3369, 'SPORTELLO C-O UFF.CENTR.BENI AMBIEN.ECC.', 'VIA S.MICHELE 22 C-O UFF. CENTRALE BENI AMBIENT.AR', 272, 153),
(519, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 3370, 'FILIALE DI', 'VIA SAN BASILIO,', 223, 179),
(520, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 3371, 'C/O CASERMA P.S. STATILIA', 'PRESSO CASERMA STATILIA - VIA STATILIA, 30', 223, 185),
(521, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 3372, 'C/O CASERMA P.S. FERDINANDO DI SAVOIA', 'PRESSO CASERMA FERDINANDO DI SAVOIA - VIALE DEL CA', 223, 185),
(522, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 3373, 'AGENZIA PRESSO IL SENATO', 'PRESSO SENATO DELLA REPUBBLICA PZZA MADAMA', 223, 186),
(523, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 3374, 'C/O MINISTERO INTERNO', 'PRESSO MINISTERO DEGLI INTERNI', 223, 184),
(524, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 3375, 'AG. N 75 ROMA', 'VIALE IPPOCRATE 95 A', 223, 161),
(525, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 3376, 'C/O ENI', 'PRESSO ENI ENTE NAZ.IDROCARBURI - P.LE ENRICO MATT', 223, 144),
(526, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 3379, 'C/O MIN.RO AFFARI ESTERI', 'PRESSO MINISTERO DEGLI AFFARI ESTERI - PIAZZALE DE', 223, 194),
(527, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 3381, 'C/O INA DIREZ. GENERALE', 'PRESSO ISTITUTO NAZIONALE DELLE ASSICURAZIONI - VI', 223, 187),
(528, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 3382, '', 'FILIALE DI ROMA - TESORERIA VIA S.NICOLO\' DA TOLEN', 223, 187),
(529, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 3383, 'SP. PRESSO ENI SPA DIV. R&M', 'VIA LAURENTINA, 449', 223, 142),
(530, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 3384, '', 'PRESSO ENEA VIALE REGINA MARGHERITA,125', 223, 198),
(531, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 3385, 'AGENZIA ENEA/CASACCIA', 'PRESSO E.N.E.A - VIA ANGUILLARESE KM 1,300 - CASAC', 223, 60),
(532, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 3386, 'C/O QUESTURA DI ROMA', 'PRESSO QUESTURA DI ROMA - VIA S. VITALE, 15', 223, 184),
(533, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 3387, 'C/O COM. GEN. ARMA CARABINIERI', 'C/O COMANDO GENERALE DELL\'ARMA DEI CARABINIERI - V', 223, 197),
(534, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 3388, 'SP. PRESSO MINISTERO INFRASTRUTTURE', 'PIAZZALE DI PORTA PIA', 223, 198),
(535, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 3389, 'C/O OSP. MIL. PRINCIPALE DI ROMA CELIO', 'PRESSO OSPEDALE MILITARE PRINCIPALE CELIO - P.ZZA ', 223, 184),
(536, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 3392, 'C/O CONSIGLIO NAZ.LE DELLE RICERCHE', 'PRESSO CONSIGLIO NAZIONALE DELLE RICERCHE PIAZZALE', 223, 185),
(537, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 3393, 'C/O MINIST. BENI CULTURALI E AMBIENTALI', 'PRESSO MINISTERO PER I BENI CULTURALI-VIA DEL COLL', 223, 186),
(538, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 3394, 'C/O MINISTERO DI GRAZIA E GIUSTIZIA', 'PRESSO MINISTERO DI GRAZIA E GIUSTIZIA - VIA ARENU', 223, 186),
(539, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 3395, 'C/O ENASARCO', 'PRESSO ENASARCO-VIA USODIMARE,29', 223, 154),
(540, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 3396, 'C/O MIN. TESORO - DIR. GEN.-PENS. GUERRA', 'PRESSO MINISTERO DEL TESORO - DIREZ.GEN. DELLE PEN VIA CASILINA', 223, 182),
(541, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 3397, 'AG.33', 'PRESSO CENTRO COMM.LE CINECITTA\' 2 - VIA LAMARO ED', 223, 173),
(542, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 3398, 'INTERNET-FAMILY NET', 'VIA DEGLI ALDOBRANDESCHI, 300', 223, 163),
(543, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 3399, 'AGENZIA DI CITTA\' N. 16 BIS', 'P.LE MEDAGLIE D\'ORO,54', 223, 136),
(544, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 3400, 'FIL. DI NAPOLI', 'VIA TOLEDO 126', 5387, 80134),
(545, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 3401, 'AG.1', 'PIAZZA GARIBALDI,6/8', 5387, 80142),
(546, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 3402, 'AG.2', 'VIA FIRENZE, 39/41', 5387, 80142),
(547, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 3403, 'AG.3', 'VIA AUGUSTO WITTING, 5/6', 5387, 80133),
(548, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 3404, 'AG.4', 'PIAZZA MERCATO, 54/57', 5387, 80123),
(549, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 3405, 'AG.5', 'VIA FELICE CAVALLOTTI, 66', 5387, 80141),
(550, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 3406, 'AG.6', 'PIAZZA DEGLI ARTISTI 35', 5387, 80129),
(551, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 3407, '', 'PIAZZA DEI MARTIRI 23B', 5387, 80121),
(552, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 3408, 'AG.8', 'VIA DIOCLEZIANO 236-246', 5387, 80125),
(553, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 3409, 'AG. DI SAN GIOVANNI A TEDUCCIO', 'VIA PONTE DEI FRANCESI 33/C', 5387, 80146),
(554, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 3410, 'C/O CASERMA P.S. G. IOVINO', 'PRESSO CASERMA DELLA POLIZIA DI STATO IOVINO NAPOL', 5387, 80133),
(555, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 3411, 'AG.11', 'PIAZZA SALVATORE DI GIACOMO, 116/BIS', 5387, 80123),
(556, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 3412, 'AGENZIA N. 12', 'VIA CILEA, 134', 5387, 80127),
(557, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 3413, 'AG. 10', 'VIA G.PALERMO, 83/85', 5387, 80131),
(558, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 3414, 'NAPOLI AG.14', 'VIA IANNELLI, 8', 5387, 80100),
(559, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 3415, 'NAPOLI AG.15', 'VIA CARACCIOLO, 14-D', 5387, 80100),
(560, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 3416, 'CENTRO PRIVATE BANKING NAPOLI', 'VIA RIVIERA DI CHIAIA, 281', 5387, 80121),
(561, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 3417, 'AG. 16 DI NAPOLI', 'VIA VINCENZO ARANGIO RUIZ, 77', 5387, 80122),
(562, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 3419, 'AGENZIA DI NAPOLI', 'VIA STEFANO BARBATO, 26', 5387, 80147),
(563, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 3420, 'APAC F.P. NAPOLI', 'VIA TOLEDO 126', 5387, 80134),
(564, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 3421, 'AG. 18', 'VIA COLLI AMINEI,76 ANG.VIA NICOLARDI 14', 5387, 80131),
(565, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 3422, 'AG.19 NAPOLI', 'VIA ALESSANDRO MANZONI, 107', 5387, 80123),
(566, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 3433, 'AGENZIA N. 13', 'VIA GIULIO CESARE N. 1-5 ANG. VIA DELLE CROCIATE', 5387, 80125),
(567, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 3531, 'C/O AERITALIA SPA - STABILIM.CAPODICHINO', 'PRESSO SOCIETA\' AERITALIA S.P.A. - VIA DEL RIPOSO', 5387, 80144),
(568, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 3600, 'FILIALE DI L\'AQUILA', 'CORSO FEDERICO II, 2', 5756, 67100),
(569, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 3601, '', 'PRESSO SCUOLA ALLIEVI SOTT.LI GUARDIA DI FINANZA', 5802, 67019),
(570, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 3602, 'L\'AQUILA AG.2', 'VIA CORRADO IV, SNC', 5756, 67100),
(571, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 3603, 'AG.3 L\'AQUILA', 'S.S.17 - KM 41.970 LOC. BAZZANO', 5756, 67100),
(572, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 3800, 'AG. DI CAMPOBASSO', 'VIALE REGINA ELENA, 44B', 6018, 86100),
(573, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 3801, 'AG.1 CAMPOBASSO', 'VIA XXIV MAGGIO, 181', 6018, 86100),
(574, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 4000, 'FIL. DI BARI', 'VIA DANTE ALIGHIERI 32-40', 1946, 70121),
(575, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 4001, 'AGENZIA N. 1', 'PIAZZA GARIBALDI 45/47 ANGOLO VIA PICCINNI', 1946, 70122),
(576, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 4002, 'AGENZIA N. 2', 'VIA EXTRAMURALE CAPRUZZI,184', 1946, 70126),
(577, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 4003, 'AGENZIA DI CITTA\' N. 3', 'VIA CAMILLO ROSALBA, 47/S-7', 1946, 70124),
(578, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 4004, 'AGENZIA DI CITTA\' N. 4', 'VIA GARRUBA 41', 1946, 70122),
(579, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 4005, 'BARI AG.5', 'VIA DELLA COSTITUENTE 3,5,7', 1946, 70125),
(580, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 4006, 'AGENZIA DI CITTA\' N. 6', 'VIA GIULIO PETRONI, 47 F/G', 1946, 70124),
(581, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 4007, 'AGENZIA DI CITTA\' N.7', 'VIA LATTANZIO, 121/123', 1946, 70126),
(582, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 4008, 'C/O LEGIONE CARABINIERI', 'LUNGOMARE NAZARIO SAURO, 43', 1946, 70121),
(583, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 4009, 'MERCATO ORTOFRUTTICOLO', 'VIA CARACCIOLO, 7', 1946, 70100),
(584, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 4010, 'BA-POLIZIA DI STATO', 'VIA CACUDI, 5', 1946, 70123),
(585, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 4011, 'NUOVO PALAZZO DI GIUSTIZIA DI BARI', 'VIA NAZARIANTZ, 1', 1946, 70123),
(586, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 4012, 'APAC F.P. BARI', 'PIAZZA ALDO MORO 37', 1946, 70121),
(587, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 4013, 'AGENZIA N.8 BARI', 'VIA AMENDOLA, 172', 1946, 70126),
(588, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 4014, 'BARI AG. 9', 'P.ZZA EUROPA PRESSO CENTRO COMMERCIALE', 1946, 70123),
(589, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 4015, 'AG. 10', 'CORSO V.EMANUELE II, 62', 1946, 70122),
(590, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 4016, 'AG.11 BARI', 'CORSO SIDNEY SONNINO 103 109', 1946, 70121),
(591, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 4017, 'AG.12 BARI', 'V.LE PAPA GIOVANNI XXIII 163,165,167,169', 1946, 70124),
(592, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 4070, 'BARI TESORERIA COMUNALE', 'VIA ROBERTO DA BARI, 3', 1946, 70122),
(593, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 4199, 'C/O PALAZZO DI GIUSTIZIA', 'PIAZZA ENRICO DE NICOLA (PRESSO IL PALAZZO DI GIUS', 1946, 70123),
(594, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 4200, 'AGENZIA DI POTENZA', 'VIALE MARCONI, 94', 4319, 85100),
(595, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 4201, 'AG.1 POTENZA', 'VIA DEL GALLITELLO, 93', 4319, 85100),
(596, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 4400, 'FILIALE DI CATANZARO', 'P.ZZA MATTEOTTI, 12', 6653, 88100),
(597, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 4401, 'AGENZIA DI CATANZARO LIDO', 'VIA CORACE, 20', 6653, 88063),
(598, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 4402, '', 'VIALE PIO X, 216', 6653, 88100),
(599, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 4403, 'CATANZARO NORD', 'VIALE PIO X, 139', 6653, 88100),
(600, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 4404, 'CATANZARO NORD', 'VIALE PIO X, 139', 6653, 88100),
(601, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 4405, 'B.O.U.-A.T. CALABRIA', 'PIAZZA MATTEOTTI 12', 6653, 88100),
(602, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 4600, 'FILIALE DI PALERMO', 'VIA ROMA, 291-307', 6894, 90133),
(603, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 4601, 'AG.1', 'VIA LEONARDO DA VINCI, 68', 6894, 90145),
(604, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 4602, 'AG.2', 'VIA CAVOUR, 151', 6894, 90133),
(605, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 4603, 'AG.3', 'VIA DELLA LIBERTA, 68', 6894, 90143),
(606, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 4604, 'AGENZIA DI CITTA\' N.4', 'VIA AUSONIA, 112/A-B', 6894, 90146),
(607, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 4605, 'AGENZIA DI CITTA\' N.5', 'CORSO CALATAFIMI, 1037/L-M-N', 6894, 90132),
(608, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 4606, 'AGENZIA DI CITTA\' N.6 - PALERMO INPS', 'VIA MAGGIORE TOSELLI, 9', 6894, 90143),
(609, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 4607, 'APAC F.P. PALERMO', 'VIA ROMA 297-299', 6894, 90133),
(610, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 4608, 'SP CO ASL 6 P.O. PISANI - PALERMO', 'VIA PINDEMONTE 88', 6894, 90129),
(611, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 4609, 'SP. AZ. OSP. V. CERVELLO - PALERMO', 'VIA TRABUCCO, 180', 6894, 90146),
(612, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 4610, 'PALERMO AG.7', 'VIA LIBERTA\'', 6894, 90139),
(613, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 4611, 'AG. 8 PALERMO', 'VIA GIUSEPPE SCIUTI, 85 G', 6894, 90144),
(614, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 4612, 'AG.9 PALERMO', 'VIA TRABUCCO 180', 6894, 90146),
(615, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 4613, 'CENTRO PRIVATE BANKING PALERMO', 'VIA NICOLO\' GALLO', 6894, 90129),
(616, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 4675, 'SPORTELLO MERCATO ITTICO', 'VIA F.CRISPI, 3', 6894, 90100),
(617, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 4676, 'SPORTELLO MERCATO ORTOFRUTTICOLO', 'VIA MONTEPELLEGRINO, 4', 6894, 90100),
(618, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 4773, 'C/O PALAZZO DI GIUSTIZIA', 'PRESSO PALAZZO DI GIUSTIZIA - P.ZZA V.E.ORLANDO', 6894, 90138),
(619, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 4800, 'FILIALE DI CAGLIARI', 'LARGO CARLO FELICE, 11', 7331, 9100),
(620, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 4801, 'AGENZIA DI PIRRI', 'PIAZZA ITALIA, 27', 7331, 9134),
(621, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 4802, 'AG.2', 'VIA EFISIO CAO DI S.MARCO, 2', 7331, 9100),
(622, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 4803, 'SPORT. C.O UFFICI AMMINISTRAZ.FINANZIARI', 'VIA VESALIO - LOC. SANTU NICOLAU', 7331, 9134),
(623, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 4804, 'APAC F.P. CAGLIARI', 'LARGO CARLO FELICE 11 - 09124', 7331, 9124),
(624, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 4805, 'AG. N 5 CAGLIARI', 'VIA DELLA PINETA 231', 7331, 9126),
(625, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 4998, 'AGENZIA N.3', 'CORSO VITTORIO EMANUELE, 302', 7331, 9123),
(626, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 4999, 'C/O OSPEDALE S. GIOVANNI DI DIO', 'PRESSO L\'OSPEDALE S.GIOVANNI DI DIO - VIA OSPEDALE', 7331, 9100),
(627, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 5448, 'AG. MONTECCHIO', 'VIA ROMA SNC', 7268, 61022),
(628, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 10000, 'FILIALE DI VERCELLI', 'VIA MERCURINO DI GATTINARA, 8', 398, 13100),
(629, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 10100, 'FILIALE DI NOVARA', 'CORSO MAZZINI, 4/6', 459, 28100),
(630, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 10101, 'AGENZIA N. 1', 'CORSO VERCELLI, 3', 459, 28100),
(631, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 10102, 'AG.2 NOVARA', 'VIA ANDREA COSTA, 16', 459, 28100),
(632, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 10103, 'NOVARA AG.3', 'VIA ALESSANDRO VOLTA 59', 459, 28100),
(633, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 10104, 'AG.4 NOVARA', 'VIA XXIII MARZO 1849', 459, 28100),
(634, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 10200, 'FILIALE DI CUNEO', 'CORSO NIZZA, 10', 567, 12100),
(635, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 10201, 'CUNEO AG.2', 'VIA ROMA, 10', 567, 12100),
(636, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 10300, 'AG. DI ASTI', 'CORSO ALFIERI, 179', 744, 14100),
(637, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 10400, 'FILIALE DI ALESSANDRIA', 'PIAZZA DELLA LIBERTA\', 6', 860, 15100),
(638, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 10401, 'AG. 1 ALESSANDRIA', 'CORSO ACQUI, 71', 860, 15100),
(639, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 10500, 'AG. DI IMPERIA', 'VIA DELLA REPUBBLICA, 50', 1152, 18100),
(640, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 10600, 'FIL. DI SAVONA', 'PIAZZA MARCONI, 3', 1244, 17100),
(641, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 10601, 'AG.1', 'VIA GRAMSCI, 48/R', 1244, 17100),
(642, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 10700, 'AG. DI LA SPEZIA', 'VIA DALMAZIA, 13', 1339, 19100),
(643, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 10800, 'FILIALE DI VARESE', 'VIA VOLTA, 9', 1353, 21100),
(644, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 10801, 'AG. 1 VARESE', 'VIA TAMAGNO, 1', 1353, 21100),
(645, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 10900, 'FILIALE DI COMO', 'PIAZZA CAVOUR, 33/34', 1550, 22100),
(646, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 10901, 'AG N 1 COMO', 'VIA ANZANI,38', 1550, 22100),
(647, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 10943, 'AG. DI PONTE CHIASSO', 'VIA CATENAZZI, 3/D', 1550, 22100),
(648, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 11000, 'AGENZIA DI SONDRIO', 'PIAZZALE BERTACCHI, 26', 1720, 23100),
(649, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 11100, 'FILIALE DI BERGAMO', 'VIA PETRARCA, 12', 1950, 24100),
(650, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 11101, 'FILIALE DI BERGAMO', 'VIA PETRARCA, 12', 1950, 24100),
(651, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 11102, 'AG.N 1 BERGAMO', 'VIA JACOPO PALMA IL VECCHIO,4', 1950, 24128),
(652, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 11103, 'AG. 2', 'VIA BORGO SANTA CATERINA 65', 1950, 24124),
(653, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 11200, 'FILIALE DI BRESCIA', 'VIA MORETTO, 40', 2199, 25100),
(654, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 11201, 'AG.1', 'VIALE PIAVE, 27', 2199, 25123),
(655, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 11202, 'AGENZIA N. 2', 'VIA S.MARIA CROCIFISSA DI ROSA, 74', 2199, 25128),
(656, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 11203, 'BRESCIA AG.3', 'VIA MILANO, 18ŽŽ', 2199, 25126),
(657, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 11204, 'AG. 4 BRESCIA', 'VIA CREMONA, 52', 2199, 25124),
(658, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 11300, 'FILIALE DI PAVIA', 'VIA MENTANA, 2', 2486, 27100),
(659, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 11301, 'AGENZIA DI CITTA\' N. 1', 'VIA MAZZINI, 13', 2486, 27100),
(660, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 11302, 'AG.2 PAVIA', 'V.LE DELLA LIBERTA\', 23', 2486, 27100),
(661, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 11400, 'FILIALE DI CREMONA', 'CORSO CAMPI, 4/10', 2602, 26100),
(662, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 11401, 'AGENZIA DI CITTA\' N. 1', 'VIA F. GHINAGLIA, 77', 2602, 26100),
(663, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 11402, 'CREMONA AG.2', 'VIA DANTE, 265', 2602, 26100),
(664, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 11500, 'FILIALE DI MANTOVA', 'PIAZZA FELICE CAVALLOTTI, 3', 2711, 46100),
(665, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 11600, 'FILIALE DI BOLZANO', 'PIAZZA WALTHER, 10', 2759, 39100),
(666, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 11601, 'AGENZIA DI CITTA\' N. 1', 'VIA PALERMO, 11/F', 2759, 39100),
(667, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 11602, 'AG.2 BOLZANO', 'CORSO ITALIA, 31', 2759, 39100),
(668, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 11699, 'C/O FIAT VEICOLI INDUSTRIALI SPA', 'PRESSO FIAT IVECO SPA - VIA A.VOLTA, 6', 2759, 39100),
(669, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 11700, 'AG.IN SEDE VERONA', 'PIAZZA DELLE ERBE 19', 3181, 37121),
(670, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 11701, 'AG.1', 'PIAZZA RENATO SIMONI, 40', 3181, 37100),
(671, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 11702, 'AGENZIA DI CITTA\' N. 3', 'VIA G. MAMELI, 69', 3181, 37124),
(672, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 11703, 'AGENZIA PRESSO IL TRIBUNALE', 'VIA DEL LANCIERE', 3181, 37122),
(673, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 11704, 'VERONA AG.4', 'VIA L. PRINA, 9', 3181, 37100),
(674, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 11705, 'APAC FLUSSI E PRODOTTI VERONA', 'VIA MAZZINI 18', 3181, 37121),
(675, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 11706, 'AG.5 VERONA', 'CORSO MILANO, 2', 3181, 37138),
(676, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 11707, 'AG.6 VERONA', 'VIA IV NOVEMBRE 23A', 3181, 37126),
(677, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 11708, 'AG.7 VERONA', 'C.SO DI PORTA NUOVA, 107AB', 3181, 37122),
(678, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 11709, 'CENTRO IMPRESE VERONA', 'VIA ALBERE, 19', 3181, 37138),
(679, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 11710, 'CENTRO PRIVATE VERONA', 'LOCATELLI 1', 3181, 37122),
(680, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 11712, 'AGENZIA DI CITTA\' N. 2', 'VIALE STAZIONE PORTA VESCOVO, 4', 3181, 37133),
(681, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 11800, 'FILIALE DI VICENZA', 'CORSO ANDREA PALLADIO, 45', 3303, 36100),
(682, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 11801, 'AGENZIA DI CITTA\' N. 2', 'CORSO PADOVA, 145', 3303, 36100),
(683, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 11802, 'AGENZIA SETAF', 'PRESSO CASERMA EDERLE - VIALE DELLA PACE193', 3303, 36100),
(684, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 11803, 'AG. 3 VICENZA', 'VIALE TRIESTE, 161-163', 3303, 36100),
(685, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 11804, 'AG.4 VICENZA', 'VIALE VERONA, 87', 3303, 36100),
(686, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 11896, 'AGENZIA N.1 - VICENZA', 'VIALE VENEZIA, 14/A', 3303, 36100),
(687, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 11900, 'AGENZIA DI BELLUNO', 'VIA VITTORIO VENETO, 173/A', 3315, 32100),
(688, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 12000, 'FILIALE DI TREVISO', 'PIAZZA DELLA BORSA, 5', 2361, 31100),
(689, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 12001, 'TREVISO AG. 1', 'VIALE MONFENERA, 6', 2361, 31100),
(690, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 12002, 'AG.2 TREVISO', 'V. MONTELLO 13', 2361, 31100),
(691, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 12099, 'C/O AERONAUTICA MILIT.-COMANDO 2 STORMO', 'PRESSO COMANDO II STORMO AERONAUTICA MILITARE - AE', 2361, 31100),
(692, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 12100, 'FIL. DI PADOVA', 'PIAZZA INSURREZIONE, 6', 3575, 35139),
(693, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 12101, 'AG.1', 'PIAZZA GAETANO SALVEMINI, 3', 3575, 35131),
(694, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 12102, 'AG. DI CITTA\' N.2 - PADOVA', 'VIA URUGUAY, 41', 3575, 35020),
(695, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 12103, 'AGENZIA DI CITTA\' N. 3', 'VIA GUIZZA, 218', 3575, 35125),
(696, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 12104, 'PADOVA AG.4', 'VIA ROBERTO MARIN, 19-21', 3575, 35122),
(697, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 12111, 'AERONAUTICA MILITARE COM. 1^ AEROBRIGATA', 'PRESSO COMANDO DELLA 1^ AEROBRIGATA - VIA SORIO, 8', 3575, 35141),
(698, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 12200, 'AGENZIA DI ROVIGO', 'CORSO DEL POPOLO, 226', 3660, 45100),
(699, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 12201, 'AG.1 ROVIGO', 'CORSO DEL POPOLO 379', 3660, 45100),
(700, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 12300, 'FILIALE DI UDINE', 'VIA MERCATO VECCHIO, 17/19', 3800, 33100),
(701, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 12301, 'UDINE AGENZIA 1', 'PIAZZALE OSOPPO 2A', 3800, 33100),
(702, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 12302, 'AG.2 UDINE', 'VIA TRICESIMO, 181', 3800, 33100),
(703, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 12400, 'AGENZIA DI GORIZIA', 'CORSO ITALIA, 19', 3815, 34170),
(704, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 12500, 'AGENZIA DI PORDENONE', 'CORSO GARIBALDI, 62', 7428, 33170),
(705, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 12501, 'AG.1 PORDENONE', 'VIALE DANTE, 29', 7428, 33170),
(706, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 12502, 'AG. 2 PORDENONE', 'VIA M. GRIGORETTI ANG. V. CASERME 1', 7428, 33170),
(707, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 12600, 'FILIALE DI PIACENZA', 'PIAZZA CAVALLI, 36/41', 3577, 29100),
(708, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 12601, 'AGENZIA DI CITTA\' N. 1 - PIACENZA', 'VIA CAORSANA, 34', 3577, 29100),
(709, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 12602, 'PIACENZA AG.2', 'VIA VITTORIO VENETO, 37-D', 3577, 29100),
(710, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 12603, 'AG. N 3 PIACENZA', 'VIA GENOVA 15', 3577, 29100),
(711, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 12699, 'PRESSO ARSENALE DELL\'ESERCITO', 'PRESSO ARSENALE DELL\'ESERCITO - VIALE MALTA, 30', 3577, 29100),
(712, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 12700, 'FILIALE DI PARMA', 'PIAZZA GARIBALDI, 17/A', 3914, 43100),
(713, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 12701, 'AGENZIA DI CITTA\' N. 1', 'VIA BRUXELLES, 10-A', 3914, 43100),
(714, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 12702, 'AG.2 PARMA', 'V.LE MENTANA, 120', 3914, 43121),
(715, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 12703, 'PARMA AG.3', 'VIALE VITTORIA, 1-A', 3914, 43125),
(716, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 12704, 'PARMA AG.4', 'VIA SAVANI, 2', 3914, 43126),
(717, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 12800, 'FILIALE DI REGGIO EMILIA', 'VIA EMILIA S.STEFANO, 4', 3967, 42100),
(718, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 12801, 'AGENZIA DI CITTA\' N. 1', 'VIA EMILIA ALL\'OSPIZIO, 14', 3967, 42100),
(719, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 12802, 'RE-PALAZZO DI GIUSTIZIA', 'VIA PATERLINI, SNC', 3967, 42100),
(720, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 12803, 'REGGIO EMILIA AG.2', 'VIA EMILIA ALL\'ANGELO, 22 E-F', 3967, 42100),
(721, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 12900, 'FILIALE DI MODENA', 'VIA CASTELLARO, 12 ANG. VIA SCUDARI, 13', 4002, 41100),
(722, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 12901, 'AG.1', 'VIA GIARDINI, 595', 4002, 41100),
(723, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 12902, 'AGENZIA N.2 - MODENA EST', 'VIALE CADUTI SUL LAVORO, 218-226/A', 4002, 41100),
(724, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 12903, 'AGENZIA DI CITTA\' N. 3', 'VIA SANTE FATTORI, 26', 4002, 41100),
(725, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 12904, 'MODENA AG. 3', 'VIA EMILIA EST, 378', 4002, 41100),
(726, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 12905, 'MODENA AG.4', 'VIA PIETRO GIARDINI, 313', 4002, 41124),
(727, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 13000, 'FILIALE DI FERRARA', 'VIA PORTA RENO, 19', 3124, 44100),
(728, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 13001, 'AGENZIA DI CITTA\' N. 1', 'VIALE IV NOVEMBRE, 94 ANG. VIA DARSENA, 148', 3124, 44100),
(729, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 13002, 'AG.2 FERRARA', 'VIA BOLOGNA, 161', 3124, 44122),
(730, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 13100, 'AGENZIA DI PIAZZA DEL POPOLO', 'PIAZZA DEL POPOLO, 23', 4126, 48100),
(731, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 13101, 'SP. C/O COMPAGNIA PORTUALE', 'VIA ANTICO SQUERO, 6', 4126, 48100),
(732, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 13102, 'FILIALE', 'VIA CICOGNANI, 7', 4126, 48100),
(733, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 13103, 'AG.2 RAVENNA', 'VIALE VINCENZO RANDI 39-41', 4126, 48121),
(734, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 13196, 'AGENZIA DI CITTA\' N.1', 'VIA CICOGNANI, 7', 4126, 48100),
(735, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 13200, 'FILIALE DI FORLI\'', 'VIA DELLE TORRI, 26', 4140, 47100),
(736, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 13201, 'AGENZIA DI CITTA\' N.1', 'VIALE RISORGIMENTO, 108', 4140, 47100),
(737, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 13300, 'FILIALE DI PESARO', 'VIA MAMELI ANG. VIA NEVIERA', 4204, 61100),
(738, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 13301, 'AG.2 PESARO', 'LARGO ASCOLI PICENO, SNC', 4204, 61122),
(739, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 13399, 'AGENZIA N.1 - PESARO', 'LARGO TERENZIO MAMIANI, 2/4', 4204, 61100),
(740, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 13400, 'FILIALE DI MACERATA', 'PIAZZA OBERDAN, 7', 4183, 62100),
(741, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 13401, 'AGENZIA N. 1', 'VIA DON BOSCO, 39/41', 4183, 62100),
(742, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 13500, 'FILIALE DI ASCOLI PICENO', 'CORSO MAZZINI, 160 ANG. VIA TRIESTE', 4340, 63100),
(743, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 13599, 'AGENZIA N.1', 'VIALE INDIPENDENZA, 63', 4340, 63100),
(744, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 13600, 'AG. MASSA', 'VIALE DEMOCRAZIA, 44', 3565, 54100),
(745, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 13700, 'FILIALE DI LUCCA', 'PIAZZA S.MICHELE, 7', 4440, 55100),
(746, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 13701, 'AGENZIA. N. 1', 'VIALE SAN CONCORDIO, 461', 4440, 55100),
(747, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 13702, 'LUCCA AG.2', 'VIA PISANA VECCHIA, 166-185', 4440, 55100),
(748, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 13703, 'AG.3 LUCCA', 'VIA CASTRUCCIO CASTRACANI, 196', 4440, 55100),
(749, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 13800, 'AGENZIA DI PISTOIA', 'VIA E.FERMI ANG. VIA S.QUASIMODO', 4472, 51100),
(750, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 13801, 'AGENZIA A DI PISTOIA', 'PIAZZA SAN FRANCESCO, 26', 4472, 51100),
(751, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 13900, 'FILIALE DI LIVORNO', 'VIA CAIROLI, 61', 357, 57100),
(752, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 13901, 'AGENZIA N.1 - LIVORNO', 'VIA GAETANO D\'ALESIO 8-12', 357, 57123),
(753, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 13902, 'LI-LA TORRE', 'VIA AURELIO LAMPREDI 35', 357, 57121),
(754, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 13974, 'C/O ACCADEMIA NAVALE MARINA MILITARE', 'PRESSO ACCADEMIA NAVALE DELLA MARINA MILITARE - VI', 357, 57100),
(755, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 14000, 'AG. DI PISA', 'CORSO ITALIA 141', 466, 56100),
(756, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 14001, 'AGENZIA A PRESSO OSPEDALE S.CHIARA-PISA', 'VIA ROMA, 67', 466, 56100),
(757, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 14002, 'C/O LA BASE USA-SETAF CAMP DARBY', 'PRESSO BASE USA-SETAF DI CAMP DARBY - VIA VECCHIA ', 466, 56018),
(758, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 14003, 'AGENZIA PRESSO C.N.R.', 'LOCALITA\' SAN CATALDO', 466, 56100),
(759, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 14004, 'PISA AG.A', 'VIA C.S.CAMMEO, 31', 466, 56100),
(760, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 14099, 'PRESSO AERONAUTICA MILITARE', 'PRESSO AERONAUTICA MILITARE - 46 AEROBRIGATA', 466, 56100),
(761, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 14100, 'AG. DI AREZZO', 'VIA G.MONACO, 74', 4585, 52100),
(762, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 14101, 'AREZZO AG.A', 'VIA J.F.KENNEDY, 69', 4585, 52100),
(763, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 14102, 'AREZZO AG.2', 'VIA FRANCESCO CRISPI, 60', 4585, 52100),
(764, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 14200, 'AGENZIA DI SIENA', 'VIALE VITTORIO VENETO, 43', 4654, 53100),
(765, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 14201, 'AG.1 SIENA', 'VIA BANCHI DI SOTTO, 10', 4654, 53100),
(766, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 14300, 'FILIALE DI GROSSETO', 'PIAZZA DEL DUOMO, 5', 4669, 58100),
(767, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 14301, 'AGENZIA DI CITTA\' N. 1', 'VIALE GIULIO CESARE, 25', 4669, 58100),
(768, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 14400, 'AG. DI TERNI', 'PIAZZA TACITO, 9 ANG. VIA CESARE BATTISTI', 4777, 5100),
(769, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 14401, 'AG. 1 TERNI', 'VIA TURATI 22 H', 4777, 5100),
(770, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 14500, 'AG. DI VITERBO', 'VIA GENOVA, 52', 4837, 1100),
(771, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 14600, 'AGENZIA DI RIETI', 'VIA A. SACCHETTI SASSETTI, 1/7', 4897, 2100),
(772, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 14700, 'FILIALE DI LATINA', 'VIA EMANUELE FILIBERTO, 1', 5043, 4100),
(773, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 14701, 'AGENZIA N. 1', 'VIALE PIER LUIGI NERVI, 176', 5043, 4100),
(774, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 14702, 'LT-C.COMMERC.LATINAFIORI', 'VIALE PIER LUIGI NERVI', 5043, 4100),
(775, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 14703, 'CENTRO CORPORATE LAZIO SUD', 'VIA EMANUELE FILIBERTO 9', 5043, 4100),
(776, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 14704, 'LATINA AG.2', 'VIA APRILIA SNC ANG. VIA PRIVERNO', 5043, 4100),
(777, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 14800, 'AG. DI FROSINONE', 'PIAZZA CADUTI DI VIA FANI, 38', 5103, 3100),
(778, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 14900, 'AG. DI CASERTA', 'VIA TRIESTE 59/67', 5178, 81100),
(779, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 14901, 'AG.1 CASERTA', 'VIA ALESSANDRO MANZONI, 11', 5178, 81100),
(780, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 15000, 'AG. DI BENEVENTO', 'VIA PIETRO NENNI, 13', 5268, 82100),
(781, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 15001, 'BENEVENTO AG.A', 'VIA ARCO TRAIANO, 24', 5268, 82100),
(782, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 15100, 'AG. DI AVELLINO', 'VIA S.DE RENZI,34/40', 5438, 83100),
(783, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 15101, 'AVELLINO AG.1', 'VIALE ITALIA, 36', 5438, 83100),
(784, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 15200, 'FILIALE DI SALERNO', 'CORSO GARIBALDI,208-210', 5665, 84100),
(785, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 15201, 'AGENZIA DI CITTA\' N. 1 - SALERNO', 'VIA SILVIO BARATTA, 30', 5665, 84100),
(786, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 15202, 'SALERNO AG.2', 'VIA TRENTO, 115-117', 5665, 84131),
(787, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 15203, 'CENTRO IMPRESE SALERNO', 'CORSO GARIBALDI 215', 5665, 84100),
(788, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 15300, 'FILIALE DI TERAMO', 'PIAZZA ERCOLE VINCENZO ORSINI 7/8/9', 5856, 64100),
(789, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 15301, 'TERAMO AG.1', 'VIA CRISTOFORO COLOMBO, 126', 5856, 64100),
(790, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 15400, 'FILIALE DI PESCARA', 'CORSO VITTORIO EMANUELE, 148', 5890, 65100),
(791, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 15401, 'AGENZIA DI CITTA\' N.1', 'VIA TIBURTINA, 383', 5890, 65129),
(792, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 15403, 'APAC F.P. PESCARA', 'VIA MAZZINI 75', 5890, 65100),
(793, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 15404, 'AGENZIA DI CITTA\' N.3', 'VIA FONTE ROMANA, S.N.C.', 5890, 65124),
(794, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 15405, 'AGENZIA N.4', 'VIA BOVIO, 441', 5890, 65124),
(795, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 15499, 'AGENZIA DI CITTA\' N.2', 'VIALE GUGLIELMO MARCONI 263', 5890, 65126),
(796, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 15500, 'AG. DI CHIETI', 'CORSO MARRUCINO, 169/175', 5930, 66100),
(797, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 15501, 'CHIETI SCALO', 'VIA TOMMASO SCARAVIGLIA, 34', 5930, 66013),
(798, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 15600, 'AG. DI ISERNIA', 'VIA XXIV MAGGIO, 311', 7470, 86170),
(799, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 15700, 'FILIALE DI FOGGIA', 'VIA DELLA REPUBBLICA 18', 6120, 71100),
(800, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 15701, 'FOGGIA AG.2', 'VIA BARI', 6120, 71100),
(801, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 15702, 'AG.3 FOGGIA', 'VIALE OFANTO 49 51 55 57', 6120, 71121),
(802, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 15798, 'C/O STAZIONE F.S.', 'PRESSO STAZIONE FERROVIARIA - P.LE VITTORIO VENETO', 6120, 71100),
(803, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 15800, 'FILIALE DI TARANTO', 'VIA DE CESARE 21', 6235, 74100),
(804, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 15801, 'AG.1', 'VIALE MAGNA GRECIA, 110/A', 6235, 74100),
(805, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 15802, 'AGENZIA DI CITTA\' N. 2', 'VIA DUCA D\'AOSTA, 37', 6235, 74100),
(806, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 15803, '', 'PRESSO PALAZZO DI GIUSTIZIA - CORSO ITALIA', 6235, 74100),
(807, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 15804, 'SPORTELLO PRESSO CORTE APPELLO DI LECCE', 'VIA CANNATA, SNC QUARTIERE PAOLO VI', 6235, 74123),
(808, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 15805, 'TARANTO-AG.LAMA', 'VIA GREGORIO VII, 6', 6235, 74020),
(809, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 15900, 'AG. DI BRINDISI', 'VIA SANTI 11', 6238, 72100),
(810, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 15901, 'SPORTELLO PRESSO COMANDO M.M.', 'VIA DEI MILLE', 6238, 72100),
(811, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 15902, 'BR-PALAZZO GIUSTIZIA', 'VIA PALMIRO TOGLIATTI, 1', 6238, 72100),
(812, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 15903, 'AG.1 BRINDISI', 'VIALE PALMIRO TOGLIATTI, 60', 6238, 72100),
(813, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 16000, 'FILIALE DI LECCE', 'PIAZZA SANT\'ORONZO,39', 5757, 73100),
(814, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 16001, 'AGENZIA DI CITTA\' N.1', 'VIA TARANTO, 38', 5757, 73100),
(815, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 16002, 'LECCE AG.2', 'VIA ZANARDELLI 25-27', 5757, 73100),
(816, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 16003, 'LECCE AG.3', 'VIA GIACOMO LEOPARDI, 134', 5757, 73100),
(817, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 16100, 'AG. DI MATERA', 'VIA DANTE, 47', 6468, 75100),
(818, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 16101, 'SPORTELLO PRESSO IL TRIBUNALE DI MATERA', 'VIA ALDO MORO,26', 6468, 75100),
(819, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 16200, 'FILIALE DI COSENZA', 'CORSO MAZZINI 86', 6530, 87100),
(820, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 16201, 'CS-PALAZZO DI GIUSTIZIA', 'VIA SICILIA, 10', 6530, 87100),
(821, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 16202, 'COSENZA AG.1', 'P.ZZA LORETO 31-33', 6530, 87100),
(822, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 16300, 'FILIALE DI R. CALABRIA', 'C.SO GARIBALDI,431-VIA S.STEFANO DA NICEA,29', 6783, 89100),
(823, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 16301, 'AGENZIA DI CITTA\' N.1', 'VIA CARDINALE PORTANOVA, 126', 6783, 89124),
(824, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 16302, 'AGENZIA 2 DI REGGIO CALABRIA', 'VIALE CALABRIA CO CENTRO COMMERCIALE LE NINFEE', 6783, 89132),
(825, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 16303, 'REGGIO CALABRIA AG.3', 'VIA SANTA CATERINA D\'ALESSANDRIA 87-91', 6783, 89122),
(826, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 16400, 'AGENZIA DI TRAPANI', 'VIA SCONTRINO, 5 ANG. VIA MARINO TORRE', 6838, 91100),
(827, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 16500, 'AG.IN SEDE MESSINA', 'VIA DOGALI 26', 6971, 98123),
(828, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 16501, 'AGENZIA SS. ANNUNZIATA', 'VIA DEL FANTE, 78/84', 6971, 98168),
(829, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 16502, 'MESSINA AG.2', 'STRADA STATALE 114 - KM 5,8 TRE MESTIERI', 6971, 98100),
(830, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 16503, 'ME-UFFICI PROVINCIALI', 'CORSO CAVOUR, SNC PALAZZO DEI LEONI', 6971, 98122),
(831, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 16504, 'AG. 2 MESSINA', 'VIA G. GARIBALDI 201 -203', 6971, 98122),
(832, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 16505, 'AG.3', 'VIA GIUSEPPE GARIBALDI', 6971, 98122),
(833, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 16506, 'MESSINA AG.4', 'SS 114 KM 5,4', 6971, 98125),
(834, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 16600, 'AGENZIA DI AGRIGENTO', 'VIA IMERA, 203', 7032, 92100),
(835, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 16700, 'AGENZIA DI CALTANISSETTA', 'VIA J.F. KENNEDY, 1', 7078, 93100),
(836, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 16800, 'AGENZIA DI ENNA', 'VIA SANT\'AGATA, 56-58-60-62', 7105, 94100),
(837, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 16900, 'FILIALE DI CATANIA', 'CORSO SICILIA, 30 ANG. VIA GAMBINO', 7131, 95131),
(838, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 16901, 'AG.1', 'VIA GARIBALDI, 71', 7131, 95121),
(839, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 16902, 'AG.2', 'LARGO VESPRI SICILIANI, 18', 7131, 95129),
(840, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 16903, 'AGENZIA N. 3', 'CORSO DELLE PROVINCE, 205', 7131, 95127),
(841, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 16904, 'AG.4', 'CORSO ITALIA, 57/A', 7131, 95129),
(842, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 16905, 'SP. CO OSPEDALE GARIBALDI - CATANIA', 'PIAZZA SANTA MARIA DI GESU\', 5', 7131, 95125),
(843, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 16906, 'CATANIA AG. N 5', 'PIAZZA LUDOVICO ARIOSTO,15', 7131, 95127),
(844, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 17000, 'AGENZIA DI RAGUSA', 'VIA G. DI VITTORIO, 8', 7183, 97100),
(845, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 17100, 'AG. DI SIRACUSA', 'CORSO UMBERTO, 29', 7203, 96100),
(846, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 17101, 'AG.1 SIRACUSA', 'VIALE TICA, 113', 7203, 96100),
(847, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 17200, 'FILIALE DI SASSARI', 'PIAZZA D\'ITALIA, 35', 7255, 7100),
(848, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 17201, 'AGENZIA DI CITTA\' N. 1', 'VIA DUCA DEGLI ABRUZZI, 46', 7255, 7100),
(849, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 17202, 'AG. N 2 SASSARI', 'VIA MASTINO 27', 7255, 7100),
(850, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 17203, 'CENTRO IMPRESE SASSARI', 'VIA CAGLIARI 12', 7255, 7100),
(851, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 17300, 'AG. DI NUORO', 'VIA MANZONI, 26/A', 7299, 8100),
(852, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 17400, 'AG. DI ORISTANO', 'PIAZZA ROMA, 5/11', 7537, 9170),
(853, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 20000, 'MONCALIERI', 'PIAZZA VITTORIO EMANUELE II, 8', 156, 10024),
(854, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 20100, 'AGENZIA DI BOLLATE', 'VIA CAVOUR 18', 1761, 20021),
(855, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 20200, 'AG. DI LEGNANO', 'PIAZZA DON LUIGI STURZO,1', 1826, 20025),
(856, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 20300, 'AGENZIA DI LODI', 'VIA XX SETTEMBRE, 20', 7325, 20075),
(857, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 20400, 'FILIALE DI MONZA', 'VIA FELICE CAVALLOTTI 4', 1846, 20052),
(858, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 20401, 'MONZA AG.1', 'VIA BUONARROTI, 22-24', 1846, 20052),
(859, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 20402, 'MONZA AG.2', 'PIAZZA GIUSEPPE GARIBALDI, 2-4', 1846, 20052),
(860, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 20403, 'AG.3 MONZA', 'VIA GEROLAMO BORGAZZI, 20', 1846, 20052),
(861, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 20404, 'CENTRO AFFARI TERRITORIALE LOMB.NORD', 'VIA GRAMSCI, 23', 1846, 20052),
(862, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 20500, 'AG. RHO', 'VIALE E. DE AMICIS 39/43', 1874, 20017),
(863, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 20501, 'SP PRESSO NUOVO POLO FIERISTICO RHO-PERO', 'STRADA STATALE DEL SEMPIONE, 28', 1874, 20017),
(864, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 20600, 'AGENZIA DI SEGRATE', 'VIA MODIGLIANI, 45', 1890, 20090),
(865, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 20700, 'AG. DI SESTO SAN GIOVANNI', 'VIALE GRAMSCI,23', 1893, 20099),
(866, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 20701, 'AG.1 SESTO SAN GIOVANNI', 'VIA ERCOLE MARELLI, 382', 1893, 20099),
(867, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 20899, 'AGENZIA DI ROVERETO', 'VIA FOLLONE, 7 ANG. VIA DANTE', 3025, 38068),
(868, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 20900, 'AG. DI CHIOGGIA', 'CORSO DEL POPOLO 1307', 3481, 30015),
(869, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 20901, 'AG. DI SOTTOMARINA DI CHIOGGIA', 'VIALE VENETO, 10', 3481, 30019),
(870, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 20902, '', 'PRESSO MERCATO ITTICO ALL\'INGROSSO - ISOLA CANTIER', 3481, 30015),
(871, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 21000, 'AG. DI IMOLA', 'VIA EMILIA, 25/B', 4058, 40026),
(872, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 21100, 'AG. DI FABRIANO', 'VIA BALBO 2', 4244, 60044),
(873, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 21200, 'AG DI JESI', 'PIAZZA DELLA REPUBBLICA 11', 4248, 60035),
(874, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 21300, 'AG. DI SENIGALLIA', 'CORSO 2 GIUGNO 1 ANGOLO PORTICI ERCOLANI', 4272, 60019),
(875, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 21400, 'CAMPI BISENZIO', 'VIA V.VENETO, 26A', 4486, 50013),
(876, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 21500, 'FILIALE DI PRATO', 'VIA BETTINO, 2', 469, 50047),
(877, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 21501, 'AGENZIA DI CITTA\' N. 1', 'VIA MONTALESE N.255 - LOCALITA\' MALISETI', 469, 50047),
(878, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 21502, 'AG. N 2 - PRATO', 'VIA BOLOGNA, 114', 469, 59100),
(879, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 21503, 'CENTRO PRIVATE PRATO-PISTOIA', 'VIA BETTINO 2', 469, 59100);
INSERT INTO `gaz_bank` (`id`, `iso_country`, `codabi`, `descriabi`, `codcab`, `descricab`, `indiri`, `id_municipalities`, `cap`) VALUES
(880, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 21600, 'AGENZIA DI CITTA\' DI CASTELLO', 'VIA VITTORIO VENETO, 8', 4699, 6012),
(881, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 21700, 'AG. DI FOLIGNO', 'VIA GARIBALDI', 4704, 6034),
(882, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 21799, 'C/O OFFICINA GRANDI RIPARAZ. F.S.', 'PRESSO OFFICINA GRANDE RIPARAZIONE FF.SS. VIA ANCO', 4704, 6034),
(883, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 21800, 'SPOLETO', 'V.LE TRENTO E TRIESTE, 41-43-45-47', 4737, 6049),
(884, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 22000, 'AGENZIA DI POMEZIA', 'VIA ROMA, 198', 4990, 40),
(885, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 22001, 'CENTRO IMPRESE DI POMEZIA', 'VIA URBANO RATTAZZI, 9', 4990, 40),
(886, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 22100, 'CASTELLAMARE', 'CORSO VITTORIO EMANUELE 152', 5362, 80053),
(887, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 22200, 'AG. DI CROTONE', 'VIA MARIO NICOLETTA 30', 7857, 88074),
(888, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 22201, 'SPORTELLO PRESSO PALAZZO DI GIUSTIZIA', 'PALAZZO DI GIUSTIZIA', 7857, 88900),
(889, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 22300, 'FILIALE DI BIELLA', 'VIA ANTONIO GRAMSCI 2/B', 7591, 13051),
(890, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 22301, 'BIELLA BORGO S.PAOLO', 'VIA TRIPOLI, 2', 7591, 13051),
(891, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 22302, 'CENTRO PRIVATE BANKING PIEMONTE', 'VIA GRAMSCI, 4 B', 7591, 13900),
(892, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 22400, 'AGENZIA DI VERBANIA', 'CORSO EUROPA, 50', 7996, 28048),
(893, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 22500, 'AG. DI ALBA', 'CORSO LANGHE', 317, 12051),
(894, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 22600, 'AGENZIA DI CASALE MONFERRATO', 'VIA CAVOUR, 43', 896, 15033),
(895, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 22800, 'AG. DI BUSTO ARSIZIO', 'PIAZZA GARIBALDI 1/TER', 1382, 21052),
(896, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 22900, 'AG. DI LECCO', 'CORSO MARTIRI DELLA LIBERAZIONE,34', 7711, 22053),
(897, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 23000, 'AG. DI VIGEVANO', 'VIA E. DE AMICIS, 8-8/A', 2553, 27029),
(898, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 23300, 'AG. DI CARPI', 'VIA CARLO MARX, 47/B', 419, 41012),
(899, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 23600, 'AGENZIA DI CERVIA', 'VIA G. DI VITTORIO, 27', 4119, 48015),
(900, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 23800, 'LUGO', 'PIAZZA 1 MAGGIO ANG. VIA MARIOTTI', 3241, 48022),
(901, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 23900, 'AG. DI CESENA', 'VIA IX FEBBRAIO 7/9', 4135, 47023),
(902, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 23901, 'CESENA AG.1', 'VIALE GASPARE FINALI, 62', 4135, 47521),
(903, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 24100, 'AG. DI RICCIONE', 'VIALE DANTE ALIGHIERI,9', 7833, 47036),
(904, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 24200, 'AG. DI RIMINI', 'CORSO D\'AUGUSTO 110/112', 7834, 47037),
(905, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 24201, 'AGENZIA A DI RIMINI', 'VIA PASCOLI, 186 ANG. VIA MARIOTTI', 7834, 47037),
(906, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 24202, 'RIMINI AG.2', 'VIA MARECCHIESE ANG VIA DE\' SURIANI', 7834, 47923),
(907, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 24300, 'AG. DI FANO', 'VIA MONTEVECCHIO,51', 4173, 61032),
(908, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 24301, 'FANO AG.A', 'VIA ROMA, 185', 4173, 61032),
(909, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 24400, 'AG. DI S. BENEDETTO DEL TRONTO', 'VIA FRANCESCO CRISPI 2/4', 4399, 63039),
(910, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 24401, 'AG. PORTO D\'ASCOLI', 'S.S. ADRIATICA VIA MONTI DELLA LAGA', 4399, 63039),
(911, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 24402, 'SAN BENEDETTO DEL TRONTO', 'VIA DE GASPERI, 70', 4399, 63039),
(912, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 24500, 'AG. DI CARRARA', 'VIA ROMA,15', 4409, 54033),
(913, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 24501, 'CARRARA AG.A', 'VIA FIASCHI, 12', 4409, 54033),
(914, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 24700, 'AG. DI CAPANNORI', 'VIA PESCIATINA, 166/B', 4430, 55010),
(915, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 24800, 'AG. VIAREGGIO', 'VIA MAZZINI ANG. VIA PAOLINA BONAPARTE', 4456, 55049),
(916, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 25600, 'AGENZIA DI MONTEPULCIANO', 'PIAZZA SAVONAROLA', 4637, 53045),
(917, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 25700, 'AGENZIA DI ORVIETO', 'VIA DI PIAZZA DEL POPOLO ANG. VIA RIPA DELL\'OLMO', 4768, 5018),
(918, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 25900, 'AGENZIA DI MARSALA', 'VIA MAZZINI, 110', 6828, 91025),
(919, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 26200, 'AGENZIA DI ACIREALE', 'CORSO ITALIA, 2', 7120, 95024),
(920, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 30360, 'AG. DI CHIERI', 'VICOLO SANT\'ANTONIO, 2', 78, 10023),
(921, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 30410, 'COLLEGNO', 'CORSO FRANCIA 136', 90, 10010),
(922, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 30680, 'AG.14 C/O INTERPORTO DOGANALE TORINO', 'PRESSO INTERPORTO DOGANALE DI TORINO - TANGENZIALE', 171, 10043),
(923, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 30750, 'AG. PINEROLO', 'CORSO TORINO, 174', 191, 10064),
(924, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 30870, 'AGENZIA DI RIVOLI', 'CORSO SUSA, 80-B', 219, 10098),
(925, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 31030, 'AG.SETTIMO TORINESE', 'VIA TORINO, 34/A', 265, 10036),
(926, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 31050, 'AGENZIA DI STRAMBINO', 'PIAZZA DELLA REPUBBLICA, 10/BIS', 269, 10019),
(927, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 31870, 'AGENZIA DI BUSALLA', 'VIA ROMA, 5', 1263, 16012),
(928, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 31950, 'AG. CHIAVARI', 'VIA NINO BIXIO 8', 1272, 16043),
(929, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 32110, 'AGENZIA DI RAPALLO', 'VIA LAMARMORA, 1/A', 1303, 16035),
(930, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 32230, 'AGENZIA DI SESTRI LEVANTE', 'VIA STATI UNITI, 12', 1316, 16039),
(931, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 32380, 'AGENZIA DI ABBIATEGRASSO', 'PIAZZA CASTELLO, 19', 1738, 20081),
(932, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 32620, 'BRESSO', 'VIA VITTORIO VENETO 89', 1763, 20091),
(933, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 32650, 'AGENZIA DI BUCCINASCO', 'VIA MANTEGNA, 1', 1767, 20090),
(934, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 32931, 'AGENZIA DI CINISELLO BALSAMO', 'PIAZZA GRAMSCI, 34', 1796, 20092),
(935, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 32932, 'SP. C/O KODAK', 'VIALE MATTEOTTI, 62', 1796, 20092),
(936, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 32970, 'COLOGNO MONZESE', 'VIA INDIPENDENZA, 8', 1799, 20093),
(937, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 33030, 'AG. DI CORSICO', 'VIA GIUSEPPE DI VITTORIO, 10', 1807, 20094),
(938, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 33100, 'DESIO', 'VIA GIACOMO MATTEOTTI, 1', 1812, 20033),
(939, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 33160, 'AGENZIA DI GORGONZOLA', 'VIA MAZZINI, 2', 1818, 20064),
(940, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 33260, 'AGENZIA DI LIMBIATE', 'VIA TRENTO, 11', 1829, 20051),
(941, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 33270, 'LISSONE', 'VIA S.MARTINO,3', 1831, 20035),
(942, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 33380, 'AG. DI MELEGNANO', 'VIA TURATI, 9/15', 1840, 20077),
(943, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 33480, 'AG. OPERA', 'VIA DELLA RESISTENZA,14', 1855, 20090),
(944, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 33520, 'AG. PADERNO DUGNANO', 'VIA GASPARE ROTONDI, 54', 1859, 20037),
(945, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 33570, 'AGENZIA DI PESCHIERA BORROMEO', 'VIA GRAMSCI, 4', 1864, 20068),
(946, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 33710, 'AGENZIA DI SAN DONATO MILANESE', 'METANOPOLI - P.LE SUPERCORTEMAGGIORE, M6PRESSO GRU', 1883, 20097),
(947, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 33730, 'SAN GIULIANO MILANESE', 'VIALE MILANO 2-4-6', 1885, 20098),
(948, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 33840, 'AG. DI SEREGNO', 'PIAZZA MARTIRI DELLA LIBERTA\',10', 1892, 20038),
(949, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 33860, 'AG. DI SETTIMO MILANESE', 'VIA DELLA LIBERTA\', 67', 1895, 20019),
(950, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 34070, 'AGENZIA DI VIMERCATE', 'PIAZZA ROMA, 16', 1918, 20059),
(951, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 34190, 'SPORT. C/O IBM ITALIA SPA', 'PRESSO CENTRO DISTRIBUZIONE DELLA IBM ITALIA SPA', 1750, 20060),
(952, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 36030, 'AGENZIA DI CAVARZERE', 'VIA DANIELATO, 8', 3479, 30014),
(953, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 36080, 'AGENZIA DI DOLO', 'VIA CAIROLI, 127', 3485, 30031),
(954, 'IT', 1005, 'BANCA NAZIONALE DEL LAVORO SPA', 36140, '', 'PIAZZA MAZZINI, 49', 3492, 30017),
(955, 'IT', 1005, 'BANC