<?php

/*
  --------------------------------------------------------------------------
  GAzie - Gestione Azienda
  Copyright (C) 2004-2024 - Antonio De Vincentiis Montesilvano (PE)
  (http://www.devincentiis.it)
  <http://gazie.sourceforge.net>
  --------------------------------------------------------------------------
  Questo programma e` free software;   e` lecito redistribuirlo  e/o
  modificarlo secondo i  termini della Licenza Pubblica Generica GNU
  come e` pubblicata dalla Free Software Foundation; o la versione 2
  della licenza o (a propria scelta) una versione successiva.

  Questo programma  e` distribuito nella speranza  che sia utile, ma
  SENZA   ALCUNA GARANZIA; senza  neppure  la  garanzia implicita di
  NEGOZIABILITA` o di  APPLICABILITA` PER UN  PARTICOLARE SCOPO.  Si
  veda la Licenza Pubblica Generica GNU per avere maggiori dettagli.

  Ognuno dovrebbe avere   ricevuto una copia  della Licenza Pubblica
  Generica GNU insieme a   questo programma; in caso  contrario,  si
  scriva   alla   Free  Software Foundation, 51 Franklin Street,
  Fifth Floor Boston, MA 02110-1335 USA Stati Uniti.
  --------------------------------------------------------------------------
 */

class cdcForm extends GAzieForm {

    function ticketPayments($name, $val, $class = 'FacetSelect') {
        global $gTables;
        $query = 'SELECT codice,descri,tippag FROM `' . $gTables['pagame'] . "` WHERE tippag = 'D' OR tippag = 'C' OR tippag = 'O' OR tippag = 'K' ORDER BY tippag";
        echo "\t <select name=\"$name\" class=\"$class\">\n";
        $result = gaz_dbi_query($query);
        while ($r = gaz_dbi_fetch_array($result)) {
            $selected = '';
            if ($r['codice'] == $val) {
                $selected = "selected";
            }
            echo "\t\t<option value=\"" . $r['codice'] . "\" $selected >" . $r['descri'] . "</option>\n";
        }
        print "\t </select>\n";
    }

    function getECR_userData($login) {
        global $gTables;
        return gaz_dbi_get_row($gTables['cash_register'], 'adminid', $login);
    }

    function getECRdata($id) {
        global $gTables;
        return gaz_dbi_get_row($gTables['cash_register'], 'id_cash', $id);
    }

    function selectCustomer($name, $val, $strSearch = '', $val_hiddenReq = '', $mesg = '', $class = 'FacetSelect') {
        global $gTables, $admin_aziend;
        $anagrafica = new Anagrafica();
        if ($val > 100000000) { //vengo da una modifica della precedente select case quindi non serve la ricerca
            $partner = $anagrafica->getPartner($val);
            echo "\t<input type=\"hidden\" name=\"$name\" value=\"$val\">\n";
            echo "\t<input type=\"hidden\" name=\"search[$name]\" value=\"" . substr($partner['ragso1'], 0, 8) . "\">\n";
            echo "\t<input type=\"submit\" value=\"" . $partner['ragso1'] . " " . $partner["ragso2"] . " " . $partner["citspe"] . " (" . $partner["codice"] . ")\" name=\"change\" onclick=\"this.form.$name.value='0'; this.form.hidden_req.value='change';\" title=\"$mesg[2]\">\n";
        } else {
            if (strlen($strSearch) >= 2) { //sto ricercando un nuovo partner
                echo "\t<select tabindex=\"1\" name=\"$name\" class=\"FacetSelect\" onchange=\"this.form.hidden_req.value='$name'; this.form.submit();\">\n";
                echo "<option value=\"0\"> ---------- </option>";
                $partner = $anagrafica->queryPartners("*", "codice LIKE '" . $admin_aziend['mascli'] . "%' AND codice >" . intval($admin_aziend['mascli'] . '000000') . "  AND ragso1 LIKE '" . addslashes($strSearch) . "%'", "codice ASC");
                if (count($partner) > 0) {
                    foreach ($partner as $r) {
                        $selected = '';
                        if ($r['codice'] == $val) {
                            $selected = "selected";
                        }
                        echo "\t\t <option value=\"" . $r['codice'] . "\" $selected >" . $r['ragso1'] . " " . $r["ragso2"] . " " . $r["citspe"] . "</option>\n";
                    }
                    echo "\t </select>\n";
                } else {
                    $msg = $mesg[0];
                }
            } else {
                $msg = $mesg[1];
                echo "\t<input type=\"hidden\" name=\"$name\" value=\"$val\">\n";
            }
            echo "\t<input tabindex=\"2\" type=\"text\" id=\"search_$name\" name=\"search[$name]\" value=\"" . $strSearch . "\" maxlength=\"15\"  class=\"FacetInput\">\n";
            if (isset($msg)) {
                echo "<input type=\"text\" style=\"color: red; font-weight: bold;\"  disabled value=\"$msg\">";
            }
//echo "\t<input tabindex=\"3\" type=\"image\" align=\"middle\" name=\"search_str\" src=\"../../library/images/cerbut.gif\">\n";
            /** ENRICO FEDELE */
            /* Cambio l'aspetto del pulsante per renderlo bootstrap, con glyphicon */
            echo '<button type="submit" class="btn btn-default btn-sm" name="search_str" tabindex="3"><i class="glyphicon glyphicon-search"></i></button>';
            /** ENRICO FEDELE */
        }
    }

    function selectAsset($name, $val, $class = 'FacetSelect') {
        global $gTables, $admin_aziend;
        echo "<select id=\"$name\" name=\"$name\" class=\"$class\">\n";
        echo "\t<option value=\"0\"> ---------- </option>\n";
        $result = gaz_dbi_dyn_query("acc_fixed_assets, descri", $gTables['assets'], "type_mov = 1");
        while ($r = gaz_dbi_fetch_array($result)) {
            $selected = '';
            $v = $r["acc_fixed_assets"];
            if ($val == $v) {
                $selected .= " selected ";
            }
            echo "\t<option value=\"" . $v . "\"" . $selected . ">" . $r["acc_fixed_assets"] . "-" . $r['descri'] . "</option>\n";
        }
        echo "</select>\n";
    }

    function selRifDettaglioLinea($name, $val, $RiferimentoNumeroLinea, $class = '') {
        global $gTables, $admin_aziend;
        echo '<select id="' . $name . '" name="' . $name . '" class="' . $class . '">';
        echo '<option value="">Tutto il documento</option>';
        foreach ($RiferimentoNumeroLinea as $k => $v) {
            $selected = '';
            if ($k == $val)
                $selected = ' selected';
            echo '<option value="' . $k . '" ' . $selected . ' >Linea n.' . $k . ' ' . $v . '</option>';
        }
        echo "</select>\n";
    }

    function concileArtico($name, $key, $val, $class = 'small') {
        global $gTables;
        $acc = '';
        $query = 'SELECT * FROM `' . $gTables['artico'] . '`  ORDER BY `catmer`,`codice`';
        $acc .= '<select id="' . $name . '" name="' . $name . '" class="' . $class . '">';
        $acc .= '<option value="" style="background-color:#5bc0de;">NON IN MAGAZZINO</option>';
        $acc .= '<option value="Insert_New" style="background-color:#f0ad4e;">INSERISCI COME NUOVO</option>';
        $result = gaz_dbi_query($query);
        while ($r = gaz_dbi_fetch_array($result)) {
            $selected = '';
            $setstyle = '';
            if ($r[$key] == $val) {
                $selected = " selected ";
                $setstyle = ' style="background-color:#5cb85c;" ';
            }
            $acc .= '<option class="small" value="' . $r[$key] . '"' . $selected . '' . $setstyle . '>' . $r['codice'] . '-' . substr($r['descri'], 0, 30) . '</option>';
        }
        $acc .= '</select>';
        return $acc;
    }

    function selectRegistratoreTelematico($val, $user_name) { // funzione per selezionare tra i registratori telematici abiliti per l'utente
        global $gTables, $admin_aziend;
        echo '<select id="id_cash" name="id_cash">';
        echo '<option value="0">File XML (no RT)</option>';
        $result = gaz_dbi_dyn_query("id_cash, descri", $gTables['cash_register'], "enabled_users LIKE '%" . $user_name . "%'");
        while ($r = gaz_dbi_fetch_array($result)) {
            $selected = '';
            if ($val == $r["id_cash"]) {
                $selected .= " selected ";
            }
            echo '<option value="' . $r["id_cash"] . '"' . $selected . '>' . $r['descri'] . "</option>\n";
        }
        echo "</select>\n";
    }

    function chkRegistratoreTelematico($user_name) { // controllo se l'utente è abilitato ad almeno un RT e restituisco il valore altrimenti false
        global $gTables;
        // trovo il registratore che è stato usato per ultimo dall'utente abilitato
        $rs_last = gaz_dbi_dyn_query("*", $gTables['cash_register'] . " LEFT JOIN " . $gTables['tesdoc'] . " ON " . $gTables['cash_register'] . ".id_cash = " . $gTables['tesdoc'] . ".id_contract", "tipdoc ='VCO' AND id_contract > 0 AND enabled_users LIKE '%" . $user_name . "%'", $gTables['tesdoc'] . '.datemi DESC,' . $gTables['tesdoc'] . '.numdoc DESC', 0, 1);
        $exist = gaz_dbi_fetch_array($rs_last);
        return ($exist) ? $exist['id_cash'] : false;
    }

    function selectRepartoIVA($val, $id_cash = 0) { // per selezionare l'aliquota IVA, tutte se viene prodotto un XML (id_cash=0) ed in base ai reparti del Registatore Telematico se viene utilizzato questo (id_cash > 0)
        global $gTables;
        $table_where = ($id_cash >= 1) ? $gTables['cash_register_reparto'] . " LEFT JOIN " . $gTables['aliiva'] . " ON " . $gTables['cash_register_reparto'] . ".aliiva_codice = " . $gTables['aliiva'] . ".codice" : $gTables['aliiva'];
        echo '<select id="in_codvat" name="in_codvat">';
        echo '<option value="0">-------------</option>';
        $result = gaz_dbi_dyn_query($gTables['aliiva'] . ".codice, " . $gTables['aliiva'] . ".descri", $table_where);
        while ($r = gaz_dbi_fetch_array($result)) {
            $selected = '';
            if ($val == $r["codice"]) {
                $selected .= " selected ";
            }
            echo '<option value="' . $r["codice"] . '"' . $selected . '>' . $r['descri'] . "</option>\n";
        }
        echo "</select>\n";
    }

    function chkReparto($codvat, $id_cash) { // controllo se il codice IVA dell'articolo ha un reparto associato, se presente restituisco il valore
        global $gTables;
        $exist = gaz_dbi_get_row($gTables['cash_register_reparto'], "aliiva_codice", $codvat, "AND cash_register_id_cash = " . $id_cash);
        return ($exist) ? $exist['reparto'] : false;
    }

    function selectBanacc($val, $name = 'bank') { // per selezionare la banca d'accredito degli effetti
        $eof = false;
        global $gTables, $admin_aziend;
        echo '<select id="' . $name . '" name="' . $name . '">';
        $rs = gaz_dbi_dyn_query($gTables['clfoco'] . ".*," . $gTables['banapp'] . ".codabi," . $gTables['banapp'] . ".codcab", $gTables['clfoco'] . " LEFT JOIN " . $gTables['banapp'] . " ON " . $gTables['clfoco'] . ".banapp = " . $gTables['banapp'] . ".codice", $gTables['clfoco'] . ".codice BETWEEN " . $admin_aziend['masban'] . "000001 AND " . $admin_aziend['masban'] . "999999 AND  banapp > 0");
        while ($r = gaz_dbi_fetch_array($rs)) {
            $selected = '';
            if ($val == $r["codice"]) {
                $selected .= " selected ";
                $eof = ($r["addbol"] == 'N') ? false : true;
            }
            echo '<option value="' . $r["codice"] . '"' . $selected . '>' . $r['descri'] . " ABI:" . $r['codabi'] . " CAB:" . $r['codcab'] . "</option>\n";
        }
        echo "</select>\n";
        return $eof;
    }

    function getAllPrevLots($codart, $datref) {
// restituisce la quantità residua di tutti i lotti precedenti o uguali alla data di riferimento, serve per proporre un inventario per lotti ad una data
        global $gTables;
// prendo tutti i movimenti dell'articolo e li raggruppo per ognuno di essi anche se non hanno lotti id_lotmag=0
        $sqlquery = "SELECT id_lotmag, SUM(quanti*operat) AS rest, identifier, lot_or_serial AS ls FROM " . $gTables['movmag'] . " LEFT JOIN " . $gTables['lotmag'] . " ON " . $gTables['movmag'] . ".id_lotmag =" . $gTables['lotmag'] . ".id LEFT JOIN " . $gTables['artico'] . " ON " . $gTables['movmag'] . ".artico =" . $gTables['artico'] . ".codice WHERE " . $gTables['movmag'] . ".artico = '" . $codart . "' AND datreg <= '" . $datref . "' AND caumag < 99 GROUP BY " . $gTables['movmag'] . ".id_lotmag ORDER BY " . $gTables['lotmag'] . ".id";
        $result = gaz_dbi_query($sqlquery);
        $acc = [];
        while ($row = gaz_dbi_fetch_array($result)) {
            $acc[] = $row;
        }
        return $acc;
    }

    // FUNZIONE PER RECUPERARE ULTIMO PROGRESSIVO PACCHETTO IN fae_flux, RESTITUISCE IL NUMERO PROGRESSIVO DELL'ULTIMO PACCHETTO CREATO/INVIATO
    function getLastPack() {
        global $gTables;
        $where = "(filename_zip_package != '') AND exec_date LIKE '" . date('Y') . "%' ";
        $orderby = "filename_zip_package DESC";
        $from = $gTables['fae_flux'];
        $result = gaz_dbi_dyn_query('*', $from, $where, $orderby, 0, 1);
        $row = gaz_dbi_fetch_array($result);
        if (!$row) {
            $row['filename_zip_package'] = '00000.zip';
        }
        return substr($row['filename_zip_package'], -9, 5);
    }

    function getFAEunpacked($include_fe_PA = true) { // FUNZIONE CHE CONTROLLA LO STATO DELLE FATTURE DA IMPACCHETTARE PER INVIARE ALLO SDI
        global $gTables, $admin_aziend;
        $calc = new Compute;
        $from = $gTables['tesdoc'] . ' AS tesdoc
				 LEFT JOIN ' . $gTables['pagame'] . ' AS pay ON tesdoc.pagame=pay.codice
				 LEFT JOIN ' . $gTables['clfoco'] . ' AS customer ON tesdoc.clfoco=customer.codice
				 LEFT JOIN ' . $gTables['anagra'] . ' AS anagraf ON customer.id_anagra=anagraf.id
				 LEFT JOIN ' . $gTables['country'] . ' AS country ON anagraf.country=country.iso
				 LEFT JOIN ' . $gTables['fae_flux'] . ' AS flux ON tesdoc.id_tes = flux.id_tes_ref ';
        $where = "(fattura_elettronica_zip_package IS NULL OR fattura_elettronica_zip_package = '')
				  AND (flux_status = '' OR flux_status = 'DI' OR flux_status IS NULL)
				  AND (tipdoc LIKE 'F__'  OR (tipdoc = 'VCO' AND numfat > 0) OR (tipdoc LIKE 'X__') )";
        if (!$include_fe_PA) {
            $where .= " AND LENGTH(fe_cod_univoco)<>6";
        }
        $orderby = "seziva ASC,tipdoc ASC, protoc ASC";
        $result = gaz_dbi_dyn_query('tesdoc.*, CONCAT(SUBSTRING(tesdoc.tipdoc,1,1),tesdoc.protoc) AS ctrlp, SUBSTRING(tesdoc.tipdoc,1,1) AS ctrlreg ,
							pay.tippag,pay.numrat,pay.incaut,pay.tipdec,pay.giodec,pay.tiprat,pay.mesesc,pay.giosuc,pay.id_bank,
							customer.codice, customer.speban AS addebitospese,
							CONCAT(anagraf.ragso1,\' \',anagraf.ragso2) AS ragsoc, anagraf.citspe, anagraf.prospe, anagraf.capspe, anagraf.country, anagraf.fe_cod_univoco, anagraf.pec_email, anagraf.e_mail, anagraf.country,
							country.istat_area, flux.flux_status', $from, $where, $orderby);
        $docs['data'] = [];
        $ctrlp = 0;
        $carry = 0;
        $ivasplitpay = 0;
        $somma_spese = 0;
        $totimpdoc = 0;
        $taxstamp = 0;
        $rit = 0;
        while ($tes = gaz_dbi_fetch_array($result)) {
            if ($tes['ctrlp'] <> $ctrlp) { // la prima testata della fattura
                if ($ctrlp > 0 && ($docs['data'][$ctrlp]['tes']['stamp'] >= 0.01 || $docs['data'][$ctrlp]['tes']['taxstamp'] >= 0.01 )) { // non è il primo ciclo faccio il calcolo dei bolli del pagamento e lo aggiungo ai castelletti
                    $calc->payment_taxstamp($calc->total_imp + $calc->total_vat + $carry - $rit - $ivasplitpay + $taxstamp, $docs['data'][$ctrlp]['tes']['stamp'], $docs['data'][$ctrlp]['tes']['round_stamp'] * $docs['data'][$ctrlp]['tes']['numrat']);
                    $calc->add_value_to_VAT_castle($docs['data'][$ctrlp]['vat'], $taxstamp + $calc->pay_taxstamp, $admin_aziend['taxstamp_vat']);
                    $docs['data'][$ctrlp]['vat'] = $calc->castle;
                    // aggiungo il castelleto conti
                    if (!isset($docs['data'][$ctrlp]['acc'][$admin_aziend['boleff']])) {
                        $docs['data'][$ctrlp]['acc'][$admin_aziend['boleff']]['import'] = 0;
                    }
                    $docs['data'][$ctrlp]['acc'][$admin_aziend['boleff']]['import'] += $taxstamp + $calc->pay_taxstamp;
                }
                $carry = 0;
                $ivasplitpay = 0;
                $cast_vat = [];
                $cast_acc = [];
                $somma_spese = 0;
                $totimpdoc = 0;
                $totimp_decalc = 0.00;
                $n_vat_decalc = 0;
                $spese_incasso = $tes['numrat'] * $tes['speban'];
                $taxstamp = 0;
                $rit = 0;
            } else {
                $spese_incasso = 0;
            }
            // aggiungo il bollo sugli esenti/esclusi se nel DdT c'è ma non è ancora stato mai aggiunto
            if ($tes['taxstamp'] >= 0.01 && $taxstamp < 0.01) {
                $taxstamp = $tes['taxstamp'];
            }
            if ($tes['virtual_taxstamp'] == 0 || $tes['virtual_taxstamp'] == 3) { //  se è a carico dell'emittente non lo aggiungo al castelletto IVA
                $taxstamp = 0.00;
            }
            if ($tes['traspo'] >= 0.01) {
                if (!isset($cast_acc[$admin_aziend['imptra']]['import'])) {
                    $cast_acc[$admin_aziend['imptra']]['import'] = $tes['traspo'];
                } else {
                    $cast_acc[$admin_aziend['imptra']]['import'] += $tes['traspo'];
                }
            }
            if ($spese_incasso >= 0.01) {
                if (!isset($cast_acc[$admin_aziend['impspe']]['import'])) {
                    $cast_acc[$admin_aziend['impspe']]['import'] = $spese_incasso;
                } else {
                    $cast_acc[$admin_aziend['impspe']]['import'] += $spese_incasso;
                }
            }
            if ($tes['spevar'] >= 0.01) {
                if (!isset($cast_acc[$admin_aziend['impvar']]['import'])) {
                    $cast_acc[$admin_aziend['impvar']]['import'] = $tes['spevar'];
                } else {
                    $cast_acc[$admin_aziend['impvar']]['import'] += $tes['spevar'];
                }
            }
            //recupero i dati righi per creare il castelletto
            $from = $gTables['rigdoc'] . ' AS rs
						LEFT JOIN ' . $gTables['aliiva'] . ' AS vat
						ON rs.codvat=vat.codice';
            $rs_rig = gaz_dbi_dyn_query('rs.*,vat.tipiva AS tipiva', $from, "rs.id_tes = " . $tes['id_tes'], "id_tes DESC");
            while ($r = gaz_dbi_fetch_array($rs_rig)) {
                if ($tes['tipdoc'] == 'XNC') { // è una nota di credito del reverse charge lo SdI vuole che siano negativi gli importi in quanto non prevista una tipologia specifica
                    $r['prelis'] = -abs($r['prelis']);
                }
                if ($r['tiprig'] <= 1 || $r['tiprig'] == 90) { //ma solo se del tipo normale, forfait, vendita cespite
                    //calcolo importo rigo
                    $importo = CalcolaImportoRigo($r['quanti'], $r['prelis'], array($r['sconto'], $tes['sconto']));
                    if ($r['tiprig'] == 1 || $r['tiprig'] == 90) { // se di tipo forfait o vendita cespite
                        $importo = CalcolaImportoRigo(1, $r['prelis'], $tes['sconto']);
                    }
                    //creo il castelletto IVA
                    if (!isset($cast_vat[$r['codvat']]['impcast'])) {
                        $cast_vat[$r['codvat']]['impcast'] = 0;
                        $cast_vat[$r['codvat']]['ivacast'] = 0;
                        $cast_vat[$r['codvat']]['periva'] = $r['pervat'];
                        $cast_vat[$r['codvat']]['tipiva'] = $r['tipiva'];
                    }
                    $cast_vat[$r['codvat']]['impcast'] += $importo;
                    $cast_vat[$r['codvat']]['ivacast'] += round(($importo * $r['pervat']) / 100, 2);
                    $totimpdoc += $importo;
                    //creo il castelletto conti
                    if (!isset($cast_acc[$r['codric']]['import'])) {
                        $cast_acc[$r['codric']]['import'] = 0;
                    }
                    $cast_acc[$r['codric']]['import'] += $importo;
                    if ($r['tiprig'] == 90) { // se è una vendita cespite lo indico sull'array dei conti
                        $cast_acc[$r['codric']]['asset'] = 1;
                    }
                    $rit += round($importo * $r['ritenuta'] / 100, 2);
                    // aggiungo all'accumulatore l'eventuale iva non esigibile (split payment)
                    if ($r['tipiva'] == 'T') {
                        $ivasplitpay += round(($importo * $r['pervat']) / 100, 2);
                    }
                } elseif ($r['tiprig'] == 3) {
                    $carry += $r['prelis'];
                }
            }
            $docs['data'][$tes['ctrlp']]['tes'] = $tes;
            $docs['data'][$tes['ctrlp']]['acc'] = $cast_acc;
            $docs['data'][$tes['ctrlp']]['car'] = $carry;
            $docs['data'][$tes['ctrlp']]['isp'] = $ivasplitpay;
            $docs['data'][$tes['ctrlp']]['rit'] = $rit;
            $somma_spese += $tes['traspo'] + $spese_incasso + $tes['spevar'];
            $calc->add_value_to_VAT_castle($cast_vat, $somma_spese, $tes['expense_vat']);
            $docs['data'][$tes['ctrlp']]['vat'] = $calc->castle;

            // QUI ACCUMULO I VALORI MASSIMI E MINIMI DEI PROTOCOLLI PER OGNI SINGOLO REGISTRO/SEZIONE IVA
            if (!isset($docs['head'][$tes['seziva']][$tes['ctrlreg']])) {
                $docs['head'][$tes['seziva']][$tes['ctrlreg']]['min'] = 999999999;
                $docs['head'][$tes['seziva']][$tes['ctrlreg']]['max'] = 1;
            }
            if ($tes['ctrlreg'] == 'V') {
                $tes['protoc'] = $tes['numfat'];
            }
            $docs['head'][$tes['seziva']][$tes['ctrlreg']]['min'] = ($tes['protoc'] < $docs['head'][$tes['seziva']][$tes['ctrlreg']]['min']) ? $tes['protoc'] : $docs['head'][$tes['seziva']][$tes['ctrlreg']]['min'];
            $docs['head'][$tes['seziva']][$tes['ctrlreg']]['max'] = ($tes['protoc'] > $docs['head'][$tes['seziva']][$tes['ctrlreg']]['max']) ? $tes['protoc'] : $docs['head'][$tes['seziva']][$tes['ctrlreg']]['max'];
            // FINE ACCUMULO MIN-MAX PROTOCOLLI

            $ctrlp = $tes['ctrlp'];
        }
        if ($ctrlp > 0 && ($docs['data'][$ctrlp]['tes']['stamp'] >= 0.01 || $taxstamp >= 0.01)) { // a chiusura dei cicli faccio il calcolo dei bolli del pagamento e lo aggiungo ai castelletti
            $calc->payment_taxstamp($calc->total_imp + $calc->total_vat + $carry - $rit - $ivasplitpay + $taxstamp, $docs['data'][$ctrlp]['tes']['stamp'], $docs['data'][$ctrlp]['tes']['round_stamp'] * $docs['data'][$ctrlp]['tes']['numrat']);
            // aggiungo al castelletto IVA
            $calc->add_value_to_VAT_castle($docs['data'][$ctrlp]['vat'], $taxstamp + $calc->pay_taxstamp, $admin_aziend['taxstamp_vat']);
            $docs['data'][$ctrlp]['vat'] = $calc->castle;
            // aggiungo il castelleto conti
            if (!isset($docs['data'][$ctrlp]['acc'][$admin_aziend['boleff']])) {
                $docs['data'][$ctrlp]['acc'][$admin_aziend['boleff']]['import'] = 0;
            }
            $docs['data'][$ctrlp]['acc'][$admin_aziend['boleff']]['import'] += $taxstamp + $calc->pay_taxstamp;
        }
        return $docs;
    }

    function computeTotFromVatCastle($data) {
        $tax = 0;
        $vat = 0;
        foreach ($data as $k => $v) {
            $tax += $v['impcast'];
            $vat += round($v['impcast'] * $v['periva']) / 100;
        }
        $tot = $vat + $tax;
        return array('taxable' => $tax, 'vat' => $vat, 'tot' => $tot);
    }

    function call() {
        $url = 'https://localhost/cc_webapp/webservices/';
        $jsonLogin = <<<EOD
{"op":"gjwt","dati":{"cod_affiliato":"gazie","token":"1mDZMdfLxhsZyqtQyd2VjyvdJuUOqWxT"}}
EOD;

        $ch = curl_init($url);

        curl_setopt($ch, CURLOPT_POST, 1);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $jsonLogin);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false); // per i certificati autofirmati
        curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);
        $response = curl_exec($ch);
        if ($response === false) {
            echo 'Curl error: ' . curl_error($ch);
        } else {
            print "<p>ok:</p>";
            //var_dump($response);
            $risposta = json_decode($response);
            var_dump($risposta);

            $jwt = $risposta->jwt;
            /*
            $jsonOp = '{
    "op": "ins_dati",
    "jwt": ' . $jwt .
                    '"dati": {
            "proponente": "IT05799620876",
            "nome_file": "IT07945211006_X6YQL.xml",
            "documento_base64": "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"
        }
}';
            curl_setopt($ch, CURLOPT_POSTFIELDS, $jsonOp);
            $response = curl_exec($ch);
            var_dump($response);
             * 
             */
        }
        curl_close($ch);
    }

}

?>