UPDATE `gaz_config` SET `cvalue` = '83' WHERE `id` =2;
DROP TABLE gaz_country;
CREATE TABLE `gaz_country` (
  `iso` char(2) NOT NULL,
  `name` varchar(80) NOT NULL,
  `iso3` char(3) DEFAULT NULL,
  `postal_code_length` int(2) NOT NULL,
  `IBAN_prefix` varchar(2) NOT NULL,
  `IBAN_lenght` int(2) NOT NULL,
  `bank_code_pos` tinyint(2) NOT NULL,
  `bank_code_lenght` tinyint(2) NOT NULL,
  `bank_code_fix` tinyint(1) NOT NULL,
  `bank_code_alpha` tinyint(1) NOT NULL,
  `account_number_pos` tinyint(2) NOT NULL,
  `account_number_lenght` tinyint(2) NOT NULL,
  `account_number_fix` tinyint(1) NOT NULL,
  `account_number_alpha` tinyint(1) NOT NULL,
  `VAT_number_lenght` tinyint(2) NOT NULL,
  `VAT_number_alpha` tinyint(1) NOT NULL,
  `black_list` int(1) NOT NULL,
  `istat_continent` int(1) NOT NULL,
  `istat_area` int(2) NOT NULL,
  `istat_country` int(3) NOT NULL,
  `cod_agenzia_entrate` int(3) NOT NULL,
  `istat_name` varchar(100) NOT NULL,
  `iana` varchar(4) NOT NULL,
  `un_vehicle` varchar(3) NOT NULL,
  PRIMARY KEY (`iso`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;


INSERT INTO `gaz_country` (`iso`, `name`, `iso3`, `postal_code_length`, `IBAN_prefix`, `IBAN_lenght`, `bank_code_pos`, `bank_code_lenght`, `bank_code_fix`, `bank_code_alpha`, `account_number_pos`, `account_number_lenght`, `account_number_fix`, `account_number_alpha`, `VAT_number_lenght`, `VAT_number_alpha`, `black_list`, `istat_continent`, `istat_area`, `istat_country`, `cod_agenzia_entrate`, `istat_name`, `iana`, `un_vehicle`) VALUES
('AD', 'ANDORRA', 'AND', 0, 'AD', 24, 0, 8, 1, 0, 0, 12, 1, 1, 0, 0, 5, 1, 13, 202, 4, 'Andorra', '.ad', 'AND'),
('AT', 'AUSTRIA', 'AUT', 0, 'AT', 20, 0, 5, 1, 0, 0, 11, 0, 0, 0, 0, 2, 1, 11, 203, 8, 'Austria', '.at', 'A'),
('BE', 'BELGIUM', 'BEL', 0, 'BE', 16, 0, 3, 1, 0, 0, 9, 1, 0, 0, 0, 2, 1, 11, 206, 9, 'Belgio', '.be', 'B'),
('CH', 'SWITZERLAND (Confederation of Helvetia)', 'CHE', 0, 'CH', 21, 0, 5, 0, 0, 0, 12, 0, 1, 0, 0, 5, 1, 13, 241, 71, 'Svizzera', '.ch', 'CH'),
('DE', 'GERMANY (Deutschland)', 'DEU', 0, 'DE', 22, 0, 8, 1, 0, 0, 10, 0, 0, 0, 0, 0, 1, 11, 216, 94, 'Germania', '.de', 'D'),
('DK', 'DENMARK', 'DNK', 0, 'DK', 18, 0, 4, 0, 0, 0, 10, 0, 0, 0, 0, 0, 1, 11, 212, 21, 'Danimarca', '.dk', 'DK'),
('ES', 'SPAIN (España)', 'ESP', 0, 'ES', 24, 0, 10, 1, 0, 0, 10, 1, 0, 0, 0, 0, 1, 11, 239, 67, 'Spagna', '.es', 'E'),
('FI', 'FINLAND', 'FIN', 0, 'FI', 18, 0, 6, 1, 0, 0, 8, 0, 0, 0, 0, 0, 1, 11, 214, 28, 'Finlandia', '.fi', 'FIN'),
('FR', 'FRANCE', 'FRA', 0, 'FR', 27, 0, 10, 1, 0, 0, 13, 1, 1, 0, 0, 0, 1, 11, 215, 29, 'Francia', '.fr', 'F'),
('GB', 'UNITED KINGDOM', 'GBR', 0, 'GB', 22, 0, 10, 1, 1, 0, 8, 0, 0, 0, 0, 0, 1, 11, 219, 31, 'Regno Unito', '.uk', ' '),
('GR', 'GREECE', 'GRC', 0, 'GR', 27, 0, 7, 1, 0, 0, 16, 0, 1, 0, 0, 0, 1, 11, 220, 32, 'Grecia', '.gr', 'GR'),
('HU', 'HUNGARY', 'HUN', 0, 'HU', 28, 0, 0, 1, 1, 0, 24, 0, 1, 0, 0, 0, 1, 11, 244, 77, 'Ungheria', '.hu', 'H'),
('IE', 'IRELAND', 'IRL', 0, 'IE', 22, 0, 10, 1, 1, 0, 8, 1, 0, 0, 0, 0, 1, 11, 221, 40, 'Irlanda', '.ie', 'IRL'),
('IS', 'ICELAND', 'ISL', 0, 'IS', 26, 0, 4, 1, 0, 0, 18, 1, 0, 0, 0, 0, 1, 13, 223, 41, 'Islanda', '.is', 'IS'),
('LI', 'LIECHTENSTEIN (Fürstentum Liechtenstein)', 'LIE', 0, 'LI', 21, 0, 5, 0, 0, 0, 12, 0, 1, 0, 0, 5, 1, 13, 225, 90, 'Liechtenstein', '.li', 'FL'),
('LU', 'LUXEMBOURG', 'LUX', 0, 'LU', 20, 0, 3, 1, 0, 0, 13, 1, 1, 0, 0, 5, 1, 11, 226, 92, 'Lussemburgo', '.lu', 'L'),
('MC', 'MONACO', 'MCO', 0, 'MC', 27, 0, 10, 1, 0, 0, 13, 1, 1, 0, 0, 5, 1, 13, 229, 91, 'Monaco', '.mc', 'MC'),
('NL', 'NETHERLANDS', 'NLD', 0, 'NL', 18, 0, 4, 1, 1, 0, 10, 0, 0, 0, 0, 0, 1, 11, 232, 50, 'Paesi Bassi', '.nl', 'NL'),
('NO', 'NORWAY', 'NOR', 0, 'NO', 15, 0, 4, 1, 0, 0, 7, 1, 0, 0, 0, 0, 1, 13, 231, 48, 'Norvegia', '.no', 'N'),
('PL', 'POLAND', 'POL', 0, 'PL', 28, 0, 8, 1, 0, 0, 16, 0, 1, 0, 0, 0, 1, 11, 233, 54, 'Polonia', '.pl', 'PL'),
('PT', 'PORTUGAL', 'PRT', 0, 'PT', 25, 0, 8, 1, 0, 0, 13, 1, 0, 0, 0, 0, 1, 11, 234, 55, 'Portogallo', '.pt', 'P'),
('SE', 'SWEDEN', 'SWE', 0, 'SE', 24, 0, 3, 1, 0, 0, 17, 0, 0, 0, 0, 0, 1, 11, 240, 68, 'Svezia', '.se', 'S'),
('SI', 'SLOVENIA', 'SVN', 0, 'SI', 19, 0, 5, 1, 0, 5, 10, 1, 0, 8, 1, 0, 1, 11, 251, 260, 'Slovenia', '.si', 'SLO'),
('SM', 'SAN MARINO (Republic of)', 'SMR', 0, 'SM', 27, 0, 11, 1, 1, 0, 12, 1, 1, 0, 0, 5, 1, 13, 236, 37, 'San Marino', '.sm', 'RSM'),
('AF', 'AFGHANISTAN', 'AFG', 0, 'AF', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 32, 301, 2, 'Afghanistan', '.af', 'AFG'),
('AL', 'ALBANIA', 'ALB', 0, 'AL', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 12, 201, 87, 'Albania', '.al', 'AL'),
('DZ', 'ALGERIA (El Djazaïr)', 'DZA', 0, 'DZ', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 21, 401, 3, 'Algeria', '.dz', 'DZ'),
('CU', 'CUBA', 'CUB', 0, 'CU', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 42, 514, 20, 'Cuba', '.cu', 'CU'),
('HR', 'CROATIA (Hrvatska)', 'HRV', 0, 'HR', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 12, 250, 261, 'Croazia', '.hr', 'HR'),
('AO', 'ANGOLA', 'AGO', 0, 'AO', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 5, 2, 24, 402, 133, 'Angola', '.ao', ' '),
('AG', 'ANTIGUA AND BARBUDA', 'ATG', 0, 'AG', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 5, 4, 42, 503, 197, 'Antigua e Barbuda', '.ag', ' '),
('AR', 'ARGENTINA', 'ARG', 0, 'AR', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 42, 602, 6, 'Argentina', '.ar', 'RA'),
('AM', 'ARMENIA', 'ARM', 0, 'AM', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 31, 358, 266, 'Armenia', '.am', 'AM'),
('AU', 'AUSTRALIA', 'AUS', 0, 'AU', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 5, 50, 701, 7, 'Australia', '.au', 'AUS'),
('AZ', 'AZERBAIJAN', 'AZE', 0, 'AZ', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 31, 359, 268, 'Azerbaigian', '.az', 'AZ'),
('BS', 'BAHAMAS', 'BHS', 0, 'BS', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 5, 4, 42, 505, 160, 'Bahamas', '.bs', 'BS'),
('BH', 'BAHRAIN', 'BHR', 0, 'BH', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 5, 3, 31, 304, 169, 'Bahrein', '.bh', 'BRN'),
('BD', 'BANGLADESH', 'BGD', 0, 'BD', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 32, 305, 130, 'Bangladesh', '.bd', 'BD'),
('BB', 'BARBADOS', 'BRB', 0, 'BB', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 5, 4, 42, 506, 118, 'Barbados', '.bb', 'BDS'),
('BY', 'BELARUS', 'BLR', 0, 'BY', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 12, 256, 264, 'Bielorussia', '.by', 'BY'),
('BZ', 'BELIZE', 'BLZ', 0, 'BZ', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 5, 4, 42, 507, 198, 'Belize', '.bz', 'BH'),
('BJ', 'BENIN', 'BEN', 0, 'BJ', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 22, 406, 158, 'Benin (ex Dahomey)', '.bj', 'DY'),
('BT', 'BHUTAN', 'BTN', 0, 'BT', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 32, 306, 97, 'Bhutan', '.bt', ' '),
('BO', 'BOLIVIA', 'BOL', 0, 'BO', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 42, 604, 10, 'Bolivia', '.bo', 'BOL'),
('BA', 'BOSNIA AND HERZEGOVINA', 'BIH', 0, 'BA', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 12, 252, 274, 'Bosnia-Erzegovina', '.ba', 'BIH'),
('BW', 'BOTSWANA', 'BWA', 0, 'BW', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 24, 408, 98, 'Botswana', '.bw', 'BW'),
('BR', 'BRAZIL', 'BRA', 0, 'BR', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 42, 605, 11, 'Brasile', '.br', 'BR'),
('BN', 'BRUNEI DARUSSALAM', 'BRN', 0, 'BN', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 5, 3, 33, 309, 125, 'Brunei', '.bn', 'BRU'),
('BG', 'BULGARIA', 'BGR', 0, 'BG', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 11, 209, 12, 'Bulgaria', '.bg', 'BG'),
('BF', 'BURKINA FASO', 'BFA', 0, 'BF', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 22, 409, 142, 'Burkina Faso (ex Alto Volta)', '.bf', 'BF'),
('BI', 'BURUNDI', 'BDI', 0, 'BI', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 23, 410, 25, 'Burundi', '.bi', 'RU'),
('KH', 'CAMBODIA', 'KHM', 0, 'KH', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 33, 310, 135, 'Cambogia', '.kh', 'K'),
('CM', 'CAMEROON', 'CMR', 0, 'CM', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 24, 411, 119, 'Camerun', '.cm', 'CAM'),
('CA', 'CANADA', 'CAN', 0, 'CA', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 41, 509, 13, 'Canada', '.ca', 'CDN'),
('CV', 'CAPE VERDE', 'CPV', 0, 'CV', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 22, 413, 188, 'Capo Verde', '.cv', ' '),
('CF', 'CENTRAL AFRICAN REPUBLIC', 'CAF', 0, 'CF', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 24, 414, 143, 'Centrafricana, Repubblica', '.cf', 'RCA'),
('TD', 'CHAD', 'TCD', 0, 'TD', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 24, 415, 144, 'Ciad', '.td', 'TCH'),
('CL', 'CHILE', 'CHL', 0, 'CL', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 42, 606, 15, 'Cile', '.cl', 'RCH'),
('CN', 'CHINA', 'CHN', 0, 'CN', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 33, 314, 16, 'Cinese, Repubblica Popolare', '.cn', ' '),
('CO', 'COLOMBIA', 'COL', 0, 'CO', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 42, 608, 17, 'Colombia', '.co', 'CO'),
('KM', 'COMOROS', 'COM', 0, 'KM', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 23, 417, 176, 'Comore', '.km', ' '),
('CG', 'CONGO, REPUBLIC OF', 'COG', 0, 'CG', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 24, 418, 145, 'Congo (Repubblica del)', '.cg', 'RCB'),
('CD', 'CONGO, THE DEMOCRATIC REPUBLIC OF THE (formerly Zaire)', 'COD', 0, 'CD', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 24, 463, 18, 'Congo, Repubblica democratica del (ex Zaire)', '.cd', 'ZRE'),
('CI', 'CÔTE D''IVOIRE (Ivory Coast)', 'CIV', 0, 'CI', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 22, 404, 146, 'Costa d''Avorio', '.ci', 'CI'),
('CR', 'COSTA RICA', 'CRI', 0, 'CR', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 5, 4, 42, 513, 19, 'Costa Rica', '.cr', 'CR'),
('CY', 'CYPRUS', 'CYP', 0, 'CY', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 11, 315, 101, 'Cipro', '.cy', 'CY'),
('CZ', 'CZECH REPUBLIC', 'CZE', 0, 'CZ', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 11, 257, 275, 'Ceca, Repubblica', '.cz', 'CZ'),
('DJ', 'DJIBOUTI', 'DJI', 0, 'DJ', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 5, 2, 23, 424, 113, 'Gibuti', '.dj', ' '),
('DM', 'DOMINICA', 'DMA', 0, 'DM', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 5, 4, 42, 515, 192, 'Dominica', '.dm', 'WD'),
('DO', 'DOMINICAN REPUBLIC', 'DOM', 0, 'DO', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 42, 516, 63, 'Dominicana, Repubblica', '.do', 'DOM'),
('EC', 'ECUADOR', 'ECU', 0, 'EC', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 5, 4, 42, 609, 24, 'Ecuador', '.ec', 'EC'),
('EG', 'EGYPT', 'EGY', 0, 'EG', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 21, 419, 23, 'Egitto', '.eg', 'ET'),
('SV', 'EL SALVADOR', 'SLV', 0, 'SV', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 42, 517, 64, 'El Salvador', '.sv', 'ES'),
('GQ', 'EQUATORIAL GUINEA', 'GNQ', 0, 'GQ', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 24, 427, 167, 'Guinea Equatoriale', '.gq', ' '),
('ER', 'ERITREA', 'ERI', 0, 'ER', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 23, 466, 277, 'Eritrea', '.er', ' '),
('EE', 'ESTONIA', 'EST', 0, 'EE', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 11, 247, 257, 'Estonia', '.ee', 'EST'),
('ET', 'ETHIOPIA', 'ETH', 0, 'ET', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 23, 420, 26, 'Etiopia', '.et', 'ETH'),
('FJ', 'FIJI', 'FJI', 0, 'FJ', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 5, 50, 703, 161, 'Figi', '.fj', 'FJI'),
('GA', 'GABON', 'GAB', 0, 'GA', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 24, 421, 157, 'Gabon', '.ga', 'G'),
('GM', 'GAMBIA, THE', 'GMB', 0, 'GM', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 22, 422, 164, 'Gambia', '.gm', 'WAG'),
('GE', 'GEORGIA', 'GEO', 0, 'GE', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 31, 360, 267, 'Georgia', '.ge', 'GE'),
('GH', 'GHANA', 'GHA', 0, 'GH', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 22, 423, 112, 'Ghana', '.gh', 'GH'),
('GD', 'GRENADA', 'GRD', 0, 'GD', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 5, 4, 42, 519, 156, 'Grenada', '.gd', 'WG'),
('GT', 'GUATEMALA', 'GTM', 0, 'GT', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 5, 4, 42, 523, 33, 'Guatemala', '.gt', 'GCA'),
('GN', 'GUINEA', 'GIN', 0, 'GN', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 22, 425, 137, 'Guinea', '.gn', 'RG'),
('GW', 'GUINEA-BISSAU', 'GNB', 0, 'GW', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 22, 426, 185, 'Guinea Bissau', '.gw', ' '),
('GY', 'GUYANA', 'GUY', 0, 'GY', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 42, 612, 159, 'Guyana', '.gy', 'GUY'),
('HT', 'HAITI', 'HTI', 0, 'HT', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 42, 524, 34, 'Haiti', '.ht', 'RH'),
('HN', 'HONDURAS', 'HND', 0, 'HN', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 42, 525, 35, 'Honduras', '.hn', ' '),
('IN', 'INDIA', 'IND', 0, 'IN', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 32, 330, 114, 'India', '.in', 'IND'),
('ID', 'INDONESIA', 'IDN', 0, 'ID', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 33, 331, 129, 'Indonesia', '.id', 'RI'),
('IR', 'IRAN (Islamic Republic of Iran)', 'IRN', 0, 'IR', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 31, 332, 39, 'Iran, Repubblica Islamica del', '.ir', 'IR'),
('IQ', 'IRAQ', 'IRQ', 0, 'IQ', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 31, 333, 38, 'Iraq', '.iq', 'IRQ'),
('IL', 'ISRAEL', 'ISR', 0, 'IL', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 31, 334, 182, 'Israele', '.il', 'IL'),
('JM', 'JAMAICA', 'JAM', 0, 'JM', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 5, 4, 42, 518, 82, 'Giamaica', '.jm', 'JA'),
('JP', 'JAPAN', 'JPN', 0, 'JP', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 33, 326, 88, 'Giappone', '.jp', 'J'),
('JO', 'JORDAN (Hashemite Kingdom of Jordan)', 'JOR', 0, 'JO', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 31, 327, 122, 'Giordania', '.jo', 'HKJ'),
('KZ', 'KAZAKHSTAN', 'KAZ', 0, 'KZ', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 32, 356, 269, 'Kazakhstan', '.kz', 'KZ'),
('KE', 'KENYA', 'KEN', 0, 'KE', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 5, 2, 23, 428, 116, 'Kenya', '.ke', 'EAK'),
('KI', 'KIRIBATI', 'KIR', 0, 'KI', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 5, 5, 50, 708, 194, 'Kiribati', '.ki', ' '),
('KP', 'KOREA, Democratic People''s Republic of [North] Korea)', 'PRK', 0, 'KP', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 33, 319, 74, 'Corea, Repubblica Popolare Democratica (Corea del Nord)', '.kp', ' '),
('KR', 'KOREA, Republic of [South]', 'KOR', 0, 'KR', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 33, 320, 84, 'Corea, Repubblica (Corea del Sud)', '.kr', 'ROK'),
('KW', 'KUWAIT', 'KWT', 0, 'KW', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 31, 335, 126, 'Kuwait', '.kw', 'KWT'),
('KG', 'KYRGYZSTAN', 'KGZ', 0, 'KG', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 32, 361, 270, 'Kirghizistan', '.kg', 'KS'),
('LA', 'LAO PEOPLE''S DEMOCRATIC REPUBLIC', 'LAO', 0, 'LA', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 33, 336, 136, 'Laos', '.la', 'LAO'),
('LV', 'LATVIA', 'LVA', 0, 'LV', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 11, 248, 258, 'Lettonia', '.lv', 'LV'),
('LB', 'LEBANON', 'LBN', 0, 'LB', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 5, 3, 31, 337, 95, 'Libano', '.lb', 'RL'),
('LS', 'LESOTHO', 'LSO', 0, 'LS', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 24, 429, 89, 'Lesotho', '.ls', 'LS'),
('LR', 'LIBERIA', 'LBR', 0, 'LR', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 5, 2, 22, 430, 44, 'Liberia', '.lr', 'LB'),
('LY', 'LIBYA (Libyan Arab Jamahirya)', 'LBY', 0, 'LY', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 21, 431, 45, 'Libia', '.ly', 'LAR'),
('LT', 'LITHUANIA', 'LTU', 0, 'LT', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 11, 249, 259, 'Lituania', '.lt', 'LT'),
('MK', 'MACEDONIA (Former Yugoslav Republic of Macedonia)', 'MKD', 0, 'MK', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 12, 253, 278, 'Macedonia, Repubblica di', '.mk', 'MK'),
('MG', 'MADAGASCAR', 'MDG', 0, 'MG', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 23, 432, 104, 'Madagascar', '.mg', 'RM'),
('MW', 'MALAWI', 'MWI', 0, 'MW', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 23, 434, 56, 'Malawi', '.mw', 'MW'),
('MY', 'MALAYSIA', 'MYS', 0, 'MY', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 5, 3, 33, 340, 106, 'Malaysia', '.my', 'MAL'),
('MV', 'MALDIVES', 'MDV', 0, 'MV', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 5, 3, 32, 339, 127, 'Maldive', '.mv', ' '),
('ML', 'MALI', 'MLI', 0, 'ML', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 22, 435, 149, 'Mali', '.ml', 'RMM'),
('MT', 'MALTA', 'MLT', 0, 'MT', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 11, 227, 105, 'Malta', '.mt', 'M'),
('MH', 'MARSHALL ISLANDS', 'MHL', 0, 'MH', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 5, 5, 50, 712, 217, 'Marshall, Isole', '.mh', ' '),
('MR', 'MAURITANIA', 'MRT', 0, 'MR', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 22, 437, 141, 'Mauritania', '.mr', 'RIM'),
('MU', 'MAURITIUS', 'MUS', 0, 'MU', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 5, 2, 23, 438, 128, 'Mauritius', '.mu', 'MS'),
('MX', 'MEXICO', 'MEX', 0, 'MX', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 42, 527, 46, 'Messico', '.mx', 'MEX'),
('FM', 'MICRONESIA (Federated States of Micronesia)', 'FSM', 0, 'FM', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 5, 50, 713, 215, 'Micronesia, Stati Federati', '.fm', ' '),
('MD', 'MOLDOVA', 'MDA', 0, 'MD', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 12, 254, 265, 'Moldova', '.md', 'MD'),
('MN', 'MONGOLIA', 'MNG', 0, 'MN', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 33, 341, 110, 'Mongolia', '.mn', 'MGL'),
('ME', 'MONTENEGRO', 'MNE', 0, 'ME', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 12, 270, 290, 'Montenegro', '.me', 'MNE'),
('MA', 'MOROCCO', 'MAR', 0, 'MA', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 21, 436, 107, 'Marocco', '.ma', 'MA'),
('MZ', 'MOZAMBIQUE (Moçambique)', 'MOZ', 0, 'MZ', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 23, 440, 134, 'Mozambico', '.mz', 'MOC'),
('MM', 'MYANMAR (formerly Burma)', 'MMR', 0, 'MM', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 33, 307, 83, 'Myanmar (ex Birmania)', '.mm', 'BUR'),
('NA', 'NAMIBIA', 'NAM', 0, 'NA', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 24, 441, 206, 'Namibia', '.na', 'NAM'),
('NR', 'NAURU', 'NRU', 0, 'NR', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 5, 5, 50, 715, 109, 'Nauru', '.nr', 'NAU'),
('NP', 'NEPAL', 'NPL', 0, 'NP', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 32, 342, 115, 'Nepal', '.np', 'NEP'),
('NZ', 'NEW ZEALAND', 'NZL', 0, 'NZ', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 5, 50, 719, 49, 'Nuova Zelanda', '.nz', 'NZ'),
('NI', 'NICARAGUA', 'NIC', 0, 'NI', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 42, 529, 47, 'Nicaragua', '.ni', 'NIC'),
('NE', 'NIGER ', 'NER', 0, 'NE', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 22, 442, 150, 'Niger', '.ne', 'RN'),
('NG', 'NIGERIA', 'NGA', 0, 'NG', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 22, 443, 117, 'Nigeria', '.ng', 'WAN'),
('OM', 'OMAN ', 'OMN', 0, 'OM', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 5, 3, 31, 343, 163, 'Oman', '.om', ' '),
('PK', 'PAKISTAN', 'PAK', 0, 'PK', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 32, 344, 36, 'Pakistan', '.pk', 'PK'),
('PW', 'PALAU', 'PLW', 0, 'PW', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 5, 50, 720, 216, 'Palau', '.pw', ' '),
('PS', 'PALESTINIAN TERRITORIES', 'PSE', 0, 'PS', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 31, 324, 279, 'Territori dell''Autonomia Palestinese', '.ps', ' '),
('PA', 'PANAMA', 'PAN', 0, 'PA', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 5, 4, 42, 530, 51, 'Panama', '.pa', 'PA'),
('PG', 'PAPUA NEW GUINEA', 'PNG', 0, 'PG', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 5, 50, 721, 186, 'Papua Nuova Guinea', '.pg', 'PNG'),
('PY', 'PARAGUAY', 'PRY', 0, 'PY', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 42, 614, 52, 'Paraguay', '.py', 'PY'),
('PE', 'PERU', 'PER', 0, 'PE', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 42, 615, 53, 'Perù', '.pe', 'PE'),
('PH', 'PHILIPPINES', 'PHL', 0, 'PH', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 5, 3, 33, 323, 27, 'Filippine', '.ph', 'RP'),
('QA', 'QATAR', 'QAT', 0, 'QA', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 31, 345, 168, 'Qatar', '.qa', 'Q'),
('RO', 'ROMANIA', 'ROU', 0, 'RO', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 11, 235, 61, 'Romania', '.ro', 'RO'),
('RU', 'RUSSIAN FEDERATION', 'RUS', 0, 'RU', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 12, 245, 262, 'Russa, Federazione', '.ru', 'RUS'),
('RW', 'RWANDA', 'RWA', 0, 'RW', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 23, 446, 151, 'Ruanda', '.rw', 'RWA'),
('KN', 'SAINT KITTS AND NEVIS', 'KNA', 0, 'KN', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 5, 4, 42, 534, 195, 'Saint Kitts e Nevis', '.kn', ' '),
('LC', 'SAINT LUCIA', 'LCA', 0, 'LC', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 5, 4, 42, 532, 199, 'Saint Lucia', '.lc', 'WL'),
('VC', 'SAINT VINCENT AND THE GRENADINES', 'VCT', 0, 'VC', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 5, 4, 42, 533, 196, 'Saint Vincent e Grenadine', '.vc', 'WV'),
('WS', 'SAMOA (formerly Western Samoa)', 'WSM', 0, 'WS', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 5, 5, 50, 727, 131, 'Samoa', '.ws', 'WS'),
('ST', 'SAO TOME AND PRINCIPE', 'STP', 0, 'ST', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 24, 448, 187, 'São Tomé e Principe', '.st', ' '),
('SA', 'SAUDI ARABIA (Kingdom of Saudi Arabia)', 'SAU', 0, 'SA', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 31, 302, 5, 'Arabia Saudita', '.sa', 'SA'),
('SN', 'SENEGAL', 'SEN', 0, 'SN', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 22, 450, 152, 'Senegal', '.sn', 'SN'),
('RS', 'SERBIA (Republic of Serbia)', 'SRB', 0, 'RS', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 12, 271, 289, 'Serbia, Repubblica di', '.rs', ' '),
('SC', 'SEYCHELLES', 'SYC', 0, 'SC', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 5, 2, 23, 449, 189, 'Seychelles', '.sc', 'SY'),
('SL', 'SIERRA LEONE', 'SLE', 0, 'SL', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 22, 451, 153, 'Sierra Leone', '.sl', 'WAL'),
('SG', 'SINGAPORE', 'SGP', 0, 'SG', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 5, 3, 33, 346, 147, 'Singapore', '.sg', 'SGP'),
('SK', 'SLOVAKIA (Slovak Republic)', 'SVK', 0, 'SK', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 11, 255, 276, 'Slovacchia', '.sk', 'SK'),
('SB', 'SOLOMON ISLANDS', 'SLB', 0, 'SB', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 5, 5, 50, 725, 191, 'Salomone, Isole', '.sb', ' '),
('SO', 'SOMALIA', 'SOM', 0, 'SO', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 23, 453, 66, 'Somalia', '.so', 'SO'),
('ZA', 'SOUTH AFRICA (Zuid Afrika)', 'ZAF', 0, 'ZA', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 24, 454, 78, 'Sud Africa', '.za', 'ZA'),
('ZZ', 'STATELESS', 'ZZZ', 0, '', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 5, 6, 60, 999, 999, 'Apolide', '', ''),
('LK', 'SRI LANKA (formerly Ceylon)', 'LKA', 0, 'LK', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 32, 311, 85, 'Sri Lanka (ex Ceylon)', '.lk', 'CL'),
('SD', 'SUDAN', 'SDN', 0, 'SD', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 21, 455, 70, 'Sudan', '.sd', 'SUD'),
('SR', 'SURINAME', 'SUR', 0, 'SR', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 42, 616, 124, 'Suriname', '.sr', 'SME'),
('SZ', 'SWAZILAND', 'SWZ', 0, 'SZ', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 24, 456, 138, 'Swaziland', '.sz', 'SD'),
('SY', 'SYRIAN ARAB REPUBLIC', 'SYR', 0, 'SY', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 31, 348, 65, 'Siria', '.sy', 'SYR'),
('TW', 'TAIWAN ("Chinese Taipei" for IOC)', 'TWN', 0, 'TW', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 5, 3, 33, 363, 22, 'Taiwan (ex Formosa)', '.tw', ' '),
('TJ', 'TAJIKISTAN', 'TJK', 0, 'TJ', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 32, 362, 272, 'Tagikistan', '.tj', 'TJ'),
('TZ', 'TANZANIA', 'TZA', 0, 'TZ', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 23, 457, 57, 'Tanzania', '.tz', ' '),
('TH', 'THAILAND', 'THA', 0, 'TH', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 33, 349, 72, 'Thailandia', '.th', 'T'),
('TL', 'TIMOR-LESTE (formerly East Timor)', 'TLS', 0, 'TL', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 33, 338, 287, 'Timor Orientale', '.tl', ' '),
('TG', 'TOGO', 'TGO', 0, 'TG', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 22, 458, 155, 'Togo', '.tg', 'TG'),
('TO', 'TONGA', 'TON', 0, 'TO', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 5, 5, 50, 730, 162, 'Tonga', '.to', ' '),
('TT', 'TRINIDAD AND TOBAGO', 'TTO', 0, 'TT', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 42, 617, 120, 'Trinidad e Tobago', '.tt', 'TT'),
('TN', 'TUNISIA', 'TUN', 0, 'TN', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 21, 460, 75, 'Tunisia', '.tn', 'TN'),
('TR', 'TURKEY', 'TUR', 0, 'TR', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 12, 351, 76, 'Turchia', '.tr', 'TR'),
('TM', 'TURKMENISTAN', 'TKM', 0, 'TM', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 32, 364, 273, 'Turkmenistan', '.tm', 'TM'),
('TV', 'TUVALU', 'TUV', 0, 'TV', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 5, 5, 50, 731, 193, 'Tuvalu', '.tv', ' '),
('UG', 'UGANDA', 'UGA', 0, 'UG', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 23, 461, 132, 'Uganda', '.ug', 'EAU'),
('UA', 'UKRAINE', 'UKR', 0, 'UA', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 12, 243, 263, 'Ucraina', '.ua', 'UA'),
('AE', 'UNITED ARAB EMIRATES', 'ARE', 0, 'AE', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 5, 3, 31, 322, 238, 'Emirati Arabi Uniti', '.ae', ' '),
('US', 'UNITED STATES', 'USA', 0, 'US', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 41, 536, 69, 'Stati Uniti d''America', '.us', 'USA'),
('UY', 'URUGUAY', 'URY', 0, 'UY', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 5, 4, 42, 618, 80, 'Uruguay', '.uy', 'ROU'),
('UZ', 'UZBEKISTAN', 'UZB', 0, 'UZ', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 32, 357, 271, 'Uzbekistan', '.uz', 'UZ'),
('VU', 'VANUATU', 'VUT', 0, 'VU', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 5, 5, 50, 732, 121, 'Vanuatu', '.vu', ' '),
('VA', 'VATICAN CITY (Holy See)', 'VAT', 0, 'VA', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 13, 246, 93, 'Stato della Città del Vaticano', '.va', 'V'),
('VE', 'VENEZUELA', 'VEN', 0, 'VE', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 42, 619, 81, 'Venezuela', '.ve', 'YV'),
('VN', 'VIET NAM', 'VNM', 0, 'VN', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 33, 353, 62, 'Vietnam', '.vn', 'VN'),
('IT', 'ITALY', 'ITA', 0, 'IT', 27, 6, 10, 1, 0, 16, 12, 0, 1, 0, 0, 0, 0, 0, 0, 0, 'Italia', '.it', 'I'),
('YE', 'YEMEN (Yemen Arab Republic)', 'YEM', 0, 'YE', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 31, 354, 42, 'Yemen', '.ye', 'YAR'),
('ZM', 'ZAMBIA (formerly Northern Rhodesia)', 'ZMB', 0, 'ZM', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 23, 464, 58, 'Zambia', '.zm', 'RNR'),
('ZW', 'ZIMBABWE', 'ZWE', 0, 'ZW', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 23, 465, 73, 'Zimbabwe (ex Rhodesia)', '.zw', 'ZW');

-- START_WHILE ( questo e' un tag che serve per istruire install.php ad INIZIARE ad eseguire le query seguenti su tutte le aziende dell'installazione)
-- STOP_WHILE ( questo e' un tag che serve per istruire install.php a SMETTERE di eseguire le query seguenti su tutte le aziende dell'installazione)